<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Order.class.inc
 * \class Order
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Order php class
 *
 * This class defines operation for one Order
 * 
 */
class Order extends GTF {
    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("order_id", "priority_id", "workspace_id", "workspace_key", "label_name", "order_status_id", "user_id", "login", "period_id", "order_period_libelle", "wk_params", "result_url", $this->getDateSelectedFields('order_date', 'yeartosecond'), "log_url", $this->getDateSelectedFields('execution_date', 'yeartosecond'), "attempt", "email_notifications", "email_option_id", "deleted", "gtf_engine_id", "length_sec", "email_option_label", $this->getDateSelectedFields('minexecdate', 'yeartosecond'));
    }

    /**
     * @SWG\Get(path="/orders/{order_id}", 
     *   tags={"Orders"},
     *   summary="Get Order",
     *   description="Request to get Order by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="order id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/orders")
     *     )
     *  )
     */

    /**
     * get informations about order
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_order", "order_id");
    }

    /**
     * delete an order
     */
    function DELETE() {
        // Supprime les fichiers de la demande (log, résultat...).
        $this->cleanOrderFiles();
        // Supprime la demande.
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'order', 'order_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['order_id'] = $this->aValues["my_vitis_id"];
        }
    }

    /**
     * cleanOrderFiles
     */
    function cleanOrderFiles() {
        require $this->sRessourcesFile;
        // Répertoire ou sont stockés les fichiers de la demande.
        $sSql = $aSql['getOrderPathFiles'];
        $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
        $aParams['order_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
        $oPDOresult = $this->oConnection->oBd->executeWithParams($sSql, $aParams);
        if (!$this->oConnection->oBd->enErreur()) {
            if ($this->oConnection->oBd->nombreLigne($oPDOresult) > 0) {
                $aDemande = $this->oConnection->oBd->ligneSuivante($oPDOresult);
                // Supprime le répertoire.
                if (!empty($aDemande['log_url']))
                    $sFolder = $aDemande['log_url'];
                else if (!empty($aDemande['result_url']))
                    $sFolder = $aDemande['result_url'];
                if (!empty($sFolder)) {
                    $aFolder = explode("/", $sFolder);
                    $sFolder = $this->aProperties['dir_export'] . "/gtf/" . $aFolder[0];
                    clearDir($sFolder);
                }
            }
        }
    }
}

?>