<?php

/**
 * \file OrderStatutes.class.inc
 * \class OrderStatutes
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the OrderStatutes php class
 *
 * This class defines Rest Api to Gtf order statutes
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'OrderStatus.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class OrderStatutes extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/orderstatutes",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/orderstatutes")
     *   }
     * )
     * * @SWG\Tag(
     *   name="OrderStatutes",
     *   description="Operations about OrderStatutes"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('order_status_id', 'order_status_label');
    }

    /**
     * @SWG\Get(path="/orderstatutes",
     *   tags={"OrderStatutes"},
     *   summary="Get OrderStatutes",
     *   description="Request to get OrderStatutes",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/orderstatutes")
     *     )
     *  )
     */

    /**
     * get OrderStatutes
     * @return  OrderStatutes
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_order_status", "order_status_id");
        return $aReturn['sMessage'];
    }

}

?>