<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * This class defines operation for one Period
 * @file Period.class.inc
 * @class Period
 * 
 * @author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * @brief This file contains the Period php class
 *
 * 
 */
class Period extends GTF {

    public $oError;

    /**
	 *Construct
     *@param type $aPath url of the request
     *@param type $aValues parameters of the request
     *@param type $properties properties
     *@param type $bShortcut false to reinit variables
     *@param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('period_id', 'cron_expression', 'name', 'enabled');
    }

    /**
     * @SWG\Get(path="/periods/{period_id}", 
     *   tags={"Periods"},
     *   summary="Get Period",
     *   description="Request to get Period by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="period_id",
     *     in="path",
     *     description="period id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        if (isset($this->aPath[3]) && $this->aPath[3] == "CronValidation") {
            $aCheckCronResult = $this->checkCronExpression($this->aValues["code"]);
            $this->aFields = array('checkcron' => $aCheckCronResult);
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        } else {
            require $this->sRessourcesFile;
            $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "period", "period_id");
        }
    }

    /**
     * delete a period
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'period', 'period_id', $this->aValues["my_vitis_id"], 'integer');
        $this->insertCrontabSubscription();
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['period_id'] = $this->aValues["my_vitis_id"];
        }
    }

    Public function insertCrontabSubscription() {
        require_once("ServerClass.class.inc");
        $oCrontab = new ServerClass(1, $this->oConnection->oBd, $this->aProperties['vas_home'], null, $this->aProperties);
        $oCrontab->deleteCrontabValuesSubscription();
        $oCrontab->AddCrontabValuesSubscription();
    }

    /**
     * Vérification de l'expression CRON.
	 * @return mixed $aCheckCronResult
     */
    function checkCronExpression($sCronExpression) {
        //$sCronExpression = $this->aPath[3];
        $aCheckCronResult = array('cron_expression' => $sCronExpression);
        $aCode = explode(" ", $sCronExpression);
        if (count($aCode) != 5 || $aCode[4] == "") {
            $aCheckCronResult['status'] = 0;
            $aCheckCronResult['message'] = 'FORM_CRON_ERROR_MSG_PUBLICATION_PERIOD';
        } else {
            $aCheckCronResult['arguments'] = $aCode;
            $columns = explode(" ", $sCronExpression);
            $patterns = array(
                '((?P<minute>(?:\*|(?:(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)(?:,(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)*)(?:/(?:[1-9]|[1-5][0-9]))?)$)AD',
                '((?P<hour>(?:\*|(?:(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)(?:,(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)*)(?:/(?:[1-9]|1[0-9]|2[0-3]))?)$)AD',
                '((?P<dayOfMonth>(?:\*|(?:(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)(?:,(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)*)(?:/(?:[1-9]|[1-2][0-9]|3[0-1]))?)$)AD',
                '((?P<month>(?:\*|jan|feb|mar|abr|may|jun|jul|aug|sep|oct|nov|dec|JAN|FEB|MAR|ABR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC|(?:(?:[1-9]|1[0-2])(?:-(?:[1-9]|1[1-2]))?)(?:,(?:[1-9]|1[1-2])(?:-(?:[1-9]|1[1-2]))?)*)(?:/(?:[1-9]|1[1-2]))?)$)AD',
                '((?P<dayOfWeek>(?:\*|sun|mon|tue|wed|thu|fri|sat|SUN|MON|TUE|WED|THU|FRI|SAT|(?:(?:[0-7])(?:-(?:[0-7]))?)(?:,(?:[0-7])(?:-(?:[0-7]))?)*)(?:/(?:[1-7]))?)$)AD',
            );
            $bIsCorrecte = true;
            foreach ($columns as $key => $column) {
                if (preg_match($patterns[$key], $column) !== 1) {
                    $bIsCorrecte = false;
                    $aCheckCronResult['status'] = 0;
                    $aCheckCronResult['message'] = 'FORM_CRON_ERROR_MSG2_PUBLICATION_PERIOD';
                    $aCheckCronResult['index_error_argument'] = $key + 1;
                }
            }
            if ($bIsCorrecte == true) {
                $aCheckCronResult['status'] = 1;
                $aCheckCronResult['message'] = 'FORM_CRON_VALID_PUBLICATION_PERIOD';
            }
        }
        return $aCheckCronResult;
    }

}

?>