<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'Period.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

/**
 * \file Periods.class.inc
 * \class Periods
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis Periods
 * 
 */
class Periods extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/periods",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/periods")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Periods",
     *   description="Operations about Period"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('period_id', 'cron_expression', 'name', 'enabled');
    }

    /**
     * @SWG\Get(path="/periods",
     *   tags={"Periods"},
     *   summary="Get Period",
     *   description="Request to get Period",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="period token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/periods/CronValidation/{cron_expression}",
     *   tags={"Periods"},
     *   summary="Get cron expression validation",
     *   description="Request to get a validation of the cron expression",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="cron_expression",
     *     in="path",
     *     description="cron expression",
     *     required=true,
     *     type="string",
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */

    /**
     * get Periods
     * @return  Periods
     */
    function GET() {


        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "period", "period_id");
        $sMessage = $aReturn['sMessage'];

        return $sMessage;
    }

    /**
     * @SWG\Post(path="/periods",
     *   tags={"Periods"},
     *   summary="Add Period",
     *   description="Request to add period",
     *   operationId="POST",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="period token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="formData",
     *     description="Alias of the period",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="cron_expression",
     *     in="formData",
     *     description="cron expression of the period",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="enabled",
     *     in="formData",
     *     description="period enabled ?",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */

    /**
     * insert period
     * @return id of the period created
     */
    function POST() {
        $aCheckCronResult = $this->checkCronExpression($this->aValues['cron_expression']);
        if ($aCheckCronResult["status"] == 1) {
            $aReturn = $this->genericPost($this->aProperties['schema_gtf'], 'period', $this->aProperties['schema_gtf'] . '.seq_common', 'period_id');
            if ($aReturn['sStatus'] == 1) {
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                $oPeriod = new Period($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
                $oPeriod->GET();
                //
                //$this->checkCronExpression();
                //
                    $this->insertCrontabSubscription();
            } else {
                $sMessage = $aReturn['sMessage'];
            }
        } else {
            $oError = new VitisError(1, "Cron expression invalid");
            $aXmlRacineAttribute['status'] = 0;
            $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        }
        return $sMessage;
    }

    /**
     * @SWG\Put(path="/periods/{period_id}",
     *   tags={"Periods"},
     *   summary="Update Period",
     *   description="Request to update Period",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="period token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="period_id",
     *     in="path",
     *     description="id of the period",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="query",
     *     description="Alias of the period",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="cron_expression",
     *     in="query",
     *     description="cron expression of the period",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="enabled",
     *     in="query",
     *     description="period enabled ?",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */

    /**
     * update period
     * @return id of the period if ok error object if ko
     */
    function PUT() {
        $aCheckCronResult = $this->checkCronExpression($this->aValues['cron_expression']);
        if ($aCheckCronResult["status"] == 1) {
            $aReturn = $this->genericPut($this->aProperties['schema_gtf'], 'period', 'period_id');
            if ($aReturn['sStatus'] == 1) {
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                $oPeriod = new Period($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
                $oPeriod->GET();
                //
                $this->insertCrontabSubscription();
            } else {
                $sMessage = $aReturn['sMessage'];
            }
        } else {
            $oError = new VitisError(1, "Cron expression invalid");
            $aXmlRacineAttribute['status'] = 0;
            $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        }
        return $sMessage;
    }

    /**
     * @SWG\Delete(path="/periods/",
     *   tags={"Periods"},
     *   summary="delete Period",
     *   description="Request to delete Period",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="period token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the Periods",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/periods/{period_id}",
     *   tags={"Periods"},
     *   summary="delete Period",
     *   description="Request to delete Period",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="period token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="period_id",
     *     in="path",
     *     description="id of the period",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/periods")
     *     )
     *  )
     */

    /**
     * delete period
     * @return id of period deleted or error object if a period is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'period', 'period_id');
        $this->insertCrontabSubscription();
        return $aReturn['sMessage'];
    }

    /*
     * *	Insère les mots clefs liés au moteur GTF.
     */

    Public function insertCrontabSubscription() {
        require_once("ServerClass.class.inc");
        $oCrontab = new ServerClass(1, $this->oConnection->oBd, $this->aProperties['vas_home'], null, $this->aProperties);
        $oCrontab->deleteCrontabValuesSubscription();
        $oCrontab->AddCrontabValuesSubscription();
    }

    /**
     * Vérification de l'expression CRON.
     */
    function checkCronExpression($sCronExpression) {
        //$sCronExpression = $this->aPath[3];
        $aCheckCronResult = array('cron_expression' => $sCronExpression);
        $aCode = explode(" ", $sCronExpression);
        if (count($aCode) != 5 || $aCode[4] == "") {
            $aCheckCronResult['status'] = 0;
            $aCheckCronResult['message'] = 'FORM_CRON_ERROR_MSG_PUBLICATION_PERIOD';
        } else {
            $aCheckCronResult['arguments'] = $aCode;
            $columns = explode(" ", $sCronExpression);
            $patterns = array(
                '((?P<minute>(?:\*|(?:(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)(?:,(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)*)(?:/(?:[1-9]|[1-5][0-9]))?)$)AD',
                '((?P<hour>(?:\*|(?:(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)(?:,(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)*)(?:/(?:[1-9]|1[0-9]|2[0-3]))?)$)AD',
                '((?P<dayOfMonth>(?:\*|(?:(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)(?:,(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)*)(?:/(?:[1-9]|[1-2][0-9]|3[0-1]))?)$)AD',
                '((?P<month>(?:\*|jan|feb|mar|abr|may|jun|jul|aug|sep|oct|nov|dec|JAN|FEB|MAR|ABR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC|(?:(?:[1-9]|1[0-2])(?:-(?:[1-9]|1[1-2]))?)(?:,(?:[1-9]|1[1-2])(?:-(?:[1-9]|1[1-2]))?)*)(?:/(?:[1-9]|1[1-2]))?)$)AD',
                '((?P<dayOfWeek>(?:\*|sun|mon|tue|wed|thu|fri|sat|SUN|MON|TUE|WED|THU|FRI|SAT|(?:(?:[0-7])(?:-(?:[0-7]))?)(?:,(?:[0-7])(?:-(?:[0-7]))?)*)(?:/(?:[1-7]))?)$)AD',
            );
            $bIsCorrecte = true;
            foreach ($columns as $key => $column) {
                if (preg_match($patterns[$key], $column) !== 1) {
                    $bIsCorrecte = false;
                    $aCheckCronResult['status'] = 0;
                    $aCheckCronResult['message'] = 'FORM_CRON_ERROR_MSG2_PUBLICATION_PERIOD';
                    $aCheckCronResult['index_error_argument'] = $key + 1;
                }
            }
            if ($bIsCorrecte == true) {
                $aCheckCronResult['status'] = 1;
                $aCheckCronResult['message'] = 'FORM_CRON_VALID_PUBLICATION_PERIOD';
            }
        }
        return $aCheckCronResult;
    }

}

?>