<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file SchemaGroup.class.inc
 * \class SchemaGroup
 *
 * \author Sofian Pujo <Sofian.pujo@veremes.com>.
 *
 * 	\brief This file contains the SchemaGroup php class
 *
 * This class defines operation for one SchemaGroup
 * 
 */
class SchemaGroup extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('group_id', 'schema_group_id', 'schema', 'id_schema');
    }

    /**
     * get SchemaGroup
     * @return  SchemaGroup
     */
    function GET() {
        $this->aFields = $this->getFields($this->aProperties['schema_contraintes'], "schema", "id_schema");
        $this->getSchemas();
    }
    
    /**
     *  get schemas of group
     */
    function getSchemas() {
        $this->sRessourcesFile = "ws/gtf/SchemaGroups.class.sql.inc";
        require $this->sRessourcesFile;
        if (in_array("id_schema", $this->aSelectedFields)) {             
            $aParams['sSchemaContraintes'] = array('value' => $this->aProperties['schema_contraintes'], 'type' => 'schema_name');
            $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            //Requête pour récupérer les schémas
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getSchemas'], $aParams);
            $sListSchemaId = "";
            $aListSchemaName = array();
            //Formation du tableau pour les schémas
            while ($aLigne = $this->oConnection->oBd->ligneSuivante($oPDOresult)) {
                if ($sListSchemaId == "") {
                    $sListSchemaId = $aLigne["id_schema"];
                } else {
                    $sListSchemaId .= "|" . $aLigne["id_schema"];
                }
                $aListSchemaName[] = $aLigne["name"];
            }
            $oPDOresult = $this->oConnection->oBd->fermeResultat();
            $this->aFields['group_schema'] = $sListSchemaId;
            $this->aFields['group_schema_label'] = implode(',', $aListSchemaName);
        }
    }

}

?>