<?php

/**
 * \file SchemaGroups.class.inc
 * \class SchemaGroups
 *
 * \author Sofian Pujo <sofian.pujo@veremes.com>.
 *
 * 	\brief This file contains the SchemaGroups php class
 *
 * This class defines Rest Api to Gtf schemagroups
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'SchemaGroup.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class SchemaGroups extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/schemagroups",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/schemagroups")
     *   }
     * )
     * * @SWG\Tag(
     *   name="SchemaGroups",
     *   description="Operations about SchemaGroups"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('group_id', 'id_schema', 'schema_group_id', 'schema');
    }

    /**
     * @SWG\Get(path="/schemagroups",
     *   tags={"SchemaGroups"},
     *   summary="Get SchemaGroups",
     *   description="Request to get SchemaGroups",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *  @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/schemagroups")
     *     )
     *  )
     */

    /**
     * get SchemaGroups
     * @return  SchemaGroups
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_contraintes'], "v_schema_group", "id_schema");
        return $aReturn['sMessage'];
    }
    
    /**
     * @SWG\Put(path="/schemagroups",
     *   tags={"SchemaGroups"},
     *   summary="Put SchemaGroups",
     *   description="Request to Put SchemaGroups",
     *   operationId="Put",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/schemagroups")
     *     )
     *  )
     */

    /**
     * Put SchemaGroups
     * @return  SchemaGroups
     */
    function PUT() {
        
        $this->sRessourcesFile = "ws/gtf/SchemaGroups.class.sql.inc";
        require $this->sRessourcesFile;
        $aReturn = $this->genericPut($this->aProperties['schema_contraintes'], 'v_schema_group', 'id_schema');
        //Suppression de tous les schémas dans la table
        $this->oConnection->oBd->delete($this->aProperties['schema_contraintes'], 'v_schema_group', 'group_id', $this->aValues["my_vitis_id"]);
        
        if (!empty($this->aValues['group_schema'])) {
                $aSchemas = explode('|', $this->aValues['group_schema']);
                foreach ($aSchemas as $iSchemaId) {
                    $aParams['sSchemaContraintes'] = array('value' => $this->aProperties['schema_contraintes'], 'type' => 'schema_name');
                    $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
                    $aParams['id_schema'] = array('value' => $iSchemaId, 'type' => 'string');
                    //Enregistrement des schémas dans la table
                    $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['insertGroupSchema'], $aParams);
                }
            }
        return $aReturn['sMessage'];
    }

}

?>