<?php

require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/dbUtil.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/logUtil.inc';

class ServerClass {

    //Chemin du fichier crontab
    var $sCrontabFile;
    //Id du server
    var $iId;
    //Nom du server
    var $sServerName;
    //Ancien nom du server
    var $sOldServerName;
    //Répertoire racine
    var $sGtfHome;
    //Répertoire Engines
    var $EnginesHome;
    //Objet de labase de données 
    var $oBd;

    function __construct($iId, $oBd, $sGtfHome, $sOldServerName = "", $aProperties = array()) {
        $this->iId = $iId;
        $this->oBd = $oBd;
        $this->sOldServerName = $sOldServerName;
        $this->sGtfHome = $sGtfHome;
        $this->aProperties = $aProperties;
        $this->setValues($iId);
    }

    function setValues($iId) {
        if ($iId != "") {
            $sSql = 'SELECT scheduler_network_home, hostname, engines_home FROM ' . $this->aProperties['schema_gtf'] . '.server where server_id=[iIdServer]';
            $aParams['iIdServer'] = array('value' => $this->iId, 'type' => 'number');
            $oPDOresult = $this->oBd->executeWithParams($sSql, $aParams);
            $oServer = $this->oBd->objetSuivant($oPDOresult);
            $this->sCrontabFile = $oServer->scheduler_network_home;
            $this->sServerName = $oServer->hostname;
            $this->EnginesHome = $oServer->engines_home;
            if ($this->sOldServerName == "") {
                $this->sOldServerName = $this->sServerName;
            }
        }
    }

    function deleteCrontabValuesEngine() {
        $aValuesPycronNewFile = Array();
        if (is_file($this->sCrontabFile)) {
            $aPycronValues = file($this->sCrontabFile);
            $bWrite = true;
            foreach ($aPycronValues as $sPycronValue) {
                $sPycronValue = str_replace("\n", "", $sPycronValue);
                $sPycronValue = str_replace("\r", "", $sPycronValue);
                if ($sPycronValue == "#<gtf_engines " . gethostname() . " " . $this->sGtfHome . ">") {

                    $bWrite = false;
                } else if ($sPycronValue == "#</gtf_engines " . gethostname() . " " . $this->sGtfHome . ">") {
                    $bWrite = true;
                }
                if ($bWrite == true && $sPycronValue != "#</gtf_engines " . gethostname() . " " . $this->sGtfHome . ">") {
                    $aValuesPycronNewFile[] = $sPycronValue;
                }
            }
        }
        // On écrit dans le fichier texte	
        $sFichierCrontab = fopen($this->sCrontabFile, "w");
        // Le fichier texte est vidé
        ftruncate($sFichierCrontab, 0);
        $aValuesPycronNewFile = str_replace("\n", "", $aValuesPycronNewFile);
        $aValuesPycronNewFile = str_replace("\r", "", $aValuesPycronNewFile);
        foreach ($aValuesPycronNewFile as $sPycronValues2) {
            fputs($sFichierCrontab, $sPycronValues2 . "\n");
        }
        // Enfin fermer le fichier
        fclose($sFichierCrontab);
    }

    function deleteCrontabValuesSubscription() {
        $aPycronValues = file($this->sCrontabFile);
        $aValuesPycronNewFile = Array();
        $bWrite = true;
        foreach ($aPycronValues as $sPycronValue) {
            $sPycronValue = str_replace("\n", "", $sPycronValue);
            $sPycronValue = str_replace("\r", "", $sPycronValue);

            if ($sPycronValue == "#<gtf_subscription " . gethostname() . " " . $this->sGtfHome . ">") {

                $bWrite = false;
            } else if ($sPycronValue == "#</gtf_subscription " . gethostname() . " " . $this->sGtfHome . ">") {
                $bWrite = true;
            }
            if ($bWrite == true && $sPycronValue != "#</gtf_subscription " . gethostname() . " " . $this->sGtfHome . ">") {
                $aValuesPycronNewFile[] = $sPycronValue;
            }
        }
        // On écrit dans le fichier texte	
        $sFichierCrontab = fopen($this->sCrontabFile, "w");
        // Le fichier texte est vidé
        ftruncate($sFichierCrontab, 0);
        $aValuesPycronNewFile = str_replace("\n", "", $aValuesPycronNewFile);
        $aValuesPycronNewFile = str_replace("\r", "", $aValuesPycronNewFile);
        foreach ($aValuesPycronNewFile as $sPycronValues2) {
            fputs($sFichierCrontab, $sPycronValues2 . "\n");
        }
        // Enfin fermer le fichier
        fclose($sFichierCrontab);
    }

    function AddCrontabValuesEngines($sNotInList = "") {
        if ($sNotInList == "") {
            $sSql = 'SELECT gtf_engine_id, period, enabled FROM ' . $this->aProperties['schema_gtf'] . '.gtf_engine WHERE server_id=[iIdServer]';
        } else {
            $sSql = 'SELECT gtf_engine_id, period, enabled FROM ' . $this->aProperties['schema_gtf'] . '.gtf_engine WHERE server_id=[iIdServer] AND gtf_engine_id not in ([sNotInList])';
            $aParams['sNotInList'] = array('value' => str_replace(',', '|', $sNotInList), 'type' => 'group');
        }
        $aParams['iIdServer'] = array('value' => $this->iId, 'type' => 'number');
        $oPDOresult = $this->oBd->executeWithParams($sSql, $aParams);
        $sFichierCrontab = fopen($this->sCrontabFile, "a");
        fputs($sFichierCrontab, "#<gtf_engines " . gethostname() . " " . $this->sGtfHome . ">" . "\n");
        while ($oGTF = $this->oBd->objetSuivant($oPDOresult)) {
            if ($oGTF->enabled == true) {
                $sActif = "";
            } else {
                $sActif = "#";
            }
            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                $sLigne = $sActif . "*/" . $oGTF->period . " * * * * \"" . $this->EnginesHome . "/engine.exe\" " . $oGTF->gtf_engine_id;
            } else {
                $sLigne = $sActif . "*/" . $oGTF->period . " * * * * cd \"" . $this->EnginesHome . "\" && \"" . $this->EnginesHome . "/engine\" " . $oGTF->gtf_engine_id;
            }
            fputs($sFichierCrontab, $sLigne . "\n");
        }
        fputs($sFichierCrontab, "#</gtf_engines " . gethostname() . " " . $this->sGtfHome . ">" . "\n");
        if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
            $sCronTmp = '/tmp/' . uniqid('cron_');
            exec("crontab -u www-data -l > " . $sCronTmp);
            exec("crontab -u www-data " . $sCronTmp);
            exec("rm " . $sCronTmp);
        }
    }

    function AddCrontabValuesSubscription() {
        $sSql = 'SELECT period_id, cron_expression, enabled FROM ' . $this->aProperties['schema_gtf'] . '.period';
        $oPDOresult = $this->oBd->executeWithParams($sSql, array());
        $sFichierCrontab = fopen($this->sCrontabFile, "a");
        fputs($sFichierCrontab, "#<gtf_subscription " . gethostname() . " " . $this->sGtfHome . ">" . "\n");
        while ($oPeriod = $this->oBd->objetSuivant($oPDOresult)) {
            if ($oPeriod->enabled == true) {
                $sActif = "";
            } else {
                $sActif = "#";
            }
            if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                $sLigne = $sActif . $oPeriod->cron_expression . " \"" . $this->EnginesHome . "/php/php.exe\" \"" . $this->EnginesHome . "/subscription.php\" " . $oPeriod->period_id;
            } else {
                $sLigne = $sActif . $oPeriod->cron_expression . " (\"" . $this->EnginesHome . "/php/bin/php\" \"" . $this->EnginesHome . "/subscription.php\" " . $oPeriod->period_id . ")";
            }
            fputs($sFichierCrontab, $sLigne . "\n");
        }
        fputs($sFichierCrontab, "#</gtf_subscription " . gethostname() . " " . $this->sGtfHome . ">" . "\n");
        if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
            $sCronTmp = '/tmp/' . uniqid('cron_');
            exec("crontab -u www-data -l > " . $sCronTmp);
            exec("crontab -u www-data " . $sCronTmp);
            exec("rm " . $sCronTmp);
        }
    }

    function AddPropertiesFME($sNotInList = "") {
        $sFichierProperties = fopen($this->sGtfHome . "/rest/conf/gtf/properties_post_engines.inc", "w");
        fputs($sFichierProperties, "<?php" . "\n");
        $sLigne = '$properties["engines_list"] = \'';
        $aParams = array();
        if ($sNotInList == "") {
            $sSql = 'SELECT gtf_engine_id FROM ' . $this->aProperties['schema_gtf'] . '.gtf_engine WHERE enabled = true ORDER BY gtf_engine_id';
        } else {
            $sSql = 'SELECT gtf_engine_id FROM ' . $this->aProperties['schema_gtf'] . '.gtf_engine WHERE gtf_engine_id not in (' . $sNotInList . ") AND enabled = true ORDER BY gtf_engine_id";
            $aParams['sNotInList'] = array('value' => str_replace(',', '|', $sNotInList), 'type' => 'group');
        }
        $oPDOresult = $this->oBd->executeWithParams($sSql, $aParams);
        while ($oFme = $this->oBd->objetSuivant($oPDOresult)) {
            if ($sLigne == '$properties["engines_list"] = \'') {
                $sLigne .= $oFme->gtf_engine_id;
            } else {
                $sLigne .= "," . $oFme->gtf_engine_id;
            }
        }
        $sLigne .= "';";
        fputs($sFichierProperties, $sLigne . "\n");
        fputs($sFichierProperties, "?>" . "\n");
    }

}

?>