<?php

/**
 * \file Statistics.class.inc
 * \class Statistics
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Statistics php class
 *
 * This class defines Rest Api to Gtf order statutes
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';
require 'Stats.class.inc';

class Statistics extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/statistics",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/statistics")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Statistics",
     *   description="Operations about Statistics"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('email_option_id', 'email_option_label');
    }

    /**
     * @SWG\Get(path="/statistics",
     *   tags={"Statistics"},
     *   summary="Get Statistics",
     *   description="Request to get Statistics",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="variable_id",
     *     in="query",
     *     description="Type of statistics",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="var_tjl",
     *         enum={"var_tjl", "var_ujl", "var_jn"}
     *   ),
     * @SWG\Parameter(
     *     name="unit_id",
     *     in="query",
     *     description="Type of unit",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="unit_sec",
     *         enum={"unit_sec", "unit_min", "unit_hour", "unit_pc"}
     *   ),
     * @SWG\Parameter(
     *     name="gb_id",
     *     in="query",
     *     description="Type of legend",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="gb_workspace",
     *         enum={"gb_workspace", "gb_user", "gb_engine", "gb_status"}
     *   ),
     * @SWG\Parameter(
     *     name="per_type",
     *     in="query",
     *     description="Type of period",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="per_week",
     *         enum={"per_day", "per_week", "per_month", "per_year"}
     *   ),
     * @SWG\Parameter(
     *     name="per_date",
     *     in="query",
     *     description="",
     *     required=true,
     *     type="string",
     *   ),
     * @SWG\Parameter(
     *     name="max_elements",
     *     in="query",
     *     description="number of max elements",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="max_labels_characters",
     *     in="query",
     *     description="number of max labels characters",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="graph_colors",
     *     in="query",
     *     description="Type of graph colors",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="palette1",
     *         enum={"palette1", "palette2"}
     *   ),
     * @SWG\Parameter(
     *     name="view_id",
     *     in="query",
     *     description="Type of ",
     *     required=true,
     *     type="array",
     *         @SWG\Items(type="string"),
     *         collectionFormat="multi",
     *         default="view_graph",
     *         enum={"view_graph", "view_table"}
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/statistics")
     *     )
     *  )
     */

    /**
     * get Statistics
     * @return  Statistics
     */
    function GET() {
        $oMyStats = new Stats($this->oConnection->oBd, $this->aProperties);
        $aReturn = $oMyStats->getStats($this->aValues);
        $this->aFields["statistics"] = $aReturn;
        $aXmlRacineAttribute['status'] = 1;
        $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        return $sMessage;
    }

}

?>