<?php

class Stats {
    /* Critères de la requête sql suivant les données demandées : */

    // Nom de la requête à exécuter suivant la variable et le regroupement
    private $aSqlRequest = array('var_tjl' => array('gb_workspace' => 'max_elements', 'gb_user' => 'max_elements', 'gb_engine' => 'normal', 'gb_status' => 'traductions'),
        'var_ujl' => array('gb_workspace' => 'traitements_unitaires'),
        'var_jn' => array('gb_workspace' => 'max_elements', 'gb_user' => 'max_elements', 'gb_engine' => 'normal', 'gb_status' => 'traductions'));
    // Valeurs de retour suivant l'unité (et suivant le grain si %)	
    private $aSqlUnit = array('unit_sec' => 'aSqlUnitFonction[this->variable_id]::integer',
        'unit_min' => '(aSqlUnitFonction[this->variable_id]::real/60)',
        'unit_hour' => '(aSqlUnitFonction[this->variable_id]::real/3600)',
        'unit_pc' => '((100*aSqlUnitFonction[this->variable_id]::real)/aSecondGranularity[this->per_type])');
    // Valeurs de retour suivant l'unité uniquement pour 'traitements unitaires'(plusieurs colonnes: min, moy, max)	
    private $aSqlUnitVarUjl = array('unit_sec' => '::integer',
        'unit_min' => '::real/60',
        'unit_hour' => '::real/3600');
    // Fonctions à exécuter dans la requête suivant 'variable_id' : sum,count...
    private $aSqlUnitFonction = array('var_tjl' => 'sum(job.length_sec)',
        'var_ujl' => '',
        'var_jn' => 'count(*)');
    // Nb secondes par granularité (uniquement pour '%')
    private $aSecondGranularity = array('per_day' => 3600, // 1h
        'per_week' => 86400, // 1 jour
        'per_month' => 86400, // 1jour
        'per_year' => "((date_part('day', DATE([per_date]) + '1 month - 1 day'::interval)::integer)*86400)");
    // Durée de l'intervalle (= date de fin)
    private $aSqlIntervalLength = array('per_day' => '1 day',
        'per_week' => '1 week',
        'per_month' => '1 month',
        'per_year' => '1 year');
    // generate series : remplir les données vides par des 0 --> graphique 'bar'
    private $aSqlPerDateGenerateSeries = array('per_day' => 'generate_series (0,24)',
        'per_week' => array('generate_series (0,6)', 'generate_series (1,7)'),
        'per_month' => "generate_series (1,date_part('day', DATE([per_date]) + '1 month - 1 day'::interval)::integer)",
        'per_year' => 'generate_series (1,12)');
    // Critère de tri pour la granularité (order by)
    private $aSqlGranularityOrderBy = array('per_day' => 'hour',
        'per_week' => array('dow', 'isodow'),
        'per_month' => 'day',
        'per_year' => 'month');
    // Critère de regroupement pour la légende (gb_id)
    private $aSqlLegendGroupBy = array('gb_workspace' => 'workspace',
        'gb_user' => 'login',
        'gb_engine' => 'engine_id',
        'gb_status' => 'order_status_id');
// Formatage des dates (constantes)
    private $aGranularityLabels = array('per_week' => array('DIMANCHE_STATISTICS_STATISTICS', 'LUNDI_STATISTICS_STATISTICS', 'MARDI_STATISTICS_STATISTICS', 'MERCREDI_STATISTICS_STATISTICS', 'JEUDI_STATISTICS_STATISTICS', 'VENDREDI_STATISTICS_STATISTICS', 'SAMEDI_STATISTICS_STATISTICS', 'DIMANCHE_STATISTICS_STATISTICS'),
        'per_year' => array('', 'JANVIER_STATISTICS_STATISTICS', 'FEVRIER_STATISTICS_STATISTICS', 'MARS_STATISTICS_STATISTICS', 'AVRIL_STATISTICS_STATISTICS', 'MAI_STATISTICS_STATISTICS', 'JUIN_STATISTICS_STATISTICS', 'JUILLET_STATISTICS_STATISTICS', 'AOUT_STATISTICS_STATISTICS', 'SEPTEMBRE_STATISTICS_STATISTICS', 'OCTOBRE_STATISTICS_STATISTICS', 'NOVEMBRE_STATISTICS_STATISTICS', 'DECEMBRE_STATISTICS_STATISTICS')); // Constante (fichier de trad.)
    private $aMonthNames = array('', 'JANVIER_STATISTICS_STATISTICS', 'FEVRIER_STATISTICS_STATISTICS', 'MARS_STATISTICS_STATISTICS', 'AVRIL_STATISTICS_STATISTICS', 'MAI_STATISTICS_STATISTICS', 'JUIN_STATISTICS_STATISTICS', 'JUILLET_STATISTICS_STATISTICS', 'AOUT_STATISTICS_STATISTICS', 'SEPTEMBRE_STATISTICS_STATISTICS', 'OCTOBRE_STATISTICS_STATISTICS', 'NOVEMBRE_STATISTICS_STATISTICS', 'DECEMBRE_STATISTICS_STATISTICS');
// Palettes de couleurs	(suivant le critère de regroupement)
    private $aGraphColors = array('gb_status' => array('1' => 'Silver', '2' => 'Red', '3' => 'Lime', '4' => 'Black', '5' => 'Gold'));

// Valeurs par défaut
    const DEFAULT_MAX_ELEMENTS = 5;
    const DEFAULT_MAX_LABELS_CHARACTERS = 50;
    const DEFAULT_UNIT_ID = 'unit_sec';

// Paramètres pour la requête de stats
    private $variable_id; // Variable à représenter dans les tableaux ou graphiques : var_tjl, var_ujl, var_jn
    private $unit_id; // Unité de temps pour la représentation (unit_sec(s), unit_min(m), unit_hour(h) - pourcentage (unit_pc - traitement particulier)
    private $gb_id; // Critère de regroupement : gb_workspace, gb_user, gb_engine, gb_status
    private $per_type; // Durée totale de la série statistique analysée : per_year (semaine), per_month (jour), per_week (jour), per_day (heure)
    private $per_date; // Date de début de la série statistique analysée : 1er jour année, 1er jour mois, 1er jour semaine, jour choisi
    private $max_elements; // Nb éléments max. à retourner (ex: 5 utilisateurs + autres)
    private $max_labels_characters; // Nb caractères max. pour les labels
    private $first_day_week;
    private $graph_type; // Type de données à retourner (générales ou détaillées) suivant le graphique
    private $aStats; // Tableau de stats qui sera converti en json et retourné
    private $oBd; // Objet de connexion vers la base

// RGraph : structure des données pour le tableau de retour

    const GRAPH_TITLE = 'title';
    const GRAPH_SUBTITLE = 'subtitle';
    const GRAPH_LABELS = 'labels';
    const GRAPH_DATA = 'data';
    const GRAPH_KEY = 'key';
    const LEGEND_TITLE = 'legend';
    const GRAPH_DATA_UNIT = 'data_unit';
    const GRAPH_COLORS = 'colors'; // Palette de couleurs imposée ()
    const SCATTER_LEGEND = 'scatter_legend';
// RGraph : paramètres pour l'affichage
    const SCATTER_X_SPACING = 3;
    const SCATTER_COLOR_UP = 'black';
    const SCATTER_COLOR_DOWN = 'white';
    const SCATTER_COLOR_OUTLINE = 'black';
// Tableau de retour (succès ou échec)
    const REQUEST_SUCCESS = 1;
    const REQUEST_ERROR = 0;
// Paramètres spécifiques de la requête sql pour le mode 'général' (pie) --> pas de granularité
    const SQL_PER_DATE_GENERATE_SERIES_GENERAL = "date_part('millennium', DATE([per_date]))";
    const SQL_GRANULARITY_ORDER_BY_GENERAL = 'millennium';

    /*     * ********************************
      Connexion à la bdd
      $oBd : Objet de connexion vers la base
     * ********************************* */

    function __construct($oBd, $aProperties) {
        $this->aProperties = $aProperties;
        $this->oBd = $oBd;
    }

    /*     * *********************************
      Initialise les paramètres et appelle la méthode correspondante à la variable (variable_id) à afficher
      $aStatsRequest : Tableau contenant les paramètres pour la requête de stats (en général le tableau $_POST)
      Retour : idem
     * ********************************* */

    function getStats($aStatsRequest) {
        if (!empty($aStatsRequest)) {
            // Vérifie et initialise les paramètres pour la requête de stats dans l'objet
            if ($this->checkStatsRequest($aStatsRequest)) {
                // Configure et lance la requête sql correspondante	
                $aRawStats = $this->setSqlRequest();

                // Crée un tableau structuré pour la partie graphique
                $this->getGraphTable($aRawStats);
            }
        }

        // Converti et retourne le tableau au format json	
        return $this->aStats;
    }

    /*     * *********************************
      Vérifie et initialise les paramètres pour la requête de stats
      $aStatsRequest : Tableau contenant les paramètres pour la requête de stats (en général $_POST)
     * ********************************* */

    private function checkStatsRequest($aStatsRequest) {
        // Variable, période, date de début, unité (sauf si nombre de traitements), critère de regroupement : obligatoires
        if (!empty($aStatsRequest['variable_id']) && !empty($aStatsRequest['per_type']) && !empty($aStatsRequest['per_date_sql']) && !empty($aStatsRequest['gb_id'])) {
            $this->variable_id = $aStatsRequest['variable_id'];
            $this->per_type = $aStatsRequest['per_type'];
            $this->per_date = $aStatsRequest['per_date_sql'];
            $this->gb_id = $aStatsRequest['gb_id'];
            $this->first_day_week = $aStatsRequest['first_day_week'];
            $this->graph_type = $aStatsRequest['graph_type'];
            $this->aStats = array();

            // Si l'unité est vide (<select> grisé pour 'nombre de traitements') : valeur par défaut
            if (empty($aStatsRequest['unit_id']))
                $this->unit_id = self::DEFAULT_UNIT_ID;
            else
                $this->unit_id = $aStatsRequest['unit_id'];

            // Si max_elements = 0 : pas de limite
            if (!isset($aStatsRequest['max_elements']))
                $this->max_elements = self::DEFAULT_MAX_ELEMENTS;
            else {
                if ($aStatsRequest['max_elements'] == '0')
                    $this->max_elements = 1000;
                else
                    $this->max_elements = $aStatsRequest['max_elements'];
            }
            // max_labels_characters : obligatoire ? (sinon valeur par défaut)
            if (!empty($aStatsRequest['max_labels_characters']))
                $this->max_labels_characters = $aStatsRequest['max_labels_characters'];
            else
                $this->max_labels_characters = self::DEFAULT_MAX_LABELS_CHARACTERS;

            // Paramètres vérifiés : la requête de stats peut-être lancée
            $this->setStatus(self::REQUEST_SUCCESS);
            $iDoRequest = true;
        }else {
            // Erreur : pas de requête et message en retour
            $this->setStatus(self::REQUEST_ERROR, "ERROR_MISSING_DATA_STATISTICS_STATISTICS");
            $iDoRequest = false;
        }

        return $iDoRequest;
    }

    /*     * *********************************
      Configure la requête sql 'brute' correspondante et l'exécute
     * ********************************* */

    private function setSqlRequest() {
        // Toutes les requêtes génériques : à remplir suivant les critères
        require_once("Stats.class.sql.inc");

        // Requête Sql suivant la variable et le regroupement ?
        $sSqlRequest = $this->aSqlRequest[$this->variable_id][$this->gb_id];
        $sSql = $aSql[$this->oBd->sgbd]['stats'][$sSqlRequest];

        // Rempli l'unité (sec, min...)
        if ($this->variable_id == 'var_ujl')
            $sSql = str_replace('aSqlUnitVarUjl[this->unit_id]', $this->aSqlUnitVarUjl["$this->unit_id"], $sSql);
        else {
            $sSql = str_replace('aSqlUnit[this->unit_id]', $this->aSqlUnit["$this->unit_id"], $sSql);
            $sSql = str_replace('aSqlUnitFonction[this->variable_id]', $this->aSqlUnitFonction["$this->variable_id"], $sSql);

            // Traitement spécial si pourcentage	
            if ($this->unit_id == 'unit_pc')
                $sSql = str_replace('aSecondGranularity[this->per_type]', $this->aSecondGranularity["$this->per_type"], $sSql);
        }

        // Interval (Durée de la période de stats)
        $sSql = str_replace('aSqlIntervalLength[this->per_type]', $this->aSqlIntervalLength["$this->per_type"], $sSql);

        // Granularité (Order by) & astuce pour remplir à 0 la granularité sans données (exception pour per_week)
        // Si le type de graphique est 'general' (pie) : granularité identique pour toutes les données
        if ($this->graph_type == 'detail') {
            if ($this->per_type == 'per_week') {
                $sSql = str_replace('aSqlPerDateGenerateSeries[this->per_type]', $this->aSqlPerDateGenerateSeries[$this->per_type][$this->first_day_week], $sSql);
                $sSql = str_replace('aSqlGranularityOrderBy[this->per_type]', $this->aSqlGranularityOrderBy[$this->per_type][$this->first_day_week], $sSql);
            } else {
                $sSql = str_replace('aSqlPerDateGenerateSeries[this->per_type]', $this->aSqlPerDateGenerateSeries[$this->per_type], $sSql);
                $sSql = str_replace('aSqlGranularityOrderBy[this->per_type]', $this->aSqlGranularityOrderBy[$this->per_type], $sSql);
            }
        } else {
            $sSql = str_replace('aSqlPerDateGenerateSeries[this->per_type]', self::SQL_PER_DATE_GENERATE_SERIES_GENERAL, $sSql);
            $sSql = str_replace('aSqlGranularityOrderBy[this->per_type]', self::SQL_GRANULARITY_ORDER_BY_GENERAL, $sSql);
        }

        // Critère de regroupement (gb_id)
        $sSql = str_replace('aSqlLegendGroupBy[this->gb_id]', $this->aSqlLegendGroupBy[$this->gb_id], $sSql);

        // Langue pour les traductions
        $sSql = str_replace("properties['language']", $this->aProperties['language'], $sSql);

        // Traduction de 'autres'
        //$sSql = str_replace('SQL_MAX_ELEMENTS_OTHERS', html_entity_decode(SQL_MAX_ELEMENTS_OTHERS, ENT_QUOTES | ENT_HTML5, 'UTF-8'), $sSql);
        $sSql = str_replace('SQL_MAX_ELEMENTS_OTHERS', 'SQL_MAX_ELEMENTS_OTHERS_STATISTICS_STATISTICS', $sSql);

        $sSql = str_replace('grain,pc.engine_id', "grain,pc.engine_id || ' - ' || gtf_engine.name", $sSql);
        $sSql = str_replace('AND pc.engine_id=dynamic.engine_id', "AND pc.engine_id=dynamic.engine_id LEFT JOIN [sSchemaGtf].gtf_engine ON pc.engine_id = gtf_engine.gtf_engine_id", $sSql);

        // Nom des schémas à partir des properties
        $sSql = str_replace("[sSchemaGtf]", $this->aProperties['schema_gtf'], $sSql);
        $sSql = str_replace("[sSchemaFramework]", $this->aProperties['schema_framework'], $sSql);

        //  Exécute la requête sql
        if ($sSqlRequest != 'traitements_unitaires')
            $aParams['max_elements'] = array('value' => $this->max_elements, 'type' => 'number');
        $aParams['per_date'] = array('value' => $this->per_date, 'type' => 'string');
        $oPDOresult = $this->oBd->executeWithParams($sSql, $aParams);
        if (!empty($this->erreurRencontree)) {
            $this->setStatus(self::REQUEST_ERROR, $this->oBd->getBDMessage());
            exit(json_encode($this->aStats));
        }

        // Récupère les données sous forme de tableau associatif	
        $aRawStats = $this->oBd->getResultTableAssoc($oPDOresult);
        $oPDOresult = $this->oBd->fermeResultat();

        return $aRawStats;
    }

    /*     * *********************************
      Transforme un tableau de résultats de bdd (brut) en tableau json formaté pour l'affichage
      $aRawStats : Tableau de résultat de bdd brut
     * ********************************* */

    private function getGraphTable($aRawStats) {
        // Si la requête ne renvoie pas de données : message d'erreur	
        if (empty($aRawStats))
            $this->setStatus(self::REQUEST_ERROR, 'ERROR_NO_PERIOD_DATA_STATISTICS_STATISTICS');
        else {
            // Titre du graphique
            if ($this->variable_id == 'var_ujl')
                $sTitle = 'GRAPH_TITLE_VARIABLE_ID_' . strtoupper($this->variable_id) . '_STATISTICS_STATISTICS';
            else
                $sTitle = 'GRAPH_TITLE_VARIABLE_ID_' . strtoupper($this->variable_id) . '_' . strtoupper($this->graph_type) . '_STATISTICS_STATISTICS';

            // Titre de la légende (Projet_FME, utilisateur...)
            $sLegendTitle = 'FORM_STATS_LEGEND_' . strtoupper($this->gb_id) . '_STATISTICS_STATISTICS';
            $this->aStats[self::LEGEND_TITLE] = $sLegendTitle;
            $sTitle .= ' / ' . $this->aStats[self::LEGEND_TITLE]; // Ajoute la légende au titre du graphique
            // Unité dans le titre (sauf pour le nombre de traitements et les données générales (pie)) & unité (version courte) à coté des nombres
            if ($this->variable_id != 'var_jn' && ($this->graph_type != 'general' || $this->variable_id == 'var_ujl')) {
                $sTitle .= ' (' . 'FORM_STATS_UNIT_ID_' . strtoupper($this->unit_id) . '_STATISTICS_STATISTICS' . ')';
                $this->aStats[self::GRAPH_DATA_UNIT] = ' ' . 'FORM_STATS_UNIT_ID_SHORT_' . strtoupper($this->unit_id) . '_STATISTICS_STATISTICS';
            }
            $this->aStats[self::GRAPH_TITLE] = $sTitle;

            // Sous titre (période du xx)
            $this->aStats[self::GRAPH_SUBTITLE] = $this->getPeriodText();

            // Labels suivant la période : utilise un tableau de référence si il existe (sauf pour 'durée des traitements unitaires')
            $arrLabels = array();
            if (!empty($this->aGranularityLabels["$this->per_type"]) && $this->variable_id != 'var_ujl')
                $arrLabels = $this->aGranularityLabels["$this->per_type"];

            // Si variable = traitements unitaires : intitulés de la légende (min, moy, max) suivant la langue
            if ($this->variable_id == 'var_ujl') {
                $aScatterLegend['min'] = 'SCATTER_LEGEND_MIN_STATISTICS_STATISTICS';
                $aScatterLegend['avg'] = 'SCATTER_LEGEND_AVG_STATISTICS_STATISTICS';
                $aScatterLegend['max'] = 'SCATTER_LEGEND_MAX_STATISTICS_STATISTICS';
                $this->aStats[self::SCATTER_LEGEND] = $aScatterLegend;
            }

            // Rempli le tableau json avec les données de stats, les labels , la légende et la palette de couleur (si imposée)
            $arrKeys = array();
            $aLabels = array();
            $aData = array();

            // Une palette de couleur est elle imposée pour ce critère de regroupement ?
            $aColors = array();
            if (isset($this->aGraphColors[$this->gb_id]))
                $aGraphColors = $this->aGraphColors[$this->gb_id];
            else
                $aGraphColors = '';

            $i = 0;
            foreach ($aRawStats as $aDb) {
                // Légende : pas de doublons (forcage en str)
                if (!empty($aDb['legend'])) {
                    $sKeyLegend = substr(strval($aDb['legend']), 0, $this->max_labels_characters);
                    if (!in_array($sKeyLegend, $arrKeys))
                        $arrKeys[] = $sKeyLegend;
                }
                // Palette de couleurs suivant legend_id (id de chaque élément de la légende)
                if (is_array($aGraphColors))
                    $aColors["{$aDb['legend_id']}"] = $aGraphColors["{$aDb['legend_id']}"];

                // Labels par tableau de référence sinon par les index
                if (!empty($arrLabels)) {
                    if (isset($arrLabels[$aDb['grain']]))
                        $sLabel = $arrLabels[$aDb['grain']]; // --> Constante introuvable ?????
                    //$sLabel = html_entity_decode($arrLabels[$aDb['grain']], ENT_QUOTES | ENT_HTML5, 'UTF-8'); // --> Constante introuvable ?????
                }
                else {
                    if (isset($aDb['grain']))
                        $sLabel = substr(strval($aDb['grain']), 0, $this->max_labels_characters);
                }

                // Data : traitement spécifique pour 'traitement unitaire' : min, moy, max. Les autres : value
                // Force le typage en numérique (sinon problème avec json_encode), si float : arrondi à 2 décimales	
                if ($this->variable_id == 'var_ujl') {
                    //$iPosition = ($i * self::SCATTER_X_SPACING) + self::SCATTER_X_SPACING;
                    $iPosition = ($i * self::SCATTER_X_SPACING) + 1;
                    $iMinimum = round($aDb['minimum'], 2);
                    $iMoyenne = round($aDb['moyenne'], 2);
                    $iMaximum = round($aDb['maximum'], 2);
                    $aData[] = array($iPosition, array($iMinimum, $iMinimum, $iMoyenne, $iMaximum, $iMaximum, self::SCATTER_COLOR_DOWN, self::SCATTER_COLOR_UP), self::SCATTER_COLOR_OUTLINE, array($sLabel, $iPosition));

                    // Ajoute le label et ses coordonnées (spécifique à traitements unitaires)
                    $aLabels[] = array($sLabel, $iPosition);
                } else {
                    $aData["{$aDb['grain']}"][] = round($aDb['value'], 2);

                    // Si le label n'est pas déja présent : on l'ajoute (pour eviter les doublons)	
                    if (!in_array($sLabel, $aLabels))
                        $aLabels[] = $sLabel;
                }
                $i++;
            }

            // Supprime les clés et garde uniquement les valeurs du tableau de données converti
            $aData = array_values($aData);

            // Ajoute les données formatées des stats, les labels, la légende et la palette de couleurs dans le tableau json
            $this->aStats[self::GRAPH_DATA] = $aData;
            $this->aStats[self::GRAPH_KEY] = $arrKeys;
            if (!empty($aColors))
                $this->aStats[self::GRAPH_COLORS] = array_values($aColors); // Garde les valeurs mais pas les clés
            if (!empty($aLabels))
                $this->aStats[self::GRAPH_LABELS] = $aLabels;
        }
    }

    /*     * *********************************
      Retourne un texte formaté correspondant à la période des stats et à la langue (ex: semaine = semaine du xx au xx)
     * ********************************* */

    private function getPeriodText() {
        // Texte correspondant au type de période sélectionné (jour, mois....)
        $sPeriodText = 'PERIOD_TEXT_' . strtoupper($this->per_type) . '_STATISTICS_STATISTICS';

        // Formate la date suivant $this->aProperties['date_format'] / sinon suivant la langue
        $oMyDate = new DateTime($this->per_date);
        if (!empty($this->aProperties['date_format']))
            $date_format = $this->aProperties['date_format'];
        else {
            if ($this->aProperties["language"] == 'fr')
                $date_format = 'd/m/Y';
            else
                $date_format = 'm/d/Y';
        }
        $sPerDate = $oMyDate->format($date_format);

        // Formatage du texte suivant la période

        $this->aStats['translation_values'] = array();

        switch ($this->per_type) {
            // Période = jour
            case 'per_day':
                $sPeriodText = str_replace('[sPerDate]', $sPerDate, $sPeriodText); // Date au format
                $this->aStats['translation_values']['sPerDate'] = $sPerDate;
                break;

            // Période = semaine
            case 'per_week';
                $oMyDate = $oMyDate->add(date_interval_create_from_date_string('6 days')); // Ajoute 1 semaine à la date de début '1 week'
                $sEndPerDate = $oMyDate->format($date_format);
                $sPeriodText = str_replace('[sEndPerDate]', $sEndPerDate, $sPeriodText);
                $sPeriodText = str_replace('[sPerDate]', $sPerDate, $sPeriodText);
                $this->aStats['translation_values']['sPerDate'] = $sPerDate;
                $this->aStats['translation_values']['sEndPerDate'] = $sEndPerDate;
                break;

            // Période = mois
            case 'per_month':
                $sPeriodText = $this->aMonthNames[$oMyDate->format('n')] . ' ' . $oMyDate->format('Y'); // Nom du mois + l'année sur 4 chiffres;
                break;

            // Période = année
            case 'per_year':
                $sPerYear = $oMyDate->format('Y'); // L'année sur 4 chiffres
                $sPeriodText = str_replace('[sPerYear]', $sPerYear, $sPeriodText);
                $this->aStats['translation_values']['sPerYear'] = $sPerYear;
                break;
        }

        return $sPeriodText;
    }

    /*     * ********************************
      Configure le statut et un message dans le tableau json
      $iStatus : Succés, erreur...
      $sMessage : Message correspondant au statut
     * ********************************* */

    private function setStatus($iStatus, $sMessage = '') {
        $this->aStats['status'] = $iStatus;
        $this->aStats['message'] = $sMessage;
    }

}

/* * ********************************
  Fermeture de la connexion à la bdd
 * ********************************* */

function __destruct() {
    $this->oBd->quitter();
}

?>