<?php

// Requête générique de données sur la période et par granularité
$aSql['pgsql']['stats']['normal'] = "SELECT grain,pc.aSqlLegendGroupBy[this->gb_id] as legend,COALESCE(dynamic.value, 0::integer) AS value FROM ( SELECT static.grain,xuser.aSqlLegendGroupBy[this->gb_id] FROM (SELECT aSqlPerDateGenerateSeries[this->per_type] as grain) as static, (SELECT distinct aSqlLegendGroupBy[this->gb_id] FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') ORDER BY aSqlLegendGroupBy[this->gb_id] LIMIT [max_elements]) as xuser ) as pc left join (SELECT date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date) as jour,job.aSqlLegendGroupBy[this->gb_id] ,aSqlUnit[this->unit_id] as value FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') GROUP BY date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date),aSqlLegendGroupBy[this->gb_id] ) as dynamic ON pc.grain=dynamic.jour AND pc.aSqlLegendGroupBy[this->gb_id]=dynamic.aSqlLegendGroupBy[this->gb_id] order by pc.grain, legend";

// Idem requête 'normal' + récupération des traductions (ex: état des traitements : traité, non traité...)
$aSql['pgsql']['stats']['traductions'] = "SELECT grain,translation as legend,COALESCE(dynamic.value, 0::integer) AS value,pc.aSqlLegendGroupBy[this->gb_id] as legend_id FROM ( SELECT static.grain,xuser.aSqlLegendGroupBy[this->gb_id] FROM (SELECT aSqlPerDateGenerateSeries[this->per_type] as grain) as static, (SELECT distinct aSqlLegendGroupBy[this->gb_id] FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') ORDER BY aSqlLegendGroupBy[this->gb_id] LIMIT [max_elements]) as xuser ) as pc left join (SELECT date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date) as jour,job.aSqlLegendGroupBy[this->gb_id] ,aSqlUnit[this->unit_id] as value FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') GROUP BY date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date),aSqlLegendGroupBy[this->gb_id] ) as dynamic ON pc.grain=dynamic.jour AND pc.aSqlLegendGroupBy[this->gb_id]=dynamic.aSqlLegendGroupBy[this->gb_id] left join [sSchemaGtf].rt_order_status ON pc.order_status_id=rt_order_status.order_status_id left join [sSchemaFramework].vm_translation ON rt_order_status.label_id=vm_translation.translation_id WHERE vm_translation.lang='properties['language']' order by pc.grain, legend";

// Requête spécifique de données limités à un regroupement de x valeurs (ex: 5 utilisateurs max + 'SQL_MAX_ELEMENTS_OTHERS')
$aSql['pgsql']['stats']['max_elements'] = "SELECT grain, legend, value FROM ( SELECT grain,pc.aSqlLegendGroupBy[this->gb_id]::text as legend,COALESCE(dynamic.value, 0::integer) AS value FROM ( SELECT static.grain,xuser.aSqlLegendGroupBy[this->gb_id] FROM (SELECT aSqlPerDateGenerateSeries[this->per_type] as grain) as static, ( SELECT aSqlLegendGroupBy[this->gb_id] FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') group by  aSqlLegendGroupBy[this->gb_id] order by sum(length_sec) desc limit [max_elements] ) as xuser ) as pc left join (SELECT date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date) as jour,job.aSqlLegendGroupBy[this->gb_id] ,aSqlUnit[this->unit_id] as value FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') GROUP BY date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date),aSqlLegendGroupBy[this->gb_id] ) as dynamic ON pc.grain=dynamic.jour AND pc.aSqlLegendGroupBy[this->gb_id]=dynamic.aSqlLegendGroupBy[this->gb_id] ) p1 union SELECT grain,'SQL_MAX_ELEMENTS_OTHERS' as legend,COALESCE(sum(dynamic.value), 0::integer) AS value FROM ( SELECT static.grain,xuser2.aSqlLegendGroupBy[this->gb_id] FROM (SELECT aSqlPerDateGenerateSeries[this->per_type] as grain) as static, ( SELECT aSqlLegendGroupBy[this->gb_id] FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') group by  aSqlLegendGroupBy[this->gb_id] order by sum(length_sec) desc offset [max_elements] ) as xuser2 ) as pc2 left join (SELECT date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date) as jour,job.aSqlLegendGroupBy[this->gb_id] ,aSqlUnit[this->unit_id] as value FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') GROUP BY date_part('aSqlGranularityOrderBy[this->per_type]', job.execution_date),aSqlLegendGroupBy[this->gb_id] ) as dynamic ON pc2.grain=dynamic.jour AND pc2.aSqlLegendGroupBy[this->gb_id]=dynamic.aSqlLegendGroupBy[this->gb_id] group by pc2.grain order by grain, legend";

// Durée des traitements unitaires
$aSql['pgsql']['stats']['traitements_unitaires'] = "SELECT distinct workspace as grain,min(length_sec)aSqlUnitVarUjl[this->unit_id] as minimum, avg(length_sec)aSqlUnitVarUjl[this->unit_id] as moyenne, max(length_sec)aSqlUnitVarUjl[this->unit_id] as maximum FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') group by grain ORDER BY moyenne DESC";

// Requête générique pour la répartition (2eme graphique)
//	$aSql['pgsql']['generic'][1] = "SELECT distinct job.aSqlLegendGroupBy[this->gb_id] as legend,(0) as grain,sum(job.length_sec)::integer as value FROM [sSchemaGtf].job WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') GROUP BY job.aSqlLegendGroupBy[this->gb_id] ORDER BY legend desc LIMIT [max_elements]";

/*
  // Exception : répartition (2eme graphique) : Critère = état --> récupération des traductions
  $aSql['pgsql']['gb_status'][1] = "SELECT distinct (0) as grain,vm_translation.translation as legend,sum(job.length_sec)::integer as value FROM [sSchemaGtf].job,[sSchemaGtf].rt_order_status,[sSchemaGtf].vm_translation
  WHERE job.execution_date >= DATE([per_date]) AND job.execution_date < (DATE([per_date]) + interval 'aSqlIntervalLength[this->per_type]') AND job.order_status_id=rt_order_status.order_status_id AND rt_order_status.label_id=vm_translation.translation_id AND vm_translation.lang='properties['lang']'
  GROUP BY legend ORDER BY value desc LIMIT [max_elements]";
 */
?>