<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Survey.class.inc
 * \class Survey
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Survey php class
 *
 * This class defines operation for one Survey
 * 
 */
class Survey extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('order_id', 'workspace_key', 'priority_id', 'workspace_id', 'enabled', 'label_name', 'order_status_id', 'user_id', 'login', 'period_id', 'order_period_libelle', 'wk_params', 'result_url', $this->getDateSelectedFields('order_date', 'yeartosecond'), 'log_url', $this->getDateSelectedFields('execution_date', 'yeartosecond'), 'attempt', 'email_notifications', 'email_option_id', 'deleted', 'gtf_engine_id', 'survey_id', 'condition', 'warehouse_name', 'notification', 'survey_name');
    }

    /**
     * @SWG\Get(path="/surveys/{order_id}", 
     *   tags={"Surveys"},
     *   summary="Get Survey",
     *   description="Request to get Survey by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="order id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/surveys")
     *     )
     *  )
     */

    /**
     * get informations about survey
     */
    function GET() {
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_survey", "order_id");
    }

    /**
     * delete an survey
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'v_survey', 'order_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['order_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>