<?php

/**
 * \file Surveys.class.inc
 * \class Surveys
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Surveys php class
 *
 * This class defines Rest Api to Gtf surveys
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'Survey.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class Surveys extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/surveys",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/surveys")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Surveys",
     *   description="Operations about Surveys"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('order_id', 'workspace_key', 'priority_id', 'workspace_id', 'enabled', 'label_name', 'order_status_id', 'user_id', 'login', 'period_id', 'order_period_libelle', 'wk_params', 'result_url', $this->getDateSelectedFields('order_date', 'yeartosecond'), 'log_url', $this->getDateSelectedFields('execution_date', 'yeartosecond'), 'attempt', 'email_notifications', 'email_option_id', 'deleted', 'gtf_engine_id', 'survey_id', 'condition', 'warehouse_name', 'notification', 'survey_name', "name || '/' || condition as full_condition");
    }

    /**
     * @SWG\Get(path="/surveys",
     *   tags={"Surveys"},
     *   summary="Get Surveys",
     *   description="Request to get Surveys",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of surveying fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/surveys")
     *     )
     *  )
     */

    /**
     * get Surveys
     * @return  Surveys
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_survey", "order_id");
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Delete(path="/surveys/",
     *   tags={"Surveys"},
     *   summary="delete Survey",
     *   description="Request to delete Survey",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the surveys",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/surveys")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/surveys/{order_id}",
     *   tags={"Surveys"},
     *   summary="delete Survey",
     *   description="Request to delete Survey",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="id of the order",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/surveys")
     *     )
     *  )
     */

    /**
     * delete survey
     * @return id of survey deleted or error object if a survey is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'v_survey', 'order_id');
        return $aReturn['sMessage'];
    }

}

?>