<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Inbox.class.inc
 * \class Inboxe
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Inboxe php class
 *
 * This class defines operation for one Inbox
 * 
 */
class UserInboxe extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('inbox_id', 'name');
    }

    /**
     * @SWG\Get(path="/userinboxes/{inbox_id}", 
     *   tags={"Inboxes"},
     *   summary="Get Inboxe",
     *   description="Request to get Inbox by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="inbox_id",
     *     in="path",
     *     description="inbox id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="form",
     *     in="query",
     *     description="form to load",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/userinboxes")
     *     )
     *  )
     */

    /**
     * get informations about inbox
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_inbox", "inbox_id");
    }

}

?>