<?php

/**
 * \file Inboxes.class.inc
 * \class Inboxes
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Inboxes php class
 *
 * This class defines Rest Api to Gtf Inboxes
 * 
 */
require_once 'Gtf.class.inc';
require_once 'UserInboxe.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/phpUtil.inc';

class UserInboxes extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/userinboxes",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/userinboxes")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Inboxes",
     *   description="Operations about Inboxes"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        $this->aValues = $aValues;
        $this->aPath = $aPath;
        $this->aProperties = $properties;
        $this->aValues['getGroup'] = true;
        $this->oConnection = new Connection($this->aValues, $this->aProperties);
        $this->aSelectedFields = Array('inbox_id', 'alias', 'name');
    }

    /**
     * @SWG\Get(path="/userinboxes",
     *   tags={"Inboxes"},
     *   summary="Get User Inboxes",
     *   description="Request to get Inboxes",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/userworkspaces")
     *     )
     *  )
     */

    /**
     * get Workspaces
     * @return  Workspaces
     */
    function GET() {
        $sesGroup = $this->oConnection->sesGroup;
        if (!empty($this->aValues['filter'])) {
            $oFilter = json_decode($this->aValues['filter']);
            $oFilter->operators[] = json_decode('{"column": "group_id", "compare_operator": "IN", "value": [' . $sesGroup . ']}');
            $this->aValues['filter'] = json_encode($oFilter);
        } else
            $this->aValues['filter'] = '{"relation": "AND", "operators": [{"column": "group_id", "compare_operator": "IN", "value": [' . $sesGroup . ']}]}';
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_inbox", "inbox_id");
        return $aReturn['sMessage'];
    }

}

?>