<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file UserOrder.class.inc
 * \class UserOrder
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the UserOrder php class
 *
 * This class defines operation for one UserOrder
 * 
 */
class UserOrder extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("order_id", "priority_id", "workspace_key", "workspace_id", "name", "order_status_id", "user_id", "wk_params", "result_url", $this->getDateSelectedFields('order_date', 'yeartosecond'), "log_url", $this->getDateSelectedFields('execution_date', 'yeartosecond'), "attempt", "email_notifications", "email_option_id", "deleted", "gtf_engine_id", "length_sec", "workspace_name", $this->getDateSelectedFields('minexecdate', 'yeartosecond'));
    }

    /**
     * @SWG\Get(path="/userorders/{order_id}", 
     *   tags={"UserOrders"},
     *   summary="Get UserOrder",
     *   description="Request to get UserOrder by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="userorder id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/userorders")
     *     )
     *  )
     */

    /**
     * get informations about userorder
     */
    function GET() {
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_user_order", "order_id");
    }

    /**
     * delete an userorder
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'v_user_order', 'order_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['order_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>
