<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file UserSubscription.class.inc
 * \class UserSubscription
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the UserSubscription php class
 *
 * This class defines operation for one UserSubscription
 * 
 */
class UserSubscription extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('order_id', 'workspace_id', 'workspace_key', 'enabled', 'label_name', 'order_status_id', 'user_id', 'period_id', $this->getDateSelectedFields('order_date', 'yeartosecond'), $this->getDateSelectedFields('execution_date', 'yeartosecond'), 'wk_params', 'result_url', 'email_option_id', 'email_notifications', 'gtf_engine_id', 'workspace_name', 'notification', 'order_period_libelle');
    }

    /**
     * @SWG\Get(path="/usersubscriptions/{order_id}",
     *   tags={"UserSubscriptions"},
     *   summary="Get UserSubscription",
     *   description="Request to get UserSubscription by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="order id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersubscriptions")
     *     )
     *  )
     */

    /**
     * get informations about usersubscription
     */
    function GET() {
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_user_subscription", "order_id");
    }

    /**
     * delete an usersubscription
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'v_user_subscription', 'order_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['order_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>