<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file UserSurvey.class.inc
 * \class UserSurvey
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the UserSurvey php class
 *
 * This class defines operation for one UserSurvey
 * 
 */
class UserSurvey extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('order_id', 'workspace_key', 'workspace_id', 'label_name', 'enabled', 'order_status_id', 'user_id', 'period_id', $this->getDateSelectedFields('order_date', 'yeartosecond'), $this->getDateSelectedFields('execution_date', 'yeartosecond'), 'wk_params', 'result_url', 'email_option_id', 'email_notifications', 'gtf_engine_id', 'survey_id', 'condition', 'inbox_id', 'name', 'workspace_name', 'monitoring_type', 'notification', 'order_period_libelle', 'survey_name');
    }

    /**
     * @SWG\Get(path="/usersurveys/{order_id}", 
     *   tags={"UserSurveys"},
     *   summary="Get UserSurvey",
     *   description="Request to get UserSurvey by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="order id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     )
     *  )
     */

    /**
     * get informations about usersurvey
     */
    function GET() {
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_user_survey", "order_id");
    }

    /**
     * delete an usersurvey
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'v_user_survey', 'order_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['order_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>