<?php

/**
 * \file UserSurveys.class.inc
 * \class UserSurveys
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the UserSurveys php class
 *
 * This class defines Rest Api to Gtf usersurveys
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'UserSurvey.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class UserSurveys extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/usersurveys",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/usersurveys")
     *   }
     * )
     * * @SWG\Tag(
     *   name="UserSurveys",
     *   description="Operations about UserSurveys"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $login = $_SESSION['ses_Login'];
        $this->aSelectedFields = Array('order_id', 'workspace_key', 'workspace_id', 'label_name', 'enabled', 'order_status_id', 'user_id', 'period_id', $this->getDateSelectedFields('order_date', 'yeartosecond'), $this->getDateSelectedFields('execution_date', 'yeartosecond'), 'wk_params', 'result_url', 'email_option_id', 'email_notifications', 'gtf_engine_id', 'survey_id', 'condition', 'inbox_id', 'name', 'workspace_name', 'monitoring_type', 'notification', 'order_period_libelle', 'survey_name', "replace(name, '\$user', '$login') || '/' || condition as full_condition");
    }

    /**
     * @SWG\Get(path="/usersurveys",
     *   tags={"UserSurveys"},
     *   summary="Get UserSurveys",
     *   description="Request to get UserSurveys",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of surveying fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     )
     *  )
     */

    /**
     * get UserSurveys
     * @return  UserSurveys
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_user_survey", "order_id");
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Post(path="/usersurveys",
     *   tags={"UserSurveys"},
     *   summary="Add UserSurvey",
     *   description="Request to add user survey",
     *   operationId="POST",
     *   produces={"application/xml", "application/json",  "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="order_date",
     *     in="formData",
     *     description="user order date",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="formData",
     *     description="workspace id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="priority_id",
     *     in="formData",
     *     description="priority id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="email_option_id",
     *     in="formData",
     *     description="email option id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="user_id",
     *     in="formData",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="wk_params",
     *     in="formData",
     *     description="workspace parameters",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="period_id",
     *     in="formData",
     *     description="period id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="enabled",
     *     in="formData",
     *     description="enabled",
     *     required=true,
     *     type="boolean"
     *   ),
     *   @SWG\Parameter(
     *     name="survey_id",
     *     in="formData",
     *     description="survey id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="inbox_id",
     *     in="formData",
     *     description="inbox id",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="condition",
     *     in="formData",
     *     description="condition",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     ),
     * 
     *  )
     */

    /**
     * insert user's survey
     * @return id of the user's usersurvey created
     */
    function POST() {
        $this->aValues['order_date'] = gmdate('Y-m-d H:i:s');
        $this->aValues['user_id'] = $_SESSION['ses_user_id'];
        // Si token public -> id du compte public.
        if ($this->aValues['token'] == $this->aProperties['public_token']) {
            $aPrivateTokenValues = $this->aValues;
            $aPrivateTokenValues['user'] = $_SESSION['ses_Login'];
            $aPrivateTokenValues['password'] = $this->oConnection->oBd->mdp;
            $oPrivateToken = new PrivateToken($this->aPath, $aPrivateTokenValues, $this->aProperties, $this->oConnection);
            $oPrivateToken->POST();
            // Teste si le compte 'public' a un des groupes qui est lié au traitement.
            require $this->sRessourcesFile;
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $aParams['workspace_id'] = array('value' => $this->aValues['workspace_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['checkUserWorkspace'], $aParams);
            if ($this->oConnection->oBd->enErreur()) {
                $oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
                $aXmlRacineAttribute['status'] = 0;
                $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                return $sMessage;
            } else {
                if ($this->oConnection->oBd->nombreLigne($oPDOresult) == 0) {
                    $oError = new VitisError(1, "ERROR_WORKSPACE_NOT_LINKED_USER_GROUPS_WIDGET");
                    $aXmlRacineAttribute['status'] = 0;
                    $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                    return $sMessage;
                }
            }
        }
        $aReturn = $this->genericPost($this->aProperties['schema_gtf'], 'v_user_survey', $this->aProperties['schema_gtf'] . '.seq_order', 'order_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            $oUserSurvey = new UserSurvey($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
            $oUserSurvey->GET();
            // Met à jour le n° du moteur.
            $this->getIdEngine($this->aValues["my_vitis_id"], 'userorder', $this->aValues['workspace_id']);
            require $this->sRessourcesFile;
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $aParams['order_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            $aParams['gtf_engine_id'] = array('value' => $this->aValues['gtf_engine_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['setUserOrderEngineId'], $aParams);
            if ($this->oConnection->oBd->enErreur()) {
                $oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
                $aXmlRacineAttribute['status'] = 0;
                $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            }
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

    /*
     * function getIdEngine
     * \brief function that assigns each request processing an engine number. This engine number will be defined by the algorithm associated to the treatment.
     * \param $iUserOrderId Identifier of the request
     * \param $sTable Name of the table.
     * \param $iWorkspaceId Identifier of the treatment.
     */

    function getIdEngine($iUserOrderId, $sTable, $iWorkspaceId) {
        require $this->sRessourcesFile;
        // Récupération de l'algorithme
        $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
        $aParams['iWorkspaceId'] = array('value' => $iWorkspaceId, 'type' => 'number');
        $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getEnginesId'], $aParams);
        $this->oConnection->oBd->cleanMessage();
        $aEnginesId = array();
        while ($oEnginesId = $this->oConnection->oBd->objetSuivant($oPDOresult))
            $aEnginesId[] = $oEnginesId->gtf_engine_id;
        $this->oConnection->oBd->fermeResultat();

        if (count($aEnginesId) == 0) {
            // Le tag correspondant n'a pas été trouvé, nous allons cherché la liste des moteur ayant comme tag |default|
            $aParams = array();
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getEnginesDefaultTag'], $aParams);
            $this->oConnection->oBd->cleanMessage();
            $aEnginesId = array();
            while ($oEnginesId = $this->oConnection->oBd->objetSuivant($oPDOresult))
                $aEnginesId[] = $oEnginesId->gtf_engine_id;
            $this->oConnection->oBd->fermeResultat();
            if (count($aEnginesId) > 0)
                writeToErrorLog(str_replace('[iUserOrderId]', $iUserOrderId, ERROR_0006));
        }
        // Si la requête est en erreur ou Si aucun moteur n'a été trouvé.
        if ($this->oConnection->oBd->erreurRencontree || count($aEnginesId) == 0) {
            $aGtfEngineList = explode(",", $this->aProperties["engines_list"]);
            // Aucun tag ne correspond
            $iEngine = $aGtfEngineList[0];
            if ($iEngine != "")
                writeToErrorLog(str_replace('[aGtfEngineList[0]]', $iEngine, str_replace('[iUserOrderId]', $iUserOrderId, ERROR_0007)));
        }else {
            $iEngine = $this->returnEngineId($iUserOrderId, $aEnginesId);
        }

        if ($iEngine == "") {
            writeToErrorLog(str_replace('[iUserOrderId]', $iUserOrderId, ERROR_0008));
            $this->aValues['gtf_engine_id'] = 1;
        } else {
            $this->aValues['gtf_engine_id'] = $iEngine;
        }
    }

    /*
     * function returnEngineId
     * \param $oAlgoIndex Object of the algorithm.
     * \param $aGtfEngineList Array that corresponds to the list of available engines numbers.
     * \return Returns the engine number.
     */

    function returnEngineId($iUserOrderId, $aEnginesId) {
        $iEngine = "";
        if (count($aEnginesId) > 0) {
            $sRowCount = $iUserOrderId % count($aEnginesId);
            $iEngine = $aEnginesId[$sRowCount];
        }
        return $iEngine;
    }

    /**
     * @SWG\Put(path="/usersurveys/{order_id}",
     *   tags={"UserSurveys"},
     *   summary="Update UserSurvey",
     *   description="Request to update UserSurvey",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="usersurvey token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="id of the usersurvey",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     *   @SWG\Parameter(
     *     name="order_date",
     *     in="query",
     *     description="user order date",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="query",
     *     description="workspace id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="priority_id",
     *     in="query",
     *     description="priority id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="email_option_id",
     *     in="query",
     *     description="email option id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="user_id",
     *     in="query",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="wk_params",
     *     in="query",
     *     description="workspace parameters",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="period_id",
     *     in="query",
     *     description="period id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="enabled",
     *     in="query",
     *     description="enabled",
     *     required=true,
     *     type="boolean"
     *   ),
     *   @SWG\Parameter(
     *     name="survey_id",
     *     in="query",
     *     description="survey id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="inbox_id",
     *     in="query",
     *     description="inbox id",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="condition",
     *     in="query",
     *     description="condition",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     )
     *  )
     */

    /**
     * update category
     * @return id of the category if ok error object if ko
     */
    function PUT() {
        $aReturn = $this->genericPut($this->aProperties['schema_gtf'], 'v_user_survey', 'order_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

    /**
     * @SWG\Delete(path="/usersurveys/",
     *   tags={"UserSurveys"},
     *   summary="delete UserSurvey",
     *   description="Request to delete UserSurvey",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="usersurvey token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the usersurveys",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/usersurveys/{order_id}",
     *   tags={"UserSurveys"},
     *   summary="delete UserSurvey",
     *   description="Request to delete UserSurvey",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="usersurvey token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="order_id",
     *     in="path",
     *     description="id of the usersurvey",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/usersurveys")
     *     )
     *  )
     */

    /**
     * delete usersurvey
     * @return id of usersurvey deleted or error object if a usersurvey is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'v_user_survey', 'order_id');
        return $aReturn['sMessage'];
    }

}

?>