<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'vmlib/logUtil.inc';

/**
 * \file Workspace.class.inc
 * \class Workspace
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Workspace php class
 *
 * This class defines operation for one Workspace
 * 
 */
class UserWorkspace extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('workspace_id', 'name');
    }

    /**
     * @SWG\Get(path="/userworkspaces/{workspace_id}", 
     *   tags={"Workspaces"},
     *   summary="Get Workspace",
     *   description="Request to get Workspace by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="path",
     *     description="workspace id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="form",
     *     in="query",
     *     description="form to load",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/userworkspaces")
     *     )
     *  )
     */

    /**
     * get informations about workspace
     */
    function GET() {
        if ($this->aValues["form"]) {
            $sDirName = $this->aProperties['vas_home'] . "/rest/ws/gtf/workspace/" . (string) $this->aValues["my_vitis_id"];
            if ($this->aValues["form"] == "Default") {
                $pFile = fopen($sDirName . "/form/DSubform.json", "r");
                $iSize = filesize($sDirName . "/form/DSubform.json");
            } else if ($this->aValues["form"] == "Perso") {
                $pFile = fopen($sDirName . "/form/WSubform.json", "r");
                $iSize = filesize($sDirName . "/form/WSubform.json");
            } else if ($this->aValues["form"] == "Published") {
                $pFile = fopen($sDirName . "/form/Subform.json", "r");
                $iSize = filesize($sDirName . "/form/Subform.json");
            } else {
                writeToErrorLog("ERROR : Error parameter is not a known mode");
            }
            $sJson = fread($pFile, $iSize);
            fclose($pFile);
            $aJson = json_decode($sJson, true);
            $this->aFields = array($aJson);
            $sJs = "";
            $sCss = "";
            if ($aJson["insert"]["javascript"] == true) {
                $pFileJS = fopen($sDirName . "/form/ressources/Subform.js", "r");
                $iSize = filesize($sDirName . "/form/ressources/Subform.js");
                $sJs = fread($pFileJS, $iSize);
                fclose($pFileJS);
            }
            if ($aJson["insert"]["style"] == true) {
                $pFileCSS = fopen($sDirName . "/form/ressources/Subform.css", "r");
                $iSize = filesize($sDirName . "/form/ressources/Subform.css");
                $sCss = fread($pFileCSS, $iSize);
                fclose($pFileCSS);
            }
            array_push($this->aFields, $sJs);
            array_push($this->aFields, $sCss);
        } else {
            require $this->sRessourcesFile;
            $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_user_workspace", "workspace_id");
        }
    }

}

?>