<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Workspace.class.inc
 * \class Workspace
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Workspace php class
 *
 * This class defines operation for one Workspace
 * 
 */
class Workspace extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('workspace_id', 'name', 'owner', $this->getDateSelectedFields('creation_date', 'yeartosecond'), 'description', 'subscription', 'category_id', 'success_action_id', 'failed_action_id', 'survey', 'form_type', 'legal_terms_conditions', $this->getDateSelectedFields('last_save_date', 'yeartosecond'), 'last_save_build', 'file_encoding', 'title', 'requirements', 'history', 'usage', 'key', 'email_template_id', 'locked', 'tag', 'groups', 'login', 'category_name', 'email_template', 'fmw_file', 'dataencrypt', 'usepersonaldata', 'unitcost', 'costpersecond');
    }

    /**
     * @SWG\Get(path="/workspaces/{workspace_id}", 
     *   tags={"Workspaces"},
     *   summary="Get Workspace",
     *   description="Request to get Workspace by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="path",
     *     description="workspace id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="form",
     *     in="query",
     *     description="form to load",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/workspaces")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/workspaces/{workspace_id}/Tree",
     *   tags={"Workspaces"},
     *   summary="Get Workspace directory tree",
     *   description="Request to get Workspace directory tree by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="path",
     *     description="workspace id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/workspaces")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/workspaces/{workspace_id}/File",
     *   tags={"Workspaces"},
     *   summary="Get Workspace file",
     *   description="Request to get a file from the workspace directory",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="path",
     *     description="workspace id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="file_name",
     *     in="query",
     *     description="file name",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/workspaces")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/workspaces/{workspace_id}/Metadata",
     *   tags={"Workspaces"},
     *   summary="Regenerate workspace metadata",
     *   description="Request to regenerate the metadata of a workspace",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="workspace_id",
     *     in="path",
     *     description="workspace id",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Properties Response",
     *         @SWG\Schema(ref="#/definitions/workspaces")
     *     )
     *  )
     */

    /**
     * get informations about workspace
     */
    function GET() {
        if (!empty($this->aValues["form"])) {
            $sDirName = $this->aProperties['workspace_dir'] . "/" . (string) $this->aValues["my_vitis_id"];
            require $this->sRessourcesFile;
            $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_workspace", "workspace_id");
            $this->getGroups();

            if ($this->aValues["form"] == "Default") {
                $sFile = $sDirName . "/form/DSubform.json";
            } else if ($this->aValues["form"] == "Perso") {
                $sFile = $sDirName . "/form/WSubform.json";
            } else if ($this->aValues["form"] == "Published") {
                $sFile = $sDirName . "/form/Subform.json";
            } else {
                writeToErrorLog("Error parameter is not a known mode user :" . $_SESSION["user_id"]);

                $this->oError = new VitisError(1, "Error parameter is not a known mode");
            }
            if (is_file($sFile)) {
                $pFile = fopen($sFile, "r");
                $iSize = filesize($sFile);
                $sJson = fread($pFile, $iSize);
                fclose($pFile);
                $aJson = json_decode($sJson, true);
                $this->aFields["json_form"] = array($aJson);
                $sJs = "";
                $sCss = "";
                if (is_dir($sDirName . "/form")) {
                    if ($dh = opendir($sDirName . "/form/ressources")) {
                        while (($file = readdir($dh)) !== false) {
                            $sName = explode(".", $file);
                            if ($sName[1] == "js") {
                                // $pFileJS = fopen($sDirName . "/form/ressources/Subform.js", "r");
                                // $iSize = filesize($sDirName . "/form/ressources/Subform.js");
                                // $sJs = fread($pFileJS, $iSize);
                                // fclose($pFileJS);

                                $sJs = $this->aProperties['web_server_name'] . '/' . $this->aProperties['ws_data_alias'] . "/gtf/workspace/" . (string) $this->aValues["my_vitis_id"] . "/form/ressources/Subform.js";
                            }
                            if ($sName[1] == "css") {
                                /* $pFileCSS = fopen($sDirName . "/form/ressources/Subform.css", "r");
                                  $iSize = filesize($sDirName . "/form/ressources/Subform.css");
                                  $sCss = fread($pFileCSS, $iSize);
                                  fclose($pFileCSS); */
                                $sCss = $this->aProperties['web_server_name'] . '/' . $this->aProperties['ws_data_alias'] . "/gtf/workspace/" . (string) $this->aValues["my_vitis_id"] . "/form/ressources/Subform.css";
                            }
                        }
                        closedir($dh);
                    }
                }
                array_push($this->aFields["json_form"], $sJs);
                array_push($this->aFields["json_form"], $sCss);
            } else {

                $this->oError = new VitisError(1, "File not found");
            }
        } else {
            require $this->sRessourcesFile;
            $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_workspace", "workspace_id");
            $this->getGroups();
            // Url vers le fichier fmw du projet.
            if (!empty($this->aFields['fmw_file']))
                $this->aFields['fmw_file_url'] = $this->aProperties['web_server_name'] . '/' . $this->aProperties['ws_data_alias'] . '/gtf/workspace/' . $this->aValues['my_vitis_id'] . '/fme/' . $this->aFields['fmw_file'];
        }
        // Formatage de la colonne "form_type".
        $sFile = $this->aProperties['workspace_dir'] . "/" . $this->aValues["my_vitis_id"] . '/form/Subform.json';
        if (!file_exists($sFile))
            $this->aFields['form_type'] = '';
        else {
            if ($this->aFields['form_type'] != "custom")
                $this->aFields['form_type'] = "default";
        }
    }

    function getGroups() {
        require $this->sRessourcesFile;
        if (in_array("groups", $this->aSelectedFields)) {
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $aParams['sSchemaFramework'] = array('value' => $this->aProperties['schema_framework'], 'type' => 'schema_name');
            $aParams['workspace_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getWorkspaceGroups'], $aParams);
            $sListGroupId = "";
            $aListGroupName = array();
            while ($aLigne = $this->oConnection->oBd->ligneSuivante($oPDOresult)) {
                if ($sListGroupId == "") {
                    $sListGroupId = $aLigne["group_id"];
                } else {
                    $sListGroupId .= "|" . $aLigne["group_id"];
                }
                $aListGroupName[] = $aLigne["name"];
            }
            $oPDOresult = $this->oConnection->oBd->fermeResultat();
            $this->aFields['groups'] = $sListGroupId;
            $this->aFields['groups_label'] = implode(',', $aListGroupName);
        }
    }

    /**
     * delete a workspace
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'workspace', 'workspace_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['workspace_id'] = $this->aValues["my_vitis_id"];

            $sDirName = $this->aProperties['workspace_dir'] . "/" . $this->aFields["workspace_id"] . "/";
            if (is_dir($sDirName)) {
                clearDir($sDirName);
            } else {
                writeToErrorLog("No folder link with this workspace. verify if the workspace folder already exist on the server");
            }
        }
    }

}

?>