/* global formReader, goog, angular, NaN */

/**
 * @author: Armand Bahi
 * @Description: Form Reader Controller
 * @module formReader
 */
goog.provide('formReader.controller.formReaderController');
goog.require('formReader');

/**
 * Form displayer controller
 * @constructor
 * @param {object} $scope
 * @param {object} $q
 * @param {object} $log
 * @param {object} formReaderService
 * @param {object} $rootScope
 * @returns {formReader.formReaderController}
 * @ngInject
 * @export
 */
formReader.formReaderController = function ($scope, $q, $log, formReaderService, $rootScope, $element) {
    $log.info("formReader.formReaderController");
    var this_ = this;
    /**
     * @private
     */
    this.$scope_ = $scope;
    /**
     * @private
     */
    this.$q_ = $q;
    /**
     * @private
     */
    this.$log_ = $log;
    /**
     * @private
     */
    this.$element_ = $element;
    /**
     * @private
     */
    this.formReaderService_ = formReaderService;
    /**
     * Variables watched in case of cascade/parent events
     * @private
     */
    this.aWatchedVariables_ = [];
    $scope['oFormValues'] = goog.isDef($scope['oFormValues']) ? $scope['oFormValues'] : {};
    $scope['oFormDefinition'] = goog.isDef($scope['oFormDefinition']) ? $scope['oFormDefinition'] : {};
    $scope['sFormDefinitionName'] = goog.isDef($scope['sFormDefinitionName']) ? $scope['sFormDefinitionName'] : "";

    this.initFormTabs();

    // Utilisé pour les onglets
    $scope['sFormUniqueName'] = Date.now();

    // Onglet en cours
    $scope['iDisplayedTab'] = 0;

    // Événement au changement d'onglet
    $scope.$watch('iDisplayedTab', function(){
        // Rafraichit les grilles subform
        this_.refreshSubformGrids();
    });

    if (typeof ($rootScope["oFormPromises"]) == "undefined")
        $rootScope["oFormPromises"] = {};
    $rootScope["oFormPromises"][$scope['sFormDefinitionName']] = [];
    // Pas de listener si la définition du formulaire est déja chargée.
    var oFormDefinition = $scope['oFormDefinition'][$scope['sFormDefinitionName']];
    if (typeof (oFormDefinition) != "undefined" && oFormDefinition["formDefinitionLoaded"] === true)
        this_.loadForm();
    else {
        var clearListener = $rootScope.$on('formDefinitionLoaded', function () {
            clearListener();
            this_.loadForm();
        });
    }
};

formReader.module.controller('AppFormReaderController', formReader.formReaderController);

/**
 * Init the form tabs
 * @export
 */
formReader.formReaderController.prototype.initFormTabs = function () {

    if (goog.isDefAndNotNull(this.$scope_['oFormDefinition'])) {
        if (goog.isDefAndNotNull(this.$scope_['sFormDefinitionName'])) {
            if (goog.isDefAndNotNull(this.$scope_['oFormDefinition'][this.$scope_['sFormDefinitionName']])) {
                if (!goog.isDefAndNotNull(this.$scope_['oFormDefinition'][this.$scope_['sFormDefinitionName']]['tabs'])) {

                    var oForm = this.$scope_['oFormDefinition'][this.$scope_['sFormDefinitionName']];
                    var aElems = [];

                    // Récupère tous les noms de tous les éléments
                    if (goog.isDefAndNotNull(oForm['rows'])) {
                        for (var i = 0; i < oForm['rows'].length; i++) {
                            if (goog.isDefAndNotNull(oForm['rows'][i]['fields'])) {
                                for (var ii = 0; ii < oForm['rows'][i]['fields'].length; ii++) {
                                    if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['name'])) {
                                        aElems.push(oForm['rows'][i]['fields'][ii]['name']);
                                    } else if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['buttons'])) {
                                        for (var iii = 0; iii < oForm['rows'][i]['fields'][ii]['buttons'].length; iii++) {
                                            if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['buttons'][iii]['name'])) {
                                                aElems.push(oForm['rows'][i]['fields'][ii]['buttons'][iii]['name']);
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        this.$scope_['oFormDefinition'][this.$scope_['sFormDefinitionName']]['tabs'] = {
                            'position': 'top',
                            'list': [{
                                    'label': 'Tab 0',
                                    'elements': aElems
                                }]
                        };
                    }
                }
            }
        }
    }
};
/**
 * Use default values and run extractFormDefinitionInfos()
 * @export
 */
formReader.formReaderController.prototype.loadForm = function () {
    var this_ = this;
    this.initFormTabs();
    this.useDefaultValues(false);
    setTimeout(function () {

        // Lance initEvent si il existe
        var formDefinition = this_.$scope_["oFormDefinition"];
        var formDefinitionName = this_.$scope_["sFormDefinitionName"];

        if (!goog.isDefAndNotNull(formDefinition))
            return 0;
        if (!goog.isDefAndNotNull(formDefinitionName))
            return 0;
        if (!goog.isDefAndNotNull(formDefinition[formDefinitionName]))
            return 0;

        var initEvent = formDefinition[formDefinitionName]["initEvent"];

        setTimeout(function () {
            if (goog.isDefAndNotNull(formDefinition[formDefinitionName]["initEvent"])) {
                if (this_.formReaderService_['isFunctionCall'](initEvent)) {
                    this_.formReaderService_['callFunction'](initEvent);
                }
            }
            setTimeout(function () {
                // Effectue les requetes ajax etc..
                this_.extractFormDefinitionInfos();
            });
        });
    });

    this.$scope_['iDisplayedTab'] = 0;

    this.$scope_.$broadcast('loadForm');
};
/**
 * Refresh the scope {{:refresh:______}}
 * @export
 */
formReader.formReaderController.prototype.refreshForm = function () {
    this.initFormTabs();
    /**
     * '$$rebind' is the internal namespace used by angular-bind-notifier.
     * 'refresh' is the refresh key used in your view.
     */
    this.$scope_.$broadcast('$$rebind::refresh');
};
/**
 * oFormDefinition setter
 * @param {object} oFormDefinition
 * @export
 */
formReader.formReaderController.prototype.setFormDefinition = function (oFormDefinition) {
    this.$log_.log("formReader.formReaderController.prototype.setFormDefinition");

    this.$scope_['oFormDefinition'] = oFormDefinition;
    this.formReaderService_['oFormDefinition'] = oFormDefinition;
    this.refreshForm();
    this.$scope_['iDisplayedTab'] = 0;
};
/**
 * oFormValues setter
 * @param {object} oFormValues
 * @export
 */
formReader.formReaderController.prototype.setFormValues = function (oFormValues) {
    this.$log_.log("formReader.formReaderController.prototype.setFormValues");

    this.$scope_['oFormValues'] = oFormValues;
    this.formReaderService_['oFormValues'] = oFormValues;
};
/**
 * oFormDefinitionName setter
 * @param {object} oFormDefinitionName
 * @export
 */
formReader.formReaderController.prototype.setDefinitionName = function (oFormDefinitionName) {
    this.$log_.log("formReader.formReaderController.prototype.setDefinitionName");

    this.$scope_['sFormDefinitionName'] = oFormDefinitionName;
    this.formReaderService_['sFormDefinitionName'] = oFormDefinitionName;
};
/**
 * Determines if the value is present on the field options
 * @param {object} oField
 * @param {object} oValue
 * @returns {Boolean}
 */
formReader.formReaderController.prototype.valueIsPresent = function (oField, oValue) {

    if (!goog.isDef(oField) || !goog.isDef(oValue))
        return false;
    if (!goog.isDef(oField['options']))
        return false;

    if (!goog.object.isEmpty(oValue)) {
        if (goog.isDefAndNotNull(oValue['selectedOption'])) {
            if (goog.isDefAndNotNull(oValue['selectedOption']['value'])) {
                oValue = oValue['selectedOption']['value'];
            }
        }
    }

    if (goog.isArray(oField['options']) && oField['options'].length > 0) {

        // Valeur du select non présente dans les options ?
        var valueIsPresent = false;
        for (var i = 0; i < oField['options'].length; i++) {
            if (oField['options'][i]['value'] === oValue)
                valueIsPresent = true;
        }
        return valueIsPresent;
    } else {
        return false;
    }

};
/**
 * toTest
 * @param {object} object
 * @export
 */
formReader.formReaderController.prototype.toTest = function (object) {
};
/**
 * Use the default values on the form
 * @param {boolean} bEraseFormValues true for erase the oFormValues
 * @param {string} sElementName if defined, the function will only update the value of the given element
 * @export
 */
formReader.formReaderController.prototype.useDefaultValues = function (bEraseFormValues, sElementName) {
    this.$log_.log("formReader.formReaderController.prototype.useDefaultValues");

    var $scope = this.$scope_;
    var oFormValues = $scope['oFormValues'];
    var oFormDefinition = $scope['oFormDefinition'];
    var sFormDefinitionName = $scope['sFormDefinitionName'];

    if (!goog.isDefAndNotNull(oFormValues))
        return 0;
    if (!goog.isDefAndNotNull(oFormDefinition))
        return 0;
    if (!goog.isDefAndNotNull(sFormDefinitionName))
        return 0;
    if (!goog.isDefAndNotNull(oFormDefinition[sFormDefinitionName]))
        return 0;

    var aRows = oFormDefinition[sFormDefinitionName]['rows'];

    if (!goog.isDefAndNotNull(aRows))
        return 0;

    for (var i = 0; i < aRows.length; i++) {
        if (goog.isDefAndNotNull(aRows[i]['fields']))
            for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {

                if (aRows[i]['fields'][ii]['type'] === 'bo_grid' || aRows[i]['fields'][ii]['type'] === 'ui_grid' || aRows[i]['fields'][ii]['type'] === 'section_grid') {
                    continue;
                }

                var field;
                try {
                    field = angular.copy(aRows[i]['fields'][ii]);
                } catch (e) {
                    console.error('try angular.copy failed');
                    continue;
                }

                // sElementName différent du nom de l'élément en cours ?
                if (goog.isDefAndNotNull(sElementName)) {
                    if (field['name'] !== sElementName) {
                        continue;
                    }
                }

                // La valeur par défaut est un appel de fonction ?
                if (goog.isDefAndNotNull(field['default_value']) && field['default_value'] !== "") {
                    if (this.formReaderService_["isFunctionCall"](field['default_value'])) {
                        field['default_value'] = this.formReaderService_["callFunction"](field['default_value']);
                    }
                }

                // Le composant est une liste ou un select ?
                if (field['type'] === 'select' || field['type'] === 'editable_select') {
                    if (goog.isDefAndNotNull(field['default_value']) && field['default_value'] !== "") {
                        field['default_value'] = {
                            'value': field['default_value']
                        };
                    }
                } else if (field['type'] === 'list' || field['type'] === 'double_select') {
                    if (goog.isDefAndNotNull(field['default_value']) && field['default_value'] !== "") {
                        var aDefaultKeys = [];
                        if (goog.isString(field['default_value'])) {
                            aDefaultKeys = field['default_value'].split('|');
                        } else {
                            aDefaultKeys = field['default_value'];
                        }
                        var aDefaults = [];
                        for (var iii = 0; iii < aDefaultKeys.length; iii++) {
                            aDefaults.push({
                                'value': aDefaultKeys[iii]
                            });
                        }
                        field['default_value'] = aDefaults;
                    }
                }

                if (this.useDefaultValue(field, bEraseFormValues)) {
                    if (field['type'] === 'select' || field['type'] === 'editable_select' || field['type'] === 'list') {
                        if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][field['name']]))
                            oFormValues[sFormDefinitionName][field['name']] = {};
                        oFormValues[sFormDefinitionName][field['name']]['selectedOption'] = field['default_value'];
                    } else if (field['type'] === 'double_select') {
                        if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][field['name']]))
                            oFormValues[sFormDefinitionName][field['name_to']] = {};
                        oFormValues[sFormDefinitionName][field['name_to']]['selectedOption'] = field['default_value'];
                    } else if (field['type'] === 'editable_double_select') {
                        if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][field['name']]))
                            oFormValues[sFormDefinitionName][field['name_available_tags']] = {};
                        oFormValues[sFormDefinitionName][field['name_available_tags']]['selectedOption'] = field['default_value'];
                    } else {
                        oFormValues[sFormDefinitionName][field['name']] = field['default_value'];
                    }
                }
                delete field;
            }
    }
};
/**
 * Return true if the field has to use the default value
 * @param {object} oField
 * @param {boolean} bEraseFormValues
 * @return {boolean} true if the field has to use the default value
 * @export
 */
formReader.formReaderController.prototype.useDefaultValue = function (oField, bEraseFormValues) {
    this.$log_.log("formReader.formReaderController.prototype.useDefaultValue");

    var $scope = this.$scope_;
    var oFormValues = $scope['oFormValues'];
    var sFormDefinitionName = $scope['sFormDefinitionName'];
    if ((goog.isDef(oField["default_value"]) && oField["default_value"] !== "")) {

        // Vérifie qu'il existe pas déjà une valeur
        if (bEraseFormValues === true) {
            return true;
        } else {

            if (oField['type'] === 'select') {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]))
                    return true;
                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]['selectedOption']))
                    return true;
                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]['selectedOption']['value']))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name']]['selectedOption']['value'].length === 0)
                    return true;

            } else if (oField['type'] === 'editable_select') {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]))
                    return true;
                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]['selectedOption']))
                    return true;
                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]['selectedOption']['value']))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name']]['selectedOption']['value'].length === 0)
                    return true;

            } else if (oField['type'] === 'list') {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]))
                    return true;
                if (!goog.isArray(oFormValues[sFormDefinitionName][oField['name']]['selectedOption']))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name']]['selectedOption'].length === 0)
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name']]['selectedOption'][0]['value'].length === 0)
                    return true;

            } else if (oField['type'] === 'double_select') {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name_to']]))
                    return true;
                if (!goog.isArray(oFormValues[sFormDefinitionName][oField['name_to']]['selectedOption']))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name_to']]['selectedOption'].length === 0)
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name_to']]['selectedOption'][0]['value'].length === 0)
                    return true;

            } else if (oField['type'] === 'editable_double_select') {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name_available_tags']]))
                    return true;
                if (!goog.isArray(oFormValues[sFormDefinitionName][oField['name_available_tags']]['selectedOption']))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name_available_tags']]['selectedOption'].length === 0)
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name_available_tags']]['selectedOption'][0]['value'].length === 0)
                    return true;

            } else {

                if (!goog.isDefAndNotNull(oFormValues[sFormDefinitionName][oField['name']]))
                    return true;
                if (oFormValues[sFormDefinitionName][oField['name']].length === 0)
                    return true;

            }

        }
    } else {
        return false;
    }
};
/**
 * Parse the oFormDefinition object and make the ajax requests etc...
 * @export
 */
formReader.formReaderController.prototype.extractFormDefinitionInfos = function () {
    this.$log_.log("formReader.formReaderController.prototype.extractFormDefinitionInfos");
    if (!goog.isDef(this.$scope_['oFormDefinition'])) {
        console.error("$scope['oFormDefinition'] not defined");
        return 0;
    }

    this.$scope_.$broadcast('extractFormDefinitionInfos');
    this.$scope_['bFormDefinitionInfosExtracted'] = true;

    var oFormDefinition = this.$scope_['oFormDefinition'][this.$scope_['sFormDefinitionName']];
    var oFormValues = this.$scope_['oFormValues'][this.$scope_['sFormDefinitionName']];
    var oDataSources = this.$scope_['oFormDefinition']['datasources'];
    var formFieldValue;
    var selectValue;
    var this_ = this;

    if (!goog.isDefAndNotNull(this.$scope_.$root["oFormPromises"][this.$scope_['sFormDefinitionName']]))
        this.$scope_.$root["oFormPromises"][this.$scope_['sFormDefinitionName']] = [];

    // Promesse pour l'extraction des valeurs du formulaire.
    var deferred = this.$q_.defer();
    var promise = deferred.promise;
    this.$scope_.$root["oFormPromises"][this.$scope_['sFormDefinitionName']].push(promise);

    // Vide les anciens watchers
    for (var i = 0; i < this_.aWatchedVariables_.length; i++) {
        this_.aWatchedVariables_[i]();
    }

    this_.aWatchedVariables_.length = 0;
    if (goog.isDef(oFormDefinition) && goog.isDef(oFormDefinition['rows'])) {
        // Pour chaque élément
        for (var i = 0; i < oFormDefinition['rows'].length; i++) {
            for (var j = 0; j < oFormDefinition['rows'][i]['fields'].length; j++) {

                var elem = oFormDefinition['rows'][i]['fields'][j];
                formFieldValue = oFormValues[elem['name']];

                // Création d'un id pour l'élément de form. (si non spécifié).
                if (typeof (elem['id']) === "undefined" && typeof (elem['name']) !== "undefined")
                    elem['id'] = this.$scope_['sFormDefinitionName'] + '_' + elem['name'];

                switch (elem["type"]) {
                    // Objet à créer (options, selectedoption) pour les "select" et "double-select".
                    case "select":
                    case "editable_select":
                    case "list":
                    case "double_select":

                        // Création d'un id pour le <select> "source".
                        elem["id_from"] = elem['id'] + "_from";
                        var oWebService = null;
                        var aOptions = null;

                        // Extrait les informations permettant d'effectuer le chargement plus tard et les insère dans aOptions ou oWebService
                        if (goog.isDef(elem['datasource'])) {
                            if (goog.isDef(elem['datasource']['datasource_id'])) {
                                if (goog.isDef(oDataSources)) {
                                    if (goog.isDef(oDataSources[elem['datasource']['datasource_id']])) {
                                        // Datasource web_service ?
                                        if (oDataSources[elem['datasource']['datasource_id']]['type'] === 'web_service') {
                                            oWebService = this_.extractElemWebService(elem, oDataSources);
                                        }
                                        // Datasource object
                                        else if (oDataSources[elem['datasource']['datasource_id']]['type'] === 'object') {
                                            aOptions = this_.extractElemOptions(elem, oDataSources);
                                        }
                                    }
                                }
                            }
                        }

                        if (goog.isDef(elem['web_service'])) {
                            oWebService = angular.copy(elem['web_service']);
                        }

                        if (goog.isDefAndNotNull(elem["options"])) {
                            var aUsedOptions = elem["options"];
                        }

                        if (goog.isDefAndNotNull(aOptions)) {
                            var aUsedOptions = aOptions;
                        }

                        if (goog.isDefAndNotNull(oWebService)) {

                            oWebService = angular.copy(oWebService);

                            if (oWebService["load_first_time"] !== false) {
                                // Parents ?
                                if (goog.isDef(oWebService['parents'])) {
                                    // Écoute les changements des parents
                                    this.listenParentsChanges(elem, oWebService, oFormValues);
                                }

                                // Évalue si les parents ont un wait_for_parent
                                var parents_ready = this.areParentsReady(oFormValues, oWebService['parents'], true);

                                // Charge la requete si parents_ready vaut true
                                if (parents_ready) {
                                    this.formReaderService_['setWebServiceSelectOptions'](elem, this.$scope_['sFormDefinitionName'], this.$scope_['oFormValues'], oWebService);
                                }
                                delete oWebService;
                            } else {
                                // Exécute le code dans le paramètre "callback".
                                if (typeof (oWebService["callback"]) !== "undefined") {
                                    if (this_.formReaderService_["isFunctionCall"](oWebService["callback"])) {
                                        this_.formReaderService_['callFunction'](oWebService["callback"]);
                                    }
                                }
                            }
                        }

                        // Valeurs passées dans la structure ?
                        else if (goog.isDef(aUsedOptions)) {
                            this.formReaderService_['setSelectOptions'](elem, this.$scope_['sFormDefinitionName'], this.$scope_['oFormValues'], aUsedOptions);
                        }

                        // Création de la structure du <select> pour angular.
                        else {
                            // Si la structure du select n'est pas déja définie : <select> vide par défault.
                            if (typeof (formFieldValue) !== "object") {
                                // Valeur par défaut pour le champ si aucune valeur n'est définie.
                                selectValue = formFieldValue;
                                if (elem["type"] === 'select' || elem["type"] === 'editable_select')
                                    oFormValues[elem['name']] = {"selectedOption": {"value": selectValue}, "options": []};
                                else
                                    oFormValues[elem['name']] = {"selectedOption": [{"value": selectValue}], "options": []};
                            }
                        }
                        break;
                    case "editable_double_select":
                        // Id + nom de l'élément des tags disponibles.
                        elem["name_available_tags"] = elem['name'] + "_available";
                        elem["id_available_tags"] = elem['id'] + "_available";
                        // Valeurs à récupérer depuis un webservice ?
                        if (typeof (elem["web_service"]) !== "undefined")
                            this.formReaderService_["setWebServiceTags"](elem, this.$scope_['sFormDefinitionName'], this.$scope_['oFormValues']);
                        break;
                        // Type de champ à ne pas sauver.
                    case "title":
                    case "subtitle":
                    case "label":
                    case "button":
                        break;
                    case "ui_grid":
                        // Datasource web_service ?
                        if (typeof(elem['datasource']) != "undefined" && oDataSources[elem['datasource']['datasource_id']]['type'] === 'web_service') {
                            oWebService = this_.extractElemWebService(elem, oDataSources);
                            // Charge les données du web service
                            var oUiGridElem = elem;
                            this_.formReaderService_['getWebServiceData'](oWebService).then(function (aData) {
                                var oGridOptions = angular.element("#" + oUiGridElem["id"] + "_grid .ui-grid-contents-wrapper").scope()["grid"]["options"];
                                oGridOptions['data'] = aData;
                            });
                        }
                    break;
                    default:
                        // Valeur par défaut pour le champ si aucune valeur n'est définie.
                        //                        if (typeof (formFieldValue) === "undefined" && typeof (formFieldDefaultValue) !== "undefined")
                        //                            oFormValues[elem['name']] = formFieldDefaultValue;
                        break;
                }
                delete elem;
            }
        }
    }

    // Lance un évènement dès que toutes les promesses ont été résolues (extraction du form., données depuis un web service...).
    this.$q_.all(this.$scope_.$root["oFormPromises"][this.$scope_['sFormDefinitionName']]).then(function (values) {
        setTimeout(function () {
            this_.$scope_.$root.$emit("formExtracted", this_.$scope_['sFormDefinitionName']);
        });
        if (goog.isDefAndNotNull(oFormDefinition)) {
            // Met le formulaire dans un état non modifié.
            var sFormName = oFormDefinition["name"];
            var oFormElement = angular.element("form[name='" + sFormName + "']");
            if (oFormElement.length > 0) {
                var oFormElementScope = oFormElement.scope();
                if (goog.isDefAndNotNull(oFormElementScope[sFormName])) {
                    oFormElementScope[sFormName].$setPristine();
                }
            }
        }
    });
    deferred.resolve();
};
/**
 * Listen the parents changes
 * @param {object} elem
 * @param {object} oWebService
 * @param {object} oFormValues
 */
formReader.formReaderController.prototype.listenParentsChanges = function (elem, oWebService, oFormValues) {

    var this_ = this;

    // création d'un nouveau param filter_extension
    oWebService['parameters']['original_filter'] = goog.isDefAndNotNull(oWebService['parameters']['filter']) ? oWebService['parameters']['filter'] : '';
    oWebService['parameters']['original_filter_copy'] = angular.copy(oWebService['parameters']['original_filter']);

    for (var i = 0; i < oWebService['parents'].length; i++) {
        var filter_attr = oWebService['parents'][i]['filter_attr'];
        var filter_equality = oWebService['parents'][i]['filter_equality'];
        if (goog.isDef(oWebService['parents'][i]['name_to']))
            var watchedVariableName = oWebService['parents'][i]['name_to'];
        else
            var watchedVariableName = oWebService['parents'][i]['name'];

        var sWatchedVariable = angular.copy('oFormValues.' + this_.$scope_['sFormDefinitionName'] + '.' + watchedVariableName + '.selectedOption');

        var oldValue = oFormValues[watchedVariableName];

        var bFirstLoad = true;

        // Timout: sinon le $watch est constament appelé lors de l'instanciation des parents
        setTimeout(function (opt_options) {

            var sParentsChanged = angular.bind({
                elem: opt_options.elem,
                oWebService: opt_options.oWebService,
                filter_attr: opt_options.filter_attr,
                filter_equality: opt_options.filter_equality,
                watchedVariableName: opt_options.watchedVariableName
            }, function (changed, newVal, oldVal, scope) {
                var elem = this.elem;
                var oWebService = this.oWebService;
                var filter_attr = this.filter_attr;
                var filter_equality = this.filter_equality;
                var watchedVariableName = this.watchedVariableName;
                var watchedVariableValue = oFormValues[watchedVariableName];
                var oSelectedOption;

                // Limite le nombre d'appels pour évites les multiples chargements
                if (!bFirstLoad) {
                    if (goog.isObject(oldValue) && goog.isObject(watchedVariableValue)) {
                        if (goog.isDefAndNotNull(watchedVariableValue['selectedOption'])
                                && goog.isDefAndNotNull(oldValue['selectedOption'])) {
                            if (goog.isDefAndNotNull(watchedVariableValue['selectedOption']['value'])
                                    && goog.isDefAndNotNull(oldValue['selectedOption']['value'])) {
                                if (watchedVariableValue['selectedOption']['value'] == oldValue['selectedOption']['value']) {
                                    return 0;
                                }
                            }
                        }
                    }
                }

                // Vérifie que la valeur du parent existe vraiment
                if (!goog.isDefAndNotNull(watchedVariableValue))
                    return 0;
                if (!goog.isDefAndNotNull(watchedVariableValue['selectedOption']))
                    return 0;
                else {
                    // Si il s'agit d'une liste
                    if (goog.isArray(watchedVariableValue['selectedOption'])) {
                        if (watchedVariableValue['selectedOption'].length === 0)
                            return 0;
                    } else {
                        if (!goog.isDefAndNotNull(watchedVariableValue['selectedOption']['value']))
                            return 0;
                    }
                }

                // vérification ready
                var parents_ready = this_.areParentsReady(oFormValues, oWebService['parents']);

                // Sauvegarde la valeur
                if (goog.isDefAndNotNull(this_.$scope_['oFormValues'])) {
                    if (goog.isDefAndNotNull(this_.$scope_['oFormValues'][this_.$scope_['sFormDefinitionName']])) {
                        if (goog.isDefAndNotNull(this_.$scope_['oFormValues'][this_.$scope_['sFormDefinitionName']][elem['name']])) {
                            if (goog.isDefAndNotNull(this_.$scope_['oFormValues'][this_.$scope_['sFormDefinitionName']][elem['name']]['selectedOption'])) {
                                oSelectedOption = angular.copy(this_.$scope_['oFormValues'][this_.$scope_['sFormDefinitionName']][elem['name']]['selectedOption']);
                            }
                        }
                    }
                }

                // Vide la liste
                this_.formReaderService_['emptySelectOptions'](elem, this_.$scope_['sFormDefinitionName'], this_.$scope_['oFormValues']);

                if (parents_ready) {
                    // Céation filter
                    oWebService['parameters']['original_filter'] = angular.copy(oWebService['parameters']['original_filter_copy']);
                    oWebService['parameters']['filter'] = this_.getNewFilter(oFormValues, oWebService['parents'], oWebService['parameters']['original_filter']);
                    this_.$log_.log({"filter: ": angular.copy(oWebService['parameters']['filter'])});

                    // Lance la requête et remplit la liste
                    this_.formReaderService_['setWebServiceSelectOptions'](elem, this_.$scope_['sFormDefinitionName'], this_.$scope_['oFormValues'], oWebService, oSelectedOption);
                }

                oldValue = angular.copy(watchedVariableValue);
                bFirstLoad = false;
            }, true);

            sParentsChanged();

            // Watche la variable & stoque le watcher dans aWatchedVariables_
            this_.aWatchedVariables_.push(this_.$scope_.$watch(opt_options.sWatchedVariable, sParentsChanged));

        }, 1000, {
            sWatchedVariable: sWatchedVariable,
            elem: elem,
            oWebService: oWebService,
            filter_attr: filter_attr,
            filter_equality: filter_equality,
            watchedVariableName: watchedVariableName
        });
        delete filter_attr;
        delete filter_equality;
        delete sWatchedVariable;
    }
};
/**
 * Extract the webservice of an element
 * @param {object} elem
 * @param {object} oDataSources
 * @returns {object}
 */
formReader.formReaderController.prototype.extractElemWebService = function (elem, oDataSources) {
    if (elem["type"] != "ui_grid") {
        if (!goog.isDef(elem['datasource']['id_key']))
            return null;
        if (!goog.isDef(elem['datasource']['label_key']))
            return null;
    }

    // Céation du web_service
    var oWebService = angular.copy(oDataSources[elem['datasource']['datasource_id']]);

    // Mise en place des paramètres dans oWebService
    oWebService['id_key'] = elem['datasource']['id_key'];
    oWebService['label_key'] = elem['datasource']['label_key'];
    oWebService['parameters'] = goog.isDef(oWebService['parameters']) ? oWebService['parameters'] : {};
    if (goog.isDef(elem['datasource']['parents']))
        oWebService['parents'] = elem['datasource']['parents'];
    if (goog.isDef(elem['datasource']['filter'])) {
        oWebService['parameters']['filter'] = elem['datasource']['filter'];
    }
    if (goog.isDef(elem['datasource']['distinct']))
        oWebService['parameters']['distinct'] = elem['datasource']['distinct'];
    if (goog.isDef(elem['datasource']['attributs']))
        oWebService['parameters']['attributs'] = elem['datasource']['attributs'];
    if (goog.isDef(elem['datasource']['order_by']))
        oWebService['parameters']['order_by'] = elem['datasource']['order_by'];
    if (goog.isDef(elem['datasource']['sort_order']))
        oWebService['parameters']['sort_order'] = elem['datasource']['sort_order'];

    return oWebService;
};
/**
 * Extract the options of an element
 * @param {object} elem
 * @param {object} oDataSources
 * @returns {Array}
 */
formReader.formReaderController.prototype.extractElemOptions = function (elem, oDataSources) {

    var aOptions = [];
    if (goog.isDef(oDataSources[elem['datasource']['datasource_id']]['data']) &&
            goog.isDef(elem['datasource']['id_key']) &&
            goog.isDef(elem['datasource']['label_key'])) {

        var id_key = elem['datasource']['id_key'];
        var label_key = elem['datasource']['label_key'];
        var aData = oDataSources[elem['datasource']['datasource_id']]['data'];

        if (!goog.isDef(id_key))
            console.error('id_key not defined (required in for data json source)');
        if (!goog.isDef(label_key))
            console.error('label_key not defined (required in for data json source)');
        if (goog.isDef(id_key) && goog.isDef(label_key)) {
            for (var i = 0; i < aData.length; i++) {
                aOptions.push(aData[i][label_key] + '|' + aData[i][id_key]);
            }
        }

        delete id_key;
        delete label_key;
        delete aData;
    }
    if (goog.isDef(oDataSources[elem['datasource']['datasource_id']]['options'])) {
        aOptions = oDataSources[elem['datasource']['datasource_id']]['options'];
    }

    return aOptions;
};
/**
 * Evaluate if the parents are ready
 * @param {object} oFormValues
 * @param {array} aParents
 * @param {boolean} bLookOnlyWaited if true, the function looks only if wait_for_parent is true
 * @returns {Boolean}
 */
formReader.formReaderController.prototype.areParentsReady = function (oFormValues, aParents, bLookOnlyWaited) {

    var parents_ready = true;
    if (!goog.isDefAndNotNull(oFormValues)) {
        console.error('formReader.formReaderController.prototype.areParentsReady: oFormValues not defined');
        return false;
    }

    // Si les parents ne sont pas définis ou sont null ou sont vides
    if (!goog.isDefAndNotNull(aParents) || (goog.isArray(aParents) && aParents.length === 0)) {
        return true;
    }

    // évalue si les parents ayant un wait_for_parent ont été renseignés
    for (var i = 0; i < aParents.length; i++) {

        // Regarde si il y a un param wait_for_parent = false
        if (aParents[i]['wait_for_parent'] === 'false' || aParents[i]['wait_for_parent'] === false) {
            continue;
        }
        // Si bLookOnlyWaited == true, la fonction ne prend pas compte de la valeur
        else if (bLookOnlyWaited === true) {
            return false;
        }

        // Vérifie si la valeur du parent existe
        if (!goog.isDefAndNotNull(oFormValues[aParents[i]['name']])) {
            parents_ready = false;
            continue;
        }
        if (!goog.isDefAndNotNull(oFormValues[aParents[i]['name']]['selectedOption'])) {
            parents_ready = false;
            continue;
        }
        // Si le parent est une liste
        if (goog.isArray(oFormValues[aParents[i]['name']]['selectedOption'])) {

            // Si la liste des valeurs est vide
            if (oFormValues[aParents[i]['name']]['selectedOption'].length === 0) {
                parents_ready = false;
                continue;
            }
            if (oFormValues[aParents[i]['name']]['selectedOption'][0]['value'].length === 0) {
                parents_ready = false;
                continue;
            }
        }
        // Si le parent est un selecteur
        if (!goog.isArray(oFormValues[aParents[i]['name']]['selectedOption'])) {

            // Si la valeur est non défini ou null
            if (!goog.isDefAndNotNull(oFormValues[aParents[i]['name']]['selectedOption']['value'])) {
                parents_ready = false;
                continue;
            }
            // Si la valeur est vide
            if (oFormValues[aParents[i]['name']]['selectedOption']['value'].length === 0) {
                parents_ready = false;
                continue;
            }
        }
    }
    return parents_ready;
};
/**
 * Creates a new filter
 * @param {object} oFormValues
 * @param {array} aParents
 * @param {string} originalFilter
 * @returns {string} new filter
 */
formReader.formReaderController.prototype.getNewFilter = function (oFormValues, aParents, originalFilter) {

    var additionalFilter = {
        "relation": "AND",
        "operators": []
    };
    aParents = goog.isDefAndNotNull(aParents) ? aParents : [];
    if (!goog.isDefAndNotNull(originalFilter) || String(originalFilter).trim() === '') {
        originalFilter = {
            "relation": "AND",
            "operators": []
        };
    }

    for (var i = 0; i < aParents.length; i++) {

        if (!goog.isDef(oFormValues[aParents[i]['name']]))
            continue;
        if (!goog.isDef(oFormValues[aParents[i]['name']]['selectedOption']))
            continue;
        if (!goog.isDef(oFormValues[aParents[i]['name']]['selectedOption']['value'])) {
            if (!goog.isArray(oFormValues[aParents[i]['name']]['selectedOption']))
                continue;
            if (oFormValues[aParents[i]['name']]['selectedOption'].length < 1)
                continue;
        }

        var aParentValues = [];
        // Passage en tableau i c'est en mode simple value
        if (!goog.isArray(oFormValues[aParents[i]['name']]['selectedOption']) && goog.isDef(oFormValues[aParents[i]['name']]['selectedOption']['value'])) {
            aParentValues.push(oFormValues[aParents[i]['name']]['selectedOption']);
        } else {
            aParentValues = oFormValues[aParents[i]['name']]['selectedOption'];
        }

        var key = aParents[i]['filter_attr'];
        var equality = aParents[i]['filter_equality'];
        var parentFilter = {
            "relation": "OR",
            "operators": []
        };

        // Création du filtre parent (avec des "OR" en cas de multiple selection)
        for (var ii = 0; ii < aParentValues.length; ii++) {
            var value = aParentValues[ii]['value'];

            // Vérifie que la valeur soit correcte
            if (!goog.isDefAndNotNull(value)) {
                continue;
            } else if (goog.isString(value) && !value.length > 0)
                continue;

            parentFilter['operators'].push({
                "column": key,
                "compare_operator": equality,
                "value": value
            });
            delete value;
        }

        if (parentFilter['operators'].length === 0)
            continue;
        // Ajout du filtre parent dans le filtre général
        additionalFilter['operators'].push(parentFilter);

        delete aParentValues;
        delete key;
        delete equality;
        delete parentFilter;
    }
    delete i;
    if (additionalFilter['operators'].length > 0) {
        originalFilter['operators'].push(additionalFilter);
    }

    return originalFilter;
};
/**
 * Function to parse a number
 * @param {String} str string to parse in number
 * @param {boolean} bInt Parse in Integer or in Float
 * @export
 */
formReader.formReaderController.prototype.numberParser = function (str, bInt) {
    str = goog.isDef(str) ? str : "";
    bInt = goog.isDef(bInt) ? bInt : false;
    //si on veut un integer
    if (bInt) {
        return this.integerParser(str);
    } else {
        //sinon float
        //on remplace les , par des .
        str = str.replace(",", ".");
        //on éclate la chaine par les .
        var parts = str.split(".");
        // si la chaine est vide ou ne contient qu'un .
        if (parts.length === 0) {
            return NaN;
            // si la chaine ne contient pas de .
        } else if (parts.length === 1) {
            //si elle se termine par un . alors il faut le laisser sinon il n'est pas là on retourne un int
            if (str.charAt(str.length - 1) === ".") {
                return this.integerParser(str) + '.';
            } else {
                return this.integerParser(str);
            }
            // si la chaine contient un ou plusieurs . le premier étant en milieu de chaine
        } else if (parts.length >= 2) {
            // on traite la partie à gauche de la virgule
            var left = this.integerParser(parts[0]);
            var right = 0;
            // si juste deux membre alors on traite la partie de droite
            if (parts.length === 2) {
                if (parts[1] === "")
                    return this.integerParser(str) + '.';
                else
                    right = this.integerParser(parts[1], true);
                //sinon on concat toutes les parties ensemble à l'exception de la première et on lance le traitement
                //régle les problème de . supplémentaire et de copier coller depuis un autre champ
            } else {
                var tmp = "";
                for (var i = 1; i < parts.length; i++) {
                    tmp += parts[i];
                }
                right = this.integerParser(tmp);
            }
            // on retourne finalement un flottant qui est la concatenation du membre droit et du membre gauche avec un . au milieu
            // et on le parse en float
            return parseFloat(left + "." + right).toFixed(String(right).length);
        } else
            //sinon ce n'est pas un nombre et normalement on ne passe jamais ici
            return NaN;
    }

};
/**
 * Function to parse an integer with correction on char error
 * @param {String} str string to parse in intger
 * @param {Boolean} bKeepZeros Keep all the zeros
 * @return {integer} value intger of the string
 * @export
 */
formReader.formReaderController.prototype.integerParser = function (str, bKeepZeros) {
    var ret = "";
    if (typeof (bKeepZeros) == "undefined")
        bKeepZeros = false;
    //on parcour la chaine
    for (var i = 0; i < str.length; i++) {
        var currentChar = str.charAt(i);
        // si le caractere est un nombre on le recopie sinon non
        if (!isNaN(parseInt(currentChar)))
            ret += currentChar;
    }
    // on parse en integer la chaine et on la retourne
    if (!bKeepZeros)
        ret = parseInt(ret);
    return ret;
};
/**
 * Refresh the subform grids view
 * @export
 */
formReader.formReaderController.prototype.refreshSubformGrids = function () {

    var gridScope;
    var grids = $(this.$element_).find('[data-app-subform-grid]');

    setTimeout(function () {
        for (var i = 0; i < grids.length; i++) {
            gridScope = angular.element(grids[i]).scope();
            if (goog.isDefAndNotNull(gridScope)) {
                if (goog.isDefAndNotNull(gridScope['gridApi'])) {
                    if (goog.isDefAndNotNull(gridScope['gridApi']['core'])) {
                        if (goog.isDefAndNotNull(gridScope['gridApi']['core']['handleWindowResize'])) {
                            gridScope['gridApi']['core']['handleWindowResize']();
                        }
                    }
                }
            }
        }
    });
}
