/* global formReader, goog, angular, vitisApp, nsVitisComponent, grecaptcha */

/**
 * @author: Armand Bahi
 * @Description: Form Reader directive
 * @module formReader
 */
goog.provide('formReader.directive.formReaderDirective');
goog.require('nsVitisComponent.MapWorkbench');
goog.require('formReader');

/**
 * Form displayer directive
 * @param {service} $q Angular q service.
 * @param {service} formReaderService Service de gestion des formulaires.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @param {service} $log
 * @return {angular.Directive} The directive specs.
 * @export
 * @ngInject
 * @constructor
 */
formReader.formReaderDirective = function ($q, formReaderService, propertiesSrvc, $log, $compile) {
    return {
        restrict: 'A',
        scope: {
            'oProperties': '=?appProperties',
            'oFormValues': '=?appFormValues',
            'oFormDefinition': '=?appFormDefinition',
            'sFormDefinitionName': '=?appFormDefinitionName',
            'oFormEventsContainer': '=?appFormEventsContainer',
            'wabState': '=?appWabState',
            'wabGroup': '=?appWabGroup',
            'showTabs': '=?appTabs'
                    //'dontUseWabParameter' : "=?appDontUseWabParameter"
        },
        controller: 'AppFormReaderController',
        controllerAs: 'ctrl',
        templateUrl: window.location.protocol + "//" + window.location.hostname + (window.location.port ? ':' + window.location.port : '') + "/" + sessionStorage["appEnv"] + '/javascript/externs/formReader/formReader.html',
        link: function (scope, element, attrs) {
            $log.log("formReader.formReaderDirective.link");

            // Permet de ne pas afficher les onglets (mais tout à la suite) si on le désire
            scope['showTabs'] = scope['showTabs'] === 'false' || scope['showTabs'] === false ? scope['showTabs'] = false : scope['showTabs'] = true;

            scope['wabState'] = goog.isDefAndNotNull(scope['wabState']) && scope['wabState'] !== '' ? scope['wabState'] : null;
            scope['wabGroup'] = goog.isDefAndNotNull(scope['wabGroup']) && scope['wabGroup'] !== '' ? scope['wabGroup'] : null;
            // scope['dontUseWabParameter'] = goog.isDefAndNotNull(scope['dontUseWabParameter'])? true : false;
            // Bouton "submit" non cliqué.
            scope["submitButton"] = false;
            scope['oFormEventsContainer'] = goog.isDef(scope['oFormEventsContainer']) ? scope['oFormEventsContainer'] : scope;

            formReaderService['oProperties'] = scope['oProperties'];

            formReaderService['oFormValues'] = scope['oFormValues'];
            formReaderService['oFormDefinition'] = scope['oFormDefinition'];
            formReaderService['sFormDefinitionName'] = scope['sFormDefinitionName'];
            formReaderService['oFormEventsContainer'] = scope['oFormEventsContainer'];

            // Paramètres de Wab.
            var clearListener = scope.$root.$on('formDefinitionLoaded', function (event, sFormDefinitionName) {
                // Supprime le "listener".
                clearListener();
                if (goog.isDefAndNotNull(scope['oFormDefinition'])) {
                    if (goog.isDefAndNotNull(scope['oFormDefinition'][sFormDefinitionName])) {
                        if (goog.isDefAndNotNull(scope['oFormDefinition'][sFormDefinitionName]['wab'])) {
                            scope['showTabs'] = false;
                            scope['wabState'] = scope['oFormValues'][sFormDefinitionName]['status_name'];
                            scope['userGroups'] = [];
                            // Chargement des groupes de l'utilisateur.
                            ajaxRequest({
                                "method": "GET",
                                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/vitis/users/" + sessionStorage["user_id"],
                                "scope": scope,
                                "headers": {
                                    "Accept": "application/x-vm-json"
                                },
                                "success": function (response) {
                                    scope['userGroups'] = response.data["data"][0]["groups_label"].split(",");
                                    for (var group in scope['oFormDefinition'][sFormDefinitionName]['wab'][scope['wabState']]) {
                                        if (scope['userGroups'].indexOf(group) > -1) {
                                            scope['wabGroup'] = group;
                                            break;
                                        }
                                    }
                                    if (!goog.isDefAndNotNull(scope['wabGroup'])) {
                                        console.warn("this user can't see this form");
                                    }
                                    // Evènement de chargement du groupe Wab de l'utilisateur.
                                    scope.$root.$emit('wabGroupLoaded', scope['wabGroup']);
                                }
                            });
                            if (!goog.isDefAndNotNull(scope['wabGroup'])) {
                                console.warn("this user can't see this form");
                            }
                        }
                    }
                }
            });

            /**
             * isFormTextElement function.
             * Vérifie si le type de champ de formulaire passé est de type "text".
             * @param {string} sFormElementType Type du champ de formulaire.
             */
            scope["isFormTextElement"] = function (sFormElementType) {
                var aFormText = new Array("text", "password", "datetime", "datetime-local", "date", "month", "time", "week", "integer", "float", "number", "email", "url", "search", "tel", "color");
                if (aFormText.indexOf(sFormElementType) !== -1)
                    return true;
                else
                    return false;
            };

            /**
             * sendForm function.
             * Action à effectuer dès l'envoi (après validation) du formaulaire.
             */
            scope["sendForm"] = function () {
                $log.log("scope.sendForm");
                var sFormName = scope["oFormDefinition"][scope["sFormDefinitionName"]]["name"];
                // Le formulaire est valide ?
                if (scope[sFormName]["$valid"] === true) {
                    var deferred = $q.defer();
                    var promise = deferred.promise;
                    var bCloneObject = false; // si true l'objet sera cloné : envoyé une fois en POST puis en PUT
                    var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);

                    // Fonction à appeler avant l'envoi du form.
                    var beforeEvent = scope["oFormDefinition"][scope["sFormDefinitionName"]]["beforeEvent"];

                    if (typeof (beforeEvent) !== "undefined") {

                        // Si l'évènement "beforeEvent" s'est bien déroulé : lancement de l'évènement "event"
                        if (goog.isString(beforeEvent)) {
                            $q.when(formReaderService['callFunction'](beforeEvent)).then(function () {
                                deferred.resolve();
                            });
                        } else if (goog.isFunction(beforeEvent)) {
                            $q.when(beforeEvent(scope['oFormValues'])).then(function () {
                                deferred.resolve();
                            });
                        }

                    } else
                        deferred.resolve();

                    // Fonction à appeler dès l'envoi du form.
                    promise.then(function () {
                        deferred = $q.defer();
                        promise = deferred.promise;

                        var submitEvent = scope["oFormDefinition"][scope["sFormDefinitionName"]]["event"];

                        if (typeof (submitEvent) !== "undefined") {
                            // Si l'évènement "event" s'est bien déroulé : lancement de l'évènement "afterEvent"
                            if (goog.isString(submitEvent)) {
                                $q.when(formReaderService['callFunction'](submitEvent)).then(function () {
                                    deferred.resolve();
                                });
                            } else if (goog.isFunction(submitEvent)) {
                                $q.when(submitEvent(scope['oFormValues'])).then(function () {
                                    deferred.resolve();
                                });
                            }
                        } else
                            deferred.resolve();

                        // Fonction à appeler après l'envoi du form.
                        promise.then(function () {
                            var afterEvent = scope["oFormDefinition"][scope["sFormDefinitionName"]]["afterEvent"];
                            if (typeof (afterEvent) !== "undefined")
                                if (goog.isString(afterEvent)) {
                                    formReaderService['callFunction'](afterEvent);
                                } else if (goog.isFunction(afterEvent)) {
                                    afterEvent(scope['oFormValues']);
                                }
                        });
                    });
                }
            };

            /**
             * displaySubformModal function - Affiche un sous formulaire dans une modale
             *
             * @param  {object} oSubformDefinition     definition du formulaire
             * @param  {string} sSubformDefinitionName nom du formulaire
             * @param  {object} oSubformValues         valeurs
             * @param  {string} sSubformFormType       insert, update
             * @param  {string} sSubformTitle          titre de la modale
             * @return {string}                        identifiant de la modale
             */
            scope["displaySubformModal"] = function (oSubformDefinition, sSubformDefinitionName, oSubformValues, sSubformFormType, sSubformTitle) {

                var sSubformId = 'formreader_' + scope['sFormUniqueName'] + '_standard_subform';
                var sModalId = 'formreader_' + scope['sFormUniqueName'] + '_standard_subform_modal';
                var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
                var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
                var oSubformScope = angular.element('#' + sSubformId).scope();

                scope['closeSubformModal'] = function (identifier) {
                    $(identifier).modal('hide');
                };

                oSubformScope['standard_subform_title'] = sSubformTitle;
                oSubformScope['standard_subform_definition_name'] = sSubformFormType;

                formReaderService['showModalSubform'](sModalId, oSubformScope, oSubformDefinition, sSubformDefinitionName, oSubformValues);

                return sModalId;
            }

            /**
             * testElementsValidityTab
             * Teste la validité des éléments et change d'onglet si un élément n'est pas valide
             */
            scope["testElementsValidityTab"] = function (callback) {
                $log.log("scope.testElementsValidityTab");

                var sFormName = scope["oFormDefinition"][scope["sFormDefinitionName"]]["name"];

                // Le formulaire est valide ?
                if (!scope[sFormName]["$valid"] === true) {

                    var aElems = formReaderService['getAllFormElementDefinition'](scope["sFormDefinitionName"], scope["oFormDefinition"]);
                    var aInvalidElems = [];

                    for (var i = 0; i < aElems.length; i++) {
                        if (goog.isDefAndNotNull(aElems[i]['name'])) {
                            if (goog.isDefAndNotNull(scope[sFormName][aElems[i]['name']])) {
                                if (!scope[sFormName][aElems[i]['name']]["$valid"]) {
                                    aInvalidElems.push(aElems[i]['name']);
                                }
                            }
                        }
                    }

                    if (goog.isDefAndNotNull(aInvalidElems[0])) {
                        if (goog.isDefAndNotNull(scope['oFormDefinition'][scope["sFormDefinitionName"]]['tabs'])) {
                            if (goog.isDefAndNotNull(scope['oFormDefinition'][scope["sFormDefinitionName"]]['tabs']['list'])) {
                                var aTabs = scope['oFormDefinition'][scope["sFormDefinitionName"]]['tabs']['list'];
                                for (var i = 0; i < aTabs.length; i++) {
                                    if (aTabs[i]['elements'].indexOf(aInvalidElems[0]) !== -1) {
                                        scope['iDisplayedTab'] = i;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                // BUG Firefox : supprime le tooltip "veuillez compléter ce champ" qui reste affiché.
                if (navigator.userAgent.indexOf("Firefox") !== -1) {
                    setTimeout(function() {
                        document.querySelector("form[name=" + sFormName + "] .ng-invalid-required").blur();
                        document.querySelector("form[name=" + sFormName + "] .ng-invalid-required").focus();
                    }, 1100);
                }
                //
                if (goog.isDefAndNotNull(callback)) {
                    callback.call();
                }
            };

            /**
             * executeButtonEvent function.
             * Execute l'évènement dans la définition du bouton.
             * @param {angular.$event} $event Angular event.
             * @param {string} buttonEvent Code à éxécuter.
             */
            scope["executeButtonEvent"] = function ($event, buttonEvent) {
                $log.log("scope.executeButtonEvent");

                if (goog.isString(buttonEvent)) {
                    formReaderService['callFunction'](buttonEvent);
                } else if (goog.isFunction(buttonEvent)) {
                    buttonEvent(scope['oFormValues']);
                }
            };

            /**
             * getValidationCssClass function.
             * Retourne une classe css d'erreur (Bootstrap) si le champ de form. est invalide.
             * @param {string} sFieldName Nom du champ du formulaire.
             */
            scope["getValidationCssClass"] = function (sFieldName) {
                if (typeof (sFieldName) != "undefined") {
                    if (goog.isDefAndNotNull(scope["oFormDefinition"])) {
                        if (goog.isDefAndNotNull(scope["sFormDefinitionName"])) {
                            if (goog.isDefAndNotNull(scope["oFormDefinition"][scope["sFormDefinitionName"]])) {
                                var sFormName = scope["oFormDefinition"][scope["sFormDefinitionName"]]["name"];
                                if (typeof (scope[sFormName]) != "undefined") {
                                    if (typeof (scope[sFormName][sFieldName]) != "undefined") {
                                        if (scope[sFormName][sFieldName].$invalid && (scope[sFormName][sFieldName].$dirty)) //  || scope["submitButton"]
                                        return "has-error";
                                    }
                                }
                            }
                        }
                    }
                }
                /*
                 var sFormName = scope["oFormDefinition"][scope["sFormDefinitionName"]]["name"];
                 if (typeof(scope[sFormName][sFieldName]) != "undefined")
                 if (scope[sFormName][sFieldName].$invalid && (scope[sFormName][sFieldName].$dirty || scope["submitButton"]))
                 return "has-error";
                 */
            };

            /**
             * switchSelectedOptions function.
             * Transfère les options sélectionnés d'un <select> à l'autre.
             * @param {string} sFormDefinitionName Nom du formulaire.
             * @param {object} oFieldDefinition Définition du champ "double-select".
             * @param {string} sFromSelectName <select> source.
             * @param {string} sToSelectName <select> de destination.
             */
            scope["switchSelectedOptions"] = function (sFormDefinitionName, oFieldDefinition, sFromSelectName, sToSelectName) {
                $log.log("scope.switchSelectedOptions");

                var oFromSelect = scope["oFormValues"][sFormDefinitionName][sFromSelectName];
                scope["oFromSelect"] = oFromSelect;
                if (typeof (oFieldDefinition["switch_event"]) !== "undefined") {
                    if (formReaderService["isFunctionCall"](oFieldDefinition["switch_event"])) {
                        if (goog.isString(oFieldDefinition["switch_event"])) {
                            formReaderService['callFunction'](oFieldDefinition["switch_event"]);
                        } else if (goog.isFunction(oFieldDefinition["switch_event"])) {
                            oFieldDefinition["switch_event"](scope['oFormValues']);
                        }
                    }
                }

                // Au moins 1 option sélectionnée ?
                if (oFromSelect["selectedOption"].length > 0) {
                    var oToSelect = scope["oFormValues"][sFormDefinitionName][sToSelectName];
                    var i = 0;
                    while (i < oFromSelect["selectedOption"].length) {
                        if (oFromSelect["selectedOption"][i]["disabled"] != true)
                            oToSelect["options"].unshift(oFromSelect["options"].splice(oFromSelect["options"].indexOf(oFromSelect["selectedOption"][i]), 1)[0]);
                        i++;
                    }
                    // Vide la sélection.
                    oFromSelect["selectedOption"] = [];
                }
            };

            /**
             * reloadSelectField function.
             * Recharge les options du <select> (web service).
             * @param {object} oParentSelect Paramètres de definition du <select> parent.
             * @param {string} sFormDefinitionName Nom du formulaire.
             */
            scope["reloadSelectField"] = function (oParentSelect, sFormDefinitionName) {
                formReaderService["reloadSelectField"](oParentSelect, sFormDefinitionName, scope['oFormValues'], scope['oFormDefinition']);
            };

            /**
             * Return true if the element is a string not empty
             * @param {string} element
             * @returns {Boolean}
             */
            scope["isStringNotEmpty"] = function (element) {
                if (!goog.isDefAndNotNull(element)) {
                    return false;
                }
                if (!goog.isString(element)) {
                    return false;
                }
                if (!element.length > 0) {
                    return false;
                }
                return true;
            };

            /**
             * Get the file name from a link
             * @param {type} url
             * @returns {string}
             */
            scope["getLinkFileName"] = function (url) {

                if (!goog.isString(url)) {
                    return '';
                }

                var sName = url;

                if (sName.lastIndexOf('/') !== -1) {
                    sName = sName.substr(sName.lastIndexOf('/') + 1);
                }
                if (sName.lastIndexOf('?') !== -1) {
                    sName = sName.substr(0, sName.lastIndexOf('?'));
                }

                return sName;
            };

            /**
             * Determine if the field has to be present
             * @param {object} oField
             * @param {object} oTab
             * @param {boolean} bCheckButtons
             * @returns {Boolean}
             */
            scope['isFieldPresent'] = function (oField, oTab, bCheckButtons) {

                bCheckButtons = goog.isDefAndNotNull(bCheckButtons) ? bCheckButtons : false;

                // Visible
                var isVisible = true;
                if (oField['visible'] === false || oField['visible'] === 'false') {
                    isVisible = false;
                }
                if (oField['visible'] === true || oField['visible'] === 'true') {
                    isVisible = true;
                }
                // Visible au travers une fonction ou un ternaire
                if (typeof (oField["visible"]) !== "undefined") {
                    if (formReaderService["isFunctionCall"](oField["visible"])) {
                        isVisible = formReaderService["callFunction"](oField["visible"]);
                    } else if(formReaderService["isTernaryString"](oField["visible"])) {
                        isVisible = scope.$eval(oField["visible"]);
                    } else if (goog.isBoolean(oField["visible"])) {
                        isVisible = oField["visible"];
                    } else {
                        isVisible = false;
                    }
                }

                // Tabs
                var isOnTab = false;
                if (oTab['elements'].indexOf(oField['name']) !== -1) {
                    isOnTab = true;
                }
                if (oField['visibleAllTabs'] === true) {
                    isOnTab = true;
                }
                if (goog.isDefAndNotNull(oField['buttons']) && bCheckButtons === false) {
                    isOnTab = true;
                }
                if (!scope['showTabs']) {
                    isOnTab = true;
                }

                // Wab
                if (this['useWab']()) {
                    var isOnWab = false;
                    var wabValue = this['getWabField'](oField);
                    if (wabValue === 'r' || wabValue === 'rw') {
                        isOnWab = true;
                    }
                    if (goog.isDefAndNotNull(oField['buttons'])) {
                        isOnWab = true;
                    }
                    if (wabValue === 'r') {
                        oField['disabled'] = true;
                    }
                }

                // Return
                if (goog.isDefAndNotNull(isOnWab)) {
                    if (isVisible && isOnTab && isOnWab) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    if (isVisible && isOnTab) {
                        return true;
                    } else {
                        return false;
                    }
                }
            };

            /**
             * Determine if the button has to be present
             * @param {object} oButton
             * @param {object} oField
             * @param {object} oTab
             * @returns {Boolean}
             */
            scope['isButtonPresent'] = function (oButton, oField, oTab) {

                // Visible
                var isVisible = true;
                if (oButton['visible'] === false || oButton['visible'] === 'false') {
                    isVisible = false;
                }

                // Tabs
                var isOnTab = false;
                if (oTab['elements'].indexOf(oButton['name']) !== -1) {
                    isOnTab = true;
                }
                if (oButton['visibleAllTabs'] === true) {
                    isOnTab = true;
                }
                if (this['isFieldPresent'](oField, oTab, true)) {
                    isOnTab = true;
                }

                // Wab
                if (this['useWab']()) {
                    var isOnWab = false;
                    var wabValue = '';
                    if (this['isFieldPresent'](oField, oTab, true)) {
                        wabValue = this['getWabField'](oField);
                    } else {
                        wabValue = this['getWabField'](oButton);
                    }
                    if (wabValue === 'r' || wabValue === 'rw') {
                        isOnWab = true;
                    }
                    if (wabValue === 'r') {
                        oButton['disabled'] = true;
                    }
                    if (wabValue == '') {
                        oField['visible'] = false;
                    }
                }

                // Return
                if (goog.isDefAndNotNull(isOnWab)) {
                    if (isVisible && isOnTab && isOnWab) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    if (isVisible && isOnTab) {
                        return true;
                    } else {
                        return false;
                    }
                }
            };

            /**
             * Get the wab value of a field or null if not founded
             * @param {object} oField
             * @returns {string|null}
             */
            scope['getWabField'] = function (oField) {

                if (goog.isDefAndNotNull(scope['wabState']) && goog.isDefAndNotNull(scope['wabGroup'])) {
                    if (goog.isDefAndNotNull(scope['oFormDefinition'])) {
                        if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']])) {
                            if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']]['wab'])) {
                                if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']]['wab'][scope['wabState']])) {
                                    if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']]['wab'][scope['wabState']][scope['wabGroup']])) {

                                        var oWab = scope['oFormDefinition'][scope['sFormDefinitionName']]['wab'][scope['wabState']][scope['wabGroup']];

                                        if (goog.isDefAndNotNull(oWab[oField['name']])) {
                                            return oWab[oField['name']];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                return null;
            };

            /**
             * Return true if wab has to be used
             * @returns {Boolean}
             */
            scope['useWab'] = function () {
                var useWab = false;
                if (goog.isDefAndNotNull(scope['wabState']) && goog.isDefAndNotNull(scope['wabGroup'])) {
                    if (goog.isDefAndNotNull(scope['oFormDefinition'])) {
                        if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']])) {
                            if (goog.isDefAndNotNull(scope['oFormDefinition'][scope['sFormDefinitionName']]['wab'])) {
                                useWab = true;
                            }
                        }
                    }
                }
                return useWab;
            };

            /**
             * Recompile the entire template
             */
            scope['compileTemplate'] = function () {
                ajaxRequest({
                    "method": "GET",
                    "url": propertiesSrvc["web_server_name"] + "/" + sessionStorage["appEnv"] + "/javascript/externs/formReader/formReader.html",
                    "scope": scope,
                    "success": function (response) {
                        if (!goog.isDefAndNotNull(response['data'])) {
                            console.error('template not founded');
                            return 0;
                        }

                        var sTemplate = response['data'];
                        var compiledTemplate = $compile(sTemplate)(scope);
                        element.children().replaceWith(compiledTemplate);
                    }
                });
            };

            /**
             * Reset the file inputs
             */
            scope['resetFileInputs'] = function () {
                $(element).find(".file").each(function () {
                    $(this)['fileinput']('clear');
                });
            };

            // Attend la suppression du scope.
            scope.$on("$destroy", function () {
                // Supprime toutes les données du formulaire.
                scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
            });

            // Lors du chargement du formulaire
            scope.$on('loadForm', function () {
                // Vide les file inputs
                scope['resetFileInputs']();
            });
        }
    };
};
formReader.module.directive('appFormReader', formReader.formReaderDirective);

/**
 * appFormFieldSpecificParams directive.
 * Paramétrage spécifique suivant le type de champ de formulaire.
 * @param {angular.$timeout} $timeout Angular timeout service.
 * @param {angular.$translate} $translate Angular translate service.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @param {service} formReaderService
 * @param {service} $log
 * @param {service} $q Angular q service.
 * @ngInject
 */
formReader.appFormFieldSpecificParamsDrtv = function ($timeout, $translate, propertiesSrvc, formReaderService, $log, $q) {
    return {
        link: function (scope, element, attrs) {
            $log.log("formReader.appFormFieldSpecificParamsDrtv.link");
            // attributs à rajouter pour le champ de formulaire ?
            if (typeof (scope["field"]["attributes"]) !== "undefined") {
                var i = 0;
                var aKeys = Object.keys(scope["field"]["attributes"]);
                while (i < aKeys.length) {
                    element[0]["setAttribute"](aKeys[i], scope["field"]["attributes"][aKeys[i]]);
                    i++;
                }
            }

            // Autofocus sur l'élément.
            if (scope["field"]["autofocus"] === true)
                element[0].focus();
            // Paramétrage spécifique suivant le type de champ de form.
            switch (scope["field"]["type"]) {
                //
                case 'captcha' :
                    $timeout(function () {
                        var test = grecaptcha["render"](scope["field"]["id"], {
                            'sitekey': scope["field"]["key"],
                            'callback': function (response) {
                                scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]] = response;
                            }
                        });
                    }, 10);
                    break;
                case 'date':
                case 'datetime':
                    // Options par défaut du calendrier.
                    var oOptions = {
                        "useCurrent": false
                    };
                    // Options par défaut du calendrier suivant la langue de l'application.
                    var oLocaleOptions = {
                        "date": {
                            "fr": {
                                "locale": "fr",
                                "format": "DD/MM/YYYY"
                            },
                            "en": {
                                "format": "MM/DD/YYYY"
                            }
                        },
                        "datetime": {
                            "fr": {
                                "locale": "fr",
                                "format": "DD/MM/YYYY HH:mm"
                            },
                            "en": {
                                "format": "MM/DD/YYYY HH:mm"
                            }
                        }
                    };
                    goog.object.extend(oOptions, oLocaleOptions[scope["field"]["type"]][propertiesSrvc["language"]]);

                    // Date et heure actuelle par défaut.
                    oOptions["defaultDate"] = new Date();

                    // Surcharge les options du calendrier par celles définies dans la définition du form.
                    if (typeof (scope["field"]["options"]) !== "undefined")
                        goog.object.extend(oOptions, scope["field"]["options"]);

                    // http://momentjs.com/docs/#/displaying/format/

                    // Création du calendrier
                    $(element)["datetimepicker"](oOptions);

                    // Si sélection d'une date : mise à jour du modèle (NE PAS SUPPRIMER!).
                    $(element).on("dp.change", function (e) {
                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = element[0].value;
                    });
                    break;
                    //
                case 'checkbox':
                    // Checkbox non coché par défaut.
                    if (typeof (scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]]) == "undefined") {
                        if (typeof (scope["field"]["default_value"]) != "undefined")
                            scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]] = scope["field"]["default_value"];
                        else
                            scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]] = false;
                    }
                    break;
                case 'upload':

                    // Si sélection d'un fichier à uploader : sauve ses paramètres.
                    element[0].addEventListener("change", function () {
                        var oFileList = {
                            "aFiles": this.files
                        };
                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = oFileList;
                    }, false);
                    // Passage de paramètres de définition du champ d'upload ?
                    var oOptions = {
                        "showPreview": false,
                        "showRemove": true,
                        "showUpload": false
                    };

                    if (typeof (scope["field"]["options"]) !== "undefined")
                        goog.object.extend(oOptions, scope["field"]["options"]);

                    oOptions["mainClass"] = "input-file-" + scope["oFormDefinition"][scope["sFormDefinitionName"]]["input_size"];
                    // Langue.
                    if (propertiesSrvc["language"] != "en")
                        oOptions["language"] = propertiesSrvc["language"];
                    // Intégration du plugin "bootstrap-fileinput" dans tous les champ d'upload de fichiers.
                    $(element)["fileinput"](oOptions);
                    break;
                case 'file_wsdata':
                    // Si sélection d'un fichier à uploader : sauve ses paramètres.
                    element[0].addEventListener("change", function () {
                        var oFileList = {
                            "aFiles": this.files
                        };
                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = oFileList;
                    }, false);
                    // Extensions de fichiers autorisées.
                    if (typeof(scope["field"]["formats"]) != "undefined" && typeof(scope["field"]["extensions"]) == "undefined")
                        scope["field"]["extensions"] = scope["field"]["formats"];
                    if (goog.isDefAndNotNull(scope["field"]["extensions"])) {
                        var aFilesExtensions = scope["field"]["extensions"].split('|');
                        for (var iFileExtensionIndex in aFilesExtensions)
                            aFilesExtensions[iFileExtensionIndex] = "." + aFilesExtensions[iFileExtensionIndex];
                        element[0].setAttribute("accept", aFilesExtensions.join(","));
                    }
                    // Options
                    var oOptions = {
                        "showPreview": false,
                        "showRemove": false,
                        "showUpload": false,
                    };

                    if (typeof (scope["field"]["options"]) !== "undefined")
                        goog.object.extend(oOptions, scope["field"]["options"]);

                    oOptions["mainClass"] = "input-file-" + scope["oFormDefinition"][scope["sFormDefinitionName"]]["input_size"];
                    // Langue.
                    if (propertiesSrvc["language"] != "en")
                        oOptions["language"] = propertiesSrvc["language"];
                    // Intégration du plugin "bootstrap-fileinput" dans tous les champ d'upload de fichiers.
                    $(element)["fileinput"](oOptions);
                    break;
                case 'image_wsdata':
                    if (!goog.isDefAndNotNull(scope["field"]["display_width"])) {
                        scope["field"]["display_width"] = "100%";
                    }
                    // Si sélection d'un fichier à uploader : sauve ses paramètres.
                    element[0].addEventListener("change", function () {
                        var oFileList = {
                            "aFiles": this.files
                        };
                        if (goog.isDefAndNotNull(scope["field"]["width"]) && goog.isDefAndNotNull(scope["field"]["height"])) {
                            oFileList["width"] = scope["field"]["width"];
                            oFileList["height"] = scope["field"]["height"];
                        }

                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = oFileList;
                    }, false);
                    // Passage de paramètres de définition du champ d'upload ?
                    var oOptions = {
                        "showPreview": false,
                        "showRemove": false,
                        "showUpload": false,
                        "allowedFileTypes": ['image']
                    };
                    oOptions["mainClass"] = "input-file-" + scope["oFormDefinition"][scope["sFormDefinitionName"]]["input_size"];

                    // Langue.
                    if (propertiesSrvc["language"] != "en")
                        oOptions["language"] = propertiesSrvc["language"];

                    // Intégration du plugin "bootstrap-fileinput" dans tous les champ d'upload de fichiers.
                    $(element)["fileinput"](oOptions);
                    break;
                case 'email':
                    scope["field"]["pattern"] = "^(([a-zA-Z]|[0-9])|([-]|[_]|[.]))+[@](([a-zA-Z]|[0-9])|([-]|[_]|[.])){2,63}[.](([a-zA-Z0-9]){2,63})+$";
                    // Utile dans le studio pour mémoriser la patern
                    var pattern = angular.copy(scope['field']['pattern']);
                    scope.$watch('oFormValues.' + scope['sFormDefinitionName'] + '["' + scope['field']['name'] + '"]', function () {
                        scope['field']['pattern'] = angular.copy(pattern);
                        $timeout(function () {
                            if (element[0]["className"].indexOf("ng-invalid-pattern") !== -1) {
                                var advice;
                                if (scope["oProperties"]["language"] === "fr") {
                                    advice = "ceci n'est pas une adresse mail";
                                } else {
                                    advice = "this is not a mail adress";
                                }

                                $(element).notify(advice, {
                                    "position": "top",
                                    "className": "error",
                                    "autoHide": false,
                                    "clickToHide": false
                                });
                            } else {
                                var tabChild = element[0]["parentNode"]["children"];
                                var elToDelete = -1;
                                for (var i = 0; i < tabChild.length; i++) {
                                    if (tabChild[i]["className"] === "notifyjs-wrapper") {
                                        elToDelete = i;
                                    }
                                }
                                if (elToDelete > -1)
                                    $(tabChild[elToDelete]).remove();
                            }
                        }, 1);
                    });
                    break;
                case 'url':
                    scope['field']['pattern'] = '^https?:\\/\\/.{1,}';
                    // Utile dans le studio pour mémoriser la patern
                    var pattern = angular.copy(scope['field']['pattern']);
                    scope.$watch('oFormValues.' + scope['sFormDefinitionName'] + '["' + scope['field']['name'] + '"]', function () {
                        scope['field']['pattern'] = angular.copy(pattern);
                        $timeout(function () {
                            if (element[0]['className'].indexOf('ng-invalid-pattern') !== -1) {
                                var advice;
                                if (scope['oProperties']['language'] === 'fr') {
                                    advice = 'ce champ doit contenir une url qui commence\n par http:// ou https://';
                                } else {
                                    advice = 'this field must contain an url that begin\n by http:// or https://';
                                }

                                // Position UP car sinon le message dépasse de la div du FormReader ce qui est empetant dans vMap ou dans le studio
                                $(element).notify(advice, {
                                    'position': 'top',
                                    'className': 'error',
                                    'autoHide': false,
                                    'clickToHide': false
                                });
                            } else {
                                var tabChild = element[0]['parentNode']['children'];
                                var elToDelete = -1;
                                for (var i = 0; i < tabChild.length; i++) {
                                    if (tabChild[i]['className'] === 'notifyjs-wrapper') {
                                        elToDelete = i;
                                    }
                                }
                                if (elToDelete > -1)
                                    $(tabChild[elToDelete]).remove();
                            }
                        }, 1);
                    });
                    break;
                case "integer":
                    if (typeof (scope["field"]["min"]) !== "undefined")
                        (element)[0].setAttribute("min", scope["field"]["min"]);
                    if (typeof (scope["field"]["max"]) !== "undefined")
                        (element)[0].setAttribute("max", scope["field"]["max"]);
                    if (typeof (scope["field"]["max_length"]) !== "undefined")
                        (element)[0].setAttribute("maxLength", scope["field"]["max_length"]);

                    //scope["field"]["pattern"] = "^([-]{0,1}[0-9]+)$";
                    scope["$parent"]["valid"] = true;
                    scope["numberUpdate"] = function () {
                        var val = scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name];
                        if (goog.isDef(val) && (typeof val === "string" || typeof val === "number")) {
                            if (typeof val === "string") {
                                var tmp = scope["ctrl"]["numberParser"](val, true);
                                if (!isNaN(tmp))
                                    scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = tmp;
                                else {
                                    scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = "";
                                }
                            } else
                                scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = val;
                        } else {
                            console.error("bad type argument");
                        }
                    };
                    $timeout(function () {
                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] += " ";
                        scope["numberUpdate"]();
                    }, 500);
                    break;
                case "float":
                case "number":
                    if (typeof (scope["field"]["min"]) !== "undefined")
                        (element)[0].setAttribute("min", scope["field"]["min"]);
                    if (typeof (scope["field"]["max"]) !== "undefined")
                        (element)[0].setAttribute("max", scope["field"]["max"]);
                    if (typeof (scope["field"]["max_length"]) !== "undefined")
                        (element)[0].setAttribute("maxLength", scope["field"]["max_length"]);

                    //scope["field"]["pattern"] = "^([-]{0,1}[0-9]+[.,][0-9]+)$";
                    scope["$parent"]["valid"] = true;
                    scope["numberUpdate"] = function () {
                        var val = scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name];
                        if (goog.isDef(val) && (typeof val === "string" || typeof val === "number")) {
                            //val = val.replace(",", ".");
                            if (typeof val === "string") {
                                var tmp = scope["ctrl"]["numberParser"](val, false);
                                if (!isNaN(tmp) || typeof tmp === "string")
                                    //if (val.charAt(val.length - 1) === '0') {
                                    //var ret = val.split(".");
                                    scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = tmp;
                                else
                                    scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = "";
                            } else
                                scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] = val;
                        } else {
                            console.error("bad type argument");
                        }
                    };
                    $timeout(function () {
                        scope["oFormValues"][scope["sFormDefinitionName"]][element[0].name] += " ";
                        scope["numberUpdate"]();
                    }, 500);
                    break;
                    //
                case 'image_wsdata':
                    if (goog.isDefAndNotNull(scope["field"])) {
                        if (goog.isDefAndNotNull(scope["field"]["width"])) {
                            if (scope["field"]["width"] == 0 || scope["field"]["width"] == "0px") {
                                scope["field"]["width"] = null;
                            }
                        }
                        if (goog.isDefAndNotNull(scope["field"]["style"])) {
                            if (goog.isDefAndNotNull(scope["field"]["style"]["height"])) {
                                if (scope["field"]["style"]["height"] == 0 || scope["field"]["style"]["height"] == "0px") {
                                    scope["field"]["style"]["height"] = null;
                                }
                            }
                        }
                    }
                    break;
                case 'image':

                    if (goog.isDefAndNotNull(scope["field"])) {
                        if (goog.isDefAndNotNull(scope["field"]["width"])) {
                            if (scope["field"]["width"] == 0 || scope["field"]["width"] == "0px") {
                                scope["field"]["width"] = null;
                            }
                        }
                        if (goog.isDefAndNotNull(scope["field"]["style"])) {
                            if (goog.isDefAndNotNull(scope["field"]["style"]["height"])) {
                                if (scope["field"]["style"]["height"] == 0 || scope["field"]["style"]["height"] == "0px") {
                                    scope["field"]["style"]["height"] = null;
                                }
                            }
                        }
                    }
                    var options = {
                        "inline": false,
                        "button": true,
                        "navbar": false,
                        "title": 2,
                        "toolbar": 2,
                        "tooltip": true,
                        "fullscreen": false,
                        "url": function () {
                            return scope["oProperties"]["web_server_name"] + "/" + scope["oProperties"][scope["field"]["alias"]] + "/" + scope["field"]["folder"] + "/" + scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]];
                        }
                    };
                    scope["viewer"] = new Viewer(element[0], options);
                    scope["openViewer"] = function () {
                        $log.log("openViewer");
                        scope["viewer"].show();
                        angular.element(".viewer-prev").remove();
                        angular.element(".viewer-next").remove();
                    };
                    break;
                case 'imageurl':

                    if (goog.isDefAndNotNull(scope["field"])) {
                        if (goog.isDefAndNotNull(scope["field"]["width"])) {
                            if (scope["field"]["width"] == 0 || scope["field"]["width"] == "0px") {
                                scope["field"]["width"] = null;
                            }
                        }
                        if (goog.isDefAndNotNull(scope["field"]["style"])) {
                            if (goog.isDefAndNotNull(scope["field"]["style"]["height"])) {
                                if (scope["field"]["style"]["height"] == 0 || scope["field"]["style"]["height"] == "0px") {
                                    scope["field"]["style"]["height"] = null;
                                }
                            }
                        }
                    }
                    var options = {
                        "inline": false,
                        "button": true,
                        "navbar": false,
                        "title": 2,
                        "toolbar": 2,
                        "tooltip": true,
                        "fullscreen": false,
                        "url": function () {
                            return scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]];
                        }
                    };
                    scope["viewer"] = new Viewer(element[0], options);
                    scope["openViewer"] = function () {
                        $log.log("openViewer");
                        scope["viewer"].show();
                        angular.element(".viewer-prev").remove();
                        angular.element(".viewer-next").remove();
                    };
                    break;
                case 'select':
                case 'editable_select':
                    var oField = scope['field'];
                    var fieldValue = scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']];
                    // Conversion de la valeur numérique de type "string" en type "number".
                    if (typeof (fieldValue) == "string" && !isNaN(fieldValue)) {
                        if (fieldValue.length == 1 || fieldValue.search(/^[1-9][0-9]+$/) != -1) {
                            scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']] = Number(fieldValue);
                        }
                    }

                    // Sélection multiple ?
                    if (typeof (oField['multiple']) !== 'undefined' && oField['multiple'] === true)
                        (element)[0].setAttribute('multiple', '');
                    // Plusieurs lignes ?
                    if (typeof (oField['size']) !== 'undefined') {
                        (element)[0].setAttribute('size', oField['size']);
                        (element)[0].style.height = 'auto';
                    }
                    // Options string ?
                    if (goog.isString(oField['options'])) {
                        var tmp = oField['options'].split(',');
                        var tmp2;
                        for (var i = 0; i < tmp.length; i++) {
                            tmp2 = tmp[i].split('|');
                            tmp[i] = {
                                'label': tmp2[0],
                                'value': tmp2[1]
                            };
                        }
                        scope['oFormValues'][scope['sFormDefinitionName']][oField['name']]['options'] = tmp;
                    }
                    // Cascade list ?
                    if (typeof (scope["field"]["child_select"]) != "undefined") {
                        element[0].addEventListener("change", function () {
                            scope["reloadSelectField"](scope["field"], scope["sFormDefinitionName"]);
                        }, false);
                    }
                    // Change event
                    if (goog.isDefAndNotNull(oField['onchange'])) {
                        element[0].addEventListener("change", function () {
                            if (formReaderService['isFunctionCall'](oField['onchange'])) {
                                if (goog.isString(oField['onchange'])) {
                                    formReaderService['callFunction'](oField['onchange']);
                                } else if (goog.isFunction(oField['onchange'])) {
                                    oField['onchange'](scope['oFormValues']);
                                }
                            }
                        }, false);
                    }
                    break;
                    //
                case "map_bing":
                case "map_osm":
                case "map_vmap":

                    var initMap = function () {

                        // Suppression de la carte si elle existe déjà
                        if (goog.isDef(scope['oMap'])) {
                            scope['oMap'].MapObject.setTarget(null);
                            delete scope['oMap'];
                        }

                        // Création de la carte
                        scope['oMap'] = new nsVitisComponent.Map({
                            'target': element[0],
                            'options': scope['field']['map_options'],
                            'hiddenFieldId': scope['field']['id'],
                            'oFormValues': scope['oFormValues'][scope['sFormDefinitionName']],
                            'sFormName': scope['field']['name'],
                            'oProj': scope.$root['proj']
                        });

                        //
                        if (typeof (scope["field"]["style"]) != "undefined") {
                            // Garde le ratio de l'écran pour la hauteur de la carte.
                            if (typeof (scope["field"]["style"]["height"]) != "undefined" && scope["field"]["style"]["height"] == "ratio") {
                                var ratio = window.innerWidth / window.innerHeight;
                                scope["field"]["style"]["height"] = parseInt(element[0].clientWidth / ratio) + "px";
                            }
                        }

                        // Evènement de création de la carte.
                        scope.$root.$emit('OpenLayersMapCreated', scope['oMap']);

                        // Changement des options lors du changement de centre de la carte
                        scope['oMap'].on('moveend', function () {
                            scope['field']['map_options']['center'] = scope['oMap']['getConfig']();
                            scope.$apply();
                        }, scope['oMap']);
                    };

                    setTimeout(function () {
                        // Instanciation de la carte
                        initMap();

                        // Recharge la taille de la carte lorsqu'on modifie la taille du champ
                        scope.$watch('field.nb_cols', function (value, old) {
                            $timeout(function () {
                                scope['oMap'].MapObject.updateSize();
                            });
                        });

                        scope.$watch('field.style', function (value, old) {
                            $timeout(function () {
                                scope['oMap'].MapObject.updateSize();
                            });
                        }, true);

                        scope.$watch('oMap.bLayersTreeOpen', function (value, old) {
                            $timeout(function () {
                                scope['oMap'].MapObject.updateSize();
                            });
                        }, true);

                        scope.$on('studio resized', function () {
                            scope['oMap'].MapObject.updateSize();
                        });

                        scope.$on('updateMap', function (event, data) {
                            switch (data) {
                                case 'center':
                                    scope['oMap']['setCenter']([scope['field']['map_options']['center']['coord'][0], scope['field']['map_options']['center']['coord'][1]]);
                                    break;
                                case 'zoom':
                                    scope['oMap']['setZoom'](scope['field']['map_options']['center']['zoom']);
                                    break;
                                case 'source':
                                    scope['oMap']['setBingSource'](scope['field']['map_options']['source']);
                                    break;
                                case 'extent':
                                    scope['oMap']['setExtent'](scope['field']['map_options']['center']['extent']);
                                    break;
                                case 'controls':
                                    scope['oMap']['setControls'](scope['field']['map_options']['controls']);
                                    break;
                                case 'interact':
                                    scope['oMap']['setInteractions'](scope['field']['map_options']['interactions']);
                                    break;
                                case 'proj':
                                    var extent = scope['oMap']['getExtent']();
                                    var center = scope['oMap']['getCenter']();
                                    var proj = scope['oMap']['getProj']();

                                    scope['field']['map_options']['center']['extent'] = scope['oMap']['transformExtent'](extent, proj, scope['field']['map_options']['proj']);
                                    scope['field']['map_options']['center']['coord'] = scope['oMap']['transformer'](center, proj, scope['field']['map_options']['proj']);

                                    // Ré-initialise la carte
                                    initMap();
                                    break;
                                default:
                                    // Ré-initialise la carte
                                    initMap();
                                    break;
                            }
                        });
                    });
                    break;
                case 'slider':
                    // Id du slider.
                    scope['field']['options']['id'] = scope['field']['id'] + '_slider';
                    // Création du slider.
                    var mySlider = $(element)['slider'](scope['field']['options']);
                    // Si aucune valeurm alors vaut 0
                    if (!goog.isDefAndNotNull(scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']]))
                        scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']] = 0;
                    // Quand le slider change par l'action de l'utilisateur
                    $(element).on('slide', function () {
                        scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']] = $(element)['slider']('getValue');
                    });
                    // Quand la valeur dans oFormValues du slider change
                    scope.$watch('oFormValues.' + scope['sFormDefinitionName'] + '["' + scope['field']['name'] + '"]', function () {
                        setTimeout(function () {
                            if (goog.isDefAndNotNull($(element)))
                                if (goog.isDefAndNotNull(scope['oFormValues']))
                                    if (goog.isDefAndNotNull(scope['oFormValues'][scope['sFormDefinitionName']]))
                                        if (goog.isDefAndNotNull(scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']]))
                                            $(element)['slider']('setValue', parseFloat(scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']]));
                        }, 10);
                    });
                    // Quand une des options change, recrée le slider
                    scope.$watch('field.options', function () {
                        setTimeout(function () {
                            mySlider = $(element)['slider'](scope['field']['options']);
                        }, 10);
                    }, true);
                    break;
                    //
                case "color_picker":

                    var oOptions = {
                        format: "rgba"
                    };

                    if (goog.isDefAndNotNull(scope['field']['options'])){
                        oOptions = scope['field']['options'];
                    }
                    $(element)['colorpicker'](oOptions);
                    // Quand le colorpicker change par l'action de l'utilisateur
                    $(element).on("changeColor", function () {
                        scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]] = $(element)['colorpicker']('getValue');
                    });
                    // Quand la valeur dans oFormValues du colorpocker change
                    scope.$watch('oFormValues.' + scope["sFormDefinitionName"] + '["' + scope['field']['name'] + '"]', function () {
                        setTimeout(function () {
                            if (goog.isDefAndNotNull($(element)))
                                if (goog.isDefAndNotNull(scope['oFormValues']))
                                    if (goog.isDefAndNotNull(scope['oFormValues'][scope['sFormDefinitionName']]))
                                        if (goog.isDefAndNotNull(scope['oFormValues'][scope['sFormDefinitionName']][scope['field']['name']]))
                                            $(element)['colorpicker']('setValue', scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["name"]]);
                        }, 10);
                    });

                    break;
                case 'double_select':
                    // Hauteur minimale par rapport à la hauteur d'une ligne et du paramètre "size".
                    var ilineHeight = parseInt($(element).css("line-height")) - 1;
                    if (typeof (scope["field"]["size"]) !== "undefined")
                        element[0].style.minHeight = ilineHeight * scope["field"]["size"] + "px";
                    break;
                case "password":
                    // Désactivation de l'auto complétion des champs de mot de passe (ne pas afficher ceux sauvegardés par le navigateur).
                    if (typeof (scope["field"]["autocomplete"]) === "undefined" || scope["field"]["autocomplete"] === false) {
                        element[0].readOnly = true;
                        // Attend la fin de l'affichage du 1er formulaire.
                        if (document.getElementById("FormBuilder") === null) {
                            var clearListener = scope.$root.$on('endFormNgRepeat', function (event) {
                                $timeout(function () {
                                    element[0].readOnly = false;
                                }, 300);
                                // Supprime le "listener".
                                clearListener();
                            });
                        } else {
                            $timeout(function () {
                                element[0].readOnly = false;
                            }, 300);
                        }
                    }
                    break;
                case "text":
                    if (typeof (scope["field"]["max_length"]) !== "undefined")
                        (element)[0].setAttribute("maxLength", scope["field"]["max_length"]);
                    break;
                case "treeview":
                    var oTreeviewOptions = angular.copy(scope["field"]["options"]);
                    // Evènement à attendre pour les données du treeview (optionnel).
                    if (goog.isDefAndNotNull(oTreeviewOptions["dataLoadingEvent"]) && oTreeviewOptions["dataLoadingEvent"] != "") {
                        scope.$root["waitForTreeviewDataLoaded"] = function () {
                            var deferred = $q.defer();
                            var clearListener = scope.$root.$on(oTreeviewOptions["dataLoadingEvent"], function (event, aNodes) {
                                clearListener();
                                deferred.resolve(aNodes);
                            });
                            return deferred.promise;
                        };
                        // Appel à la fonction qui emet l'évènement.
                        if (goog.isDefAndNotNull(oTreeviewOptions['data']) && oTreeviewOptions['data'] != "" && formReaderService["isFunctionCall"](oTreeviewOptions['data']))
                            formReaderService['callFunction'](oTreeviewOptions  ['data']);
                        // Appel à la fonction qui attend l'évènement et retorune les données du treeview.
                        oTreeviewOptions['data'] = "waitForTreeviewDataLoaded()";
                    }
                    // Données json dans le paramètre "data".
                    else if ((!formReaderService["isFunctionCall"](oTreeviewOptions['data']))) {
                        scope.$root["getTreeviewData"] = function () {
                            var deferred = $q.defer();
                            deferred.resolve(scope["field"]["options"]["data"]);
                            return deferred.promise;
                        };
                        oTreeviewOptions['data'] = "getTreeviewData()";
                    }
                    // Données pour le treeview (paramètre obligatoire pour afficher le treeview).
                    if (goog.isDefAndNotNull(oTreeviewOptions['data']) && oTreeviewOptions['data'] != "") {
                        formReaderService['callFunction'](oTreeviewOptions['data']).then(function (aNodes) {
                            oTreeviewOptions["data"] = aNodes;
                            if (typeof (oTreeviewOptions["showCheckbox"]) != "undefined" && oTreeviewOptions["showCheckbox"] === true) {
                                // Coche les items déja cochés.
                                this["setTreeviewNodesState"] = function (oNode) {
                                    for (var i in oNode) {
                                        if (typeof (oNode[i]["nodes"]) != "undefined")
                                            this["setTreeviewNodesState"](oNode[i]["nodes"]);
                                        else {
                                            if (typeof (oNode[i]["state"]) == "undefined")
                                                oNode[i]["state"] = {};
                                            var aCheckedItem = [];
                                            var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                            if (typeof (sValue) == "string" && sValue != "")
                                                aCheckedItem = sValue.split("|");
                                            if (aCheckedItem.indexOf(String(oNode[i]["value"])) != -1)
                                                oNode[i]["state"]["checked"] = true;
                                        }
                                    }
                                };
                                this["setTreeviewNodesState"](oTreeviewOptions["data"]);

                                // Ajoute le noeud coché dans la liste.
                                oTreeviewOptions["onNodeChecked"] = function (event, data) {
                                    // Coche toute l'arborescence du noeud.
                                    if (typeof (data["nodes"]) != "undefined") {
                                        for (var i in data["nodes"])
                                            $(element)["treeview"]("checkNode", data["nodes"][i]["nodeId"]);
                                    } else {
                                        // Met à jour la liste des noeuds cochés.
                                        var aCheckedItem = [];
                                        if (typeof (data["value"]) != "undefined") {
                                            var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                            if (typeof (sValue) == "string" && sValue != "") {
                                                aCheckedItem = sValue.split("|");
                                            }
                                            aCheckedItem.push(data["value"]);
                                            scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = aCheckedItem.join("|");
                                        }
                                    }
                                };
                                // Supprime le noeud coché de la liste.
                                oTreeviewOptions["onNodeUnchecked"] = function (event, data) {
                                    // Décoche toute l'arborescence du noeud.
                                    if (typeof (data["nodes"]) != "undefined") {
                                        for (var i in data["nodes"])
                                            $(element)["treeview"]("uncheckNode", data["nodes"][i]["nodeId"]);
                                    } else {
                                        // Met à jour la liste des noeuds cochés.
                                        var aCheckedItem = [];
                                        if (typeof (data["value"]) != "undefined") {
                                            var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                            if (typeof (sValue) == "string" && sValue != "") {
                                                aCheckedItem = sValue.split("|");
                                            }
                                            aCheckedItem.splice(aCheckedItem.indexOf(data["value"]), 1);
                                            scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = aCheckedItem.join("|");
                                        }
                                    }
                                };
                            }
                            // Création du "Treeview".
                            $(element)["treeview"](oTreeviewOptions);
                        });
                    }
                    break;
                case "foldermanager":
                    // Crée l'arborescence dans l'élément.
                    var oTreeviewOptions = angular.copy(scope["field"]["options"]);
                    oTreeviewOptions["data"] = [];
                    if (typeof (oTreeviewOptions["showCheckbox"]) != "undefined" && oTreeviewOptions["showCheckbox"] === true) {
                        // Coche les items déja cochés.
                        this["setTreeviewNodesState"] = function (oNode) {
                            for (var i in oNode) {
                                if (typeof (oNode[i]["nodes"]) != "undefined")
                                    this["setTreeviewNodesState"](oNode[i]["nodes"]);
                                else {
                                    if (typeof (oNode[i]["state"]) == "undefined")
                                        oNode[i]["state"] = {};
                                    var aCheckedItem = [];
                                    var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                    if (typeof (sValue) == "string" && sValue != "")
                                        aCheckedItem = sValue.split("|");
                                    if (aCheckedItem.indexOf(String(oNode[i]["value"])) != -1)
                                        oNode[i]["state"]["checked"] = true;
                                }
                            }
                        };
                        this["setTreeviewNodesState"](oTreeviewOptions["data"]);
                        //autoset de la config pour cocher les enfants si on coche le parent
                        if(!goog.isDefAndNotNull(oTreeviewOptions["recursiveCheck"])){
                            oTreeviewOptions["recursiveCheck"] = true;
                        }
                        // Ajoute le noeud coché dans la liste.
                        oTreeviewOptions["onNodeChecked"] = function (event, data) {
                            // Coche toute l'arborescence du noeud.
                            if (typeof (data["nodes"]) != "undefined" && oTreeviewOptions["recursiveCheck"]) {
                                for (var i in data["nodes"])
                                    $(element)["treeview"]("checkNode", data["nodes"][i]["nodeId"]);
                            } else {
                                // Met à jour la liste des noeuds cochés.
                                var aCheckedItem = [];
                                if (typeof (data["value"]) != "undefined") {
                                    var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                    if (typeof (sValue) == "string" && sValue != "") {
                                        aCheckedItem = sValue.split("|");
                                    }
                                    aCheckedItem.push(data["value"]);
                                    scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = aCheckedItem.join("|");
                                }
                            }
                        };
                        // Supprime le noeud coché de la liste.
                        oTreeviewOptions["onNodeUnchecked"] = function (event, data) {
                            // Décoche toute l'arborescence du noeud.
                            if (typeof (data["nodes"]) != "undefined" && oTreeviewOptions["recursiveCheck"]) {
                                for (var i in data["nodes"])
                                    $(element)["treeview"]("uncheckNode", data["nodes"][i]["nodeId"]);
                            } else {
                                // Met à jour la liste des noeuds cochés.
                                var aCheckedItem = [];
                                if (typeof (data["value"]) != "undefined") {
                                    var sValue = scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]];
                                    if (typeof (sValue) == "string" && sValue != "") {
                                        aCheckedItem = sValue.split("|");
                                    }
                                    aCheckedItem.splice(aCheckedItem.indexOf(data["value"]), 1);
                                    scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = aCheckedItem.join("|");
                                }
                            }
                        };
                    }
                    // Création du "Treeview".
                    $(element)["treeview"](oTreeviewOptions);

                    var destroyer = scope.$on("update_data_treeview_" + scope["field"]["id"], function (event, data) {
                        if (goog.isDefAndNotNull(data)) {
                            oTreeviewOptions["data"] = data;
                            // $("#" + element[0].id)["treeview"]("remove");
                            $(element)["treeview"](oTreeviewOptions);
                        }
                    });

                    scope.$on("$destroy", function () {
                        destroyer();
                        //$("#" + element[0].id)["treeview"]("remove");
                    })
                    if (goog.isDefAndNotNull(scope["field"]['loadDataFunction']))
                        formReaderService['callFunction'](scope["field"]['loadDataFunction']);
                    break;
            }
            //
            if (typeof (scope["field"]["read_only"]) != "undefined" && scope["field"]["read_only"] == true) {
                (element)[0].readOnly = true;
            }
        }
    };
};
formReader.module.directive("appFormFieldSpecificParams", formReader.appFormFieldSpecificParamsDrtv);

/**
 * appFormRowNgRepeat directive.
 * Paramétrage de chaque ligne du formulaire.
 * @param {angular.$timeout} $timeout Angular timeout service.
 * @param {angular.$rootScope} $rootScope Angular rootScope.
 * @param {service} $log
 * @ngInject
 */
formReader.appFormRowNgRepeatDrtv = function ($timeout, $rootScope, envSrvc, $log) {
    return {
        link: function (scope, element, attrs) {
            $log.log("formReader.appFormRowNgRepeatDrtv.link");
            // Composant "Togglable tabs" de bootstrap.
            if (typeof (scope["row"]["tab"]) != "undefined") {
                // Insertion de l'élément conteneur s'il n'existe pas déja (obligatoire).
                var bFirstTab = false;
                var sTabContainerId = scope["sFormDefinitionName"] + '_' + scope["row"]["tab"]["parent"] + "_tab_container";
                if (document.getElementById(sTabContainerId) == null) {
                    var oDiv = document.createElement("div");
                    oDiv.className = "tab-content";
                    oDiv.id = sTabContainerId;
                    element[0].parentNode.insertBefore(oDiv, element[0]);
                    bFirstTab = true;
                }
                // Déplacement de l'onglet dans l'élement conteneur.
                document.getElementById(sTabContainerId).appendChild(element[0]);
                // Paramétrage de l'onglet.
                element[0].id = scope["sFormDefinitionName"] + '_' + scope["row"]["tab"]["name"] + "_tab";
                element[0].setAttribute("role", "tabpanel");
                $timeout(function () {
                    element[0].className += " tab-pane fade";
                    // 1er onglet actif par défaut.
                    if (bFirstTab)
                        element[0].className += " in active";
                });
            }
            //
            $timeout(function () {
                if (scope["$last"])
                    $rootScope.$emit("endFormNgRepeat", envSrvc["oSelectedObject"]["name"]);
            });
        }
    }
};
formReader.module.directive("appFormRowNgRepeat", formReader.appFormRowNgRepeatDrtv);

/**
 * appFormFieldNgRepeat directive.
 * Paramétrage de tous les champs de formulaire.
 * @param {service} $translate Translate service.
 * @param {angular.$timeout} $timeout Angular timeout service.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @param {service} externFunctionSrvc Fonctions externes à Angular.
 * @param {service} $log
 * @ngInject
 * @constructor
 */
formReader.appFormFieldNgRepeatDrtv = function ($translate, $timeout, formReaderService, propertiesSrvc, externFunctionSrvc, $log) {
    return {
        link: function (scope, element, attrs) {
            // Valeur par défaut à traduire ?
            if (typeof (scope["field"]["default_value"]) == "string") {
                if (/^[A-Z0-9_]+$/.test(scope["field"]["default_value"])) {
                    $translate([scope["field"]["default_value"]]).then(function (translations) {
                        if (scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] == scope["field"]["default_value"])
                            scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = translations[scope["field"]["default_value"]];
                        //scope["field"]["default_value"] = translations[scope["field"]["default_value"]];
                    });
                }
            }
            // Valeur dans un objet ?
            if (typeof (scope["field"]["name"]) != "undefined" && scope["field"]["name"].indexOf(".") != -1)
                scope['oFormValues'][scope["sFormDefinitionName"]][scope["field"]["name"]] = formReaderService["getFormValueFromObject"](scope['oFormValues'][scope["sFormDefinitionName"]], scope["field"]["name"]);

            // Paramètre "visible" ?
            if (typeof (scope["field"]["visible"]) !== "undefined") {
                /**
                 * Armand 04/09/2018 : fonctionnalité déplacée dans la fonction isFieldPresent
                if (formReaderService["isFunctionCall"](scope["field"]["visible"])) {
                    scope["field"]["visible"] = scope.$eval(scope["field"]["visible"]);
                }
                */
                /*
                 var bVisible = false;
                 if (formReaderService["isFunctionCall"](scope["field"]["visible"])) {

                 //                    bVisible = scope.$eval(scope["field"]["visible"]);

                 } else if (typeof (scope["field"]["visible"]) == "boolean")
                 bVisible = scope["field"]["visible"];
                 // l'élément est caché ?
                 if (!bVisible)
                 element[0].parentNode.removeChild(element[0]);
                 */
            }
            // Création d'un id pour l'élément de form. (si non spécifié).
            /*
             if (typeof (scope["field"]["id"]) == "undefined" && typeof (scope["field"]["name"]) != "undefined")
             scope["field"]["id"] = scope["sFormDefinitionName"] + '_' + scope["field"]["name"];
             */

            // Création des tags.
            if (scope["field"]["type"] === "editable_double_select") {
                // Attend le chargement des la liste des tags.
                var clearListener = scope.$root.$on("webServiceTagsloaded", function (event, oFormElementDefinition) {
                    // Supprime le "listener".
                    clearListener();
                    if (oFormElementDefinition["webServiceTagsloaded"] != true) {
                        oFormElementDefinition["webServiceTagsloaded"] = true;
                        // Attend la fin d'un cycle de "$digest".
                        $timeout(function () {
                            // Création des tags.
                            var oOptions = {};
                            if (typeof (oFormElementDefinition["options"]) !== "undefined")
                                oOptions = oFormElementDefinition["options"];
                            $("#" + oFormElementDefinition["id"])["tagsinput"](oOptions);
                            $("#" + oFormElementDefinition["id_available_tags"])["tagsinput"](oOptions);
                            // Evènement sur la suppression d'un tag (déplacement vers l'autre élément).
                            $("#" + oFormElementDefinition["id"]).on("itemRemoved itemAdded", function (event) {
                                if (event["type"] == "itemRemoved") {
                                    $("#" + oFormElementDefinition["id_available_tags"])["tagsinput"]('add', event["item"]);
                                    scope.$root["setTagsInput"]([oFormElementDefinition["id_available_tags"]]);
                                } else
                                    scope.$root["setTagsInput"]([oFormElementDefinition["id"]]);
                            });
                            $("#" + oFormElementDefinition["id_available_tags"]).on("itemRemoved itemAdded", function (event) {
                                if (event["type"] == "itemRemoved") {
                                    $("#" + oFormElementDefinition["id"])["tagsinput"]('add', event["item"]);
                                    scope.$root["setTagsInput"]([oFormElementDefinition["id"]]);
                                } else
                                    scope.$root["setTagsInput"]([oFormElementDefinition["id_available_tags"]]);
                            });
                            // Mise en forme des tags.
                            scope.$root["setTagsInput"]([oFormElementDefinition["id_available_tags"], oFormElementDefinition["id"]]);
                        });
                    }
                });
            } else if (scope["field"]["type"] == "ui_grid" || scope["field"]["type"] == "bo_grid" || scope["field"]["type"] == "section_grid") {

                if (!goog.isDefAndNotNull(scope["field"]["options"])) {
                    scope["field"]["options"] = {
                        "enableRowSelection": true,
                        "enableSelectAll": true,
                        "enablePagination": false,
                        "enablePaginationControls": false,
                        "enableColumnMenus": false,
                        "enableColumnResizing": false,
                        "appHeader": true,
                        "appHeaderTitleBar": true,
                        "columnDefs": [],
                        "data": []
                    };
                }

                // Désactive la sélection de toutes les lignes.
                if (typeof (scope["field"]["options"]["appDisableRowSelection"]) != "undefined" && scope["field"]["options"]["appDisableRowSelection"] === true)
                    scope["field"]["options"]["isRowSelectable"] = function () {
                        return false
                    };

                scope["gridOptions"] = angular.copy(scope["field"]["options"]);

                // Traduction des titres des colonnes.
                var aColumnTitleTranslation = [];
                var aColumnDefs = angular.copy(scope["gridOptions"]["columnDefs"]);
                // Sauve les id de traduction.
                aColumnDefs.forEach(function (oColumnDef) {
                    aColumnTitleTranslation.push(oColumnDef["name"]);
                });
                $translate(aColumnTitleTranslation).then(function (oTranslations) {
                    // Mise à jour avec les titres des colonnes traduites.
                    aColumnTitleTranslation.forEach(function (sTranslation, i) {
                        aColumnDefs[i]["name"] = oTranslations[sTranslation];
                        aColumnDefs[i]["displayName"] = oTranslations[sTranslation];
                    });
                    scope["gridOptions"]["columnDefs"] = angular.copy(aColumnDefs);
                });
                // Template pour activer le drag'n drop.
                if (scope["gridOptions"]["appEnableDragAndDrop"] === true)
                    scope["gridOptions"]["rowTemplate"] = '<div grid="grid" class="ui-grid-draggable-row" draggable="true"><div ng-repeat="(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name" class="ui-grid-cell" ng-class="{ \'ui-grid-row-header-cell\': col.isRowHeader, \'custom\': true }" ui-grid-cell></div></div>';
                // Attend l'instanciation de la grille.
                scope["gridOptions"]["onRegisterApi"] = function (gridApi) {
                    //
                    scope.$root.$emit("registeredUiGridApi", gridApi);
                    scope['gridApi'] = gridApi;
                    // Redimensionnement de la fenêtre et de la grille.
                    $timeout(function () {
                        externFunctionSrvc["resizeWin"]();
                        gridApi["core"]["handleWindowResize"]();
                    });
                    // Sauve l'api.
                    scope["gridOptions"]["gridApi"] = gridApi;
                    // Sélectionne toute la ligne si click sur une de ses colonnes.
                    $timeout(function () {
                        if (scope["gridOptions"]["enableRowSelection"]) {
                            $(gridApi["grid"]["element"]).find(".ui-grid-render-container-body").on("click.selectRow", function (event) {
                                var oCell = event.target;
                                // Click sur la colonne de données ou d'action (boutons) ?
                                if ($(oCell).hasClass("ui-grid-cell") || $(oCell).hasClass("ui-grid-cell-contents")) {
                                    var iRowIndex = $(element).find(".ui-grid-render-container-body .ui-grid-canvas").children().index($(oCell).parents(".ui-grid-row"));
                                    $(element).find(".ui-grid-render-container-left .ui-grid-row").eq(iRowIndex).find(".ui-grid-selection-row-header-buttons").click();
                                }
                            });
                        }
                    });
                    // Module "ui.grid.draggable-rows" chargé ?
                    if (typeof (gridApi["dragndrop"]) !== "undefined") {
                        // Activation ou désactivation du drag'n drop.
                        if (scope["gridOptions"]["appEnableDragAndDrop"] === true) {
                            gridApi["dragndrop"]["setDragDisabled"] = false;
                            // Début du drag'n drop.
                            gridApi["draggableRows"]["on"]["rowDragged"](scope, function (info, rowElement) {
                            });
                            // Fin du drag'n drop.
                            gridApi["draggableRows"]["on"]["rowFinishDrag"](scope, function () {
                                if (typeof (scope["gridOptions"]["appDragAndDropEvent"]) !== "undefined" && typeof (scope["gridOptions"]["appDragAndDropEvent"]["rowFinishDrag"]) !== "undefined") {
                                    if (goog.isFunction(scope.$root[scope["gridOptions"]["appDragAndDropEvent"]["rowFinishDrag"]]))
                                        scope.$root[scope["gridOptions"]["appDragAndDropEvent"]["rowFinishDrag"]]();
                                    else
                                        console.error(scope["gridOptions"]["appDragAndDropEvent"]["rowFinishDrag"] + ' is not a function of scope.$root');
                                }
                            });
                            //
                            gridApi["draggableRows"]["on"]["rowEnterRow"](scope, function (info, rowElement) {
                            });
                            //
                            gridApi["draggableRows"]["on"]["beforeRowMove"](scope, function (from, to, data) {
                            });
                        } else
                            gridApi["dragndrop"]["setDragDisabled"] = true;
                    }
                    // Hauteur auto. du "body" de la liste.
                    element[0].querySelector(".ui-grid-render-container-body").style.height = "100%";
                    element[0].querySelector(".ui-grid-render-container-body .ui-grid-viewport").style.height = "Calc(100% - 30px)";
                };
            } else if (scope["field"]["type"] == "codemirror") {

                // Ancien paramètre des options de CodeMirror.
                if (typeof (scope["field"]["codemirrorOptions"]) != "undefined")
                    scope["field"]["cm_options"] = scope["field"]["codemirrorOptions"];

                // Exécute la fonction dès le chargement de l'éditeur CodeMirror.
                if (goog.isDefAndNotNull(scope["field"]["cm_options"])) {
                    scope["field"]["cm_options"]["onLoad"] = function (oEditor) {
                        // Sauve l'éditeur.
                        if (typeof (scope["oCodeMirrorEditor"]) == "undefined")
                            scope["oCodeMirrorEditor"] = {};
                        scope["oCodeMirrorEditor"][oEditor["options"]["appName"]] = oEditor;
                        oEditor.on('change', function(){
                            // si max-height défini on check si on doit l'utiliser et si oui on met à jour height
                            if (typeof (oEditor["options"]["appMaxHeight"]) != "undefined") {
                                var iMaxHeight = oEditor["options"]["appMaxHeight"]
                                var oDoc = oEditor["getDoc"]();
                                var iLines = oDoc["lineCount"]();
                                var iLineHeight = oEditor["defaultTextHeight"]();
                                var iHeightNeeded = iLines * iLineHeight;
                                // Hauteur dans un "string" (pourcentage ou numérique ou ligne).
                                if (iMaxHeight.indexOf("%") != -1){
                                    iMaxHeight = parseInt((window.innerHeight * parseInt(iMaxHeight)) / 100);
                                } else if(iMaxHeight.indexOf("l") != -1){
                                    iMaxHeight = parseInt(parseInt(iMaxHeight) * iLineHeight);
                                } else if (!isNaN(iMaxHeight)){
                                    iMaxHeight = parseInt(iMaxHeight);
                                }

                                if(iMaxHeight < iHeightNeeded){
                                    oEditor["setSize"](null, iMaxHeight);
                                }
                            }
                        })

                        // Définition de la hauteur de l'éditeur.
                        if (typeof (oEditor["options"]["appHeight"]) != "undefined") {
                            var iHeight = oEditor["options"]["appHeight"];
                            var iLineHeight = oEditor["defaultTextHeight"]();
                            // Hauteur dans un "string" (pourcentage ou numérique ou ligne).
                            if (typeof (iHeight) == "string") {
                                if (iHeight.indexOf("%") != -1){
                                    iHeight = parseInt((window.innerHeight * parseInt(iHeight)) / 100);
                                } else if(iHeight.indexOf("l") != -1){
                                    iHeight = parseInt(parseInt(iHeight) * iLineHeight);
                                } else if (!isNaN(iHeight)){
                                    iHeight = parseInt(iHeight);
                                }
                            }
                            if (typeof (iHeight) == "number"){
                                oEditor["setSize"](null, iHeight);
                            }
                        }
                        // Affichage des suggestions dans l'éditeur CodeMirror.
                        if (typeof (scope["field"]["cm_options"]["appHints"]) != "undefined") {
                            oEditor.on("keyup", function (cm, event) {
                                if (event.key == scope["field"]["cm_options"]["appHints"]["key"]) {
                                    var options = {
                                        hint: function () {
                                            return {
                                                "from": oEditor["getDoc"]()["getCursor"](),
                                                "to": oEditor["getDoc"]()["getCursor"](),
                                                "list": scope["field"]["cm_options"]["appHints"]["hints"]
                                            }
                                        }
                                    };
                                    oEditor["showHint"](options);
                                }
                            });
                        }
                    };
                }
            }// A vérifier si vraiment un doublon
            /* else if (scope["field"]["type"] == "codemirror") {
                // Ancien paramètre des options de CodeMirror.
                if (typeof (scope["field"]["codemirrorOptions"]) != "undefined")
                    scope["field"]["cm_options"] = scope["field"]["codemirrorOptions"];
                // Exécute la fonction dès le chargement de l'éditeur CodeMirror.
                scope["field"]["cm_options"]["onLoad"] = function (oEditor) {
                    // Sauve l'éditeur.
                    if (typeof (scope["oCodeMirrorEditor"]) == "undefined")
                        scope["oCodeMirrorEditor"] = {};
                    scope["oCodeMirrorEditor"][oEditor["options"]["appName"]] = oEditor;
                    // Définition de la hauteur de l'éditeur.
                    if (typeof (oEditor["options"]["appHeight"]) != "undefined") {
                        var iHeight = oEditor["options"]["appHeight"];
                        // Hauteur dans un "string" (pourcentage ou numérique).
                        if (typeof (iHeight) == "string") {
                            if (iHeight.indexOf("%") != -1)
                                iHeight = parseInt((window.innerHeight * parseInt(iHeight)) / 100);
                            else if (!isNaN(iHeight))
                                iHeight = parseInt(iHeight);
                        }
                        if (typeof (iHeight) == "number")
                            oEditor["setSize"](null, iHeight);
                    }
                    // si max-height défini on met à jour
                    if (typeof (oEditor["options"]["appMaxHeight"]) != "undefined") {
                        console.log(oEditor["getScrollInfo"]());
                        /*var iHeight = oEditor["options"]["appMaxHeight"];
                        // Hauteur dans un "string" (pourcentage ou numérique).
                        if (typeof (iHeight) == "string") {
                            if (iHeight.indexOf("%") != -1)
                                iHeight = parseInt((window.innerHeight * parseInt(iHeight)) / 100);
                            else if (!isNaN(iHeight))
                                iHeight = parseInt(iHeight);
                        }
                        if (typeof (iHeight) == "number")
                            oEditor["setSize"](null, iHeight);
                    }
                    // Affichage des suggestions dans l'éditeur CodeMirror.
                    if (typeof (scope["field"]["cm_options"]["appHints"]) != "undefined") {
                        oEditor.on("keyup", function (cm, event) {
                            if (event.key == scope["field"]["cm_options"]["appHints"]["key"]) {
                                var options = {
                                    hint: function () {
                                        return {
                                            "from": oEditor["getDoc"]()["getCursor"](),
                                            "to": oEditor["getDoc"]()["getCursor"](),
                                            "list": scope["field"]["cm_options"]["appHints"]["hints"]
                                        }
                                    }
                                };
                                oEditor["showHint"](options);
                            }
                        });
                    }
                };
            }*/

            //
            $timeout(function () {
                // Tooltip sur le label du champ de form. ?
                if (typeof (scope["field"]["tooltip"]) !== "undefined" && scope["field"]["visible"] !== false) {
                    // Tooltip au survol de la souris (par défaut) ?
                    if (typeof (scope["field"]["tooltip"]["trigger"]) === "undefined")
                        scope["field"]["tooltip"]["trigger"] = "hover";
                    // Création de l'élément qui contient le tooltip.
                    var oTooltipElement = document.createElement("span");
                    oTooltipElement.className = "form-field-label-tooltip";
                    var sTooltipElementId = scope["field"]["id"] + "_tooltip";
                    oTooltipElement.id = sTooltipElementId;
                    // Tooltip qui contient un thumbnail.
                    if (typeof (scope["field"]["tooltip"]["thumbnail"]) != "undefined") {
                        var sFileName = scope["oFormValues"][scope["sFormDefinitionName"]][scope["field"]["tooltip"]["thumbnail"]];
                        if (sFileName != "" && sFileName != null) {
                            //oTooltipElement.className += " popover-thumbnail";
                            var sImagePath = propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["public_alias"] + "/" + propertiesSrvc["application"] + "/" + sFileName;
                            scope["field"]["tooltip"]["html"] = true;
                            scope["field"]["tooltip"]["content"] = '<img src="' + sImagePath + '" class="popover-thumbnail-img">';
                            scope["field"]["tooltip"]["template"] = '<div class="popover popover-thumbnail" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>';
                            // Création du toolltip
                            element[0].querySelector("label").appendChild(oTooltipElement);
                            $(element).find("label .form-field-label-tooltip")["popover"](scope["field"]["tooltip"]);
                        }
                    } else {
                        element[0].querySelector("label").appendChild(oTooltipElement);
                        // Traduction du titre et du contenu du tooltip.
                        $translate([scope["field"]["tooltip"]["title"], scope["field"]["tooltip"]["content"]])
                                .then(function (translations) {
                                    scope["field"]["tooltip"]["title"] = translations[scope["field"]["tooltip"]["title"]];
                                    scope["field"]["tooltip"]["content"] = translations[scope["field"]["tooltip"]["content"]];
                                    // Création du toolltip
                                    $(element).find("label .form-field-label-tooltip")["popover"](scope["field"]["tooltip"])
                                            .on('inserted.bs.popover', function () {
                                                // La largeur est spécifiée ?
                                                if (typeof (scope["field"]["tooltip"]["width"]) !== "undefined")
                                                    element[0].querySelector(".popover").style.width = scope["field"]["tooltip"]["width"];
                                            });
                                });
                    }
                }
                // Attribut "autocomplete".
                if (typeof (scope["field"]["autocomplete"]) != "undefined") {
                    if (scope["field"]["autocomplete"])
                        element[0].querySelector("[name='" + scope["field"]["name"] + "']").setAttribute("autocomplete", "on");
                    else
                        element[0].querySelector("[name='" + scope["field"]["name"] + "']").setAttribute("autocomplete", "off");
                }
            });

            // Langue de l'éditeur TinyMCE.
            if (scope["field"]["type"] == "tinymce") {
                if (typeof (scope["field"]["tinymceOptions"]) == "undefined")
                    scope["field"]["tinymceOptions"] = {};
                if (propertiesSrvc["language"] != "en")
                    scope["field"]["tinymceOptions"]["language"] = propertiesSrvc["language"] + "_" + propertiesSrvc["language"].toUpperCase();
            }
        }
    };
};
formReader.module.directive("appFormFieldNgRepeat", formReader.appFormFieldNgRepeatDrtv);

/**
 * appButton directive.
 * Traitements spécifiques sur les boutons.
 * @param {service} $translate Translate service.
 * @param {service} $log
 * @ngInject
 */
formReader.appButtonDrtv = function ($translate, $log) {
    return {
        link: function (scope, element, attrs) {
            $log.log("formReader.appButtonDrtv.link");

            // Tooltip à afficher pour le bouton ?
            if (typeof (scope["button"]["tooltip"]) !== "undefined") {
                // Traduction du titre.
                $translate([scope["button"]["tooltip"]["title"]])
                        .then(function (translations) {
                            scope["button"]["tooltip"]["title"] = translations[scope["button"]["tooltip"]["title"]];
                            // Affichage du tooltip.
                            $(element).tooltip(scope["button"]["tooltip"]);
                        });
            }
        }
    };
};
formReader.module.directive("appButton", formReader.appButtonDrtv);

/**
 * appSubformGrid directive.
 * Display a grid containing a subobject
 * @param {service} $timeout
 * @param {service} $translate
 * @param {service} propertiesSrvc
 * @param {service} formReaderService
 * @param {service} $log
 * @ngInject
 */
formReader.appSubformGridDrtv = function ($timeout, $translate, propertiesSrvc, formReaderService, $log) {
    return {
        link: function (scope, element, attrs) {
            $log.log("formReader.appSubformGridDrtv.link");

            var oMainScope = angular.element('#formreader_' + scope['sFormUniqueName'] + '_grid_subform_modal').scope();
            var formContainer = element.closest('form').parent();

            /**
             * Initializes the Business Object grid
             */
            scope['initBoSubformGrid'] = function () {
                $log.log("formReader.appSubformGridDrtv.initBoSubformGrid");

                var sBusinessObject = scope['field']['bo_id'];
                var sModalId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_modal';
                var oSearchValues = {};
                var oInsertValues = {};
                // Nom du champ cible
                var sFilterAttr = scope['field']['bo_filter_attr'];
                // Nom du champ dans lequel aller chercher la valeur de jointure
                var sFilterValue = scope['field']['form_filter_value'];
                var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
                var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
                var sSubformId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform';
                var oSubformScope = angular.element('#' + sSubformId).scope();
                var bIsIntersected = false;

                oMainScope['closeModal'] = function (identifier) {
                    $(identifier).modal('hide');
                };

                $('#' + sModalId).on('hidden.bs.modal', function (event) {
                    setTimeout(function () {
                        envSrvc["oFormValues"] = oMainScope['oFormValues'];
                        envSrvc["oFormDefinition"] = oMainScope['oFormDefinition'];
                        envSrvc["sFormDefinitionName"] = oMainScope['sFormDefinitionName'];
                    });
                });

                scope['haveInsertRights'] = false;
                scope['haveDeleteRights'] = false;
                scope['haveUpdateRights'] = false;
                scope['haveCardRights'] = false;
                scope['oListWebService'] = {
                    'dataType': 'businessObject',
                    'ressource_id': 'vmap/querys/' + sBusinessObject + '/list',
                    'parameters': {
                        'filter': ''
                    }
                };

                // Charge les infos de l'objet métier
                formReaderService['getBusinessObjectDef'](sBusinessObject).then(function (oBusinessObject) {

                    if (!goog.isDefAndNotNull(oBusinessObject['business_object_id'])) {
                        console.error('error while loading business object (' + sBusinessObject + ')');
                        return 0;
                    }

                    // Filtre composant (défini par field.bo_filter_attr et field.form_filter_value)
                    if (goog.isDefAndNotNull(sFilterAttr) && sFilterAttr !== '') {
                        if (goog.isDefAndNotNull(sFilterValue) && sFilterValue !== '') {
                            if (goog.isDefAndNotNull(oMainScope['oFormValues'])) {
                                if (goog.isDefAndNotNull(oMainScope['oFormValues'][oMainScope['sFormDefinitionName']])) {

                                    // Cas où l'attribut de jointure se fasse sur un champ de type select
                                    var sFilterValueValue = oMainScope['oFormValues'][oMainScope['sFormDefinitionName']][sFilterValue];
                                    if (goog.isDefAndNotNull(sFilterValueValue)) {
                                        if (goog.isDefAndNotNull(sFilterValueValue['selectedOption'])) {
                                            if (goog.isDefAndNotNull(sFilterValueValue['selectedOption']['value'])) {
                                                sFilterValueValue = sFilterValueValue['selectedOption']['value'];
                                            }
                                        }
                                    }
                                    if (goog.isDefAndNotNull(sFilterValueValue)) {
                                        if (goog.isDefAndNotNull(sFilterValueValue['selectedOption'])) {
                                            if (goog.isDefAndNotNull(sFilterValueValue['selectedOption'][0])) {
                                                if (goog.isDefAndNotNull(sFilterValueValue['selectedOption'][0]['value'])) {
                                                    sFilterValueValue = sFilterValueValue['selectedOption'][0]['value'];
                                                }
                                            }
                                        }
                                    }

                                    bIsIntersected = true;
                                    oSearchValues[sFilterAttr] = sFilterValueValue;
                                    oInsertValues[sFilterAttr] = sFilterValueValue;
                                }
                            }
                        }
                    }
                    var sFilter = formReaderService['parseFilter'](oSearchValues);
                    scope['oListWebService']['parameters']['filter'] = sFilter;
                    scope['oListWebService']['parameters']['limit'] = 100;

                    // Droits
                    if (oBusinessObject['user_rights'].indexOf('INSERT') !== -1) {
                        scope['haveInsertRights'] = true;
                    }
                    if (oBusinessObject['user_rights'].indexOf('DELETE') !== -1) {
                        scope['haveDeleteRights'] = true;
                    }
                    if (oBusinessObject['user_rights'].indexOf('UPDATE') !== -1) {
                        if (goog.isDefAndNotNull(oBusinessObject['json_form'])) {
                            if (goog.isDefAndNotNull(oBusinessObject['json_form'][0])) {
                                if (goog.isDefAndNotNull(oBusinessObject['json_form'][0]['update'])) {
                                    scope['haveUpdateRights'] = true;
                                }
                            }
                        }
                    }
                    if (oBusinessObject['user_rights'].indexOf('SELECT') !== -1) {
                        if (goog.isDefAndNotNull(oBusinessObject['json_form'])) {
                            if (goog.isDefAndNotNull(oBusinessObject['json_form'][0])) {
                                if (goog.isDefAndNotNull(oBusinessObject['json_form'][0]['display'])) {
                                    scope['haveCardRights'] = true;
                                }
                            }
                        }
                    }

                    /**
                     * Set the grid data
                     * @param {array} aResult
                     */
                    var setGridData = function (aResult) {
                        var aList = [];

                        // Récupère les informations à injecter dans le tableau
                        for (var i = 0; i < aResult.length; i++) {
                            aResult[i]['bo_list']['bo_object_infos'] = {
                                'bo_id_value': aResult[i]['bo_id_value'],
                                'bo_id_field': aResult[i]['bo_id_field'],
                                'bo_type': aResult[i]['bo_type']
                            };
                            aList.push(aResult[i]['bo_list']);
                        }

                        scope['gridOptions']['data'] = aList;
                    };

                    /**
                     * Initialie the grid
                     * @returns {undefined}
                     */
                    var setGrid = function () {
                        // Récupère la liste des éléments
                        formReaderService['getWebServiceData'](angular.copy(scope['oListWebService'])).then(function (aResult) {

                            if (!goog.isDefAndNotNull(aResult)) {
                                return null;
                            }

                            if (goog.isDefAndNotNull(aResult[0])) {

                                // Colonnes du tableau
                                scope['gridOptions']['columnDefs'] = [{
                                        "name": "",
                                        "field": "actions",
                                        "cellTemplate": "<app-ui-grid-action></app-ui-grid-action>",
                                        "width": 60,
                                        "enableSorting": false,
                                        "enableColumnMoving": false,
                                        "enableColumnResizing": false
                                    }];
                                for (var i = 0; i < aResult[0]['bo_list_attributs'].length; i++) {
                                    scope['gridOptions']['columnDefs'].push({
                                        'field': aResult[0]['bo_list_attributs'][i]
                                    });
                                }

                                // Contennu du tableau
                                setGridData(aResult);

                                // Actions éditer/voir/ajouter/supprimer
                                if (scope['haveUpdateRights']) {
                                    scope['gridApi']['grid']['appScope']['edit_column'] = 'edit';
                                }
                                if (scope['haveCardRights']) {
                                    scope['gridApi']['grid']['appScope']['show_column'] = 'show';
                                }

                                scope['gridApi']['grid']['appScope']['executeActionButtonEvent'] = function (oRow, sEvent) {

                                    if (formContainer.attr('id') === 'studio_form_reader') {
                                        $translate('NO_IN_STUDIO').then(function (translation) {
                                            $.notify(translation, 'error');
                                        });
                                        return 0;
                                    }

                                    var oElement = oRow['entity'];
                                    var oObject = oElement['bo_object_infos'];
                                    var sSubformDefinitionName = sEvent === 'edit' ? 'update' : sEvent === 'show' ? 'display' : 'display';
                                    var oFormWebService = {
                                        'dataType': 'businessObject',
                                        'ressource_id': 'vmap/querys/' + sBusinessObject + '/form',
                                        'parameters': {
                                            'filter': {
                                                "column": oObject['bo_id_field'],
                                                "compare_operator": "=",
                                                "value": oObject['bo_id_value']
                                            }
                                        }
                                    };

                                    // Récupère lélément en sélectionné
                                    formReaderService['getWebServiceData'](oFormWebService).then(function (aResult) {

                                        var oSubformDefinition = aResult[0]['bo_json_form'];
                                        var oSubformValues = {};
                                        var sModalId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_modal';

                                        // Evènement submit
                                        if (sSubformDefinitionName === 'update') {
                                            oSubformDefinition['update']['event'] = function (oFormValuesResulted) {
                                                formReaderService['updateBoElement'](sBusinessObject, oObject, oSubformDefinition, sSubformDefinitionName, oFormValuesResulted, function () {
                                                    // Ferme la modale
                                                    $('#' + sModalId).modal('hide');
                                                    // Rafraichit la grille
                                                    setTimeout(function () {
                                                        formReaderService['getWebServiceData'](angular.copy(scope['oListWebService'])).then(function (oNewResult) {
                                                            setGridData(oNewResult);
                                                        });
                                                    });
                                                    $translate('LIST_EDIT_OK').then(function (translation) {
                                                        $.notify(translation, 'success');
                                                    });
                                                });
                                            };
                                        }

                                        // Valeurs du formulaire
                                        oSubformValues[sSubformDefinitionName] = aResult[0]['bo_form'];

                                        // Id du formulaire
                                        oSubformDefinition[sSubformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                                        // Grise le champ contenant la valeur du parent
                                        if (bIsIntersected) {
                                            oSubformDefinition = formReaderService['disableFormElement'](oSubformDefinition, sFilterAttr, sSubformDefinitionName);
                                        }

                                        if (!goog.isDefAndNotNull(oObject)) {
                                            console.error('oObject undefined');
                                            return 0;
                                        }
                                        if (!goog.isDefAndNotNull(oSubformScope)) {
                                            console.error('oSubformScope undefined');
                                            return 0;
                                        }
                                        if (!goog.isDefAndNotNull(oSubformDefinition)) {
                                            console.error('oSubformDefinition undefined');
                                            return 0;
                                        }
                                        if (!goog.isDefAndNotNull(sSubformDefinitionName)) {
                                            console.error('sSubformDefinitionName undefined');
                                            return 0;
                                        }
                                        if (!goog.isDefAndNotNull(oSubformValues)) {
                                            console.error('oSubformValues undefined');
                                            return 0;
                                        }

                                        // Titre etc.. de la modale
                                        oMainScope.$applyAsync(function () {
                                            oMainScope['grid_subform_title'] = aResult[0]['bo_title'];
                                            oMainScope['grid_subform_definition_name'] = sSubformDefinitionName;
                                            if (sSubformDefinitionName === 'update') {
                                                oMainScope['grid_subform_size'] = oBusinessObject['edit_form_size'];
                                            }
                                            if (sSubformDefinitionName === 'display') {
                                                oMainScope['grid_subform_size'] = oBusinessObject['display_form_size'];
                                            }
                                        });

                                        formReaderService['showModalSubform'](sModalId, oSubformScope, oSubformDefinition, sSubformDefinitionName, oSubformValues);
                                    });
                                };

                                scope['gridApi']['grid']['refresh']();
                            } else {
                                setGridData([]);
                            }
                        });
                    };

                    /**
                     * Fonction qui permet d'ajouter un enregistrement de l'objet métier en question
                     */
                    scope['addObject'] = function () {

                        if (formContainer.attr('id') === 'studio_form_reader') {
                            $translate('NO_IN_STUDIO').then(function (translation) {
                                $.notify(translation, 'error');
                            });
                            return 0;
                        }

                        var oSubformValues = {
                            'insert': angular.copy(oInsertValues)
                        };
                        var sModalId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_modal';
                        var oSubformDefinition = oBusinessObject['json_form'][0];
                        var sSubformDefinitionName = 'insert';

                        // Grise le champ contenant la valeur du parent
                        if (bIsIntersected) {
                            oSubformDefinition = formReaderService['disableFormElement'](oSubformDefinition, sFilterAttr, sSubformDefinitionName);
                        }

                        // Titre etc.. de la modale
                        oMainScope.$applyAsync(function () {
                            oMainScope['grid_subform_title'] = oBusinessObject['title'];
                            oMainScope['grid_subform_size'] = oBusinessObject['add_form_size'];
                            oMainScope['grid_subform_definition_name'] = sSubformDefinitionName;
                        });

                        // Id du formulaire
                        oSubformDefinition[sSubformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                        // Événement
                        var lastInsert = Date.now();
                        oSubformDefinition['insert']['event'] = function (oFormValuesResulted) {

                            // Évite la double création en cas de double click
                            if (lastInsert > Date.now() - 2000) {
                                return false;
                            }
                            lastInsert = Date.now();

                            formReaderService['insertBoElement'](sBusinessObject, oBusinessObject, oSubformDefinition, sSubformDefinitionName, oFormValuesResulted, function () {
                                // Ferme la modale
                                $('#' + sModalId).modal('hide');
                                // Rafraichit la grille
                                setTimeout(function () {
                                    setGrid();
                                });

                                // Message ok
                                $translate('LIST_ADD_OK').then(function (translation) {
                                    $.notify(translation, 'success');
                                });
                            });
                        };
                        formReaderService['showModalSubform'](sModalId, oSubformScope, oSubformDefinition, sSubformDefinitionName, oSubformValues);
                    };

                    /**
                     * Fonction qui permet de supprimer les enregistrements séléctionnés
                     */
                    scope['removeSelection'] = function () {

                        if (formContainer.attr('id') === 'studio_form_reader') {
                            $translate('NO_IN_STUDIO').then(function (translation) {
                                $.notify(translation, 'error');
                            });
                            return 0;
                        }

                        var aIds = [];
                        var rows = scope['gridApi']['selection']['getSelectedRows']();
                        if (rows.length > 0) {

                            $translate('LIST_DELETE_CONFIRM').then(function (translation) {
                                bootbox.confirm(translation, function (result) {
                                    if (result === true) {

                                        for (var i = 0; i < rows.length; i++) {
                                            aIds.push(rows[i]['bo_object_infos']['bo_id_value']);
                                        }

                                        formReaderService['deleteBoElements'](sBusinessObject, aIds, function () {
                                            // Rafraichit la grille
                                            setTimeout(function () {
                                                formReaderService['getWebServiceData'](angular.copy(scope['oListWebService'])).then(function (oNewResult) {
                                                    setGridData(oNewResult);
                                                });
                                            });
                                            // Message ok
                                            $translate('LIST_DELETE_OK').then(function (translation) {
                                                $.notify(translation, 'success');
                                            });
                                        });
                                    }
                                });
                            });
                        } else {
                            $translate('LIST_NO_ELEMENT_SELECTED').then(function (translation) {
                                $.notify(translation, 'warning');
                            });
                        }
                    };

                    /**
                     * Fonction qui affiche le formulaire de filtrage
                     */
                    scope['showFilterFormModal'] = function () {

                        if (formContainer.attr('id') === 'studio_form_reader') {
                            $translate('NO_IN_STUDIO').then(function (translation) {
                                $.notify(translation, 'error');
                            });
                            return 0;
                        }

                        var oFilterformScope = oSubformScope;
                        var sFilterformDefinitionName = 'search';
                        var oFilterformDefinition = oBusinessObject['json_form'][0];
                        var oFilterformValues = {
                            'search': oSearchValues
                        };

                        // Grise le champ contenant la valeur du parent
                        if (bIsIntersected) {
                            oFilterformDefinition = formReaderService['disableFormElement'](oFilterformDefinition, sFilterAttr, sFilterformDefinitionName);
                        }

                        // Nom du formulaire
                        oFilterformDefinition[sFilterformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                        // Événement
                        oFilterformDefinition[sFilterformDefinitionName]['event'] = function (oFormValuesResulted) {

                            envSrvc["oFormValues"] = oFormValuesResulted;
                            envSrvc["oFormDefinition"] = oFilterformDefinition;
                            envSrvc["sFormDefinitionName"] = sFilterformDefinitionName;

                            var oValues = formSrvc['getFormData'](sFilterformDefinitionName, true);
                            var sFilter = formReaderService['parseFilter'](oValues);
                            scope['oListWebService']['parameters']['filter'] = sFilter;

                            // Ferme la modale
                            $('#' + sModalId).modal('hide');

                            // Rafraichit la grille
                            formReaderService['getWebServiceData'](angular.copy(scope['oListWebService'])).then(function (oNewResult) {
                                setGridData(oNewResult);
                            });

                            // Message ok
                            $translate('LIST_SEARCH_OK').then(function (translation) {
                                $.notify(translation, 'success');
                            });
                        };

                        // Titre etc.. de la modale
                        oMainScope.$applyAsync(function () {
                            oMainScope['grid_subform_title'] = oBusinessObject['title'];
                            oMainScope['grid_subform_definition_name'] = sFilterformDefinitionName;
                        });

                        oFilterformScope['loadSubForm']({
                            'sFormDefinitionName': sFilterformDefinitionName,
                            'oFormDefinition': oFilterformDefinition,
                            'oFormValues': oFilterformValues,
                            'oProperties': scope['oProperties']
                        });

                        // Affiche la modale
                        $('#' + sModalId).modal('show');
                    };

                    // Initialise la grille
                    setGrid();
                });
            };

            /**
             * Initializes the Vitis Section grid
             */
            scope['initSectionSubformGrid'] = function () {
                $log.log("formReader.appSubformGridDrtv.initSectionSubformGrid");

                var sSection = scope['field']['section_id'];
                var sSubformId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform';
                var sModalId = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_modal';
                var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
                var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
                var oSubformScope = angular.element('#' + sSubformId).scope();
                var oSearchValues = {};
                var oInsertValues = {};
                var sFilterAttr = scope['field']['section_filter_attr'];
                var sFilterValue = scope['field']['form_filter_value'];
                var bIsIntersected = false;

                scope['haveInsertRights'] = false;
                scope['haveDeleteRights'] = false;

                oMainScope['closeModal'] = function (identifier) {
                    $(identifier).modal('hide');
                };

                $('#' + sModalId).on('hidden.bs.modal', function (event) {
                    setTimeout(function () {
                        envSrvc["oFormValues"] = oMainScope['oFormValues'];
                        envSrvc["oFormDefinition"] = oMainScope['oFormDefinition'];
                        envSrvc["sFormDefinitionName"] = oMainScope['sFormDefinitionName'];
                    });
                });

                // Filtre composant (défini par field.bo_filter_attr et field.form_filter_value)
                if (goog.isDefAndNotNull(sFilterAttr) && sFilterAttr !== '') {
                    if (goog.isDefAndNotNull(sFilterValue) && sFilterValue !== '') {
                        if (goog.isDefAndNotNull(oMainScope['oFormValues'])) {
                            if (goog.isDefAndNotNull(oMainScope['oFormValues'][oMainScope['sFormDefinitionName']])) {
                                if (goog.isDefAndNotNull(oMainScope['oFormValues'][oMainScope['sFormDefinitionName']][sFilterValue])) {
                                    bIsIntersected = true;
                                    oSearchValues[sFilterAttr] = oMainScope['oFormValues'][oMainScope['sFormDefinitionName']][sFilterValue];
                                    oInsertValues[sFilterAttr] = oMainScope['oFormValues'][oMainScope['sFormDefinitionName']][sFilterValue];
                                }
                            }
                        }
                    }
                }

                /**
                 * Fonction qui permet d'ajouter un enregistrement de l'objet métier en question
                 */
                scope['addObject'] = function () {

                    if (formContainer.attr('id') === 'studio_form_reader') {
                        $translate('NO_IN_STUDIO').then(function (translation) {
                            $.notify(translation, 'error');
                        });
                        return 0;
                    }

                    var oSubformValues = {
                        'insert': angular.copy(oInsertValues)
                    };
                    var oSubformDefinition = scope['oSubformDefinition'];
                    var oSubformScope = angular.element('#formreader_' + scope['sFormUniqueName'] + '_grid_subform').scope();
                    var sSubformDefinitionName = 'insert';

                    // Grise le champ contenant la valeur du parent
                    if (bIsIntersected) {
                        oSubformDefinition = formReaderService['disableFormElement'](oSubformDefinition, sFilterAttr, sSubformDefinitionName);
                    }

                    // Titre etc.. de la modale
                    oMainScope.$applyAsync(function () {
                        oMainScope['grid_subform_title'] = scope['oRessourceTab']['name'];
                        oMainScope['grid_subform_definition_name'] = sSubformDefinitionName;
                    });

                    // Id du formulaire
                    oSubformDefinition[sSubformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                    // Événement
                    if (goog.isDefAndNotNull(oSubformDefinition['insert']['afterEvent'])) {
                        delete oSubformDefinition['insert']['afterEvent'];
                    }
                    oSubformDefinition['insert']['event'] = function (oFormValuesResulted) {
                        formReaderService['insertSectionElement'](scope['oSection']['ressource_id'], scope['sIdField'], scope['oSubformDefinition'], sSubformDefinitionName, oFormValuesResulted).then(function () {
                            // Ferme la modale
                            $('#' + sModalId).modal('hide');
                            // Rafraichit la grille
                            setTimeout(function () {
                                formReaderService['getSectionRessourceData'](scope['oSection']['ressource_id']).then(function (oNewResult) {
                                    scope['gridOptions']['data'] = oNewResult;
                                });
                            });
                            // Message ok
                            $translate('LIST_ADD_OK').then(function (translation) {
                                $.notify(translation, 'success');
                            });
                        });
                    };

                    formReaderService['showModalSubform'](sModalId, oSubformScope, oSubformDefinition, sSubformDefinitionName, oSubformValues);
                };

                /**
                 * Fonction qui permet de supprimer les enregistrements séléctionnés
                 */
                scope['removeSelection'] = function () {

                    if (formContainer.attr('id') === 'studio_form_reader') {
                        $translate('NO_IN_STUDIO').then(function (translation) {
                            $.notify(translation, 'error');
                        });
                        return 0;
                    }

                    var aIds = [];
                    var rows = scope['gridApi']['selection']['getSelectedRows']();
                    if (rows.length > 0) {

                        $translate('LIST_DELETE_CONFIRM').then(function (translation) {
                            bootbox.confirm(translation, function (result) {
                                if (result === true) {

                                    for (var i = 0; i < rows.length; i++) {
                                        aIds.push(rows[i][scope['sIdField']]);
                                    }

                                    formReaderService['deleteSectionElements'](scope['oSection']['ressource_id'], aIds).then(function (oResponse) {
                                        // Rafraichit la grille
                                        setTimeout(function () {
                                            formReaderService['getSectionRessourceData'](scope['oSection']['ressource_id']).then(function (oNewResult) {
                                                scope['gridOptions']['data'] = oNewResult;
                                            });
                                        });
                                        // Message ok
                                        $translate('LIST_DELETE_OK').then(function (translation) {
                                            $.notify(translation, 'success');
                                        });
                                    });
                                }
                            });
                        });
                    } else {
                        $translate('LIST_NO_ELEMENT_SELECTED').then(function (translation) {
                            $.notify(translation, 'warning');
                        });
                    }
                };

                /**
                 * Fonction qui affiche le formulaire de filtrage
                 */
                scope['showFilterFormModal'] = function () {

                    if (formContainer.attr('id') === 'studio_form_reader') {
                        $translate('NO_IN_STUDIO').then(function (translation) {
                            $.notify(translation, 'error');
                        });
                        return 0;
                    }

                    var oFilterformScope = oSubformScope;
                    var sFilterformDefinitionName = 'search';
                    var oFilterformDefinition = scope['oSubformDefinition'];
                    var oFilterformValues = {
                        'search': oSearchValues
                    };

                    // Grise le champ contenant la valeur du parent
                    if (bIsIntersected) {
                        oFilterformDefinition = formReaderService['disableFormElement'](oFilterformDefinition, sFilterAttr, sFilterformDefinitionName);
                    }

                    // Nom du formulaire
                    oFilterformDefinition[sFilterformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                    // Événement
                    oFilterformDefinition[sFilterformDefinitionName]['event'] = function (oFormValuesResulted) {

                        envSrvc["oFormValues"] = oFormValuesResulted;
                        envSrvc["oFormDefinition"] = oFilterformDefinition;
                        envSrvc["sFormDefinitionName"] = sFilterformDefinitionName;

                        var oValues = formSrvc['getFormData'](sFilterformDefinitionName, true);
                        var sFilter = formReaderService['parseFilter'](oValues);

                        // Ferme la modale
                        $('#' + sModalId).modal('hide');

                        // Rafraichit la grille
                        formReaderService['getSectionRessourceData'](scope['oSection']['ressource_id'], sFilter).then(function (oNewResult) {
                            scope['gridOptions']['data'] = oNewResult;
                        });

                        // Message ok
                        $translate('LIST_SEARCH_OK').then(function (translation) {
                            $.notify(translation, 'success');
                        });
                    };

                    // Titre etc.. de la modale
                    oMainScope.$applyAsync(function () {
                        oMainScope['grid_subform_title'] = scope['oRessourceTab']['name'];
                        oMainScope['grid_subform_definition_name'] = sFilterformDefinitionName;
                    });

                    oFilterformScope['loadSubForm']({
                        'sFormDefinitionName': sFilterformDefinitionName,
                        'oFormDefinition': oFilterformDefinition,
                        'oFormValues': oFilterformValues,
                        'oProperties': scope['oProperties']
                    });

                    // Affiche la modale
                    $('#' + sModalId).modal('show');

                };

                formReaderService['getSectionDef'](sSection).then(function (oSection) {
                    scope['oSection'] = oSection;

                    formReaderService['getSectionRessourceTab'](scope['oSection']['ressource_id']).then(function (oRessourceTab) {
                        scope['oRessourceTab'] = oRessourceTab;

                        formReaderService['getSectionRessourceData'](scope['oSection']['ressource_id']).then(function (aRessourceData) {
                            scope['aRessourceData'] = aRessourceData;

                            formReaderService['getSectionForm'](scope['oSection'], true).then(function (oSubformDefinition) {
                                scope['oSubformDefinition'] = oSubformDefinition;

                                var aColumns, aActions, oTab;

                                // ressource
                                var sRessource = scope['oRessourceTab']['ressource_id'].substr(scope['oRessourceTab']['ressource_id'].lastIndexOf('/') + 1);

                                for (var i = 0; i < scope['oRessourceTab'][sRessource].length; i++) {
                                    if (goog.isDefAndNotNull(scope['oRessourceTab'][sRessource][i]['columns'])) {
                                        aColumns = scope['oRessourceTab'][sRessource][i]['columns'];
                                    }
                                    if (goog.isDefAndNotNull(scope['oRessourceTab'][sRessource][i]['actions'])) {
                                        aActions = scope['oRessourceTab'][sRessource][i]['actions'];
                                    }
                                    if (goog.isDefAndNotNull(scope['oRessourceTab'][sRessource][i]['tabs'])) {
                                        oTab = scope['oRessourceTab'][sRessource][i]['tabs'][0];
                                    }
                                }

                                // Set scope.sIdField
                                scope['sIdField'] = angular.copy(aColumns[0]['name']);

                                // Colonnes du tableau
                                if (oTab['show_column'] === 'showSectionForm') {
                                    scope['gridApi']['grid']['appScope']['show_column'] = 'show';
                                }
                                if (oTab['edit_column'] === 'editSectionForm') {
                                    scope['gridApi']['grid']['appScope']['edit_column'] = 'edit';
                                }
                                scope['gridOptions']['columnDefs'] = [{
                                        "name": "",
                                        "field": "actions",
                                        //"cellClass":"workspace-list-action",
                                        "cellTemplate": "<app-ui-grid-action></app-ui-grid-action>",
                                        "width": 60,
                                        "enableSorting": false,
                                        "enableColumnMoving": false,
                                        "enableColumnResizing": false
                                    }];
                                if (goog.isDefAndNotNull(aColumns)) {
                                    goog.array.extend(scope['gridOptions']['columnDefs'], aColumns);
                                }

                                // Contenu du tableau
                                scope['gridOptions']['data'] = angular.copy(scope['aRessourceData']);

                                // Boutons ajout/supprimer
                                for (var i = 0; i < aActions.length; i++) {
                                    if (aActions[i]['event'] === 'AddSectionForm') {
                                        scope['haveInsertRights'] = true;
                                    }
                                    if (aActions[i]['event'] === 'DeleteSelection') {
                                        scope['haveDeleteRights'] = true;
                                    }
                                }

                                // Événement edit
                                scope['gridApi']['grid']['appScope']['executeActionButtonEvent'] = function (oRow, sEvent) {

                                    if (formContainer.attr('id') === 'studio_form_reader') {
                                        $translate('NO_IN_STUDIO').then(function (translation) {
                                            $.notify(translation, 'error');
                                        });
                                        return 0;
                                    }

                                    var sSubformDefinitionName = sEvent === 'edit' ? 'update' : sEvent === 'show' ? 'display' : 'display';
                                    var oSubformValues = {};

                                    // Valeurs du formulaire
                                    oSubformValues[sSubformDefinitionName] = angular.copy(oRow['entity']);

                                    // Id du formulaire
                                    scope['oSubformDefinition'][sSubformDefinitionName]['name'] = 'formreader_' + scope['sFormUniqueName'] + '_grid_subform_form';

                                    // Evènement submit
                                    if (sSubformDefinitionName === 'update') {
                                        scope['oSubformDefinition']['update']['event'] = function (oFormValuesResulted) {
                                            formReaderService['updateSectionElement'](scope['oSection']['ressource_id'], scope['sIdField'], scope['oSubformDefinition'], sSubformDefinitionName, oFormValuesResulted).then(function () {
                                                // Ferme la modale
                                                $('#' + sModalId).modal('hide');
                                                // Rafraichit la grille
                                                setTimeout(function () {
                                                    formReaderService['getSectionRessourceData'](scope['oSection']['ressource_id']).then(function (oNewResult) {
                                                        scope['gridOptions']['data'] = oNewResult;
                                                    });
                                                });
                                                // Message ok
                                                $translate('LIST_EDIT_OK').then(function (translation) {
                                                    $.notify(translation, 'success');
                                                });
                                            });
                                        };
                                    }

                                    // Grise le champ contenant la valeur du parent
                                    if (bIsIntersected) {
                                        scope['oSubformDefinition'] = formReaderService['disableFormElement'](scope['oSubformDefinition'], sFilterAttr, sSubformDefinitionName);
                                    }

                                    if (!goog.isDefAndNotNull(oSubformScope)) {
                                        console.error('oSubformScope undefined');
                                        return 0;
                                    }
                                    if (!goog.isDefAndNotNull(scope['oSubformDefinition'])) {
                                        console.error('scope.oSubformDefinition undefined');
                                        return 0;
                                    }
                                    if (!goog.isDefAndNotNull(sSubformDefinitionName)) {
                                        console.error('sSubformDefinitionName undefined');
                                        return 0;
                                    }
                                    if (!goog.isDefAndNotNull(oSubformValues)) {
                                        console.error('oSubformValues undefined');
                                        return 0;
                                    }

                                    // Titre etc.. de la modale
                                    oMainScope.$applyAsync(function () {
                                        oMainScope['grid_subform_title'] = scope['oRessourceTab']['name'];
                                        oMainScope['grid_subform_definition_name'] = sSubformDefinitionName;
                                    });

                                    formReaderService['showModalSubform'](sModalId, oSubformScope, scope['oSubformDefinition'], sSubformDefinitionName, oSubformValues);
                                };

                                scope['gridApi']['grid']['refresh']();
                            });
                        });
                    });
                });
            };

            /**
             * Initializes all the grids
             */
            scope['initSubformGrid'] = function () {
                $log.log("initSubformGrid");
                if (scope['field']['type'] === 'bo_grid') {
                    scope['initBoSubformGrid']();
                } else if (scope['field']['type'] === 'section_grid') {
                    scope['initSectionSubformGrid']();
                }
                setTimeout(function () {
                    if (goog.isDefAndNotNull(scope['gridOptions'])) {
                        if (goog.isDefAndNotNull(scope['gridOptions']['gridApi'])) {
                            if (goog.isDefAndNotNull(scope['gridOptions']['gridApi']['core'])) {
                                if (goog.isDefAndNotNull(scope['gridOptions']['gridApi']['core']['handleWindowResize'])) {
                                    scope['gridOptions']['gridApi']['core']['handleWindowResize']();
                                    setTimeout(function () {
                                        scope['gridOptions']['gridApi']['core']['handleWindowResize']();
                                    }, 500);
                                    setTimeout(function () {
                                        scope['gridOptions']['gridApi']['core']['handleWindowResize']();
                                    }, 1000);
                                    setTimeout(function () {
                                        scope['gridOptions']['gridApi']['core']['handleWindowResize']();
                                    }, 2000);
                                }
                            }
                        }
                    }
                });
            };

            if (goog.isDefAndNotNull(oMainScope['initSubformGridEvent'])) {
                oMainScope['initSubformGridEvent_' + scope['field']['name']]();
                oMainScope['initSubformGridEvent_' + scope['field']['name']] = null;
            }

            if (oMainScope['bFormDefinitionInfosExtracted']) {
                scope['initSubformGrid']();
            } else {
                oMainScope['initSubformGridEvent_' + scope['field']['name']] = oMainScope.$on('extractFormDefinitionInfos', function () {
                    scope['initSubformGrid']();
                });
            }
        }
    };
};
formReader.module.directive("appSubformGrid", formReader.appSubformGridDrtv);

/**
 * appSubform directive.
 * Affiche un sous formulaire,
 * le formualire d'être chargé avec loadSubForm
 * @param {service} $compile
 * @param {service} $log
 * @ngInject
 */
formReader.appSubformDrtv = function ($compile, $log) {
    return {
        restrict: 'A',
        scope: true,
        link: function (scope, element, attrs) {
            $log.log("formReader.appSubformDrtv.link");

            var content;
            var template = '<div app-form-reader app-properties="oProperties"></div>';

            scope['oSubformValues'] = null;

            scope['loadSubForm'] = function (opt_options) {
                $log.log("formReader.loadSubForm");

                if (!goog.isDefAndNotNull(opt_options['sFormDefinitionName'])) {
                    console.error("opt_options['sFormDefinitionName'] undefined");
                    return 0;
                }
                if (!goog.isDefAndNotNull(opt_options['oFormDefinition'])) {
                    console.error("opt_options['oFormDefinition'] undefined");
                    return 0;
                }
                if (!goog.isDefAndNotNull(opt_options['oFormValues'])) {
                    console.error("opt_options['oFormValues'] undefined");
                    return 0;
                }
                if (!goog.isDefAndNotNull(opt_options['oProperties'])) {
                    console.error("opt_options['oProperties'] undefined");
                    return 0;
                }

                scope['oSubformValues'] = opt_options['oFormValues'];

                scope.$applyAsync(function () {
                    scope['oProperties'] = opt_options['oProperties'];

                    // compile the provided template against the current scope
                    content = $compile(template)(scope);

                    // add the template content
                    element.html("");
                    element.append(content);

                    setTimeout(function () {
                        scope['oFormReaderScope'] = angular.element($(element).find('[app-form-reader]').children()).scope();
                        scope['oFormReaderScope']['ctrl']['setDefinitionName'](opt_options['sFormDefinitionName']);
                        scope['oFormReaderScope']['ctrl']['setFormValues'](scope['oSubformValues']);
                        scope['oFormReaderScope']['ctrl']['setFormDefinition'](opt_options['oFormDefinition']);
                        scope['oFormReaderScope']['ctrl']['loadForm']();
                    });
                });
            };

            scope['setFormValues'] = function (oValues) {
                $log.log("formReader.setFormValues");

                scope['oSubformValues'] = oValues;
                if (goog.isDefAndNotNull(scope['oFormReaderScope'])) {
                    if (goog.isDefAndNotNull(scope['oFormReaderScope']['ctrl'])) {
                        scope['oFormReaderScope']['ctrl']['setFormValues'](scope['oSubformValues']);
                        scope['oFormReaderScope']['ctrl']['loadForm']();
                    }
                }
            };
        }
    };
};
formReader.module.directive("appSubform", formReader.appSubformDrtv);
