/*! =========================================================
 * bootstrap-slider.js
 *
 * Maintainers:
 *		Kyle Kemp
 *			- Twitter: @seiyria
 *			- Github:  seiyria
 *		Rohit Kalkur
 *			- Twitter: @Rovolutionary
 *			- Github:  rovolution
 *
 * =========================================================
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ========================================================= */
(function(n,t){if(typeof define=="function"&&define.amd)define(["jquery"],t);else if(typeof module=="object"&&module.exports){var i;try{i=require("jquery")}catch(r){i=null}module.exports=t(i)}else n.Slider=t(n.jQuery)})(this,function(n){var t;return function(n){"use strict";function i(){}function r(n){function u(t){t.prototype.option||(t.prototype.option=function(t){n.isPlainObject(t)&&(this.options=n.extend(!0,this.options,t))})}function f(i,u){n.fn[i]=function(f){var c,s,l,a,e,h,o;if(typeof f=="string"){for(c=t.call(arguments,1),s=0,l=this.length;s<l;s++){if(a=this[s],e=n.data(a,i),!e){r("cannot call methods on "+i+" prior to initialization; attempted to call '"+f+"'");continue}if(!n.isFunction(e[f])||f.charAt(0)==="_"){r("no such method '"+f+"' for "+i+" instance");continue}if(h=e[f].apply(e,c),h!==undefined&&h!==e)return h}return this}return o=this.map(function(){var t=n.data(this,i);return t?(t.option(f),t._init()):(t=new u(this,f),n.data(this,i,t)),n(this)}),!o||o.length>1?o:o[0]}}if(n){var r=typeof console=="undefined"?i:function(n){console.error(n)};return n.bridget=function(n,t){u(t);f(n,t)},n.bridget}}var t=Array.prototype.slice;r(n)}(n),function(n){function u(t,i){function rt(n,t){var r="data-slider-"+t.replace(/_/g,"-"),i=n.getAttribute(r);try{return JSON.parse(i)}catch(u){return i}}var g,u,h,s,o,w,b,d,l,a,v,tt,it;for(this._state={value:null,enabled:null,offset:null,size:null,percentage:null,inDrag:!1,over:!1},typeof t=="string"?this.element=document.querySelector(t):t instanceof HTMLElement&&(this.element=t),i=i?i:{},g=Object.keys(this.defaultOptions),u=0;u<g.length;u++)h=g[u],s=i[h],s=typeof s!="undefined"?s:rt(this.element,h),s=s!==null?s:this.defaultOptions[h],this.options||(this.options={}),this.options[h]=s;this.options.orientation==="vertical"&&(this.options.tooltip_position==="top"||this.options.tooltip_position==="bottom")?this.options.tooltip_position="right":this.options.orientation==="horizontal"&&(this.options.tooltip_position==="left"||this.options.tooltip_position==="right")&&(this.options.tooltip_position="top");var ut=this.element.style.width,nt=!1,ft=this.element.parentNode,c,y,p,f,e;if(this.sliderElem)nt=!0;else{if(this.sliderElem=document.createElement("div"),this.sliderElem.className="slider",o=document.createElement("div"),o.className="slider-track",y=document.createElement("div"),y.className="slider-track-low",c=document.createElement("div"),c.className="slider-selection",p=document.createElement("div"),p.className="slider-track-high",f=document.createElement("div"),f.className="slider-handle min-slider-handle",f.setAttribute("role","slider"),f.setAttribute("aria-valuemin",this.options.min),f.setAttribute("aria-valuemax",this.options.max),e=document.createElement("div"),e.className="slider-handle max-slider-handle",e.setAttribute("role","slider"),e.setAttribute("aria-valuemin",this.options.min),e.setAttribute("aria-valuemax",this.options.max),o.appendChild(y),o.appendChild(c),o.appendChild(p),w=Array.isArray(this.options.labelledby),w&&this.options.labelledby[0]&&f.setAttribute("aria-labelledby",this.options.labelledby[0]),w&&this.options.labelledby[1]&&e.setAttribute("aria-labelledby",this.options.labelledby[1]),!w&&this.options.labelledby&&(f.setAttribute("aria-labelledby",this.options.labelledby),e.setAttribute("aria-labelledby",this.options.labelledby)),this.ticks=[],Array.isArray(this.options.ticks)&&this.options.ticks.length>0){for(u=0;u<this.options.ticks.length;u++)b=document.createElement("div"),b.className="slider-tick",this.ticks.push(b),o.appendChild(b);c.className+=" tick-slider-selection"}if(o.appendChild(f),o.appendChild(e),this.tickLabels=[],Array.isArray(this.options.ticks_labels)&&this.options.ticks_labels.length>0)for(this.tickLabelContainer=document.createElement("div"),this.tickLabelContainer.className="slider-tick-label-container",u=0;u<this.options.ticks_labels.length;u++){var k=document.createElement("div"),et=this.options.ticks_positions.length===0,ot=this.options.reversed&&et?this.options.ticks_labels.length-(u+1):u;k.className="slider-tick-label";k.innerHTML=this.options.ticks_labels[ot];this.tickLabels.push(k);this.tickLabelContainer.appendChild(k)}d=function(n){var i=document.createElement("div"),t;i.className="tooltip-arrow";t=document.createElement("div");t.className="tooltip-inner";n.appendChild(i);n.appendChild(t)};l=document.createElement("div");l.className="tooltip tooltip-main";l.setAttribute("role","presentation");d(l);a=document.createElement("div");a.className="tooltip tooltip-min";a.setAttribute("role","presentation");d(a);v=document.createElement("div");v.className="tooltip tooltip-max";v.setAttribute("role","presentation");d(v);this.sliderElem.appendChild(o);this.sliderElem.appendChild(l);this.sliderElem.appendChild(a);this.sliderElem.appendChild(v);this.tickLabelContainer&&this.sliderElem.appendChild(this.tickLabelContainer);ft.insertBefore(this.sliderElem,this.element);this.element.style.display="none"}if(n&&(this.$element=n(this.element),this.$sliderElem=n(this.sliderElem)),this.eventToCallbackMap={},this.sliderElem.id=this.options.id,this.touchCapable="ontouchstart"in window||window.DocumentTouch&&document instanceof window.DocumentTouch,this.tooltip=this.sliderElem.querySelector(".tooltip-main"),this.tooltipInner=this.tooltip.querySelector(".tooltip-inner"),this.tooltip_min=this.sliderElem.querySelector(".tooltip-min"),this.tooltipInner_min=this.tooltip_min.querySelector(".tooltip-inner"),this.tooltip_max=this.sliderElem.querySelector(".tooltip-max"),this.tooltipInner_max=this.tooltip_max.querySelector(".tooltip-inner"),r[this.options.scale]&&(this.options.scale=r[this.options.scale]),nt===!0&&(this._removeClass(this.sliderElem,"slider-horizontal"),this._removeClass(this.sliderElem,"slider-vertical"),this._removeClass(this.tooltip,"hide"),this._removeClass(this.tooltip_min,"hide"),this._removeClass(this.tooltip_max,"hide"),["left","top","width","height"].forEach(function(n){this._removeProperty(this.trackLow,n);this._removeProperty(this.trackSelection,n);this._removeProperty(this.trackHigh,n)},this),[this.handle1,this.handle2].forEach(function(n){this._removeProperty(n,"left");this._removeProperty(n,"top")},this),[this.tooltip,this.tooltip_min,this.tooltip_max].forEach(function(n){this._removeProperty(n,"left");this._removeProperty(n,"top");this._removeProperty(n,"margin-left");this._removeProperty(n,"margin-top");this._removeClass(n,"right");this._removeClass(n,"top")},this)),this.options.orientation==="vertical"?(this._addClass(this.sliderElem,"slider-vertical"),this.stylePos="top",this.mousePos="pageY",this.sizePos="offsetHeight"):(this._addClass(this.sliderElem,"slider-horizontal"),this.sliderElem.style.width=ut,this.options.orientation="horizontal",this.stylePos="left",this.mousePos="pageX",this.sizePos="offsetWidth"),this._setTooltipPosition(),Array.isArray(this.options.ticks)&&this.options.ticks.length>0&&(this.options.max=Math.max.apply(Math,this.options.ticks),this.options.min=Math.min.apply(Math,this.options.ticks)),Array.isArray(this.options.value)?(this.options.range=!0,this._state.value=this.options.value):this._state.value=this.options.range?[this.options.value,this.options.max]:this.options.value,this.trackLow=y||this.trackLow,this.trackSelection=c||this.trackSelection,this.trackHigh=p||this.trackHigh,this.options.selection==="none"&&(this._addClass(this.trackLow,"hide"),this._addClass(this.trackSelection,"hide"),this._addClass(this.trackHigh,"hide")),this.handle1=f||this.handle1,this.handle2=e||this.handle2,nt===!0)for(this._removeClass(this.handle1,"round triangle"),this._removeClass(this.handle2,"round triangle hide"),u=0;u<this.ticks.length;u++)this._removeClass(this.ticks[u],"round triangle hide");if(tt=["round","triangle","custom"],it=tt.indexOf(this.options.handle)!==-1,it)for(this._addClass(this.handle1,this.options.handle),this._addClass(this.handle2,this.options.handle),u=0;u<this.ticks.length;u++)this._addClass(this.ticks[u],this.options.handle);this._state.offset=this._offset(this.sliderElem);this._state.size=this.sliderElem[this.sizePos];this.setValue(this._state.value);this.handle1Keydown=this._keydown.bind(this,0);this.handle1.addEventListener("keydown",this.handle1Keydown,!1);this.handle2Keydown=this._keydown.bind(this,1);this.handle2.addEventListener("keydown",this.handle2Keydown,!1);this.mousedown=this._mousedown.bind(this);this.touchCapable&&this.sliderElem.addEventListener("touchstart",this.mousedown,!1);this.sliderElem.addEventListener("mousedown",this.mousedown,!1);this.options.tooltip==="hide"?(this._addClass(this.tooltip,"hide"),this._addClass(this.tooltip_min,"hide"),this._addClass(this.tooltip_max,"hide")):this.options.tooltip==="always"?(this._showTooltip(),this._alwaysShowTooltip=!0):(this.showTooltip=this._showTooltip.bind(this),this.hideTooltip=this._hideTooltip.bind(this),this.sliderElem.addEventListener("mouseenter",this.showTooltip,!1),this.sliderElem.addEventListener("mouseleave",this.hideTooltip,!1),this.handle1.addEventListener("focus",this.showTooltip,!1),this.handle1.addEventListener("blur",this.hideTooltip,!1),this.handle2.addEventListener("focus",this.showTooltip,!1),this.handle2.addEventListener("blur",this.hideTooltip,!1));this.options.enabled?this.enable():this.disable()}var i={formatInvalidInputErrorMsg:function(n){return"Invalid input value '"+n+"' passed in"},callingContextNotSliderInstance:"Calling context element does not have instance of Slider bound to it. Check your code to make sure the JQuery object returned from the call to the slider() initializer is calling the method"},r={linear:{toValue:function(n){var e=n/100*(this.options.max-this.options.min),o=!0,r,s,u,f,t,h,c,i;if(this.options.ticks_positions.length>0){for(f=0,t=1;t<this.options.ticks_positions.length;t++)if(n<=this.options.ticks_positions[t]){r=this.options.ticks[t-1];u=this.options.ticks_positions[t-1];s=this.options.ticks[t];f=this.options.ticks_positions[t];break}h=(n-u)/(f-u);e=r+h*(s-r);o=!1}return c=o?this.options.min:0,i=c+Math.round(e/this.options.step)*this.options.step,i<this.options.min?this.options.min:i>this.options.max?this.options.max:i},toPercentage:function(n){var i,f,r,u,t,e;if(this.options.max===this.options.min)return 0;if(this.options.ticks_positions.length>0){for(u=0,t=0;t<this.options.ticks.length;t++)if(n<=this.options.ticks[t]){i=t>0?this.options.ticks[t-1]:0;r=t>0?this.options.ticks_positions[t-1]:0;f=this.options.ticks[t];u=this.options.ticks_positions[t];break}if(t>0)return e=(n-i)/(f-i),r+e*(u-r)}return 100*(n-this.options.min)/(this.options.max-this.options.min)}},logarithmic:{toValue:function(n){var i=this.options.min===0?0:Math.log(this.options.min),r=Math.log(this.options.max),t=Math.exp(i+(r-i)*n/100);return t=this.options.min+Math.round((t-this.options.min)/this.options.step)*this.options.step,t<this.options.min?this.options.min:t>this.options.max?this.options.max:t},toPercentage:function(n){if(this.options.max===this.options.min)return 0;var i=Math.log(this.options.max),t=this.options.min===0?0:Math.log(this.options.min),r=n===0?0:Math.log(n);return 100*(r-t)/(i-t)}}},f;t=function(n,t){return u.call(this,n,t),this};t.prototype={_init:function(){},constructor:t,defaultOptions:{id:"",min:0,max:10,step:1,precision:0,orientation:"horizontal",value:5,range:!1,selection:"before",tooltip:"show",tooltip_split:!1,handle:"round",reversed:!1,enabled:!0,formatter:function(n){return Array.isArray(n)?n[0]+" : "+n[1]:n},natural_arrow_keys:!1,ticks:[],ticks_positions:[],ticks_labels:[],ticks_snap_bounds:0,scale:"linear",focus:!1,tooltip_position:null,labelledby:null},getElement:function(){return this.sliderElem},getValue:function(){return this.options.range?this._state.value:this._state.value[0]},setValue:function(n,t,i){var f,u,r;return n||(n=0),f=this.getValue(),this._state.value=this._validateInputValue(n),u=this._applyPrecision.bind(this),this.options.range?(this._state.value[0]=u(this._state.value[0]),this._state.value[1]=u(this._state.value[1]),this._state.value[0]=Math.max(this.options.min,Math.min(this.options.max,this._state.value[0])),this._state.value[1]=Math.max(this.options.min,Math.min(this.options.max,this._state.value[1]))):(this._state.value=u(this._state.value),this._state.value=[Math.max(this.options.min,Math.min(this.options.max,this._state.value))],this._addClass(this.handle2,"hide"),this._state.value[1]=this.options.selection==="after"?this.options.max:this.options.min),this._state.percentage=this.options.max>this.options.min?[this._toPercentage(this._state.value[0]),this._toPercentage(this._state.value[1]),this.options.step*100/(this.options.max-this.options.min)]:[0,0,100],this._layout(),r=this.options.range?this._state.value:this._state.value[0],t===!0&&this._trigger("slide",r),f!==r&&i===!0&&this._trigger("change",{oldValue:f,newValue:r}),this._setDataVal(r),this},destroy:function(){this._removeSliderEventHandlers();this.sliderElem.parentNode.removeChild(this.sliderElem);this.element.style.display="";this._cleanUpEventCallbacksMap();this.element.removeAttribute("data");n&&(this._unbindJQueryEventHandlers(),this.$element.removeData("slider"))},disable:function(){return this._state.enabled=!1,this.handle1.removeAttribute("tabindex"),this.handle2.removeAttribute("tabindex"),this._addClass(this.sliderElem,"slider-disabled"),this._trigger("slideDisabled"),this},enable:function(){return this._state.enabled=!0,this.handle1.setAttribute("tabindex",0),this.handle2.setAttribute("tabindex",0),this._removeClass(this.sliderElem,"slider-disabled"),this._trigger("slideEnabled"),this},toggle:function(){return this._state.enabled?this.disable():this.enable(),this},isEnabled:function(){return this._state.enabled},on:function(n,t){return this._bindNonQueryEventHandler(n,t),this},off:function(t,i){n?(this.$element.off(t,i),this.$sliderElem.off(t,i)):this._unbindNonQueryEventHandler(t,i)},getAttribute:function(n){return n?this.options[n]:this.options},setAttribute:function(n,t){return this.options[n]=t,this},refresh:function(){return this._removeSliderEventHandlers(),u.call(this,this.element,this.options),n&&n.data(this.element,"slider",this),this},relayout:function(){return this._layout(),this},_removeSliderEventHandlers:function(){this.handle1.removeEventListener("keydown",this.handle1Keydown,!1);this.handle2.removeEventListener("keydown",this.handle2Keydown,!1);this.showTooltip&&(this.handle1.removeEventListener("focus",this.showTooltip,!1),this.handle2.removeEventListener("focus",this.showTooltip,!1));this.hideTooltip&&(this.handle1.removeEventListener("blur",this.hideTooltip,!1),this.handle2.removeEventListener("blur",this.hideTooltip,!1));this.showTooltip&&this.sliderElem.removeEventListener("mouseenter",this.showTooltip,!1);this.hideTooltip&&this.sliderElem.removeEventListener("mouseleave",this.hideTooltip,!1);this.sliderElem.removeEventListener("touchstart",this.mousedown,!1);this.sliderElem.removeEventListener("mousedown",this.mousedown,!1)},_bindNonQueryEventHandler:function(n,t){this.eventToCallbackMap[n]===undefined&&(this.eventToCallbackMap[n]=[]);this.eventToCallbackMap[n].push(t)},_unbindNonQueryEventHandler:function(n,t){var r=this.eventToCallbackMap[n],i;if(r!==undefined)for(i=0;i<r.length;i++)if(r[i]===t){r.splice(i,1);break}},_cleanUpEventCallbacksMap:function(){for(var i,t=Object.keys(this.eventToCallbackMap),n=0;n<t.length;n++)i=t[n],this.eventToCallbackMap[i]=null},_showTooltip:function(){this.options.tooltip_split===!1?(this._addClass(this.tooltip,"in"),this.tooltip_min.style.display="none",this.tooltip_max.style.display="none"):(this._addClass(this.tooltip_min,"in"),this._addClass(this.tooltip_max,"in"),this.tooltip.style.display="none");this._state.over=!0},_hideTooltip:function(){this._state.inDrag===!1&&this.alwaysShowTooltip!==!0&&(this._removeClass(this.tooltip,"in"),this._removeClass(this.tooltip_min,"in"),this._removeClass(this.tooltip_max,"in"));this._state.over=!1},_layout:function(){var n,r,t,i,u,o,s,h,c;if(n=this.options.reversed?[100-this._state.percentage[0],this.options.range?100-this._state.percentage[1]:this._state.percentage[1]]:[this._state.percentage[0],this._state.percentage[1]],this.handle1.style[this.stylePos]=n[0]+"%",this.handle1.setAttribute("aria-valuenow",this._state.value[0]),this.handle2.style[this.stylePos]=n[1]+"%",this.handle2.setAttribute("aria-valuenow",this._state.value[1]),Array.isArray(this.options.ticks)&&this.options.ticks.length>0){var l=this.options.orientation==="vertical"?"height":"width",e=this.options.orientation==="vertical"?"marginTop":"marginLeft",f=this._state.size/(this.options.ticks.length-1);if(this.tickLabelContainer){if(r=0,this.options.ticks_positions.length===0)this.options.orientation!=="vertical"&&(this.tickLabelContainer.style[e]=-f/2+"px"),r=this.tickLabelContainer.offsetHeight;else for(t=0;t<this.tickLabelContainer.childNodes.length;t++)this.tickLabelContainer.childNodes[t].offsetHeight>r&&(r=this.tickLabelContainer.childNodes[t].offsetHeight);this.options.orientation==="horizontal"&&(this.sliderElem.style.marginBottom=r+"px")}for(t=0;t<this.options.ticks.length;t++)i=this.options.ticks_positions[t]||this._toPercentage(this.options.ticks[t]),this.options.reversed&&(i=100-i),this.ticks[t].style[this.stylePos]=i+"%",this._removeClass(this.ticks[t],"in-selection"),this.options.range?i>=n[0]&&i<=n[1]&&this._addClass(this.ticks[t],"in-selection"):this.options.selection==="after"&&i>=n[0]?this._addClass(this.ticks[t],"in-selection"):this.options.selection==="before"&&i<=n[0]&&this._addClass(this.ticks[t],"in-selection"),this.tickLabels[t]&&(this.tickLabels[t].style[l]=f+"px",this.options.orientation!=="vertical"&&this.options.ticks_positions[t]!==undefined?(this.tickLabels[t].style.position="absolute",this.tickLabels[t].style[this.stylePos]=i+"%",this.tickLabels[t].style[e]=-f/2+"px"):this.options.orientation==="vertical"&&(this.tickLabels[t].style.marginLeft=this.sliderElem.offsetWidth+"px",this.tickLabelContainer.style.marginTop=this.sliderElem.offsetWidth/-2+"px"))}this.options.range?(u=this.options.formatter(this._state.value),this._setText(this.tooltipInner,u),this.tooltip.style[this.stylePos]=(n[1]+n[0])/2+"%",this.options.orientation==="vertical"?this._css(this.tooltip,"margin-top",-this.tooltip.offsetHeight/2+"px"):this._css(this.tooltip,"margin-left",-this.tooltip.offsetWidth/2+"px"),this.options.orientation==="vertical"?this._css(this.tooltip,"margin-top",-this.tooltip.offsetHeight/2+"px"):this._css(this.tooltip,"margin-left",-this.tooltip.offsetWidth/2+"px"),o=this.options.formatter(this._state.value[0]),this._setText(this.tooltipInner_min,o),s=this.options.formatter(this._state.value[1]),this._setText(this.tooltipInner_max,s),this.tooltip_min.style[this.stylePos]=n[0]+"%",this.options.orientation==="vertical"?this._css(this.tooltip_min,"margin-top",-this.tooltip_min.offsetHeight/2+"px"):this._css(this.tooltip_min,"margin-left",-this.tooltip_min.offsetWidth/2+"px"),this.tooltip_max.style[this.stylePos]=n[1]+"%",this.options.orientation==="vertical"?this._css(this.tooltip_max,"margin-top",-this.tooltip_max.offsetHeight/2+"px"):this._css(this.tooltip_max,"margin-left",-this.tooltip_max.offsetWidth/2+"px")):(u=this.options.formatter(this._state.value[0]),this._setText(this.tooltipInner,u),this.tooltip.style[this.stylePos]=n[0]+"%",this.options.orientation==="vertical"?this._css(this.tooltip,"margin-top",-this.tooltip.offsetHeight/2+"px"):this._css(this.tooltip,"margin-left",-this.tooltip.offsetWidth/2+"px"));this.options.orientation==="vertical"?(this.trackLow.style.top="0",this.trackLow.style.height=Math.min(n[0],n[1])+"%",this.trackSelection.style.top=Math.min(n[0],n[1])+"%",this.trackSelection.style.height=Math.abs(n[0]-n[1])+"%",this.trackHigh.style.bottom="0",this.trackHigh.style.height=100-Math.min(n[0],n[1])-Math.abs(n[0]-n[1])+"%"):(this.trackLow.style.left="0",this.trackLow.style.width=Math.min(n[0],n[1])+"%",this.trackSelection.style.left=Math.min(n[0],n[1])+"%",this.trackSelection.style.width=Math.abs(n[0]-n[1])+"%",this.trackHigh.style.right="0",this.trackHigh.style.width=100-Math.min(n[0],n[1])-Math.abs(n[0]-n[1])+"%",h=this.tooltip_min.getBoundingClientRect(),c=this.tooltip_max.getBoundingClientRect(),h.right>c.left?(this._removeClass(this.tooltip_max,"top"),this._addClass(this.tooltip_max,"bottom"),this.tooltip_max.style.top="18px"):(this._removeClass(this.tooltip_max,"bottom"),this._addClass(this.tooltip_max,"top"),this.tooltip_max.style.top=this.tooltip_min.style.top))},_removeProperty:function(n,t){n.style.removeProperty?n.style.removeProperty(t):n.style.removeAttribute(t)},_mousedown:function(n){var t,r,u,i;return this._state.enabled?(this._state.offset=this._offset(this.sliderElem),this._state.size=this.sliderElem[this.sizePos],t=this._getPercentage(n),this.options.range?(r=Math.abs(this._state.percentage[0]-t),u=Math.abs(this._state.percentage[1]-t),this._state.dragged=r<u?0:1):this._state.dragged=0,this._state.percentage[this._state.dragged]=t,this._layout(),this.touchCapable&&(document.removeEventListener("touchmove",this.mousemove,!1),document.removeEventListener("touchend",this.mouseup,!1)),this.mousemove&&document.removeEventListener("mousemove",this.mousemove,!1),this.mouseup&&document.removeEventListener("mouseup",this.mouseup,!1),this.mousemove=this._mousemove.bind(this),this.mouseup=this._mouseup.bind(this),this.touchCapable&&(document.addEventListener("touchmove",this.mousemove,!1),document.addEventListener("touchend",this.mouseup,!1)),document.addEventListener("mousemove",this.mousemove,!1),document.addEventListener("mouseup",this.mouseup,!1),this._state.inDrag=!0,i=this._calculateValue(),this._trigger("slideStart",i),this._setDataVal(i),this.setValue(i,!1,!0),this._pauseEvent(n),this.options.focus&&this._triggerFocusOnHandle(this._state.dragged),!0):!1},_triggerFocusOnHandle:function(n){n===0&&this.handle1.focus();n===1&&this.handle2.focus()},_keydown:function(n,t){var r,u,f,i;if(!this._state.enabled)return!1;switch(t.keyCode){case 37:case 40:r=-1;break;case 39:case 38:r=1}if(r)return this.options.natural_arrow_keys&&(u=this.options.orientation==="vertical"&&!this.options.reversed,f=this.options.orientation==="horizontal"&&this.options.reversed,(u||f)&&(r=-r)),i=this._state.value[n]+r*this.options.step,this.options.range&&(i=[n?this._state.value[0]:i,n?i:this._state.value[1]]),this._trigger("slideStart",i),this._setDataVal(i),this.setValue(i,!0,!0),this._setDataVal(i),this._trigger("slideStop",i),this._layout(),this._pauseEvent(t),!1},_pauseEvent:function(n){n.stopPropagation&&n.stopPropagation();n.preventDefault&&n.preventDefault();n.cancelBubble=!0;n.returnValue=!1},_mousemove:function(n){var t,i;return this._state.enabled?(t=this._getPercentage(n),this._adjustPercentageForRangeSliders(t),this._state.percentage[this._state.dragged]=t,this._layout(),i=this._calculateValue(!0),this.setValue(i,!0,!0),!1):!1},_adjustPercentageForRangeSliders:function(n){var t,i;this.options.range&&(t=this._getNumDigitsAfterDecimalPlace(n),t=t?t-1:0,i=this._applyToFixedAndParseFloat(n,t),this._state.dragged===0&&this._applyToFixedAndParseFloat(this._state.percentage[1],t)<i?(this._state.percentage[0]=this._state.percentage[1],this._state.dragged=1):this._state.dragged===1&&this._applyToFixedAndParseFloat(this._state.percentage[0],t)>i&&(this._state.percentage[1]=this._state.percentage[0],this._state.dragged=0))},_mouseup:function(){if(!this._state.enabled)return!1;this.touchCapable&&(document.removeEventListener("touchmove",this.mousemove,!1),document.removeEventListener("touchend",this.mouseup,!1));document.removeEventListener("mousemove",this.mousemove,!1);document.removeEventListener("mouseup",this.mouseup,!1);this._state.inDrag=!1;this._state.over===!1&&this._hideTooltip();var n=this._calculateValue(!0);return this._layout(),this._setDataVal(n),this._trigger("slideStop",n),!1},_calculateValue:function(n){var t,i,r,u;if(this.options.range?(t=[this.options.min,this.options.max],this._state.percentage[0]!==0&&(t[0]=this._toValue(this._state.percentage[0]),t[0]=this._applyPrecision(t[0])),this._state.percentage[1]!==100&&(t[1]=this._toValue(this._state.percentage[1]),t[1]=this._applyPrecision(t[1]))):(t=this._toValue(this._state.percentage[0]),t=parseFloat(t),t=this._applyPrecision(t)),n){for(i=[t,Infinity],r=0;r<this.options.ticks.length;r++)u=Math.abs(this.options.ticks[r]-t),u<=i[1]&&(i=[this.options.ticks[r],u]);if(i[1]<=this.options.ticks_snap_bounds)return i[0]}return t},_applyPrecision:function(n){var t=this.options.precision||this._getNumDigitsAfterDecimalPlace(this.options.step);return this._applyToFixedAndParseFloat(n,t)},_getNumDigitsAfterDecimalPlace:function(n){var t=(""+n).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);return t?Math.max(0,(t[1]?t[1].length:0)-(t[2]?+t[2]:0)):0},_applyToFixedAndParseFloat:function(n,t){var i=n.toFixed(t);return parseFloat(i)},_getPercentage:function(n){this.touchCapable&&(n.type==="touchstart"||n.type==="touchmove")&&(n=n.touches[0]);var i=n[this.mousePos],r=this._state.offset[this.stylePos],u=i-r,t=u/this._state.size*100;return t=Math.round(t/this._state.percentage[2])*this._state.percentage[2],this.options.reversed&&(t=100-t),Math.max(0,Math.min(100,t))},_validateInputValue:function(n){if(typeof n=="number")return n;if(Array.isArray(n))return this._validateArray(n),n;throw new Error(i.formatInvalidInputErrorMsg(n));},_validateArray:function(n){for(var r,t=0;t<n.length;t++)if(r=n[t],typeof r!="number")throw new Error(i.formatInvalidInputErrorMsg(r));},_setDataVal:function(n){this.element.setAttribute("data-value",n);this.element.setAttribute("value",n);this.element.value=n},_trigger:function(t,i){var r,u,f;if(i=i||i===0?i:undefined,r=this.eventToCallbackMap[t],r&&r.length)for(u=0;u<r.length;u++)f=r[u],f(i);n&&this._triggerJQueryEvent(t,i)},_triggerJQueryEvent:function(n,t){var i={type:n,value:t};this.$element.trigger(i);this.$sliderElem.trigger(i)},_unbindJQueryEventHandlers:function(){this.$element.off();this.$sliderElem.off()},_setText:function(n,t){typeof n.innerText!="undefined"?n.innerText=t:typeof n.textContent!="undefined"&&(n.textContent=t)},_removeClass:function(n,t){for(var f,e,u=t.split(" "),i=n.className,r=0;r<u.length;r++)f=u[r],e=new RegExp("(?:\\s|^)"+f+"(?:\\s|$)"),i=i.replace(e," ");n.className=i.trim()},_addClass:function(n,t){for(var u=t.split(" "),i=n.className,r=0;r<u.length;r++){var f=u[r],e=new RegExp("(?:\\s|^)"+f+"(?:\\s|$)"),o=e.test(i);o||(i+=" "+f)}n.className=i.trim()},_offsetLeft:function(n){return n.getBoundingClientRect().left},_offsetTop:function(n){for(var t=n.offsetTop;(n=n.offsetParent)&&!isNaN(n.offsetTop);)t+=n.offsetTop;return t},_offset:function(n){return{left:this._offsetLeft(n),top:this._offsetTop(n)}},_css:function(t,i,r){if(n)n.style(t,i,r);else{var u=i.replace(/^-ms-/,"ms-").replace(/-([\da-z])/gi,function(n,t){return t.toUpperCase()});t.style[u]=r}},_toValue:function(n){return this.options.scale.toValue.apply(this,[n])},_toPercentage:function(n){return this.options.scale.toPercentage.apply(this,[n])},_setTooltipPosition:function(){var n=[this.tooltip,this.tooltip_min,this.tooltip_max],t,i;this.options.orientation==="vertical"?(t=this.options.tooltip_position||"right",i=t==="left"?"right":"left",n.forEach(function(n){this._addClass(n,t);n.style[i]="100%"}.bind(this))):this.options.tooltip_position==="bottom"?n.forEach(function(n){this._addClass(n,"bottom");n.style.top="22px"}.bind(this)):n.forEach(function(n){this._addClass(n,"top");n.style.top=-this.tooltip.outerHeight-14+"px"}.bind(this))}};n&&(f=n.fn.slider?"bootstrapSlider":"slider",n.bridget(f,t))}(n),t})