/* global goog, oVFB, nsVFB, angular, oProperties, ol, bootbox */

/**
 * @author: Anthony Borghi
 * @Description: Fichier contenant la classe nsVFB.ElementForm
 * cette classe permet l'initialisation du panneau de visualisation et de modification des attributs liés à un élément
 */

/*********************************************************************************************************
 *  TODO LIST  (95%)
 *      ajouter et modifier des types d'éléments (Map)
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.ElementForm');

goog.require('goog.object')

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object Elemnt Form
 * @constructor
 * @export
 */
nsVFB.ElementForm = function () {
    oVFB.log('nsVFB.ElementForm');

    oVFB.module.directive('appElementForm', this.elementFormDirective);
    oVFB.module.directive('appParamElement', ["$rootScope", this.elementParamDirective]);
    oVFB.module.directive('appParamMap', this.mapParamDirective);
    oVFB.module.directive('appHelperIcon', this.helperDirective);
    oVFB.module.controller('AppElementFormController', ["$scope", "$rootScope", "$timeout", "$q", this.elementFormController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.ElementForm.prototype.elementFormDirective = function () {
    oVFB.log('nsVFB.ElementForm.elementFormDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppElementFormController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/ElementForm.html'
    };
};

/**
 * Change la vue lié au composant pour y faire apparaitre le slider de sélection de largeur
 * @param {object} $rootScope AngularJS's service who return the root scope, parent of all others scopes.
 * @export
 */
nsVFB.ElementForm.prototype.elementParamDirective = function ($rootScope) {
    oVFB.log('nsVFB.ElementForm.elementParamDirective');
    return {
        link: function (scope, element) {

            if (scope["model"]["type"] === "map_vmap") {
                $("#Vmap_Downloader_input")["fileinput"]({
                    "mainClass": "input-group-sm"
                });
                $("#Vmap_Downloader_input").on("change", function (event) {
                    var file = event.target.files[0];
                    if (file) {
                        var reader = new FileReader();
                        reader.onload = function (evt) {
                            scope['ctrl'].updateVmapData(JSON.parse(evt.target.result));
                        };
                        reader.readAsText(file);
                    }
                });
                if (scope["locker"] === true) {
                    $("#Vmap_Downloader_input")["fileinput"]("disable");
                }
            }

            // Slider
            switch (scope["model"]["type"]) {
                case "upload":
                case "text":
                case "label":
                case "email":
                case "double_select":
                case "select":
                case "list":
                case "date":
                case "datetime":
                case "password":
                case "url":
                case "color_picker":
                case "label_display":
                case "map":
                case "map_osm":
                case "map_bing":
                case "map_vmap":
                case "textarea" :
                case "button" :
                case "image":
                case "imageurl":
                case "image_wsdata":
                case "link":
                case "linkurl":
                case "file_wsdata":
                case "bo_grid":
                case "section_grid":
                case "codemirror":
                case "checkbox":
                case "radio":
                case "float":
                case "slider":
                    if ($(element).attr('id') === 'slider_Element_size') {

                        // instanciation du slider
                        $(element)['slider']({
                            "formatter": function (value) {
                                return Math.round(value * 100 / 12) + "%"; //donne un affichage en pourcentage
                            },
                            "value": scope["model"]["nb_cols"]
                        });

                        // évèvement au changement
                        $(element)['slider']("on", "change", function () {   //event listener sur changement de valeur
                            scope["model"]["nb_cols"] = $(element)["slider"]("getValue"); //Memorise de la valeur dans le scope
                            scope.$apply(); //vérifie les donnée puis recompile le rootScope ($rootScope.$digest())
                        });

                        // Met a jour la valeur du slider quand model.nb_cols est modifié
                        scope.$watch("model.nb_cols", function (value, old) {
                            $(element)['slider']('setValue', value);
                        });

                    } else if ($(element).attr('id') === 'slider_Element_height') {

                        if (!goog.isDefAndNotNull(scope["model"]["style"])) {
                            scope["model"]["style"] = {};
                        }
                        if (!goog.isDefAndNotNull(scope["model"]["style"]["height"])) {
                            scope["model"]["style"]["height"] = 0;
                        }

                        // instanciation du slider
                        $(element)['slider']({
                            "formatter": function (value) {
                                return value + 'px';
                            },
                            "value": parseFloat(scope["model"]["style"]["height"])
                        });

                        // évèvement au changement
                        $(element)['slider']("on", "change", function () {   //event listener sur changement de valeur
                            scope["model"]["style"]["height"] = $(element)["slider"]("getValue") + 'px'; //Memorise de la valeur dans le scope
                            scope.$apply(); //vérifie les donnée puis recompile le rootScope ($rootScope.$digest())
                        });

                        // Met a jour la valeur du slider quand model.style.height est modifié
                        scope.$watch("model.style.height", function (value, old) {
                            $(element)['slider']('setValue', parseFloat(value));
                        });

                    } else if ($(element).attr('id') === 'slider_Element_width') {

                        if (!goog.isDefAndNotNull(scope["model"]["style"])) {
                            scope["model"]["style"] = {};
                        }
                        if (!goog.isDefAndNotNull(scope["model"]["style"]["width"])) {
                            scope["model"]["style"]["width"] = 0;
                        }

                        // instanciation du slider
                        $(element)['slider']({
                            "formatter": function (value) {
                                return value + 'px';
                            },
                            "value": parseFloat(scope["model"]["width"])
                        });

                        // évèvement au changement
                        $(element)['slider']("on", "change", function () {   //event listener sur changement de valeur
                            scope["model"]["width"] = $(element)["slider"]("getValue") + 'px'; //Memorise de la valeur dans le scope
                            scope.$apply(); //vérifie les donnée puis recompile le rootScope ($rootScope.$digest())
                        });

                        // Met a jour la valeur du slider quand model.style.height est modifié
                        scope.$watch("model.width", function (value, old) {
                            $(element)['slider']('setValue', parseFloat(value));
                        });
                    } else if ($(element).attr('id') === 'slider_Tab_size') {
                        if (!goog.isDefAndNotNull(scope["model"]["cm_options"])) {
                            scope["model"]["cm_options"] = {};
                        }
                        if (!goog.isDefAndNotNull(scope["model"]["cm_options"]["tabSize"])) {
                            scope["model"]["cm_options"]["tabSize"] = 2;
                        }

                        // instanciation du slider
                        $(element)['slider']({
                            "formatter": function (value) {
                                return value;
                            },
                            "value": parseFloat(scope["model"]["cm_options"]["tabSize"])
                        });

                        // évèvement au changement
                        $(element)['slider']("on", "change", function () {   //event listener sur changement de valeur
                            scope["model"]["cm_options"]["tabSize"] = $(element)["slider"]("getValue"); //Memorise de la valeur dans le scope
                            scope.$apply(); //vérifie les donnée puis recompile le rootScope ($rootScope.$digest())
                        });

                        // Met a jour la valeur du slider quand model.style.height est modifié
                        scope.$watch("model.cm_options.tabSize", function (value, old) {
                            $(element)['slider']('setValue', parseFloat(value));
                        });
                    }

                    if (scope["locker"] === true) {
                        $(element)['slider']("disable");
                    } else {
                        $(element)['slider']("enable");
                    }
                    break;
            }

            //instanciation du slider de hauteur pour listes
            if (scope["model"]["type"] === "list" || scope["model"]["type"] === "double_select" || scope["model"]["type"] === "textarea") {

                //instanciation du slider
                $("#slider_Element_Row")['slider']({
                    "formatter": function (value) {
                        return value;
                    },
                    "min": 3,
                    "max": 20,
                    "step": 1,
                    "value": 5
                });
                //event listener sur changement de valeur
                $("#slider_Element_Row")['slider']("on", "change", function () {
                    scope["model"]["size"] = $("#slider_Element_Row")["slider"]("getValue"); //Memorisationd de la valeur dans le scope
                    scope.$apply(); //vérifie les donnée puis recompile le rootScope ($rootScope.$digest())
                });
                // Met a jour la valeur du slider quand model.nb_cols est modifié
                scope.$watch("model.size", function (value, old) {
                    $("#slider_Element_Row")['slider']('setValue', value);
                });
                if (scope["locker"] === true) {
                    $("#slider_Element_Row")["slider"]("disable");
                }
                if (scope["model"]["type"] === "double_select") {
                    scope.$watch("model.name", function (value) {
                        scope["model"]["name_to"] = value;
                        scope["model"]["name_from"] = value + "_from";
                    });
                }
            }
        }
    };
};

/**
 * helper directive.
 * popover sur les icon i.
 **/
nsVFB.ElementForm.prototype.helperDirective = function () {
    return {
        link: function (scope, element, attrs) {
            // 1er affichage ou tri de la liste : maj de la mise en forme.
            var clearObserver = attrs.$observe("appHelperIcon", function () {
                if (goog.isDef(attrs.text) && attrs.text !== "") {
                    $(element)["popover"]({
                        "trigger": "hover",
                        "container": "body",
                        "title": "HelperBox",
                        "content": function () {
                            return attrs.text;
                        }
                    });
                    // Attend la suppression du scope.
                    scope.$on("$destroy", function () {
                        // Supprime le tooltip.
                        $(element)["popover"]("destroy");
                        // Supprime l'observateur.
                        clearObserver();
                    });
                }
            });

        }
    };
};

/**
 * Change la vue lié au composant pour y faire apparaitre le slider de sélection de largeur
 * @param {object} $rootScope AngularJS's service who return the root scope, parent of all others scopes.
 * @export
 */
nsVFB.ElementForm.prototype.mapParamDirective = function ($rootScope) {
    oVFB.log('nsVFB.ElementForm.mapParamDirective');
    /*
     return {
     link: function (scope, element) {
     switch (scope["model"]["type"]) {
     case "map":
     case "map_osm":
     case "map_bing":
     case "map_wms":
     $(element)['slider']({//instanciation du slider
     "formatter": function (value) {
     return Math.round(value * 100 / 28) + "%"; //donne un affichage en pourcentage
     }
     });
     $(element)['slider']("on", "change", function () {   //event listener sur changement de valeur
     scope["model"]["map_options"]["center"]["zoom"] = $(element)["slider"]("getValue");
     $rootScope.$broadcast("updateMap_" + scope["model"]['map_options']["type"], "zoom");
     });
     break;
     }
     }
     };*/
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {object} $scope
 * @param {object} $rootScope
 * @param {object} $timeout
 * @param {object} $q
 * @export
 * @ngInject
 */
nsVFB.ElementForm.prototype.elementFormController = function ($scope, $rootScope, $timeout, $q) {
    oVFB.log('nsVFB.ElementForm.elementFormController');
    var elementFormController = this;

    this['applicationName'] = oVFB.getApplication();

    // Permet de retourner les keys d'un objet depuis le template html
    $rootScope['Utils'] = {
        'keys': Object.keys
    };

    /**
     * Current object
     */
    $scope["model"] = {};

    /**
     * True if the element is colapsed
     */
    $scope["collapsed"] = oVFB.Collapse_[4];

    /**
     * List of avaliable attributs of a web_service
     */
    $scope['aWebServiceAttributs'] = [];

    /**
     * List of avaliable business objects
     */
    $scope['aBusinessObjects'] = [];

    /**
     * List of avaliable business objects fields
     */
    $scope['aBoAttributs'] = [];

    /**
     * List of avaliable business objects fields
     */
    $scope['aFormAttributs'] = [];

    /**
     * List of the datasources
     */
    $scope['datasourcesArray'] = [];

    /**
     * App name
     */
    $scope['application'] = oVFB.getApplication();

    /**
     * @private
     */
    $scope.tmp = {};

    var selectedElement = {};
    var selectedElementInTreeview = {};

    $scope.$on("labelizeForm", function () {
        console.log(elementFormController);
        var oJson = oVFB.getJsonOutput();
        var oForm = oJson[$rootScope["selected_form_type"]];
        var inputType = ["select", "list", "double_select", "date", "datetime", "color_picker", "text", "password", "url", "email", "integer", "float", "number"];
        var mapType = ["map_osm", "map_bing", "map_vmap"];
        var disabledType = ["checkbox", "radio", "textarea", "slider"];

        // parcours de oForm et convert
        for (var i = 0; i < oForm["rows"].length; i++) {
            var oRow = oForm["rows"][i];
            for (var j = 0; j < oRow["fields"].length; j++) {
                var oField = oRow["fields"][j];

                //check type si input
                if (inputType.indexOf(oField["type"]) > -1) {
                    elementFormController.convert(oField, "label");
                    oField["type"] = "label";
                } else if (mapType.indexOf(oField["type"]) > -1) {
                    oField["map_options"]["interactions"] = {
                        "multi_geometry": false,
                        "full_screen": true,
                        "RA": false,
                        "RO": false,
                        "ED": false,
                        "DP": false,
                        "DL": false,
                        "DPol": false,
                        "SE": false
                    };
                    $rootScope.$broadcast("updateMap", "interact");
                } else if (disabledType.indexOf(oField["type"]) > -1) {
                    oField["disabled"] = true;
                } else if (oField["type"] === "upload") {
                    elementFormController.convert(oField, "link");
                    oField["type"] = "link";
                } else if (oField["type"] === "codemirror") {
                    oField["cm_options"]["readOnly"] = true;
                }
                // sinon on ne le modifie pas
            }
        }
        oJson[$rootScope["selected_form_type"]] = oForm;
        oVFB.setJsonOutput(oJson); // on Memorise
        $rootScope.$broadcast("updateEvent", oVFB.getJsonOutput());
        // uptade formulaire
        $rootScope.$broadcast("updateJsonModel", oVFB.getJsonOutput());
        $rootScope.$broadcast("updateForm", oVFB.getJsonOutput());
    });

    // Changement de text
    $scope.$watch("text", function () {
        oVFB.log('text updated');
        if (typeof $scope["text"]["Element"] !== "undefined") {
            // Traductions
            elementFormController["text"] = $scope["text"]["Element"];
            // Liste des types traduite
            $scope["Component_list"] = [];
            var aAcceptedTypes = oVFB['config']['avaliable_elems'];
            for (var i = 0; i < aAcceptedTypes.length; i++) {
                $scope["Component_list"].push({
                    'alias': elementFormController["text"]['Select_Type'][aAcceptedTypes[i]],
                    'value': aAcceptedTypes[i]
                });
            }
        }
    });

    // Changement d'entité
    $scope.$watch("model.id", function () {

        oVFB.log('model.id changed');

        $scope['jsonOutput'] = oVFB.getJsonOutput();

        if (!goog.isDef($scope['jsonOutput']['datasources']) || !goog.isObject($scope['jsonOutput']['datasources']) || goog.isArray($scope['jsonOutput']['datasources'])) {
            $scope['jsonOutput']['datasources'] = {};
        }

        $scope['datasources'] = $scope['jsonOutput']['datasources'];
        $scope['datasourcesArray'] = [];

        for (var key in $scope['datasources']) {
            $scope['datasources'][key]['id'] = key;
            $scope['datasourcesArray'].push($scope['datasources'][key]);
        }

        // Met à jour les paramètres avancés
        elementFormController['updateDatasourceInfos']();

        // Met à jour les Parents si besoin
        if ($scope['model']['type'] === 'select' || $scope['model']['type'] === 'list' || $scope['model']['type'] === 'double_select') {
            if (goog.isDefAndNotNull($scope['model']['datasource']) && goog.isDefAndNotNull($scope['model']['datasource']['parents'])) {
                $scope['cascade'] = true;
                $scope['aParents'] = [];
                for (var i = 0; i < $scope['model']['datasource']['parents'].length; i++) {
                    $scope['aParents'].push($scope['model']['datasource']['parents'][i]['name']);
                }
            } else {
                $scope['cascade'] = false;
                $scope['aParents'] = [];
            }
        }

        // en cas d'ajout de la section "datasources"
        oVFB.setJsonOutput($scope['jsonOutput']);
    });

    // Changement de datasource
    $scope.$watch("model.datasource.datasource_id", function () {
        oVFB.log('model.datasource.datasource_id changed');

        if (!goog.isDefAndNotNull($scope['model']['datasource'])) {
            return 0;
        }
        if (!goog.isDefAndNotNull($scope['model']['datasource']['datasource_id'])) {
            return 0;
        }
        if (!goog.isDefAndNotNull($scope['datasources'][$scope['model']['datasource']['datasource_id']])) {
            return 0;
        }

        var datasource = $scope['datasources'][$scope['model']['datasource']['datasource_id']];

        if (datasource['type'] === 'web_service') {
            // vide la liste des attributs
            goog.array.clear($scope['aWebServiceAttributs']);
        }

        // Met à jour les paramètres avancés
        elementFormController['updateDatasourceInfos']();
    });

    // Changement de valeur par défaut
    $scope.$watch("model.default_value", function () {
        $rootScope.$broadcast('updateDefautValue', $scope['model']);
    });

    // Modifications sur model.name
    $scope.$watch("model.name", function (current, old) {
        $scope['jsonOutput'] = oVFB.getJsonOutput();

        // Vérifie que le nom ne soit pas déjà utilisé
        setTimeout(function () {
            var aElems = oVFB.utils_.getElementsByName($scope['jsonOutput'], $rootScope["selected_form_type"], current);
            if (aElems.length > 1) {
                $scope.$applyAsync(function(){
                    $scope['model']['name'] = $scope['model']['name'] + '_2';
                    $.notify($scope["text"]["Element"]['SameNameWarning'], 'warning');
                })
            }
        }, 500);
    });

    // Changement d'une des valeurs de model
    $scope.$watch("model", function (current, old) {

        $rootScope.$broadcast('update model', null);
        if (goog.isDefAndNotNull(current["type"]) && goog.isDefAndNotNull(current["id"])) {
            if ((current["type"] !== old["type"]) && (current["id"] === old["id"])) {
                // Modification du studio
                oVFB.Update = true;
                if (selectedElement.length > 0) {
                    if (goog.isDefAndNotNull(selectedElement[0])) {
                        selectedElement[0]['icon'] = elementFormController.convert($scope["model"], current["type"]);
                    }
                    if (goog.isDefAndNotNull(selectedElementInTreeview[0])) {
                        selectedElementInTreeview[0]["icon"] = elementFormController.convert($scope["model"], current["type"]);
                    }
                }
                if (current['type'] === "select") {
                    if (elementFormController["optionsSelect"] === 'Text') {
                        // supprime les valeurs de options
                        if (goog.isDef(current['web_service'])) {
                            goog.object.remove(current, 'web_service');
                        }
                        $scope['selectedRessource'] = "";
                        $scope['selectedValue'] = "";
                        $scope['selectedLabel'] = "";
                    } else if (elementFormController["optionsSelect"] === 'TableValues') {
                        // supprime les valeurs de options
                        if (goog.isDef(current['options'])) {
                            goog.object.remove(current, 'options');
                        }
                        $scope['selectedRessource'] = "";
                        $scope['selectedValue'] = "";
                        $scope['selectedLabel'] = "";
                    } else if (elementFormController["optionsSelect"] === 'WebService') {
                        // supprime les valeurs de options
                        if (goog.isDef(current['options'])) {
                            goog.object.remove(current, 'options');
                        }
                        // supprime les valeurs de TableValues
                        if (goog.isDef(current['web_service']['parameters'])) {
                            goog.object.remove(current['web_service'], 'parameters');
                        }
                    }
                }
                //$rootScope.$broadcast("updateEvent", oVFB.getJsonOutput());
            } else if ((current["id"] === old["id"]) && (current["name"] !== old["name"])) {
                // Modification du studio
                oVFB.Update = true;
                if (goog.isDef(selectedElement[0]) && goog.isDef(selectedElementInTreeview[0])) {
                    selectedElement[0]['text'] = current["name"];
                    selectedElementInTreeview[0]['text'] = current["name"];
                }
                // Modifie le nom dans les tabs
                oVFB.updateElemNameInTabs(current, old);
                // Modifie le nom dans wab
                oVFB.updateElemNameInWab(current, old);
            } else if (current["id"] === old["id"]) {
                if (current['type'] == "ui_grid") {
                    var oGridOptions = angular.element("#" + $scope["model"]["id"] + "_grid .ui-grid-contents-wrapper").scope()["grid"]["options"];
                    if ($scope["bListenUiGridEvent"] !== true) {
                        // Données identiques entre le modèle et l'affichage.
                        oGridOptions["columnDefs"] = $scope["model"]["options"]["columnDefs"];
                        oGridOptions["appActions"] = $scope["model"]["options"]["appActions"];

                        // Changement de l'ordre des colonnes.
                        $scope["bListenUiGridEvent"] = true;
                        var oGridApi = angular.element("#" + $scope["model"]["id"] + "_grid .ui-grid-contents-wrapper").scope()["grid"]["api"];
                        oGridApi["colMovable"].on["columnPositionChanged"]($scope, function(colDef, originalPosition, newPosition) {
                            var oColumns = angular.element("#" + $scope["model"]["id"] + "_grid .ui-grid-header-cell-row").scope().grid.columns;
                            var aColumnsDef = [];
                            for (var i = 0; i < oColumns.length; i++) {
                                if (oColumns[i]["field"] != "selectionRowHeaderCol") {
                                    aColumnsDef.push(oColumns[i]["colDef"]);
                                }
                            }
                            $scope["model"]["options"]["columnDefs"].length = 0;
                            $scope["model"]["options"]["columnDefs"] = angular.copy(aColumnsDef);
                            aColumnsDef.length = 0;
                        });

                        // Evènement déclenché si le tri change.
                        var uiGridConstants = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["uiGridConstants"]);
                        oGridApi["core"]["on"]["sortChanged"]($scope, function (grid, sortColumns) {
                            // Maj du tri dans le modèle.
                            var sSortOrder = sortColumns[0]["sort"]["direction"].toUpperCase();
                            for (var i = 0; i < $scope["model"]["options"]["columnDefs"].length; i++) {
                                delete $scope["model"]["options"]["columnDefs"][i]["sort"];
                                if ($scope["model"]["options"]["columnDefs"][i]["field"] == sortColumns[0]["field"]) {
                                    $scope["model"]["options"]["columnDefs"][i]["sort"] = {
                                        "direction": uiGridConstants[sSortOrder],
                                        "ignoreSort": true,
                                        "priority": 0
                                    };
                                }
                            }
                            // Maj du tri si une source de données est associée.
                            if (typeof($scope["model"]["datasource"]) != "undefined") {
                                $scope["model"]["datasource"]["order_by"] = sortColumns[0]["field"];
                                $scope["model"]["datasource"]["sort_order"] = sSortOrder;
                            }
                        });
                    }

                    // Maj du titre (uniquement pour l'affichage dans le studio --> json ok).
                    document.querySelector("#studio_form_reader .ui-grid-form-field-header-title > span").textContent = current["options"]["appGridTitle"];
                    // Affichage de l'entête.
                    if ($scope["model"]["options"]["appHeader"])
                        document.getElementById($scope["model"]["id"] + "_grid_header").style.display = "";
                    else
                        document.getElementById($scope["model"]["id"] + "_grid_header").style.display = "none";
                    // Affichage du libellé.
                    if ($scope["model"]["label"] == "")
                        document.getElementById($scope["model"]["id"] + "_label").style.display = "none";
                    else
                        document.getElementById($scope["model"]["id"] + "_label").style.display = "";
                    // Colonnes.
                    if ($scope["bEditColumn"] === true) {
                        $scope["bShowColumnParameters"] = true;
                        for (var i = 0; i < $scope["model"]["options"]["columnDefs"].length; i++) {
                            if ($scope["model"]["options"]["columnDefs"][i]["field"] == $scope["sSelectedColumn"]) {
                                $scope["columnDef"] = angular.copy($scope["model"]["options"]["columnDefs"][i]);
                                break;
                            }
                        }
                        $scope["bEditColumn"] = false;
                    }
                    else if ($scope["bAddColumn"] === true) {
                        $scope["columnDef"] = {
                            "displayName": "",
                            "field": "",
                            "width": ""
                        };
                        $scope["bAddColumn"] = false;
                    }
                    // Sauvegarde des données de la colonne.
                    if ($scope["bSaveColumn"] === true) {
                        $scope["bSaveColumn"] = false;
                        // Paramètres de la colonne.
                        var oColumnDef = Object.assign({
                            "name": $scope["columnDef"]["field"],
                            "type": "string",
                            "enableSorting": true,
                            "enableColumnMoving": true,
                            "enableColumnResizing": true,
                        }, $scope["columnDef"]);
                        if (!isNaN(oColumnDef["width"]))
                            oColumnDef["width"] = parseInt(oColumnDef["width"]);
                        // Ajout ou édition d'une colonne.
                        if (oColumnDef["displayName"] != "" && oColumnDef["field"] != "" && oColumnDef["width"] != "") {
                            if (typeof($scope["sSelectedColumn"]) == "undefined" || $scope["sSelectedColumn"] == "") {
                                $scope["model"]["options"]["columnDefs"].push(angular.copy(oColumnDef));
                                $scope["sSelectedColumn"] = oColumnDef["field"];
                            }
                            else {
                                for (var i = 0; i < $scope["model"]["options"]["columnDefs"].length; i++) {
                                    if ($scope["model"]["options"]["columnDefs"][i]["field"] == $scope["sSelectedColumn"]) {
                                        $scope["model"]["options"]["columnDefs"][i] = angular.copy($scope["columnDef"]);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    // Suppression d'une colonne.
                    if ($scope["bDeleteColumn"] === true) {
                        $scope["bDeleteColumn"] = false;
                        for (var i = 0; i < $scope["model"]["options"]["columnDefs"].length; i++) {
                            if ($scope["model"]["options"]["columnDefs"][i]["field"] == $scope["sSelectedColumn"]) {
                                $scope["model"]["options"]["columnDefs"].splice(i, 1);
                                $scope["sSelectedColumn"] = "";
                                break;
                            }
                        }
                    }
                    // Boutons
                    if ($scope["bEditButton"] === true) {
                        $scope["bShowButtonParameters"] = true;
                        for (var i = 0; i < $scope["model"]["options"]["appActions"].length; i++) {
                            if ($scope["model"]["options"]["appActions"][i]["name"] == $scope["sSelectedButton"]) {
                                $scope["appAction"] = angular.copy($scope["model"]["options"]["appActions"][i]);
                                break;
                            }
                        }
                        $scope["bEditButton"] = false;
                    }
                    else if ($scope["bAddButton"] === true) {
                        $scope["appAction"] = {
                            "name": "",
                            "label": "",
                            "event": ""
                        };
                        $scope["bAddButton"] = false;
                    }
                    // Sauvegarde des données du bouton.
                    if ($scope["bSaveButton"] === true) {
                        $scope["bSaveButton"] = false;
                        // Ajout ou édition d'une colonne.
                        if ($scope["appAction"]["label"] != "" && $scope["appAction"]["name"] != "") {
                            if (typeof($scope["sSelectedButton"]) == "undefined" || $scope["sSelectedButton"] == "") {
                                $scope["model"]["options"]["appActions"].push(angular.copy($scope["appAction"]));
                                $scope["sSelectedButton"] = $scope["appAction"]["name"];
                            }
                            else {
                                for (var i = 0; i < $scope["model"]["options"]["appActions"].length; i++) {
                                    if ($scope["model"]["options"]["appActions"][i]["name"] == $scope["sSelectedButton"]) {
                                        $scope["model"]["options"]["appActions"][i] = angular.copy($scope["appAction"]);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    // Suppression d'un bouton.
                    if ($scope["bDeleteButton"] === true) {
                        $scope["bDeleteButton"] = false;
                        for (var i = 0; i < $scope["model"]["options"]["appActions"].length; i++) {
                            if ($scope["model"]["options"]["appActions"][i]["name"] == $scope["sSelectedButton"]) {
                                $scope["model"]["options"]["appActions"].splice(i, 1);
                                $scope["sSelectedButton"] = "";
                                break;
                            }
                        }
                    }
                }
                else if (current['type'] == "treeview") {
                    var this_ = this;
                    var oTreeviewDefaultOptions = {
                        "showBorder":false,
                        "levels":0,
                        "showCheckbox":true,
                        "expandIcon":"glyphicon glyphicon-folder-close",
                        "collapseIcon":"glyphicon glyphicon-folder-open",
                        "highlightSelected":false,
                        "multiSelect":true
                    };
                    if (typeof(this["getTreeviewData"]) == "undefined") {
                        /**
                         * getTreeviewData function.
                         * Retourne toute l'arborescence d'un treeview.
                         * @param {string} sTreeviewElementId Id de l'élément html du treeview.
                         * @param {boolean} bCleanNode Supprime les paramètres inutiles.
                         **/
                        this["getTreeviewData"] = function (sTreeviewElementId, bCleanNode) {
                            var aReturnData = [];
                            var oTreeviewElem = document.getElementById(sTreeviewElementId);
                            if (oTreeviewElem !== null) {
                                var oTreeview = $("#" + sTreeviewElementId)["treeview"](true);
                                var aTreeviewData = oTreeview["getEnabled"]().concat(oTreeview["getDisabled"]());
                                // Garde uniquement les noeuds qui sont dans la racine.
                                var aNode;
                                for (var i = 0; i < aTreeviewData.length; i++) {
                                    if (aTreeviewData[i]["parentId"] === undefined) {
                                        aNode = angular.copy(aTreeviewData[i]);
                                        //if (bCleanNode === true)
                                        //aNode = this_["cleanNode"](aNode);
                                        aReturnData.push(aNode);
                                    }
                                }
                            }
                            return aReturnData;
                        };

                        /**
                         * cleanNode function.
                         * Supprime tous les paramètres inutiles d'un noeud.
                         * @param {array} aNode Noeud à nettoyer.
                         **/
                        this["cleanNode"] = function (aNode) {
                            for (var i = 0; i < aNode.length; i++) {
                                delete aNode[i]["parentId"];
                                delete aNode[i]["nodeId"];
                                if (typeof(aNode[i]["nodes"]) != "undefined") {
                                    if (aNode[i]["nodes"].length > 0)
                                        aNode[i]["nodes"] = this_["cleanNode"](aNode[i]["nodes"]);
                                    else
                                        delete aNode[i]["nodes"];
                                }
                            }
                            return aNode;
                        }

                        /**
                         * addTreeviewData function.
                         * Ajoute un noeud à l'arborescence d'un treeview.
                         * @param {array} aTreeviewData Arborescence du treeview.
                         * @param {array} aNode Noeud à ajouter.
                         * @param {integer} iNodeId Id du noeud parent.
                         **/
                        this["addTreeviewData"] = function (aTreeviewData, aNode, iNodeId) {
                            for (var i = 0; i < aTreeviewData.length; i++) {
                                if (aTreeviewData[i]["nodeId"] == iNodeId) {
                                    if (!goog.isArray(aTreeviewData[i]["nodes"]))
                                        aTreeviewData[i]["nodes"] = [];
                                    aTreeviewData[i]["nodes"].push(aNode);
                                }
                                else if (goog.isArray(aTreeviewData[i]["nodes"]))
                                    this_["addTreeviewData"](aTreeviewData[i]["nodes"], aNode, iNodeId);
                            }
                            return aTreeviewData;
                        };

                        /**
                         * deleteNode function.
                         * Supprime un noeud dans l'arborescence d'un treeview.
                         * @param {array} aTreeviewData Arborescence du treeview.
                         * @param {integer} iNodeId Id du noeud à supprimer.
                         **/
                        this["deleteNode"] = function (aTreeviewData, iNodeId) {
                            for (var i = 0; i < aTreeviewData.length; i++) {
                                if (aTreeviewData[i]["nodeId"] == iNodeId) {
                                    aTreeviewData.splice(i, 1);
                                }
                                else if (goog.isArray(aTreeviewData[i]["nodes"]))
                                    this_["deleteNode"](aTreeviewData[i]["nodes"], iNodeId);
                            }
                            return aTreeviewData;
                        };
                    }
                    var aData;
                    var oTreeview = $("#" + $scope["model"]["id"] + "_treeview")["treeview"](true);
                    if ($scope["bListenTreeviewEvent"] !== true) {
                        // Evènement qui retourne le noeud sélectionné.
                        $("#" + $scope["model"]["id"] + "_treeview").on('nodeSelected', function(event, data) {
                            $scope["node"] = {
                                "text": data["text"],
                                "value": data["value"],
                                "selectable": data["selectable"],
                                "state": angular.copy(data["state"])
                            };
                            $scope["iSelectedNode"] = data["nodeId"];
                            // Libellé du noeud parent.
                            if (data["parentId"] != undefined) {
                                var oNodeParent = oTreeview["getNode"](data["parentId"]);
                                $scope["sSelectedNodeParent"] = oNodeParent["text"];
                            }
                            else
                                $scope["sSelectedNodeParent"] = "";
                            $scope["bShowNodeParameters"] = true;
                            $scope["bEditNode"] = true;
                            $scope.$applyAsync();
                        });
                        $scope["bListenTreeviewEvent"] = true;
                    }

                    // Noeuds
                    if ($scope["bAddNode"] === true && ($scope["bSaveNode"] !== true || typeof($scope["bSaveNode"]) == "undefined")) {
                        $scope["node"] = {
                            "text": "",
                            "value": "",
                            "selectable": true,
                            "state": {
                                "checked": false,
                                "disabled": false,
                                "expanded": true,
                                "selected": false
                            }
                        };
                        // Libellé du noeud parent.
                        if (typeof($scope["iSelectedNode"]) != "undefined" && String($scope["iSelectedNode"]) != "") {
                            var oSelectedNode = oTreeview["getNode"]($scope["iSelectedNode"]);
                            $scope["sSelectedNodeParent"] = oSelectedNode["text"];
                        }
                        $scope.$applyAsync();
                    }

                    // Sauvegarde des données du noeud.
                    if ($scope["bSaveNode"] === true) {
                        $scope["bSaveNode"] = false;
                        // Ajout ou édition d'un noeud.
                        if ($scope["node"]["text"] != "" && $scope["node"]["value"] != "") {
                            if ($scope["bAddNode"] === true) {
                                if (typeof($scope["iSelectedNode"]) == "undefined" || String($scope["iSelectedNode"]) == "") {
                                    // Ajout d'un noeud à la racine.
                                    $scope["model"]["options"]["data"].push(angular.copy($scope["node"]));
                                    oTreeview["init"](Object.assign(oTreeviewDefaultOptions, {"data": $scope["model"]["options"]["data"]}));
                                    $scope["bListenTreeviewEvent"] = false;
                                    $scope["bShowNodeParameters"] = false;
                                }
                                else {
                                    // Ajout d'un noeud dans un autre noeud.
                                    aData = this["addTreeviewData"](this_["getTreeviewData"]($scope["model"]["id"] + "_treeview"), $scope["node"], $scope["iSelectedNode"]);
                                    $scope["iSelectedNode"] = "";
                                    $scope["sSelectedNodeParent"] = "";
                                    $scope["bShowNodeParameters"] = false;
                                    $scope["model"]["options"]["data"].length = 0;
                                    $scope["model"]["options"]["data"] = angular.copy(this_["cleanNode"](aData));
                                    oTreeview["init"](Object.assign(oTreeviewDefaultOptions, {"data": $scope["model"]["options"]["data"]}));
                                    $scope["bListenTreeviewEvent"] = false;
                                }
                                $scope["bAddNode"] = false;
                                $scope["bShowNodeParameters"] = false;
                            }
                            else if ($scope["bEditNode"] === true) {
                                $scope["bEditNode"] = false;
                                var oSelectedNode = oTreeview["getNode"]($scope["iSelectedNode"]);
                                oSelectedNode["text"] = $scope["node"]["text"];
                                oSelectedNode["value"] = $scope["node"]["value"];
                                aData = this_["getTreeviewData"]($scope["model"]["id"] + "_treeview");
                                $scope["model"]["options"]["data"].length = 0;
                                $scope["model"]["options"]["data"] = angular.copy(this_["cleanNode"](aData));
                                oTreeview["init"](Object.assign(oTreeviewDefaultOptions, {"data": $scope["model"]["options"]["data"]}));
                                $scope["bListenTreeviewEvent"] = false;
                            }
                        }
                        $scope.$applyAsync();
                    }
                    // Suppression d'un noeud.
                    if ($scope["bDeleteNode"] === true) {
                        $scope["bDeleteNode"] = false;
                        $scope["bEditNode"] = false;
                        aData = this_["deleteNode"](this_["getTreeviewData"]($scope["model"]["id"] + "_treeview"), $scope["iSelectedNode"]);
                        $scope["iSelectedNode"] = "";
                        $scope["sSelectedNodeParent"] = "";
                        $scope["bShowNodeParameters"] = false;
                        $scope["model"]["options"]["data"].length = 0;
                        $scope["model"]["options"]["data"] = angular.copy(this_["cleanNode"](aData));
                        oTreeview["init"](Object.assign(oTreeviewDefaultOptions, {"data": $scope["model"]["options"]["data"]}));
                        $scope["bListenTreeviewEvent"] = false;
                        $scope.$applyAsync();
                    }
                }
                delete $scope["model"]["bCallWatch"];
                //$rootScope.$broadcast("updateEvent", oVFB.getJsonOutput());
            }
        }
        // Re-sélectionne l'objet
        $scope["model"]["selected"] = true;
        $timeout(function () {
            if (goog.isDef(selectedElement[0]) && goog.isDef(selectedElementInTreeview[0])) {
                if (goog.isDefAndNotNull(selectedElement[0])) {
                    $('#treeWithLines')['treeview']('selectNode', [selectedElement[0]['nodeId'], {silent: false}]);
                }
                if (goog.isDefAndNotNull(selectedElementInTreeview[0])) {
                    $('#treeView')['treeview']('selectNode', [selectedElementInTreeview[0]['nodeId'], {silent: false}]);
                }
            }
        }, 10);

        // uptade formulaire
        $rootScope.$broadcast("updateJsonModel", oVFB.getJsonOutput());
        $rootScope.$broadcast("updateForm", oVFB.getJsonOutput());

    }, true);

    // Changement d'élément (connection à un signal)
    $scope.$on('update element', function (event, data) {
        oVFB.log('update element');

        $scope["model"] = data; //on donne directement l'objet que l'on veut visualiser

        selectedElement = $('#treeWithLines')["treeview"]('getSelected');
        selectedElementInTreeview = $('#treeView')["treeview"]('getSelected');
        if (goog.isDef($scope.model))
            $("#select_element_to_add").val($scope.model.type);

        //$scope.tmp = oVFB.clone(data); //stockage d'un tampon pour la fonction de conversion

        $scope["AllSelects"] = [];
        if (goog.isDefAndNotNull(oVFB.getJsonOutput()[$rootScope["selected_form_type"]])) {
            if (!goog.object.isEmpty(oVFB.getJsonOutput()[$rootScope["selected_form_type"]]["rows"])) {
                var obj = oVFB.getJsonOutput()[$rootScope["selected_form_type"]]["rows"];
                for (var i = 0; i < obj.length; i++) {
                    for (var j = 0; j < obj[i]["fields"].length; j++) {
                        if ((obj[i]["fields"][j]["type"] === "select" || obj[i]["fields"][j]["type"] === "list") && obj[i]["fields"][j]["name"] !== $scope["model"]["name"])
                            $scope["AllSelects"].push(obj[i]["fields"][j]["name"]);
                    }
                }
            }
        }

        if ($("#load_Perso_button").hasClass("active") && oVFB.valid && data['type'] !== 'undefined') {
            $scope["locker"] = false;
        } else {
            if (oVFB.valid) {
                $scope["locker"] = true;
                if ($scope["model"]["type"] === "map_vmap") {
                    $("#Vmap_Downloader_input").fileinput('disable');
                }
            }
        }
        if (!$scope.$$phase) {
            $scope.$digest();// recompile le scope avec la vue pour mettre à jour
        }
    });

    /**
     * Update the WS infos for WebService case
     * @param {object} value the view scope
     */
    elementFormController.updateWSInfos = function (value) {
        oVFB.log('elementFormController.updateWSInfos');

        if (typeof value["selectedValue"] !== "undefined") {
            $scope["model"]["web_service"]["id_key"] = value["selectedValue"].replace(/\s/g, "");
        }
        if (typeof value["selectedLabel"] !== "undefined") {
            $scope["model"]["web_service"]["label_key"] = value["selectedLabel"].replace(/\s/g, "");
        }
        // mémorise le type de select
        $scope["model"]["web_service"]["optionsSelect"] = elementFormController["optionsSelect"];
    };

    /**
     * Update the Datasource infos for TableValues case
     */
    elementFormController['updateDatasourceInfos'] = function () {
        oVFB.log('elementFormController.updateDatasourceInfos');

        if (!goog.isDefAndNotNull($scope['model']['datasource']))
            return 0;

        // Valeurs par défaut
        $scope['model']['datasource']['sort_order'] = goog.isDefAndNotNull($scope['model']['datasource']['sort_order']) ? $scope['model']['datasource']['sort_order'] : 'ASC';
        $scope['model']['datasource']['distinct'] = goog.isDefAndNotNull($scope['model']['datasource']['distinct']) ? $scope['model']['datasource']['distinct'] : 'true';

        // Enlève les espaces
        if (goog.isDefAndNotNull($scope['model']['datasource']['id_key']))
            $scope['model']['datasource']['id_key'] = $scope['model']['datasource']['id_key'].replace(/\s/g, '');
        if (goog.isDefAndNotNull($scope['model']['datasource']['label_key']))
            $scope['model']['datasource']['label_key'] = $scope['model']['datasource']['label_key'].replace(/\s/g, '');

        // Place les nouveaux paramètres
        if (goog.isDefAndNotNull($scope['model']['datasource']['id_key']) && goog.isDefAndNotNull($scope['model']['datasource']['label_key']))
            $scope['model']['datasource']['attributs'] = $scope['model']['datasource']['id_key'] + '|' + $scope['model']['datasource']['label_key'];
        if (goog.isDefAndNotNull($scope['model']['datasource']['label_key']))
            $scope['model']['datasource']['order_by'] = $scope['model']['datasource']['label_key'];

        //        if (goog.isDefAndNotNull($scope['datasources'][$scope['model']['datasource']['datasource_id']]))
        //            if (goog.isDefAndNotNull($scope['datasources'][$scope['model']['datasource']['datasource_id']]['parameters']))
        //                if (goog.isDefAndNotNull($scope['datasources'][$scope['model']['datasource']['datasource_id']]['parameters']['filter']))
        //                    $scope['model']['datasource']['filter'] = $scope['datasources'][$scope['model']['datasource']['datasource_id']]['parameters']['filter'];
    };

    /**
     * Update WebService Attributs
     * @param {object} datasource
     */
    elementFormController['updateWebServiceAttributs'] = function (datasource) {
        oVFB.log('updateWebServiceAttributs');

        var params = {
            'limit': 1
        };

        if (goog.isObject(datasource['parameters']))
            goog.object.extend(params, datasource['parameters']);

        console.log(datasource['parameters'])

        var canceler = $q.defer();
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/" + datasource["ressource_id"],
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'params': params,
            'scope': $scope,
            'timeout': 5000,
            'abord': canceler.promise,
            'success': function (response) {

                if (!goog.isDefAndNotNull(response))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;

                var data;
                // si un sous objet est renseigné
                if (datasource['dataType'] === 'businessObject' && goog.isDefAndNotNull(datasource['businessObjectRequest'])) {
                    data = [];
                    for (var i = 0; i < response['data']['data'].length; i++)
                        data.push(response['data']['data'][i]['bo_' + datasource['businessObjectRequest']]);
                } else {
                    data = response['data']['data'];
                }

                $scope['aWebServiceAttributs'] = Object.keys(data[0]);
            }
        });
    };

    /**
     * Update the cascade params for the parent and the child
     */
    elementFormController['updateCascadeField'] = function () {
        oVFB.log('elementFormController.updateCascadeField');

        if (!goog.isDefAndNotNull($scope['aParents'])) {
            console.error('aParents not defined');
            return 0;
        }
        if (!goog.isDefAndNotNull($scope['model']['datasource'])) {
            console.error('datasource not defined');
            return 0;
        }

        if ($scope['cascade'] === false) {
            $scope['aParents'] = [];
        }

        if (goog.isArray($scope['aParents'])) {

            // Supprime les parents si ils sont vides
            if ($scope['aParents'].length === 0) {
                if (goog.isDef($scope['model']['datasource']['parents'])) {
                    delete $scope['model']['datasource']['parents'];
                }
                return 0;
            }

            // Crée les parents
            if (!goog.isDefAndNotNull($scope['model']['datasource']['parents']))
                $scope['model']['datasource']['parents'] = [];

            // Clear parents
            if (goog.isArray($scope['model']['datasource']['parents']))
                goog.array.clear($scope['model']['datasource']['parents']);

            // Remplit les parents
            for (var i = 0; i < $scope['aParents'].length; i++) {
                $scope['model']['datasource']['parents'].push({
                    'name': $scope['aParents'][i],
                    'filter_attr': $scope['aParents'][i],
                    'filter_equality': '=',
                    'wait_for_parent': true
                });
            }
        }
    };

    /**
     * Update the vMap options
     * @param {object} tree
     */
    elementFormController.updateVmapData = function (tree) {
        oVFB.log('elementFormController.updateVmapData');
        if (tree["children"]) {
            for (var i = 0; i < tree["children"].length; i++) {
                if (tree["children"][i]["view"]) {
                    $scope["model"]["map_options"]["center"]["coord"] = (tree["children"][i]["view"]["center"] ? tree["children"][i]["view"]["center"] : [0, 0]);
                    $scope["model"]["map_options"]["center"]["zoom"] = (tree["children"][i]["view"]["zoom"] ? tree["children"][i]["view"]["zoom"] : 5);
                    $scope["model"]["map_options"]["center"]["extent"] = (tree["children"][i]["view"]["extent"] ? tree["children"][i]["view"]["extent"] : [-20026376.39, -20048966.10, 20026376.39, 20048966.10]);
                    $scope["model"]["map_options"]["proj"] = (tree["children"][i]["view"]["projection"] ? tree["children"][i]["view"]["projection"] : "EPSG:3857");
                    $rootScope.$broadcast("updateMap", "view");
                }
            }
            $scope["model"]["map_options"]["tree"] = tree;
            $rootScope.$broadcast("updateMap", "tree");
        }
    };

    /**
     * Broadcast the updateOptions event
     */
    elementFormController.updateWS = function () {
        oVFB.log('elementFormController.updateWS');
        $rootScope.$broadcast("updateOptions", {});
    };

    /**
     * Update the vMap view
     * @param {object} carte
     * @param {string} option
     */
    elementFormController['updateMap'] = function (carte, option) {
        oVFB.log('elementFormController.updateMap');

        switch (option) {
            case "center" :
                var coord = ol.proj.transform($scope["model"]["map_options"]["center"]["coord"], $scope["model"]["map_options"]["proj"], "EPSG:3857");
                var boundary = [-20026376.39, -20048966.10, 20026376.39, 20048966.10];
                if (!ol.extent.containsCoordinate(boundary, coord)) {
                    $["notify"](elementFormController["text"]["Component"]["Map"]["Notify"]["OutRange"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                } else {
                    $rootScope.$broadcast("updateMap", option);
                }
                break;
            case "zoom" :
                if ($scope["model"]["map_options"]["center"]["scale"] > 0 && $scope["model"]["map_options"]["center"]["scale"] <= 200000000) {
                    $rootScope.$broadcast("updateMap", option);
                } else {
                    $["notify"](elementFormController["text"]["Component"]["Map"]["Notify"]["OutRange"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                }
                break;
            case "extent" :
                var extent = $scope.model.map_options.center.extent;
                if (extent[0] <= extent[2] && extent[0] >= -20026376.39 && extent[0] <= 20026376.39) {
                    if (extent[0] <= extent[2] && extent[2] >= -20026376.39 && extent[2] <= 20026376.39) {
                        if (extent[1] <= extent[3] && extent[1] >= -20048966.10 && extent[1] <= 20048966.10) {
                            if (extent[1] <= extent[3] && extent[3] >= -20048966.10 && extent[3] <= 20048966.10) {
                                $rootScope.$broadcast("updateMap", option);
                                break;
                            }
                        }
                    }
                }
                $["notify"](elementFormController["text"]["Component"]["Map"]["Notify"]["OutRange"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                break;
            case "multi_geom" :

                break;
            default :
                $rootScope.$broadcast("updateMap", option);
                break;
        }
    };

    /**
     * Set the element default values
     * @param {type} src
     * @param {type} dst
     * @returns {String}
     */
    elementFormController.convert = function (src, dst) {
        oVFB.log('elementFormController.convert');
        var fields;
        var icon = "icon-point";
        // si les types sont égaux on vient de mettre le composant à jour inutile de faire une conversion
        if (/*src["type"] !== dst &&*/ src["type"] !== "undefined") {
            //définition des champs pour chaque composant
            switch (dst) {
                case "button":
                    fields = ["type", "id", "class", "name", "nb_cols", "buttons", "default_value"];
                    break;
                case "title" :
                case "label" :
                    fields = ["type", "id", "label", "name", "default_value", "nb_cols"];
                    dst === "label" ? icon = "icon-eye" : icon;
                    break;
                case "hr":
                    fields = ["type", "id", "name", "default_value"];
                    dst === "hr" ? icon = "icon-minus" : icon;
                    break;
                case "hidden":
                    fields = ["type", "id", "name", "default_value", "nb_cols"];
                    dst === "hidden" ? icon = "icon-user-secret" : icon;
                    break;
                case "subtitle" :
                    fields = ["type", "id", "label", "name", "class", "default_value", "nb_cols"];
                    break;
                case "checkbox":
                    fields = ["type", "id", "label", "name", "checked", "default_value", "nb_cols"];
                    icon = "icon-check-square";
                    break;
                case "radio":
                    fields = ["type", "id", "label", "name", "checked", "options", "nb_cols", "default_value"];
                    icon = "icon-dot-circle-o";
                    break;
                case "textarea":
                    fields = ["type", "id", "label", "name", "required", "nb_cols", "default_value"];
                    icon = "icon-paragraph";
                    break;
                case "select":
                    fields = ["type", "id", "label", "name", "required", "nb_cols", "multiple", "options", "web_service", "child_select", "default_value"];
                    icon = "icon-format_list_bulleted";
                    break;
                case "list":
                    fields = ["type", "id", "label", "name", "required", "nb_cols", "multiple", "options", "web_service", "child_select", "default_value", "size"];
                    icon = "icon-format_list_bulleted";
                    break;
                case "double_select":
                    fields = ["type", "id", "label", "name", "required", "nb_cols", "options", "web_service", "size", "label_from", "label_to", "name_from", "name_to", "default_value"];
                    icon = "icon-format_list_bulleted";
                    break;
                case "date":
                case "datetime":
                case "label_display":
                case "color_picker":
                    fields = ["type", "id", "label", "name", "nb_cols", "default_value"];
                    (dst === "date" || dst === "datetime") ? icon = "icon-calendar-check-o" : icon;
                    dst === "label_display" ? icon = "icon-eye" : icon;
                    dst === "color_picker" ? icon = "icon-paint" : icon;
                    break;
                case "upload":
                    fields = ["type", "id", "label", "name", "nb_cols", "default_value", "ext"];
                    icon = "icon-file";
                    break;
                case "tinymce":
                    fields = ["type", "id", "label", "name", "nb_rows", "options", "default_value", "nb_cols"];
                    icon = "icon-font";
                    break;
                case "slider":
                    fields = ["type", "id", "label", "name", "options", "default_value", "nb_cols"];
                    icon = "icon-sliders";
                    break;
                case "text" :
                case "password":
                case "url":
                case "email":
                    fields = ["type", "id", "label", "name", "pattern", "required", "nb_cols", "default_value"];
                    dst === "text" ? icon = "icon-font" : icon;
                    dst === "password" ? icon = "icon-key" : icon;
                    dst === "url" ? icon = "icon-chrome" : icon;
                    dst === "email" ? icon = "icon-at" : icon;
                    break;
                case "integer":
                case "float":
                case "number":
                    fields = ["type", "id", "label", "name", "min", "max", "nb_cols", "default_value"];
                    icon = "icon-calculator";
                    break;
                case "link":
                    fields = ["type", "id", "label", "name", "alias", "folder", "nb_cols", "target"];
                    icon = "glyphicon glyphicon-link";
                    break;
                case "image":
                    fields = ["type", "id", "label", "name", "alias", "folder", "nb_cols", "width"];
                    icon = "glyphicon glyphicon-picture";
                    break;
                case "map_osm":
                case "map_bing":
                case "map_vmap":
                    fields = ["type", "id", "label", "name", "required", "map_options", "nb_cols", "style", "default_value"];
                    icon = "icon-map";
                    break;
                case "codemirror":
                    fields = ["type", "id", "label", "ui", "name", "cm_options", "nb_cols"];
                    icon = "icon-code";
                    break;
            }
            //suppréssion de tous les champs qui ne seront pas utile au nouveau type de composant
            for (var srckey in src) {
                if (goog.isDefAndNotNull(fields)) {
                    if (fields.indexOf(srckey) === -1) {
                        delete src[srckey];
                    }
                }
            }
            //autoconfig des nouveaux champs
            switch (dst) {
                case "list":
                case "double_select":
                    var typic = {
                        "size": 5
                    };
                    break;
                case "button":
                    goog.isDef(src['class']) ? src['class'] : src['class'] = 'btn-ungroup btn-group-sm';
                    goog.isDef(src['buttons']) ? src['buttons'] : src['buttons'] = [];
                    var typic = {
                        "type": "submit",
                        "name": "form_submit",
                        "label": "FORM_UPDATE",
                        "class": "btn-primary"
                    };
                    goog.isDef(src['buttons'][0]) ? src['buttons'][0] : src['buttons'][0] = typic;

                    break;
                case "radio":
                    var typic = {
                        "choices": [{
                                label: "Oui",
                                value: true
                            }, {
                                label: "Non",
                                value: false
                            }]
                    };
                    goog.isDef(src["options"]) ? src["options"] : src['options'] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    break;
                case "slider":
                    var typic = {
                        "min": 0,
                        "max": 100,
                        "precision": 1,
                        "step": 1
                    };
                    goog.isDef(src["options"]) ? src["options"] : src["options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    break;
                case "map_osm":
                    goog.isDef(src["style"]) ? src["style"] : src["style"] = {'height': '250px'};
                    var typic = {
                        "proj": "EPSG:3857",
                        "type": "OSM",
                        "output_format": "ewkt",
                        "center": {
                            "coord": [300000, 6000000],
                            "zoom": 5,
                            "scale": 25000000,
                            "extent": [-20026376.39, -20048966.10, 20026376.39, 20048966.10]
                        },
                        "controls": {
                            "MP": true,
                            "ZO": true,
                            "SL": true,
                            "CP": true
                        },
                        "layers": [],
                        "interactions": {
                            "multi_geometry": false,
                            "full_screen": true,
                            "RA": false,
                            "RO": true,
                            "ED": true,
                            "DP": true,
                            "DL": true,
                            "DPol": true,
                            "SE": true
                        },
                        "draw_color": "rgba(54,184,255,0.6)",
                        "contour_color": "rgba(0,0,0,0.4)",
                        "contour_size": 2,
                        "circle_radius": 6,
                        "features": [],
                        "coord_accuracy": 8
                    };
                    (goog.isDef(src["map_options"]) && src["map_options"]["type"] === "OSM") ? src["map_options"] : src["map_options"] = typic;
                    break;
                case "map_bing":
                    goog.isDef(src["style"]) ? src["style"] : src["style"] = {'height': '250px'};
                    var typic = {
                        "proj": "EPSG:3857",
                        "type": "bing",
                        "output_format": "ewkt",
                        "center": {
                            "coord": [300000, 6000000],
                            "zoom": 5,
                            "scale": 25000000,
                            "extent": [-20026376.39, -20048966.10, 20026376.39, 20048966.10]
                        },
                        "controls": {
                            "MP": true,
                            "ZO": true,
                            "SL": true,
                            "CP": true
                        },
                        "layers": [],
                        "interactions": {
                            "multi_geometry": false,
                            "full_screen": true,
                            "RA": false,
                            "RO": true,
                            "ED": true,
                            "DP": true,
                            "DL": true,
                            "DPol": true,
                            "SE": true
                        },
                        "draw_color": "rgba(54,184,255,0.6)",
                        "contour_color": "rgba(0,0,0,0.4)",
                        "contour_size": 2,
                        "circle_radius": 6,
                        "features": [],
                        "coord_accuracy": 8,
                        "source": {
                            "culture": "fr-FR",
                            "key": "",
                            "style": "Aerial"
                        }
                    };
                    (goog.isDef(src["map_options"]) && src["map_options"]["type"] === "bing") ? src["map_options"] : src["map_options"] = typic;
                    break;
                case "map_vmap":
                    goog.isDef(src["style"]) ? src["style"] : src["style"] = {'height': '250px'};
                    var typic = {
                        "proj": "EPSG:3857",
                        "type": "vmap",
                        "output_format": "ewkt",
                        "center": {
                            "coord": [300000, 6000000],
                            "zoom": 5,
                            "scale": 25000000,
                            "extent": [-20026376.39, -20048966.10, 20026376.39, 20048966.10]
                        },
                        "controls": {
                            "MP": true,
                            "ZO": true,
                            "SL": true,
                            "CP": true
                        },
                        "layers": [],
                        "interactions": {
                            "multi_geometry": false,
                            "full_screen": true,
                            "RA": false,
                            "RO": true,
                            "ED": true,
                            "DP": true,
                            "DL": true,
                            "DPol": true,
                            "SE": true
                        },
                        "draw_color": "rgba(54,184,255,0.6)",
                        "contour_color": "rgba(0,0,0,0.4)",
                        "contour_size": 2,
                        "circle_radius": 6,
                        "features": [],
                        "coord_accuracy": 8
                    };
                    (goog.isDef(src["map_options"]) && src["map_options"]["type"] === "vmap") ? src["map_options"] : src["map_options"] = typic;
                    break;
                case "codemirror":
                    var typic = {
                        "mode": "javascript",
                        "readOnly": false,
                        "styleActiveLine": true,
                        "lineNumbers": true,
                        "lineSeparator": "\r\n",
                        "indentWithTabs": true,
                        "tabSize": 2,
                        "viewportMargin": 50,
                        "theme": "Veremes"
                    };

                    goog.isDef(src["cm_options"]) ? src["cm_options"] : src["cm_options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    goog.isDef(src["ui"]) ? src["ui"] : src["ui"] = true;
                    break;
                case "bo_grid":
                    var typic = {
                        "enableRowSelection": true,
                        "enableSelectAll": true,
                        "enablePagination": false,
                        "enablePaginationControls": false,
                        "enableColumnMenus": false,
                        "enableColumnResizing": false,
                        "appHeader": true,
                        "appHeaderTitleBar": true,
                        "columnDefs": [],
                        "data": []
                    };
                    goog.isDef(src["options"]) ? src["options"] : src["options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    setTimeout(function () {
                        oVFB.reloadForm();
                    });
                    break;
                case "section_grid":
                    var typic = {
                        "enableRowSelection": true,
                        "enableSelectAll": true,
                        "enablePagination": false,
                        "enablePaginationControls": false,
                        "enableColumnMenus": false,
                        "enableColumnResizing": false,
                        "appHeader": true,
                        "appHeaderTitleBar": true,
                        "columnDefs": [],
                        "data": []
                    };
                    goog.isDef(src["options"]) ? src["options"] : src["options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    setTimeout(function () {
                        oVFB.reloadForm();
                    });
                    break;
                case "ui_grid":
                    var typic = {
                        "enableRowSelection": true,
                        "enableSelectAll": true,
                        "enablePagination": false,
                        "enablePaginationControls": false,
                        "enableColumnMenus": false,
                        "enableColumnResizing": false,
                        "appHeader": true,
                        "appHeaderTitleBar": true,
                        "appGridTitle": "Titre",
                        "appEnableDragAndDrop": false,
                        "columnDefs": [],
                        "data": [],
                        "appActions": [],
                        "datasource": {}
                    };

                    goog.isDef(src["options"]) ? src["options"] : src["options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    //
                    angular.element("#studio_form_reader > form").scope()["gridOptions"] = src["options"];
                    // Recharge le formulaire.
                    setTimeout(function () {
                        oVFB.reloadForm();
                    });
                    break;
                case "treeview":
                    var typic = {
                        "showBorder":false,
                        "levels":0,
                        "showCheckbox":true,
                        "expandIcon":"glyphicon glyphicon-folder-close",
                        "collapseIcon":"glyphicon glyphicon-folder-open",
                        "highlightSelected":false,
                        "multiSelect":true,
                        "data":[],
                        "dataLoadingEvent": ""
                    };

                    goog.isDef(src["options"]) ? src["options"] : src["options"] = typic;
                    goog.isDef(src["nb_cols"]) ? src["nb_cols"] : src["nb_cols"] = 12;
                    //
                    //angular.element("#studio_form_reader > form").scope()["gridOptions"] = src["options"];
                    // Recharge le formulaire.
                    setTimeout(function () {
                        oVFB.reloadForm();
                    });
                    break;
                default :
                    if (!src["nb_cols"]) {
                        src["nb_cols"] = 12;
                    }
                    break;
            }
            return icon;
        }
    };

    /**
     * Set the component collapsed or not
     */
    elementFormController["resize"] = function () {
        $scope["collapsed"] = !$scope["collapsed"];
        oVFB.Collapse_[4] = $scope["collapsed"];
        oVFB.resize();
    };

    /**
     * Update scope.aBusinessObjects
     */
    elementFormController["updateBoList"] = function () {

        $scope['aBusinessObjects'] = [];

        var canceler = $q.defer();
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vmap/businessobjects",
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'scope': $scope,
            'timeout': 5000,
            'abord': canceler.promise,
            'success': function (response) {

                if (!goog.isDefAndNotNull(response))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;

                $scope['aBusinessObjects'] = response['data']['data'];
            }
        });
    };

    /**
     * Updates scope.aBoAttributs & scope.aFormAttributs
     * @param {string} sBoId
     */
    elementFormController["updateBoLinkLists"] = function (sBoId) {

        if (!goog.isDefAndNotNull(sBoId)) {
            return 0;
        }

        var aBoFields = [];
        var aFormFields = [];
        var canceler = $q.defer();
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vmap/querys/" + sBoId,
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'scope': $scope,
            'timeout': 5000,
            'abord': canceler.promise,
            'success': function (response) {

                if (!goog.isDefAndNotNull(response))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;

                var aBoFields = Object.keys(response['data']['data'][0]);

                $scope['aBoAttributs'] = aBoFields;
            }
        });

        if (typeof oVFB.getJsonOutput()[$rootScope["selected_form_type"]] !== "undefined") {
            var obj = oVFB.getJsonOutput()[$rootScope["selected_form_type"]]["rows"];
            for (var i = 0; i < obj.length; i++) {
                for (var j = 0; j < obj[i]["fields"].length; j++) {
                    aFormFields.push(obj[i]["fields"][j]["name"]);
                }
            }
        }

        $scope['aFormAttributs'] = aFormFields;

    };

    /**
     * Update scope.aSections
     */
    elementFormController["updateSectionList"] = function () {

        $scope['aBusinessObjects'] = [];

        var canceler = $q.defer();
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/vitissections",
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'params': {
                //                'filter': '"template"=\'workspaceListTpl.html\' AND "lang"=\'' + oVFB.AppProperties.language + '\''
                'filter': {
                    "relation": "AND",
                    "operators": [{
                            "column": "template",
                            "compare_operator": "=",
                            "value": "workspaceListTpl.html"
                        }, {
                            "column": "lang",
                            "compare_operator": "=",
                            "value": oVFB.AppProperties.language
                        }]
                }
            },
            'scope': $scope,
            'timeout': 5000,
            'abord': canceler.promise,
            'success': function (response) {

                if (!goog.isDefAndNotNull(response))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;

                $scope['aSections'] = response['data']['data'];
            }
        });
    };

    /**
     * Updates scope.aSectionAttributs & scope.aFormAttributs
     * @param {string} sSectionId
     */
    elementFormController["updateSectionLinkLists"] = function (sSectionId) {

        $scope['aBusinessObjects'] = [];

        var canceler = $q.defer();
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/vitissections/" + sSectionId,
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'scope': $scope,
            'timeout': 5000,
            'abord': canceler.promise,
            'success': function (response) {

                if (!goog.isDefAndNotNull(response))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data']))
                    return 0;
                if (!goog.isDefAndNotNull(response['data']['data'][0]))
                    return 0;

                var oSection = response['data']['data'][0];

                if (goog.isDefAndNotNull(oSection['ressource_id'])) {
                    ajaxRequest({
                        'method': 'GET',
                        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/" + oSection['ressource_id'],
                        'headers': {
                            'Accept': 'application/x-vm-json'
                        },
                        'scope': $scope,
                        'timeout': 5000,
                        'abord': canceler.promise,
                        'success': function (response) {

                            if (!goog.isDefAndNotNull(response))
                                return 0;
                            if (!goog.isDefAndNotNull(response['data']))
                                return 0;
                            if (!goog.isDefAndNotNull(response['data']['data']))
                                return 0;
                            if (!goog.isDefAndNotNull(response['data']['data'][0]))
                                return 0;

                            var aSectionAttributes = Object.keys(response['data']['data'][0]);

                            $scope['aSectionAttributs'] = aSectionAttributes;
                        }
                    });
                }
            }
        });

        // Attributs du formulaire
        var aFormFields = [];
        if (typeof oVFB.getJsonOutput()[$rootScope["selected_form_type"]] !== "undefined") {
            var obj = oVFB.getJsonOutput()[$rootScope["selected_form_type"]]["rows"];
            for (var i = 0; i < obj.length; i++) {
                for (var j = 0; j < obj[i]["fields"].length; j++) {
                    aFormFields.push(obj[i]["fields"][j]["name"]);
                }
            }
        }

        $scope['aFormAttributs'] = aFormFields;
    };

};
/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/
