/* global goog, angular, nsVFB, oProperties, less, nsUtils, bootbox, vitisApp */

/**
 * @author: Anthony Borghi
 * @author: Armand Bahi
 * @Description: This Object is the studio
 * ce fichier est le coeur de l'architecture le l'application
 */

'use strict';

goog.provide('oVFB');
goog.require('nsUtils');
goog.require('nsVFB.properties');
goog.require('nsVFB.JsonLoader');
goog.require('nsVFB.FormTools');
goog.require('nsVFB.Visualizer');
goog.require('nsVFB.ElementForm');
goog.require('nsVitisComponent.Map');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * oVFB Object
 * @type {object}
 * @export
 */
var oVFB = {}; // instanciation d'un objet vide

/***********************************************************************************
 *                                 Config                                          *
 **********************************************************************************/


oVFB['config'] = {};

/**
 * Initialize the studio
 * @param {object} config
 * @export
 */
oVFB.init = function (config) {
    console.log("oVFB.init: ", config);
    oVFB['config'] = config;
};


/***********************************************************************************
 *                                  Utils                                          *
 **********************************************************************************/

/**
 * Unused Function called on each time the app has to resize
 * @param {boolean} bFullScreen true if fullScreen
 * @export
 */
oVFB.resize = function (bFullScreen) {

};

/***********************************************************************************
 *                               Data_Access                                       *
 **********************************************************************************/

/**
 * getter
 * return {object} Update
 * @export
 */
oVFB.getUpdate = function () {
    return oVFB.Update;
};
/**
 /**
 * setter
 * @param {object} Update
 * @export
 */
oVFB.setUpdate = function (Update) {
    oVFB.Update = Update;
};
/**
 * getter
 * @return {object} Componant FormInfo
 * @export
 */
oVFB.getDevTools = function () {
    return oVFB.oDevTools_;
};
/**
 * getter
 * @return {object} Componant TreeView
 * @export
 */
oVFB.getTreeView = function () {
    return oVFB.oTreeView_;
};
/**
 * getter
 * @return {object} Componant FormTools
 * @export
 */
oVFB.getFormTools = function () {
    return oVFB.oFormTools_;
};
/**
 * getter
 * @return {object} Componant JsonLoader
 * @export
 */
oVFB.getJsonLoader = function () {
    return oVFB.oJsonLoader_;
};
/**
 * getter
 * @return {object} Componant ElementForm
 * @export
 */
oVFB.getElementForm = function () {
    return oVFB.oElementForm_;
};
/**
 * getter
 * @return {object} Componant Visualizer
 * @export
 */
oVFB.getVisualizer = function () {
    return oVFB.oVisualizer_;
};
/**
 * getter
 * @return {object} Json Object
 * @export
 */
oVFB.getJson = function () {
    return oVFB.oJson_;
};
/**
 * setter
 * @param {object} oJson Json Object
 * @export
 */
oVFB.setJson = function (oJson) {
    oVFB.oJson_ = oJson;
};
/**
 * getter
 * @return {string} Javascript sringifier for code Mirror
 * @export
 */
oVFB.getJs = function () {
    return oVFB.sJs_;
};
/**
 * setter
 * @param {string} sJs Javascript sringifier for code Mirror
 * @export
 */
oVFB.setJs = function (sJs) {
    oVFB.sJs_ = sJs;
};
/**
 * getter
 * @return {string} CSS sringifier for code Mirror
 * @export
 */
oVFB.getCss = function () {
    return oVFB.sCSS_;
};
/**
 * setter
 * @param {string} sCss CSS sringifier for code Mirror
 * @export
 */
oVFB.setCss = function (sCss) {
    oVFB.sCSS_ = sCss;
};
/**
 * getter
 * @return {object} JSON Object to work
 * @export
 */
oVFB.getJsonOutput = function () {
    if (!goog.isDef(oVFB.oJsonOutput_)) {
        console.error('oVFB.oJsonOutput_ undefined');
    }
    if (goog.object.isEmpty(oVFB.oJsonOutput_)) {
        console.error('oVFB.oJsonOutput_ is empty');
    }
//    if (!goog.isDef(oVFB.oJsonOutput_)) {
//        oVFB.oJsonOutput_ = {};
//    }
    return oVFB.oJsonOutput_;
};
/**
 * setter
 * @param {object} oJson JSON Object to work
 * @export
 */
oVFB.setJsonOutput = function (oJson) {
    oVFB.oJsonOutput_ = oJson;
};

/**
 * Unselect the fields and return the JSON form
 * @param {object} oJson
 * @returns {object}
 */
oVFB.getUnselectedForm = function (oJson) {

    var oForm;

    for (var sFormName in oJson) {
        oForm = oJson[sFormName];
        if (goog.isDefAndNotNull(oForm['rows'])) {
            for (var i = 0; i < oForm['rows'].length; i++) {
                if (goog.isDefAndNotNull(oForm['rows'][i]['fields'])) {
                    for (var ii = 0; ii < oForm['rows'][i]['fields'].length; ii++) {
                        if (oForm['rows'][i]['fields'][ii]['selected'] === true) {
                            delete oForm['rows'][i]['fields'][ii]['selected'];
                        }
                    }
                }
            }
        }
    }

    return oJson;
};

/**
 * delete formreader attribute as disabled, selected, visible
 * @param {object} oJson
 * @returns {object}
 */
oVFB.cleanFormToSave = function(oJson){

    if(oVFB.getApplication() !== "wab"){
        return oJson;
    }
    
    var oForm;

    for (var sFormName in oJson) {
        oForm = oJson[sFormName];
        if (goog.isDefAndNotNull(oForm['rows'])) {
            for (var i = 0; i < oForm['rows'].length; i++) {
                if (goog.isDefAndNotNull(oForm['rows'][i]['fields'])) {
                    for (var ii = 0; ii < oForm['rows'][i]['fields'].length; ii++) {
                        if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['selected'])) {
                            delete oForm['rows'][i]['fields'][ii]['selected'];
                        }
                        if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['disabled'])) {
                            delete oForm['rows'][i]['fields'][ii]['disabled'];
                        }
                        if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['visible'])) {
                            delete oForm['rows'][i]['fields'][ii]['visible'];
                        }
                    }
                }
            }
        }
    }

    return oJson;
}

/**
 * The the elements of the Json form
 * @param {object} oForm
 * @returns {Array}
 */
oVFB.getFormElems = function (oForm) {

    var aElems = [];
    var aButtons = [];

    // Récupère tous les noms de tous les éléments
    for (var i = 0; i < oForm['rows'].length; i++) {
        if (goog.isDefAndNotNull(oForm['rows'][i]['fields'])) {
            for (var ii = 0; ii < oForm['rows'][i]['fields'].length; ii++) {
                if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['name'])) {
                    aElems.push(oForm['rows'][i]['fields'][ii]['name']);
                }
                if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['buttons'])) {
                    aButtons.push(oForm['rows'][i]['fields'][ii]['name']);
//                    for (var iii = 0; iii < oForm['rows'][i]['fields'][ii]['buttons'].length; iii++) {
//                        if (goog.isDefAndNotNull(oForm['rows'][i]['fields'][ii]['buttons'][iii]['name'])) {
//                            aElems.push(oForm['rows'][i]['fields'][ii]['buttons'][iii]['name']);
//                        }
//                    }
                }
            }
        }
    }
    return {
        'elems': aElems,
        'buttons': aButtons
    };
};

/**
 * Update the element also on the tabs
 * @param {object} current
 * @param {object} old
 */
oVFB.updateElemNameInTabs = function (current, old) {

    var sOldName = old['name'];
    var sCurrentName = current['name'];
    var oJson = oVFB.getJsonOutput();
    var oForm, oTab;

    for (var sFormName in oJson) {
        oForm = oJson[sFormName];
        if (goog.isDefAndNotNull(oForm['tabs'])) {
            if (goog.isDefAndNotNull(oForm['tabs']['list'])) {
                for (var i = 0; i < oForm['tabs']['list'].length; i++) {
                    oTab = oForm['tabs']['list'][i];
                    if (goog.isDefAndNotNull(oTab['elements'])) {
                        if (oTab['elements'].indexOf(sOldName) !== -1) {
                            oTab['elements'].splice(oTab['elements'].indexOf(sOldName), 1, sCurrentName);
                        }
                    }
                }
            }
        }
    }

    oVFB.setJsonOutput(oJson);
};

/**
 * Update the element also on the tabs
 * @param {object} current
 * @param {object} old
 */
oVFB.updateElemNameInWab = function (current, old) {

    var sOldName = old['name'];
    var sCurrentName = current['name'];
    var oJson = oVFB.getJsonOutput();
    var oForm, oGroup;

    for (var sFormName in oJson) {
        oForm = oJson[sFormName];
        if (goog.isDefAndNotNull(oForm['wab'])) {
            for (var sState in oForm['wab']) {
                for (var sGroup in oForm['wab'][sState]) {
                    oGroup = oForm['wab'][sState][sGroup];
                    if (goog.isDefAndNotNull(oGroup[sOldName])) {
                        oGroup[sCurrentName] = oGroup[sOldName];
                        delete oGroup[sOldName];
                    }
                }
            }
        }

    }

    oVFB.setJsonOutput(oJson);
};

/**
 * Check the existance of the elems defined in oTabs in aElems
 * @param {objet} oTabs
 * @param {objet} aElems
 * @returns {object} oTabs
 */
oVFB.checkElemsOnTabs = function (oTabs, aElems) {

    var oTab;
    if (goog.isDefAndNotNull(oTabs['list'])) {
        for (var i = 0; i < oTabs['list'].length; i++) {
            oTab = oTabs['list'][i];
            if (goog.isDefAndNotNull(oTab['elements'])) {

                for (var ii = oTab['elements'].length - 1; ii >= 0; ii--) {
                    if (aElems.indexOf(oTab['elements'][ii]) === -1) {
                        console.error("Element " + oTab['elements'][ii] + " is not in elements list");
                        oTab['elements'].splice(ii, 1);
                    }
                }
            }
        }
    }

    return oTabs;
};

/**
 * Vérifie l'exsitance des éléments de wab dans elems
 * et ajoute les elements de elems non définis dans wab
 * @param {object} oWab
 * @param {object} aElems
 * @returns {object} oWab
 */
oVFB.checkElemsOnWab = function (oWab, aElems, aStates, aGroups) {
    for (var i = 0; i < aStates.length; i++) {
        if (!goog.isDefAndNotNull(oWab[aStates[i]])) {
            oWab[aStates[i]] = {};
            //console.log("Ajout de l'état : " + aStates[i]);
        }
    }
    for (var state in oWab) {
        if (aStates.indexOf(state) === -1) {
            delete oWab[state];
            //console.log("Suppression de l'état : " + state);
        } else {
            for (var i = 0; i < aGroups.length; i++) {
                if (!goog.isDefAndNotNull(oWab[state][aGroups[i]])) {
                    oWab[state][aGroups[i]] = {};
                    //console.log("Ajout du groupe : " + aGroups[i] + " Dans l'état : " + state);
                }
            }
            for (var group in oWab[state]) {
                if (aGroups.indexOf(group) === -1) {
                    delete oWab[state][group];
                    //console.log("Supr du groupe : " + group + " Dans l'état : " + state);
                } else {
                    // Retire l'élément de oWab[state][group] si il n'est pas dans aElems
                    for (var sWabElem in oWab[state][group]) {
                        if (aElems.indexOf(sWabElem) === -1) {
                            //console.error("Element " + sWabElem + " is not in elements list");
                            delete oWab[state][group][sWabElem];
                        }
                    }

                    // Ajoute l'élément dans oWab[state][group] si il n'existe pas
                    for (var i = 0; i < aElems.length; i++) {
                        if (!goog.isDefAndNotNull(oWab[state][group][aElems[i]])) {
                            oWab[state][group][aElems[i]] = '';
                        }
                    }
                }

            }
        }
    }
    return oWab;
};

/**
 * Clean oTabs from unwanted keys ($$hashKey, studio_mode)
 * @param {object} oTabs
 * @returns {object} oTabs
 */
oVFB.cleanTabs = function (oTabs) {

    var oTab;
    if (goog.isDefAndNotNull(oTabs['list'])) {
        for (var i = 0; i < oTabs['list'].length; i++) {
            oTab = oTabs['list'][i];
            if (goog.isDefAndNotNull(oTab['$$hashKey'])) {
                delete oTab['$$hashKey'];
            }
            if (goog.isDefAndNotNull(oTab['studio_mode'])) {
                delete oTab['studio_mode'];
            }
        }
    }

    return oTabs;
};

/**
 * getter
 * @return {string} Name of Tree for drag and drop
 * @export
 */
oVFB.getTreeDnD = function () {
    return oVFB.tree_;
};

/**
 * setter
 * @param {string} str Name of Tree for drag and drop
 * @export
 */
oVFB.setTreeDnD = function (str) {
    oVFB.tree_ = str;
};

/**
 * getter
 * @return {string} Vitis's token 
 * @export
 */
oVFB.getToken = function () {
    return oVFB.token;
};

/**
 * setter
 * @param {string} token Vitis's token needed to load file from server
 */
oVFB['setToken'] = function (token) {
    oVFB.token = token;
};

/**
 * getter
 * @return {string} Vitis's token 
 * @export
 */
oVFB.getId = function () {
    return oVFB.id;
};

oVFB.getApplication = function () {
    return oVFB.AppName;
};

/**
 * setter
 * @param {integer} id Vitis's workspace's id needed to load file from server
 */
oVFB['setId'] = function (id) {
    oVFB.id = id;
};

oVFB['setContainer'] = function (str) {
    oVFB.el = str;
};

oVFB['setAppProperties'] = function (obj) {
    oVFB.AppProperties = obj;
};

oVFB['setApplication'] = function (sApp) {
    oVFB.AppName = sApp;
};

oVFB['reset'] = function () {
//    oVFB.setJsonOutput({});
};
/***********************************************************************************
 *                              Initialisation                                     *
 **********************************************************************************/

/**
 * Angular module
 * @type {!angular.Module}
 */
oVFB.module = angular.module('vfb', ['ui.codemirror', 'ui.grid', 'ui.grid.autoResize', 'formReader']);
/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * load the Main View of application
 * @export
 */
oVFB.studioMainDirective = function () {
    oVFB.log('nsVFB.MainDirective');

    if (!goog.isDefAndNotNull(oVFB['config'])) {
        console.error("oVFB['config'] not defined, please use oVFB.init(config)");
    }

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppStudioMainController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/MainTemplate.html'
    };
};

oVFB.module.directive('appStudioMainDirective', oVFB.studioMainDirective);
/*********************************Controller***************************************/
/**
 * studioMainController
 * @param {object} $scope
 * @param {object} $q
 * @param {object} $timeout
 * @export
 */
oVFB.studioMainController = function ($scope, $q, $timeout, $rootScope) {
    oVFB.log('nsVFB.MainController');

    /**
     * Pointer on "this"
     * @type oVFB.studioMainController
     * @private
     */
    var this_ = this;

    /**
     * @private
     */
    this.$scope_ = $scope;

    /**
     * @private
     */
    this.$rootScope_ = $rootScope;

    /**
     * @private
     */
    this.$q_ = $q;

    /**
     * @private
     */
    this.$timeout_ = $timeout;

    /**
     * @private
     */
    this.iLocalDatabaseChangeCounter_ = 0;

    /**
     * Contains the trads
     */
    this['text'] = {};

    /**
     * Utilisé par les child
     */
    $scope['aCollapsed'] = oVFB.Collapse_;

    /**
     * Contains the trads (used by the sub-components)
     */
    $scope['text'] = {};

    /**
     * The JSON form
     */
    $scope['jsonOutput'] = {};

    /**
     * Datasources on the $scope['jsonOutput']
     */
    $scope['datasources'] = {};

    /**
     * The selected datasource on the datasouces modal
     */
    $scope['selectedDatasource'] = {};

    /**
     * Web services
     */
    $scope['webservices'] = [];

    /**
     * Business objects
     */
    $scope['businessObjects'] = [];

    /**
     * Ressources of a web service
     */
    $scope['ressources'] = [];

    /**
     * List of avaliable tables for an external database
     */
    $scope['aExternalDatabaseTables'] = [];

    /**
     * List of avaliable schemas for an local database
     */
    $scope['schemas'] = [];

    /**
     * List of avaliable databases
     */
    $scope['databases'] = [];

    /**
     * List of avaliable tables for an local database
     */
    $scope['tables'] = [];

    /**
     * The selected datasource on the modal #studio-datasource-modal
     */
    $scope['selectedDatasource'] = {};

    /**
     * The edited datasource on the modal #studio-datasource-edit-modal
     */
    $scope['editedDatasource'] = {};

    /**
     * new datasource on the modal #studio-datasource-add-modal
     */
    $scope['newSource'] = {
        'options': ['Value one|1', 'Value two|2', 'Value three|3'],
        'result_options': [{
                'label': 'Value one',
                'value': '1'
            }, {
                'label': 'Value two',
                'value': '2'
            }, {
                'label': 'Value three',
                'value': '3'
            }]
    };

    $scope["wabVisualizer"] = false;
    /**
     * Datasource Codemirror options
     */
    $scope['editorOptions'] = {
        'mode': 'schema',
        'lineNumbers': false,
        'lineSeparator': '\n',
        'theme': 'Veremes',
        'onLoad': function (cm_) {
            /*$scope.$watch("editedDatasource.dataType", function (value) {
             if (value === 'text') {
             
             $timeout(function () {
             $scope.refresh = true;
             $timeout(function () {
             $scope.refresh = false;
             }, 100);
             }, 500);
             }
             });*/
        }
    };

    /**
     * Add modal test grid datasource options
     */
    $scope['studioAddModalTestGridOptions'] = {
        'data': [],
        'enableColumnMenus': false,
        'enableColumnResizing': true,
        'onRegisterApi': function (studioAddModalTestGridApi) {
            $scope.studioAddModalTestGridApi = studioAddModalTestGridApi;
        }
    };

    /**
     * Edit modal test grid datasource options
     */
    $scope['studioEditModalTestGridOptions'] = {
        'data': [],
        'enableColumnMenus': false,
        'enableColumnResizing': true,
        'onRegisterApi': function (studioEditModalTestGridApi) {
            $scope.studioEditModalTestGridApi = studioEditModalTestGridApi;
        }
    };

    /**
     * Datasources grid options
     */
    $scope['studioDatasourcesGridOptions'] = {
        'data': [],
        'columnDefs': [{
                'field': 'name',
                'displayName': 'Nom'
            }],
        'enableColumnMenus': false,
        'enableColumnResizing': true,
        'enableRowSelection': true,
        'multiSelect': false,
        'enableFullRowSelection': true,
        'onRegisterApi': function (datasourcesGridApi) {
            $scope['datasourcesGridApi'] = datasourcesGridApi;
            datasourcesGridApi['selection']['on']['rowSelectionChanged']($scope, function (row) {
                $scope['selectedDatasource'] = angular.copy($scope['datasources'][row['entity']['id']]);
                $scope['selectedDatasource']['id'] = row['entity']['id'];
                // Add usefull params on the selected datasource
                this_.setDatasourceContent($scope['selectedDatasource']);
            });

        }
    };

    /**
     * Tabs
     */
    $scope['tabs'] = {};

    /**
     * Form elements list
     */
    $scope['elems'] = [];

    /**
     * Test tab name of the form (display, update, insert)
     * @type string
     */
    $scope['sTestTabFormDefinitionName'] = '';

    /**
     * Test tab Values of the form
     * @type object
     */
    $scope['oTestTabFormValues'] = {};

    /**
     * Test tab Form
     * @type object
     */
    $scope['oTestTabFormDefinition'] = {};

    /**
     * Test tab Scope to use for the form events
     * @type object
     */
    $scope['oTestTabFormScope'] = {};

    /**
     * Test wab name of the form (display, update, insert)
     * @type string
     */
    $scope['sTestWabFormDefinitionName'] = '';

    /**
     * Test wab Values of the form
     * @type object
     */
    $scope['oTestWabFormValues'] = {};

    /**
     * Test wab Form
     * @type object
     */
    $scope['oTestWabFormDefinition'] = {};

    /**
     * Test wab Scope to use for the form events
     * @type object
     */
    $scope['oTestWabFormScope'] = {};

    /**
     * Properties
     * @type object
     */
    $scope['oProperties'] = oVFB.AppProperties;

    /**
     * Token
     * @type string
     */
    $scope['sToken'] = sessionStorage['session_token'];

    /**
     * 
     */
    $scope['wab'] = {};

    /**
     * The wab goup list
     */
    $scope['wabGroups'] = [];

    /**
     * The wab state list
     */
    $scope['wabStates'] = [];

    /**
     * The wab goup list
     */
    $scope['module'] = "";

    /**
     * The wab goup list
     */
    $scope['object'] = "";

    /**
     * The selected wab group
     */
    $scope['wabSelectedGroup'] = '';

    /**
     * The selected wab state
     */
    $scope['wabSelectedState'] = '';

    $scope['applicationName'] = oVFB.getApplication();

    // Get fichier de langue
    ajaxRequest({
        'method': 'GET',
        'url': 'javascript/externs/studio/lang/lang-' + oVFB.AppProperties['language'] + '.json',
        'scope': this.$scope_,
        'success': function (response) {
            // Utilisé par les autres cpmposants
            $scope['text'] = response['data'];
            // Utilisé dans le template
            this_['text'] = response['data'];
        },
        'error': function (response) {
            console['error']('ERROR : (AJAX request : ' + status + ' ) On loading Language, contact Veremes please');
        }
    });

    // récupère les différents web services
    ajaxRequest({
        'method': 'GET',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/webservices",
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'params': {
            'attributs': 'name'
        },
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                console.error("response.data['data'] not defined");
                return;
            }
            $scope['webservices'] = response.data['data'];
        }
    });

    if ($scope['applicationName'] === "vmap")
        // récupère les différents objets métier
        ajaxRequest({
            'method': 'GET',
            'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vmap/businessobjects",
            'headers': {
                'Accept': 'application/x-vm-json'
            },
            'scope': this.$scope_,
            'params': {
                "order_by": "title"
            },
            'success': function (response) {

                if (!goog.isDefAndNotNull(response.data['data'])) {
                    console.error("response.data['data'] not defined");
                    return;
                }

                var aBusinessObjects = response.data['data'];
                for (var i = 0; i < aBusinessObjects.length; i++) {
                    aBusinessObjects[i]['sql_form'] = 'SELECT * FROM ' + aBusinessObjects[i]['schema'] + '.' + aBusinessObjects[i]['table'];
                }

                $scope['businessObjects'] = [];

                for (var i = 0; i < aBusinessObjects.length; i++) {
                    $scope['businessObjects'].push({
                        'title': aBusinessObjects[i]['title'],
                        'business_object_id': aBusinessObjects[i]['business_object_id'],
                        'sql_form': aBusinessObjects[i]['sql_form'],
                        'sql_summary': aBusinessObjects[i]['sql_summary'],
                        'sql_list': aBusinessObjects[i]['sql_list']
                    });
                }
            }
        });

    // Vide la grille datasources lors que la modale est fermée
    $('#studio-datasource-modal').on('hide.bs.modal', function (e) {
        oVFB.unselectAll();
        this_.clearDatasourcesGrid();
        oVFB.reloadForm();
    });

    // Vide la grille test grid lors que la modale est fermée
    $('#studio-datasource-add-modal').on('hide.bs.modal', function (e) {
        // Vide les listes
        $scope['aExternalDatabaseTables'].length = 0;

        $scope['schemas'].length = 0;
        $scope['tables'].length = 0;
        // Vide les grilles
        this_.clearTestGrids();
    });

    // Vide la grille test grid lors que la modale est fermée
    $('#studio-datasource-edit-modal').on('hide.bs.modal', function (e) {
        // Vide les listes
        $scope['aExternalDatabaseTables'].length = 0;

        $scope['schemas'].length = 0;
        $scope['tables'].length = 0;
        // Vide les grilles
        this_.clearTestGrids();
    });

    $scope.$on('updateForm', function (event, data) {
        $scope.$applyAsync(function () {
            $scope['jsonOutput'] = data;
        });
    });

    // Formreader prévisualisation onglets
    $scope.$on('updateTestTabForm', function (event, data) {

        //si donnée valide
        if (data[$scope['selected_form_type']]) {
            var oJson = data[$scope['selected_form_type']];

            //si pas d'id on en fabrique un
            for (var i = 0; i < oJson['rows'].length; i++) {
                for (var j = 0; j < oJson['rows'][i]['fields'].length; j++) {
                    if (!oJson['rows'][i]['fields'][j]['id']) {
                        oJson['rows'][i]['fields'][j]['id'] = oJson['rows'][i]['fields'][j]['name'] + '_' + (i + 1) + '_' + (j + 1);
                    }
                }
            }

            /**
             * !Important! utilisation d'un pointeur permet que les changements 
             * de oTestTabFormDefinition affecteront getJsonOutput
             */
            $scope['oTestTabFormDefinition'] = data;

            // reinit variables
            $scope['sTestTabFormDefinitionName'] = $scope['selected_form_type'];
            $scope['title'] = oJson['title'];

            // Valeurs par défaut)
            if (!goog.isDef($scope['oTestTabFormValues']))
                $scope['oTestTabFormValues'] = {};
            if (!goog.isDef($scope['oTestTabFormValues'][$scope['sTestTabFormDefinitionName']]))
                $scope['oTestTabFormValues'][$scope['sTestTabFormDefinitionName']] = {};

            // Refresh le formReader
            angular.element($('#studio_test_tabs_form_reader').children()).scope()['ctrl'].refreshForm();

        } else {
            oVFB.log('visualizerFormModeController. Load JSON form fail: ' + $scope['selected_form_type'] + ' undefined in ', data);
        }
    });

    $scope.$on("loadWABGroups", function (event, data) {
        $scope["module"] = data["module"];
        $scope["object"] = data["object"];

        this_.loadWabGoups($scope["module"]);
    });

    // Formreader prévisualisation wab
    $scope.$on('updateTestWabForm', function (event, data) {

        //si donnée valide
        if (data[$scope['selected_form_type']]) {
            var oJson = data[$scope['selected_form_type']];

            //si pas d'id on en fabrique un
            for (var i = 0; i < oJson['rows'].length; i++) {
                for (var j = 0; j < oJson['rows'][i]['fields'].length; j++) {
                    if (!oJson['rows'][i]['fields'][j]['id']) {
                        oJson['rows'][i]['fields'][j]['id'] = oJson['rows'][i]['fields'][j]['name'] + '_' + (i + 1) + '_' + (j + 1);
                    }
                }
            }

            /**
             * !Important! utilisation d'un pointeur permet que les changements 
             * de oTestWabFormDefinition affecteront getJsonOutput
             */
            $scope['oTestWabFormDefinition'] = data;

            // reinit variables
            $scope['sTestWabFormDefinitionName'] = $scope['selected_form_type'];
            $scope['title'] = oJson['title'];

            // Valeurs par défaut)
            if (!goog.isDef($scope['oTestWabFormValues']))
                $scope['oTestWabFormValues'] = {};
            if (!goog.isDef($scope['oTestWabFormValues'][$scope['sTestWabFormDefinitionName']]))
                $scope['oTestWabFormValues'][$scope['sTestWabFormDefinitionName']] = {};

            // Refresh le formReader
            var oFormReaderScope = angular.element($('#studio_test_wab_form_reader').children()).scope();
            if (goog.isDefAndNotNull(oFormReaderScope)) {
                oFormReaderScope.$applyAsync(function () {
//                    console.log("update value");
//                    console.log($scope['wabSelectedState']);
//                    console.log($scope['wabSelectedGroup']);
                    oFormReaderScope['wabState'] = $scope['wabSelectedState'];
                    oFormReaderScope['wabGroup'] = $scope['wabSelectedGroup'];
                    oFormReaderScope['ctrl'].refreshForm();
                });
            }
        } else {
            oVFB.log('visualizerFormModeController. Load JSON form fail: ' + $scope['selected_form_type'] + ' undefined in ', data);
        }
    });

    // Formreader prévisualisation onglets
    $scope.$watch('tabs', function () {
        this_.updateTestTabForm();
    }, true);

    $scope.$watch('wabSelectedGroup', function () {
        if (goog.isString($scope['wabSelectedState'])
                && goog.isString($scope['wabSelectedGroup'])
                && $scope['wabSelectedGroup'] !== ''
                && $scope['wabSelectedState'] !== '') {
//            console.log("update group")
            this_.updateTestWabForm();
        }
    });

    $scope.$watch('wabSelectedState', function () {
        if (goog.isString($scope['wabSelectedState'])
                && goog.isString($scope['wabSelectedGroup'])
                && $scope['wabSelectedGroup'] !== ''
                && $scope['wabSelectedState'] !== '') {
//            console.log("update state")
            this_.updateTestWabForm();
        }
    });
};
oVFB.module.controller('AppStudioMainController', ['$scope', '$q', oVFB.studioMainController]);

// filtre wabStates
oVFB.module.filter('sortStates', function(){
    return function(input,sortBy) {
        var sortedOutput = [];
        for (var key in sortBy) {
            input[sortBy[key]]["name"] = sortBy[key];
            sortedOutput.push(input[sortBy[key]]);
        }
        return sortedOutput;
    };
});

/**
 * Show the tabs modal
 * @export
 */
oVFB.studioMainController.prototype.showTabsManagerModal = function () {
    oVFB.log('studioMainController.showTabsManagerModal');

    // Modification du studio 
    oVFB.Update = true;

    var $scope = this.$scope_;
    var sFormDefinitionName = $scope["selected_form_type"];
    var oElems = oVFB.getFormElems($scope['jsonOutput'][sFormDefinitionName]);

    oVFB.unselectAll();

    $scope['jsonOutput'] = oVFB.getJsonOutput();
    $scope['tabs'] = angular.copy($scope['jsonOutput'][sFormDefinitionName]['tabs']);
    $scope['elems'] = oElems['elems'];
    $scope['buttons'] = oElems['buttons'];

    // Vérifie l'exsitance des éléments dans tabs dans elems
    $scope['tabs'] = oVFB.checkElemsOnTabs($scope['tabs'], $scope['elems']);

    this.updateTestTabForm();

    $('#studio-tabsmanager-modal').modal('show');
};

/**
 * Toggle sElem in oTab
 * @param {string} sElem
 * @param {object} oTab
 * @export
 */
oVFB.studioMainController.prototype.toggleElemOnTab = function (sElem, oTab) {

    // Element déjà présent
    if (oTab.elements.indexOf(sElem) !== -1) {
        oTab.elements.splice(oTab.elements.indexOf(sElem), 1);
    } else {
        oTab.elements.push(sElem);
    }

};

/**
 * Create button method for wab
 * @export
 */
oVFB.studioMainController.prototype.generateWabMethod = function(){
    //console.log(this.$scope_);
    var aGrp = {};
    var oJson = oVFB.getJsonOutput();
    var sLabelKey = oJson["update"]["title"].replace("_TITLE", "_FORM_");
    var oLangAddons = {};

    for(var i = 0; i < this.$scope_["aBoMethods"].length; i++){
        if(goog.isDefAndNotNull(this.$scope_["aBoMethods"][i]["selected"])){
            if(this.$scope_["aBoMethods"][i]["selected"]){
                if(!goog.isDefAndNotNull(aGrp[this.$scope_["aBoMethods"][i]["group"]])){
                    // créer le groupe
                    aGrp[this.$scope_["aBoMethods"][i]["group"]] = {
                            'type' : 'button',
                            'nb_cols' : 12,
                            'class' : 'btn-ungroup btn-group-sm',
                            'name' : this.$scope_["aBoMethods"][i]["group"],
                            'id' : this.$scope_["aBoMethods"][i]["group"],
                            'buttons' : []
                        }
                }
                // créer btn dans le group
                var sLabelKeyMethod = sLabelKey + this.$scope_["aBoMethods"][i]["name"].toUpperCase()
                aGrp[this.$scope_["aBoMethods"][i]["group"]]['buttons'].push({
                    "type": "submit",
                    "name": "form_submit",
                    "label": sLabelKeyMethod,
                    "class": "btn-primary",
                    "event": "callBoMethod('"+this.$scope_["aBoMethods"][i]["name"]+"')"
                  });

                // add label in lang.json string
                oLangAddons[sLabelKeyMethod] = this.$scope_["aBoMethods"][i]["label"]; 
            }
        }
    }

    // pour chaque groupe inserer le champs dans le formulaire
    for(var sKey in aGrp){
        oJson["update"]["rows"].push({"fields":[aGrp[sKey]]});
    }
    //sauvegarde du formulaire
    oVFB.setJsonOutput(oJson);
    this.$scope_.$broadcast("updateForm", oJson);

    // save lang.json
    this.saveWabModuleLangJsonAdd(oLangAddons);

    $('#studio-wabmanager-method-modal').modal('hide');
}

oVFB.studioMainController.prototype.saveWabModuleLangJsonAdd = function(oLangAddon){
    var $scope = this.$scope_;

    ajaxRequest({
        'method': 'PUT',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/wab/modules/" + $scope["module"],
        'headers': {
            'Accept': 'application/x-vm-json'//,
            //'X-HTTP-Method-Override': 'GET'
        },
        'data': {
            "sLangAddon": oLangAddon
        },
        'scope': $scope,
        'success': function (response) {}
    });
}

/**
 * Get group list or this object WAB
 * @param {string} sModuleName
 */
oVFB.studioMainController.prototype.loadWabGoups = function (sModuleName) {

    var $scope = this.$scope_;
    var $this = this;

    ajaxRequest({
        'method': 'POST',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/wab/groups",
        'headers': {
            'Accept': 'application/x-vm-json',
            'X-HTTP-Method-Override': 'GET'
        },
        'scope': $scope,
        'data': {
            "order_by": "name",
            "distinct": true,
            "filter": {
                'column': 'module_id',
                'compare_operator': '=',
                'value': sModuleName
            }
        },
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                console.error("response.data['data'] not defined");
                return;
            }
            $scope['wabGroups'] = [];
            for (var i = 0; i < response.data['data'].length; i++) {
                $scope['wabGroups'].push(response.data['data'][i]["name"]);
            }
            $this.loadWabStates($scope["module"], $scope["object"]);
        }
    });
};

/**
 * Get group list or this object WAB
 * @param {string} sModuleName
 * @param {string} sObjectName
 */
oVFB.studioMainController.prototype.loadWabStates = function (sModuleName, sObjectName) {

    var $scope = this.$scope_;
    var $this = this;

    ajaxRequest({
        'method': 'POST',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/wab/states",
        'headers': {
            'Accept': 'application/x-vm-json',
            'X-HTTP-Method-Override': 'GET'
        },
        'scope': $scope,
        'data': {
            "order_by": "progress_lvl",
            "sort_order" : 'ASC',
            // "attributs": "name",
            "distinct": true,
            'filter': {
                "relation": "AND",
                "operators": [{
                        'column': 'module_id',
                        'compare_operator': '=',
                        'value': sModuleName
                    }, {'column': 'bo_name',
                        'compare_operator': '=',
                        'value': sObjectName
                    }]
            }
        },
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                console.error("response.data['data'] not defined");
                return;
            }
            //state.group
            $scope['wabStates'] = [];
            for (var i = 0; i < response.data['data'].length; i++) {
                $scope['wabStates'].push(response.data['data'][i]["name"]);
            }
//            console.log($scope['wabStates']);
            $this.createEmptyWabObject();
        }
    });
};

/**
 * Generate a basic wab object
 * @export
 */
oVFB.studioMainController.prototype.createEmptyWabObject = function () {

    var $scope = this.$scope_;

    for (var i = 0; i < $scope['wabStates'].length; i++) {
        $scope["wab"][$scope['wabStates'][i]] = {};
        for (var j = 0; j < $scope['wabGroups'].length; j++) {
            $scope["wab"][$scope['wabStates'][i]][$scope["wabGroups"][j]] = {};
        }
    }
};

/**
 * Add a tab
 * @param {object|undefined} oTab
 * @export
 */
oVFB.studioMainController.prototype.addTab = function (oTab) {

    var $scope = this.$scope_;

    if (!goog.isDefAndNotNull(oTab)) {
        oTab = {
            'label': $scope['text']['Loader']['Tab'],
            'elements': []
        };
    }

    $scope.$applyAsync(function () {
        $scope['tabs']['list'].push(oTab);
    });
};

/**
 * Ask and remove oTab from scope.tabs
 * @param {object} oTab
 * @export
 */
oVFB.studioMainController.prototype.askAndRemoveTab = function (oTab) {

    var this_ = this;
    var $scope = this.$scope_;

    var oModal = bootbox.confirm('<h4>' + $scope['text']['Loader']['AskRemoveTab'] + '</h4><br>' + oTab['label'], function (result) {
        if (result) {
            this_.removeTab(oTab);
        }
    });
    // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
    oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
};

/**
 * Remove oTab from scope.tabs
 * @param {object} oTab
 * @export
 */
oVFB.studioMainController.prototype.removeTab = function (oTab) {

    var $scope = this.$scope_;

    if ($scope['tabs']['list'].indexOf(oTab) !== -1) {
        $scope.$applyAsync(function () {
            $scope['tabs']['list'].splice($scope['tabs']['list'].indexOf(oTab), 1);
        });
    } else {
        console.error('Tab not founted in scope.tabs.list');
    }
};

/**
 * Move oTab on scope.tabs
 * @param {object} oTab
 * @param {string} sDirection (left, right)
 * @export
 */
oVFB.studioMainController.prototype.moveTab = function (oTab, sDirection) {

    var $scope = this.$scope_;
    var moveIndex = 0;

    if ($scope['tabs']['list'].indexOf(oTab) !== -1) {
        $scope.$applyAsync(function () {

            var tabIndex = $scope['tabs']['list'].indexOf(oTab);

            if (sDirection === 'left') {
                moveIndex = -1;
            }
            if (sDirection === 'right') {
                moveIndex = 1;
            }

            if (tabIndex + moveIndex >= 0 && tabIndex + moveIndex < $scope['tabs']['list'].length) {

                // Enleve oTab
                $scope['tabs']['list'].splice(tabIndex, 1);

                // Rajoute oTab
                $scope['tabs']['list'].splice(tabIndex + moveIndex, 0, oTab);

            }
        });
    } else {
        console.error('Tab not founted in scope.tabs.list');
    }
};

/**
 * Alect all the elements on the tab
 * @param {object} oTab
 * @export
 */
oVFB.studioMainController.prototype.selectAllElems = function (oTab) {

    var $scope = this.$scope_;

    oTab.elements = [];

    for (var i = 0; i < $scope['elems'].length; i++) {
        oTab.elements.push($scope['elems'][i]);
    }
};

/**
 * Apply oTabs on the form
 * @param {object} oTabs
 * @export
 */
oVFB.studioMainController.prototype.saveTabs = function (oTabs) {

    var $scope = this.$scope_;
    var sFormDefinitionName = $scope["selected_form_type"];

    $('#studio-tabsmanager-modal').modal('hide');

    oTabs = oVFB.cleanTabs(oTabs);

    $scope['jsonOutput'][sFormDefinitionName]['tabs'] = oTabs;
    oVFB.getJsonOutput($scope['jsonOutput']);
    $scope.$broadcast("updateForm", $scope['jsonOutput']);
};

/**
 * Update the Tab test form
 */
oVFB.studioMainController.prototype.updateTestTabForm = function () {

    var $scope = this.$scope_;
    var oForm = oVFB.getUnselectedForm($scope['jsonOutput']);
    var sFormDefinitionName = $scope["selected_form_type"];

    if (goog.isDefAndNotNull(oForm)) {
        if (goog.isDefAndNotNull(oForm[sFormDefinitionName])) {
            if (goog.isDefAndNotNull(oForm[sFormDefinitionName]['tabs'])) {
                oForm[sFormDefinitionName]['tabs'] = angular.copy($scope['tabs']);
                $scope.$broadcast('updateTestTabForm', oForm);
            }
        }
    }
};

/**
 * Show the wab modal
 * @export
 */
oVFB.studioMainController.prototype.showWabManagerModal = function () {
    oVFB.log('studioMainController.showWabManagerModal');

    var $scope = this.$scope_;
    var sFormDefinitionName = $scope["selected_form_type"];
    var oElems = oVFB.getFormElems($scope['jsonOutput'][sFormDefinitionName]);

    oVFB.unselectAll();

    $scope['jsonOutput'] = oVFB.getJsonOutput();
    if (goog.isDefAndNotNull($scope['jsonOutput'][sFormDefinitionName]['wab'])) {
        $scope['wab'] = angular.copy($scope['jsonOutput'][sFormDefinitionName]['wab']);
    }
    $scope['elems'] = oElems['elems'];
    $scope['buttons'] = oElems['buttons'];

    // Vérifie l'exsitance des éléments de wab dans elems
    // et ajoute les elements de elems non définis dans wab
    $scope['wab'] = oVFB.checkElemsOnWab($scope['wab'], $scope['elems'], $scope['wabStates'], $scope['wabGroups']);

    $('#studio-wabmanager-modal').modal('show');

//    console.log($scope['wab']);
};

/**
 * Used to toggle a checkbox on the wab matrice
 * @param {string} sElem
 * @param {object} oState
 * @param {string} sWabSelectedGroup
 * @param {string} sAction
 * @export
 */
oVFB.studioMainController.prototype.toggleElemOnWab = function (sElem, oState, sWabSelectedGroup, sAction) {
    if (goog.isDefAndNotNull(oState)) {
        if (goog.isDefAndNotNull(oState[sWabSelectedGroup])) {

            var sNextValue = '';

            // Si déjà défini
            if (goog.isDefAndNotNull(oState[sWabSelectedGroup][sElem])) {

                sNextValue = sCurrentValue;
                var sCurrentValue = oState[sWabSelectedGroup][sElem];

                // Checkbox lecture
                if (sAction === 'r') {
                    if (sCurrentValue === '') {
                        sNextValue = 'r';
                    } else {
                        sNextValue = '';
                    }
                }
                // Checkbox écriture
                if (sAction === 'rw') {
                    if (sCurrentValue === '') {
                        sNextValue = 'rw';
                    } else if (sCurrentValue === 'r') {
                        sNextValue = 'rw';
                    } else {
                        sNextValue = 'r';
                    }
                }
                oState[sWabSelectedGroup][sElem] = sNextValue;
            } else {
                oState[sWabSelectedGroup][sElem] = sAction;
            }

            this.updateTestWabForm();
        }
    }
};

/**
 * Apply wab on the form
 * @param {object} wab
 * @export
 */
oVFB.studioMainController.prototype.saveWab = function (oWab) {
    var $scope = this.$scope_;
    var sFormDefinitionName = $scope["selected_form_type"];
    var oFinalWab = {};
    $('#studio-wabmanager-modal').modal('hide');

    for(var sState in oWab ){
        oFinalWab[sState] = {};
        for(var sGrp in oWab[sState]){
            if(sGrp !== "name"){
                oFinalWab[sState][sGrp] = oWab[sState][sGrp];
            }
        }
    }

    console.log(oFinalWab);

    $scope['jsonOutput'][sFormDefinitionName]['wab'] = oFinalWab;
    oVFB.setJsonOutput($scope['jsonOutput']);
    $scope.$broadcast("updateForm", $scope['jsonOutput']);
};

/**
 * Update the Tab test form
 */
oVFB.studioMainController.prototype.updateTestWabForm = function () {
    var $scope = this.$scope_;
    var oForm = oVFB.getUnselectedForm($scope['jsonOutput']);
    var sFormDefinitionName = $scope["selected_form_type"];
    if (goog.isDefAndNotNull(oForm)) {
        if (goog.isDefAndNotNull(oForm[sFormDefinitionName])) {
            oForm[sFormDefinitionName]['wab'] = angular.copy($scope['wab']);
            $scope.$broadcast('updateTestWabForm', oForm);
        }
    }
};

/**
 * Show the datasource modal and set the default options
 * @export
 */
oVFB.studioMainController.prototype.showDatasourcesModal = function () {
    // Modification du studio 
    oVFB.Update = true;
    oVFB.log('studioMainController.showDatasourcesModal');

    var $scope = this.$scope_;

    $scope['jsonOutput'] = oVFB.getJsonOutput();

    if (!goog.isDef($scope['jsonOutput']['datasources']) || !goog.isObject($scope['jsonOutput']['datasources']) || goog.isArray($scope['jsonOutput']['datasources'])) {
        $scope['jsonOutput']['datasources'] = {};
    }

    $scope['datasources'] = $scope['jsonOutput']['datasources'];

    oVFB.unselectAll();

    $('#studio-datasource-modal').modal('show');

    $scope['selectedDatasource'] = {};

    // rempli $scope['studioDatasourcesGridOptions']['data']
    this.setStudioGridDatasources();

    var $timeout = angular.element(vitisApp.appMainDrtv).injector().get(["$timeout"]);
    $timeout(function () {
        if ($scope['datasourcesGridApi']['grid']['rows'].length > 0 && $scope['datasourcesGridApi']['selection']['getSelectedRows']().length === 0) {
            $scope['datasourcesGridApi']['selection']['selectRow']($scope['studioDatasourcesGridOptions']['data'][0]);
        }
    }, 1);
};

/**
 * Function called eachtime the database is modified, and call setLocalDatabaseSchemas if no changes appeard during 1.5 seconds
 * @param {string} database
 * @export
 */
oVFB.studioMainController.prototype.preventLocalDatabaseChanged = function (database) {

    var this_ = this;

    this.iLocalDatabaseChangeCounter_++;
    var tmpCounter = angular.copy(this.iLocalDatabaseChangeCounter_);

    // Repère si il n'y a pas eut de changements depuis 1.5 secondes
    setTimeout(function () {
        if (tmpCounter === this_.iLocalDatabaseChangeCounter_) {
            this_.setLocalDatabaseSchemas(database);
        }
    }, 1500);
};


/**
 * Set $scope['databases']
 * @export
 */
oVFB.studioMainController.prototype.setLocalDatabases = function () {
    oVFB.log('studioMainController.setLocalDatabases');

    var $scope = this.$scope_;
    var this_ = this;

    // récupère les différentes databases
    ajaxRequest({
        'method': 'GET',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/genericquerys/databases",
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                $.notify(this_['text']['Element']['Component']['Select']['Database_List_Error'], 'error');
                $scope['databases'] = [];
                return;
            }
            $scope['databases'] = response.data['data'];
        }
    });
};

/**
 * Set $scope['schemas']
 * @param {type} database
 * @export
 */
oVFB.studioMainController.prototype.setLocalDatabaseSchemas = function (database) {
    oVFB.log('studioMainController.setLocalDatabaseSchemas');

    var $scope = this.$scope_;
    var this_ = this;

    if(!goog.isDefAndNotNull(database)){
        database = oVFB.AppProperties["database"]
    }

    // récupère les différents schémas
    ajaxRequest({
        'method': 'GET',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/genericquerys/" + database + "/schemas",
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                $.notify(this_['text']['Element']['Component']['Select']['Schema_List_error'], 'error');
                $scope['schemas'] = [];
                return;
            }
            $scope['schemas'] = response.data['data'];
        }
    });
};

/**
 * Show the datasource modal and set the default options
 * @param {string} sDatabase sDatabase's name for load list of table / view
 * @param {string} sSchema Schema's name for load list of table / view
 * @export
 */
oVFB.studioMainController.prototype.reloadTablesList = function (sSchema, sDatabase) {
    oVFB.log('studioMainController.reloadTablesList');

    var $scope = this.$scope_;
    var this_ = this;

    // récupère les différentes tables du schema
    ajaxRequest({
        'method': 'GET',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/vitis/genericquerys",
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'params': {
            'database': sDatabase,
            'schema': sSchema
        },
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                $.notify(this_['text']['Element']['Component']['Select']['Table_List_error'], 'error');
                $scope['tables'] = [];
                return;
            }
            $scope['tables'] = response.data['data'];
        }
    });
};

/**
 * Show the new source modal and set the default options
 * @export
 */
oVFB.studioMainController.prototype.showNewSourceModal = function () {
    oVFB.log('studioMainController.showNewSourceModal');

    var $scope = this.$scope_;

    var new_id = 'datasource_1', i = 1;
    while (goog.isDef($scope['datasources'][new_id])) {
        new_id = 'datasource_' + i;
        i++;
    }

    $scope['newSource'] = {
        'id': new_id,
        'name': new_id,
        'description': '',
        'parameters': {},
        'options': ['Value one|1', 'Value two|2', 'Value three|3'],
        'options_model': 'Value one|1\nValue two|2\nValue three|3',
        'result_options': [{
                'label': 'Value one',
                'value': '1'
            }, {
                'label': 'Value two',
                'value': '2'
            }, {
                'label': 'Value three',
                'value': '3'
            }]
    };

    // Charge les valeurs par défaut et rafraichit la grille
    $scope['newSource'] = this.loadDatasourceDefaultValues($scope['newSource']);

    // Vide les listes
    $scope['aExternalDatabaseTables'].length = 0;
    $scope['schemas'].length = 0;
    $scope['tables'].length = 0;

    // Affiche la modale
    $('#studio-datasource-add-modal').modal('show');

    $scope["aExternalDatabaseTablesSelected"] = {};

    $scope["databaseSelected"] = {};
    $scope["schemaSelected"] = {};
    $scope["tableSelected"] = {};

    $("#typeSourceTooltip")["popover"]({
        "trigger": "hover",
        "container": "body",
        "content": function () {
            var sContent = $scope['text']['Element']['Component']['Select']['TypeSourceContent'];
            return sContent;
        },
        // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
        "placement": function (oPopoverNode, oElementNode) {
            return $scope.$root["workspaceTooltipPlacement"](oElementNode);
        }
    });
};

/**
 * Show the edit datasource modal
 * @export
 */
oVFB.studioMainController.prototype.showEditSourceModal = function () {
    oVFB.log('studioMainController.showEditSourceModal');

    var $scope = this.$scope_;

    if ($scope['datasourcesGridApi']['selection']['getSelectedRows']().length > 0) {

        // Cas où aucune source soit sélectionnée
        if (Object.keys($scope['selectedDatasource']).length === 0)
            return 0;

        $scope['editedDatasource'] = angular.copy($scope['selectedDatasource']);

        // Charge les valeurs par défaut et rafraichit la grille
        $scope['editedDatasource'] = this.loadDatasourceDefaultValues($scope['editedDatasource']);

        // Vide les listes
        $scope['schemas'].length = 0;
        $scope['tables'].length = 0;

        // Update ressources
        if ($scope['editedDatasource']['type'] === 'web_service') {
            if (goog.isDefAndNotNull($scope['editedDatasource']['webservice']))
                if (goog.isDefAndNotNull($scope['editedDatasource']['webservice']['name']))
                    this.updateRessources($scope['editedDatasource']['webservice']);
        }

        // Affiche la modale
        $('#studio-datasource-edit-modal').modal('show');

        var $timeout = angular.element(vitisApp.appMainDrtv).injector().get(["$timeout"]);

        $timeout(function () {
            $scope.refresh = true;
            $timeout(function () {
                $scope.refresh = false;
            }, 100);
        }, 500);
        // 1er affichage : Charge la liste des bases de données.
        if ($scope["databases"].length == 0) {
            $scope["databaseSelected"] = $scope["editedDatasource"]["parameters"]["database"];
            this["setLocalDatabases"]($scope["editedDatasource"]["parameters"]["database"]);
        }
        for (var i = 0; i < $scope["databases"].length; i++) {
            if ($scope["databases"][i]["database"] === $scope["editedDatasource"]["parameters"]["database"]) {
                $scope["databaseSelected"] = $scope["databases"][i];
            }
        }
        for (var i = 0; i < $scope["schemas"].length; i++) {
            if ($scope["schemas"][i]["schema_name"] === $scope["editedDatasource"]["parameters"]["schema"]) {
                $scope["schemaSelected"] = $scope["schemas"][i];
                this.reloadTablesList($scope["editedDatasource"]["parameters"]["schema"]);
            }
        }
        $timeout(function () {
            for (var i = 0; i < $scope["tables"].length; i++) {
                if ($scope["tables"][i]["table_name"] === $scope["editedDatasource"]["parameters"]["table"]) {
                    $scope["tableSelected"] = $scope["tables"][i];
                }
            }
        }, 500);
    } else {
        bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_NothingSelected']);
    }
};

/**
 * Return true if the filter is impty
 * @param {object|string} filter
 * @returns {boolean}
 * @export
 */
oVFB.studioMainController.prototype.isEmptyFilter = function (filter) {
    oVFB.log('studioMainController.isEmptyFilter');

    if (!goog.isDefAndNotNull(filter)) {
        return true;
    }

    if (goog.isString(filter)) {
        if (filter.length === 0) {
            return true;
        }
    } else if (goog.isObject(filter)) {
        if (goog.isArray(filter['operators'])) {
            if (filter['operators'].length > 1) {
                return false;
            }
            if (filter['operators'].length === 0) {
                return true;
            }
            if (filter['operators'][0]['column'] === '' && filter['operators'][0]['value'] === '') {
                return true;
            }
        }
    }

    return false;
};

/**
 * Load the default values for the new datasource and reset the test grid
 * @param {object} oDatasource
 * @returns {object}
 * @export
 */
oVFB.studioMainController.prototype.loadDatasourceDefaultValues = function (oDatasource) {
    oVFB.log('studioMainController.loadDatasourceDefaultValues');

    if (!goog.isDefAndNotNull(oDatasource['parameters'])) {
        oDatasource['parameters'] = {};
    }
    if (this.isEmptyFilter(oDatasource['parameters']['filter']) || !goog.isObject(oDatasource['parameters']['filter'])) {
        oDatasource['parameters'].filter = {
            'relation': 'AND',
            'operators': []
        };
    }

    // Rafraichit des données de la grille
    this.clearTestGrids();

    return oDatasource;
};

/**
 * Add a new source
 * @param {object} newSource
 * @export
 */
oVFB.studioMainController.prototype.addSource = function (newSource) {
    oVFB.log('studioMainController.addSource');

    var $scope = this.$scope_;

    if (newSource['dataType'] === 'text') {
        $scope.refresh = false;

        if (!goog.isDef(newSource['id'])) {
            console.error('newSource.id not defined');
            return 0;
        }
        if (!goog.isDef(newSource['name'])) {
            console.error('newSource.name not defined');
            return 0;
        }
        if (!goog.isDef(newSource['options'])) {
            console.error('newSource.options not defined');
            newSource['options'] = [];
        }
        if (goog.isDef($scope['datasources'][newSource['id']])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_Exists']);
            return 0;
        }

        var source = {
            'id': newSource['id'],
            'type': 'object',
            'dataType': newSource['dataType'],
            'name': newSource['name'],
            'description': newSource['description'],
            'options': newSource['options']
        };

        $('#studio-datasource-add-modal').modal('hide');
        this.saveDatasource(source);
        this.setStudioGridDatasources();

    } else if (newSource['dataType'] === 'externalDatabase') {

        if (!goog.isDef(newSource['id'])) {
            console.error('newSource.id not defined');
            return 0;
        }
        if (!goog.isDef(newSource['name'])) {
            console.error('newSource.name not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['server'])) {
            console.error('newSource.parameters.server not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['port'])) {
            console.error('newSource.parameters.port not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['sgbd'])) {
            console.error('newSource.parameters.sgbd not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['login'])) {
            console.error('newSource.parameters.login not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['password'])) {
            console.error('newSource.parameters.password not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['database'])) {
            console.error('newSource.parameters.database not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['schema'])) {
            console.error('newSource.parameters.schema not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['table'])) {
            console.error('newSource.parameters.table not defined');
            return 0;
        }
        if (goog.isDef($scope['datasources'][newSource['id']])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_Exists']);
            return 0;
        }

        var source = {
            'id': newSource['id'],
            'type': 'web_service',
            'dataType': newSource['dataType'],
            'name': newSource['name'],
            'description': newSource['description'],
            'parameters': newSource['parameters'],
            'ressource_id': "vitis/genericquerys/" + newSource['parameters']['table']
        };

        $('#studio-datasource-add-modal').modal('hide');
        this.saveDatasource(source);
        this.setStudioGridDatasources();

    } else if (newSource['dataType'] === 'tableValue') {

        if (goog.isDefAndNotNull(newSource['parameters'])) {
            var oParams = angular.copy(newSource['parameters']);
        }

        if (!goog.isDef(newSource['id'])) {
            console.error('newSource.id not defined');
            return 0;
        }
        if (!goog.isDef(newSource['name'])) {
            console.error('newSource.name not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['schema'])) {
            console.error('newSource.parameters.schema not defined');
            return 0;
        }
        if (!goog.isDef(newSource['parameters']['table'])) {
            console.error('newSource.parameters.table not defined');
            return 0;
        }
        if (goog.isDef($scope['datasources'][newSource['id']])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_Exists']);
            return 0;
        }

        if (goog.isDef(oParams['filter']['operators'])) {
            for (var i = 0; i < oParams['filter']['operators'].length; i++)
            {
                if (oParams['filter']['operators'][i].compare_operator == "" || oParams['filter']['operators'][i].column == "" || oParams['filter']['operators'][i].value == "")
                {
                    oParams['filter']['operators'].splice(i, 1);
                }
            }
        }

        var source = {
            'id': newSource['id'],
            'type': 'web_service',
            'dataType': newSource['dataType'],
            'name': newSource['name'],
            'description': newSource['description'],
            'parameters': oParams,
            'ressource_id': "vitis/genericquerys"
        };

        $('#studio-datasource-add-modal').modal('hide');
        this.saveDatasource(source);
        this.setStudioGridDatasources();

    } else if (newSource['dataType'] === 'webService') {

        if (!goog.isDef(newSource['id'])) {
            console.error('newSource.id not defined');
            return 0;
        }
        if (!goog.isDef(newSource['name'])) {
            console.error('newSource.name not defined');
            return 0;
        }
        if (!goog.isDef(newSource['webservice'])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['WebService_undefined']);
            console.error('newSource.webservice not defined');
            return 0;
        }
        if (!goog.isDef(newSource['ressource'])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Ressource_undefined']);
            console.error('newSource.ressource not defined');
            return 0;
        }
        if (goog.isDef($scope['datasources'][newSource['id']])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_Exists']);
            return 0;
        }

        var source = {
            'id': newSource['id'],
            'type': 'web_service',
            'dataType': newSource['dataType'],
            'name': newSource['name'],
            'description': newSource['description'],
            'webservice': newSource['webservice'],
            'ressource': newSource['ressource'],
            'ressource_id': newSource['webservice']['name'] + '/' + newSource['ressource']['name']
        };

        $('#studio-datasource-add-modal').modal('hide');
        this.saveDatasource(source);
        this.setStudioGridDatasources();

    } else if (newSource['dataType'] === 'businessObject') {

        if (!goog.isDef(newSource['id'])) {
            console.error('newSource.id not defined');
            return 0;
        }
        if (!goog.isDef(newSource['name'])) {
            console.error('newSource.name not defined');
            return 0;
        }
        if (!goog.isDef(newSource['businessObject']['business_object_id'])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['BusinessObject_undefined']);
            console.error('newSource.businessObject not defined');
            return 0;
        }
        if (goog.isDef($scope['datasources'][newSource['id']])) {
            bootbox.alert(this['text']['Element']['Component']['Select']['Datasource_Exists']);
            return 0;
        }

        var source = {
            'id': newSource['id'],
            'type': 'web_service',
            'dataType': newSource['dataType'],
            'name': newSource['name'],
            'description': newSource['description'],
            'businessObject': newSource['businessObject'],
            'businessObjectRequest': newSource['businessObjectRequest'],
            'subObject': 'bo_' + newSource['businessObjectRequest'],
            'ressource_id': "vmap/querys/" + newSource['businessObject']['business_object_id'] + "/" + newSource['businessObjectRequest']
        };

        $('#studio-datasource-add-modal').modal('hide');
        this.saveDatasource(source);
        this.setStudioGridDatasources();

    }
};

/**
 * Remove the selected datasource
 * @export
 */
oVFB.studioMainController.prototype.removeSelectedSource = function () {
    oVFB.log('studioMainController.removeSelectedSource');

    var this_ = this;
    var $scope = this.$scope_;

    var sourceId = $scope['selectedDatasource']['id'];
    var usedDatasources = [];

    if (!goog.isDefAndNotNull(sourceId))
        return 0;

    // Vérifie si la source de données est utilisée par un des champs
    for (var formName in $scope['jsonOutput']) {
        if (formName !== 'datasources') {
            var form = $scope['jsonOutput'][formName];
            if (goog.isDefAndNotNull(form['rows'])) {
                if (goog.isArray(form['rows'])) {
                    for (var i = 0; i < form['rows'].length; i++) {
                        if (goog.isDefAndNotNull(form['rows'][i]['fields'])) {
                            for (var ii = 0; ii < form['rows'][i]['fields'].length; ii++) {
                                if (goog.isDefAndNotNull(form['rows'][i]['fields'][ii]['datasource'])) {
                                    if (form['rows'][i]['fields'][ii]['datasource']['datasource_id'] === sourceId) {
                                        usedDatasources.push({
                                            label: form['rows'][i]['fields'][ii]['label'],
                                            name: form['rows'][i]['fields'][ii]['name'],
                                            formName: formName
                                        });
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    var message = this['text']['Element']['Component']['Select']['Datasource_Delete'];

    if (usedDatasources.length > 0) {
        message = this['text']['Element']['Component']['Select']['Datasource_Delete_Used'];
        message += '<br>';
        message += '<br>';
        message += '<ul>';
        for (var i = 0; i < usedDatasources.length; i++) {
            message += '<li>' + usedDatasources[i]['formName'] + ': ' + usedDatasources[i]['label'] + ' (' + usedDatasources[i]['name'] + ')</li>';
        }
        message += '</ul>';
        message += '<br>';
        message += this['text']['Element']['Component']['Select']['Datasource_Delete'];
    }

    var oModal = bootbox.confirm(message, function (result) {
        if (result === true) {
            delete $scope['datasources'][$scope['selectedDatasource']['id']];
            $scope['selectedDatasource'] = {};
            setTimeout(function () {
                this_.setStudioGridDatasources();
            }, 500);
            oVFB.setJsonOutput($scope['jsonOutput']);
        }
    });
    // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
    oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
};

/**
 * Save the datasource into the scope
 * @param {object} datasource
 * @export
 */
oVFB.studioMainController.prototype.saveDatasource = function (datasource) {
    oVFB.log('studioMainController.saveDatasource');

    var $scope = this.$scope_;

    if (datasource['type'] === 'object') {
        $scope['datasources'][datasource['id']] = {
            'type': datasource['type'],
            'dataType': datasource['dataType'],
            'name': datasource['name'],
            'description': datasource['description'],
            'options': datasource['options']
        };
    } else if (datasource['type'] === 'web_service') {
        $scope['datasources'][datasource['id']] = {
            'type': datasource['type'],
            'dataType': datasource['dataType'],
            'name': datasource['name'],
            'description': datasource['description'],
            'parameters': datasource['parameters'],
            'ressource_id': datasource['ressource_id']
        };
        if (goog.isDefAndNotNull(datasource['webservice']))
            $scope['datasources'][datasource['id']]['webservice'] = datasource['webservice'];
        if (goog.isDefAndNotNull(datasource['ressource']))
            $scope['datasources'][datasource['id']]['ressource'] = datasource['ressource'];
        if (goog.isDefAndNotNull(datasource['businessObject']))
            $scope['datasources'][datasource['id']]['businessObject'] = datasource['businessObject'];
        if (goog.isDefAndNotNull(datasource['subObject']))
            $scope['datasources'][datasource['id']]['subObject'] = datasource['subObject'];
        if (goog.isDefAndNotNull(datasource['businessObjectRequest'])) {
            $scope['datasources'][datasource['id']]['businessObjectRequest'] = datasource['businessObjectRequest'];
            $scope['datasources'][datasource['id']]['subObject'] = 'bo_' + datasource['businessObjectRequest'];
            $scope['datasources'][datasource['id']]['ressource_id'] = 'vmap/querys/' + datasource['businessObject']['business_object_id'] + '/' + datasource['businessObjectRequest'];
        }
    }

    if (datasource['dataType'] === 'externalDatabase') {
        $scope['datasources'][datasource['id']]['ressource_id'] = "vitis/genericquerys/" + datasource['parameters']['table'];
    }

    oVFB.setJsonOutput($scope['jsonOutput']);
    this.setStudioGridDatasources();
    $['notify'](this['text']['Element']['Component']['Select']['Saved'], {'className': 'success', 'autoHideDelay': oVFB.TimeNotify_});
    $('#studio-datasource-edit-modal').modal('hide');

    $scope.refresh = false;
};

/**
 * Set the studio grid datasources
 * @export
 */
oVFB.studioMainController.prototype.setStudioGridDatasources = function () {
    oVFB.log('studioMainController.setStudioGridDatasources');

    var $scope = this.$scope_;

    goog.array.clear($scope['studioDatasourcesGridOptions']['data']);
    var datasourcesCopy = angular.copy($scope['datasources']);
    for (var key in $scope['datasources']) {
        datasourcesCopy[key]['id'] = key;
        $scope['studioDatasourcesGridOptions']['data'].push(datasourcesCopy[key]);
    }
    $scope['datasourcesGridApi']['grid']['refresh']();
    goog.object.clear($scope['selectedDatasource']);
};

/**
 * Add usefull params on the selected datasource
 * @param {object} datasource
 * @export
 */
oVFB.studioMainController.prototype.setDatasourceContent = function (datasource) {
    oVFB.log('studioMainController.setDatasourceContent');

    if (datasource['type'] === 'object') {
        datasource['options_model'] = '';
        datasource['result_options'] = [];
        if (goog.isArray(datasource['options'])) {
            for (var i = 0; i < datasource['options'].length; i++) {
                if (i > 0)
                    datasource['options_model'] += '\n';
                datasource['options_model'] += datasource['options'][i];
            }
        }
        this.updateDatasourceTextContent(datasource);
    }
};

/**
 * Update datasource with options and result_options
 * @param {object} datasource
 * @export
 */
oVFB.studioMainController.prototype.updateDatasourceTextContent = function (datasource) {
    oVFB.log('studioMainController.updateDatasourceTextContent');

    datasource['options'] = datasource['options_model'].split('\n');

    // Test Résultat
    goog.array.clear(datasource['result_options']);
    var aOptions, aOptionsKeys = [], aOptionsValues = [];
    for (var i = 0; i < datasource['options'].length; i++) {
        aOptions = datasource['options'][i].split('|');
        aOptionsKeys.push(aOptions[0]);
        aOptionsValues.push(aOptions[1]);
    }
    var aTranslationsKeys = Object.keys(aOptionsKeys);
    for (var i = 0; i < aTranslationsKeys.length; i++) {
        datasource['result_options'].push({'label': aOptionsKeys[aTranslationsKeys[i]], 'value': aOptionsValues[i]});
    }
};

/**
 * Update the ressources list
 * @param {string} webService
 * @export
 */
oVFB.studioMainController.prototype.updateRessources = function (webService) {
    oVFB.log('studioMainController.updateRessources');

    var $scope = this.$scope_;

    // récupère les différents web services
    ajaxRequest({
        'method': 'GET',
        'url': oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vitis/webservices/' + webService['name'] + '/ressources',
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'params': {
            'attributs': 'name'
        },
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isDefAndNotNull(response.data['data'])) {
                console.error("response.data['data'] not defined");
                return;
            }
            $scope['ressources'] = response.data['data'];
        }
    });
};

/**
 * Text the web service writing the 10 first results on the test grid
 * @param {object} datasource
 * @param {string} modalName studio-datasource-add-modal/studio-datasource-edit-modal
 * @export
 */
oVFB.studioMainController.prototype.testTableValues = function (datasource, modalName) {
    oVFB.log('studioMainController.testTableValues');

    var $scope = this.$scope_;
    if (goog.isDefAndNotNull(datasource['parameters'])) {
        var oParams = angular.copy(datasource['parameters']);
    }

    if (goog.isDefAndNotNull(oParams['filter']['operators'])) {
        for (var i = 0; i < oParams['filter']['operators'].length; i++) {
            if (oParams['filter']['operators'][i].compare_operator == "" || oParams['filter']['operators'][i].column == "" || oParams['filter']['operators'][i].value == "") {
                oParams['filter']['operators'].splice(i, 1);
            }
        }
    }
    if (goog.isDefAndNotNull(oParams['filter']['operators'])) {
        if (oParams['filter']['operators'].length === 0) {
            delete oParams['filter'].operators;
            delete oParams['filter'].relation;
            delete oParams.filter;
        }
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vitis/genericquerys';
    var params = {
        'limit': 10
    };

    if (goog.isDefAndNotNull(oParams))
        goog.object.extend(params, oParams);

    if (modalName === 'studio-datasource-add-modal') {
        this.testRequestAPI(url, params, $scope['studioAddModalTestGridOptions'], $scope.studioAddModalTestGridApi);
    } else if (modalName === 'studio-datasource-edit-modal') {
        this.testRequestAPI(url, params, $scope['studioEditModalTestGridOptions'], $scope.studioEditModalTestGridApi);
    }
};

/**
 * Text the web service writing the 10 first results on the test grid
 * @param {object} datasource
 * @param {string} modalName studio-datasource-add-modal/studio-datasource-edit-modal
 * @export
 */
oVFB.studioMainController.prototype.testExternalDatabaseValues = function (datasource, modalName) {
    oVFB.log('studioMainController.testExternalDatabaseValues');

    var $scope = this.$scope_;

    if (!goog.isDefAndNotNull(datasource['parameters']['server'])) {
        bootbox.alert('server ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['port'])) {
        bootbox.alert('Port ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['sgbd'])) {
        bootbox.alert('SGBD ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['login'])) {
        bootbox.alert('Login ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['password'])) {
        bootbox.alert('Password ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['database'])) {
        bootbox.alert('Database ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['schema'])) {
        bootbox.alert('Schema ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['table'])) {
        bootbox.alert('Table ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vitis/genericquerys/' + datasource['parameters']['table'];
    var params = {
        'limit': 10,
        'login': datasource['parameters']['login'],
        'password': datasource['parameters']['password'],
        'server': datasource['parameters']['server'],
        'port': datasource['parameters']['port'],
        'sgbd': datasource['parameters']['sgbd'],
        'database': datasource['parameters']['database'],
        'schema': datasource['parameters']['schema'],
        'filter': datasource['parameters']['filter'],
    };

    if (modalName === 'studio-datasource-add-modal') {
        this.testRequestAPI(url, params, $scope['studioAddModalTestGridOptions'], $scope.studioAddModalTestGridApi);
    } else if (modalName === 'studio-datasource-edit-modal') {
        this.testRequestAPI(url, params, $scope['studioEditModalTestGridOptions'], $scope.studioEditModalTestGridApi);
    }
};

/**
 * Test the datasource
 * @param {object} datasource
 * @param {string} modalName studio-datasource-add-modal/studio-datasource-edit-modal
 * @export
 */
oVFB.studioMainController.prototype.testDatasource = function (datasource, modalName) {

    var $scope = this.$scope_;

    if (datasource['dataType'] === 'externalDatabase') {
        this.testExternalDatabaseValues(datasource, modalName);
    } else if (datasource['dataType'] === 'tableValue') {
        this.testTableValues(datasource, modalName);
    } else if (datasource['dataType'] === 'webService') {
        this.testWebService(datasource, modalName);
    } else if (datasource['dataType'] === 'businessObject') {
        this.testBusinessObject(datasource, modalName);
    }

};

/**
 * Text the web service writing the 10 first results on the test grid
 * @param {object} datasource
 * @param {string} modalName studio-datasource-add-modal/studio-datasource-edit-modal
 * @export
 */
oVFB.studioMainController.prototype.testWebService = function (datasource, modalName) {
    oVFB.log('studioMainController.testWebService');

    var $scope = this.$scope_;

    if (!goog.isDef(datasource['webservice'])) {
        bootbox.alert(this['text']['Element']['Component']['Select']['WebServiceUndefined']);
    }
    if (!goog.isDef(datasource['ressource'])) {
        bootbox.alert(this['text']['Element']['Component']['Select']['RessourceUndefined']);
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/' + datasource['webservice']['name'] + '/' + datasource['ressource']['name'];
    var params = {
        'limit': 10
    };

    if (modalName === 'studio-datasource-add-modal') {
        this.testRequestAPI(url, params, $scope['studioAddModalTestGridOptions'], $scope.studioAddModalTestGridApi);
    } else if (modalName === 'studio-datasource-edit-modal') {
        this.testRequestAPI(url, params, $scope['studioEditModalTestGridOptions'], $scope.studioEditModalTestGridApi);
    }
};

/**
 * Text the business object writing the 10 first results on the test grid
 * @param {object} datasource
 * @param {string} modalName studio-datasource-add-modal/studio-datasource-edit-modal
 * @export
 */
oVFB.studioMainController.prototype.testBusinessObject = function (datasource, modalName) {
    oVFB.log('studioMainController.testBusinessObject');

    var $scope = this.$scope_;

    if (!goog.isDef(datasource['businessObject'])) {
        bootbox.alert(this['text']['Element']['Component']['Select']['BusinessObject_undefined']);
    }
    if (!goog.isDef(datasource['businessObjectRequest'])) {
        bootbox.alert(this['text']['Element']['Component']['Select']['BusinessObject_Request_undefined']);
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vmap/querys/' + datasource['businessObject']['business_object_id'] + '/' + datasource['businessObjectRequest'];
    var params = {
        'limit': 10
    };

    if (goog.isDefAndNotNull(datasource['parameters']))
        goog.object.extend(params, datasource['parameters']);

    if (modalName === 'studio-datasource-add-modal') {
        this.testRequestAPI(url, params, $scope['studioAddModalTestGridOptions'], $scope.studioAddModalTestGridApi, 'bo_' + datasource['businessObjectRequest']);
    } else if (modalName === 'studio-datasource-edit-modal') {
        this.testRequestAPI(url, params, $scope['studioEditModalTestGridOptions'], $scope.studioEditModalTestGridApi, 'bo_' + datasource['businessObjectRequest']);
    }
};

/**
 * Test a API request and put the result into the test grid
 * @param {string} url
 * @param {object} params
 * @param {object} gridOptions grid options pointer (ex: $scope['studioAddModalTestGridOptions'])
 * @param {object} gridApi grid api pointer (ex: $scope.studioAddModalTestGridApi)
 * @param {string} subObject if the result hve to be on a sub object
 * @export
 */
oVFB.studioMainController.prototype.testRequestAPI = function (url, params, gridOptions, gridApi, subObject) {
    oVFB.log('studioMainController.testRequestAPI');

    var this_ = this;
    var $q = this.$q_;

    if (!goog.isDef(url)) {
        console.error('url not defined');
        return 0;
    }
    if (!goog.isDef(params)) {
        console.error('params not defined');
        return 0;
    }


    ajaxRequest({
        'method': 'GET',
        'url': url,
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'params': params,
        'scope': this.$scope_,
        'success': function (response) {

            if (!goog.isDef(response['data']['data'])) {
                bootbox.alert(this_['text']['Element']['Component']['Select']['NoDataReturned']);
                return 0;
            }

            var data;
            // si un sous objet est renseigné
            if (goog.isDefAndNotNull(subObject)) {
                data = [];
                for (var i = 0; i < response['data']['data'].length; i++)
                    data.push(response['data']['data'][i][subObject]);
            } else {
                data = response['data']['data'];
            }

            // Définition des colonnes à afficher
            var keys = Object.keys(data[0]);
            var columnDefs = [];
            for (var i = 0; i < keys.length; i++) {
                columnDefs.push({
                    'name': keys[i],
                    'displayName': keys[i],
                    'width': 100
                });
            }

            // Rafraichit des données de la grille
            gridOptions['data'] = data;
            gridOptions['columnDefs'] = columnDefs;
            gridApi['grid']['refresh']();

        }
    });
};

/**
 * Clear the datasources grid
 * @export
 */
oVFB.studioMainController.prototype.clearDatasourcesGrid = function () {
    oVFB.log('studioMainController.clearDatasourcesGrid');

    var $scope = this.$scope_;

    // Rafraichit des données de la grille
    $scope['studioDatasourcesGridOptions']['data'] = [];
    $scope['datasourcesGridApi']['grid']['refresh']();
};

/**
 * Clear the test grid
 * @export
 */
oVFB.studioMainController.prototype.clearTestGrids = function () {
    oVFB.log('studioMainController.clearTestGrids');

    var $scope = this.$scope_;

    // Rafraichit des données de la grille Add
    $scope['studioAddModalTestGridOptions']['data'] = [];
    $scope['studioAddModalTestGridOptions']['columnDefs'] = [];
    $scope.studioAddModalTestGridApi['grid']['refresh']();

    // Rafraichit des données de la grille Edit
    $scope['studioEditModalTestGridOptions']['data'] = [];
    $scope['studioEditModalTestGridOptions']['columnDefs'] = [];
    $scope.studioEditModalTestGridApi['grid']['refresh']();
};

/**
 * Complete scope.aExternalDatabaseTables witch is used to show de tables list
 * @param {type} datasource
 * @export
 */
oVFB.studioMainController.prototype.getExternalDatabaseTables = function (datasource) {
    oVFB.log('studioMainController.getExternalDatabaseTables');

    var this_ = this;
    var $scope = this.$scope_;
    var $q = this.$q_;

    if (!goog.isDefAndNotNull(datasource['parameters']['server'])) {
        bootbox.alert('Server ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['port'])) {
        bootbox.alert('Port ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['sgbd'])) {
        bootbox.alert('SGBD ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['login'])) {
        bootbox.alert('Login ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['password'])) {
        bootbox.alert('Password ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['database'])) {
        bootbox.alert('Database ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }
    if (!goog.isDefAndNotNull(datasource['parameters']['schema'])) {
        bootbox.alert('Schema ' + this['text']['Element']['Component']['Select']['Undefined']);
        return 0;
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vitis/genericquerys';
    var params = {
        'login': datasource['parameters']['login'],
        'password': datasource['parameters']['password'],
        'server': datasource['parameters']['server'],
        'port': datasource['parameters']['port'],
        'sgbd': datasource['parameters']['sgbd'],
        'database': datasource['parameters']['database'],
        'schema': datasource['parameters']['schema'],
        "order_by": "table_name"
    };

    if (!goog.isDefAndNotNull(url)) {
        console.error('url undefined');
        return 0;
    }
    if (!goog.isDefAndNotNull(params)) {
        console.error('params undefined');
        return 0;
    }

    ajaxRequest({
        'method': 'GET',
        'url': url,
        'headers': {
            'Accept': 'application/x-vm-json'
        },
        'params': params,
        'scope': this.$scope_,
        'timeout': 5000,
        'success': function (response) {

            if (!goog.isDef(response['data']['data'])) {
                bootbox.alert(this_['text']['Element']['Component']['Select']['NoDataReturned']);
                return 0;
            }

            if (!goog.isArray($scope['aExternalDatabaseTables']))
                $scope['aExternalDatabaseTables'] = [];
            else
                $scope['aExternalDatabaseTables'].length = 0;

            for (var i = 0; i < response['data']['data'].length; i++) {
                $scope['aExternalDatabaseTables'].push(response['data']['data'][i]['table_name']);
            }
        }
    });
};

/**
 * add New Filter
 * @param {object} oDatasource
 * @export
 */
oVFB.studioMainController.prototype.addNewFilterOperator = function (oDatasource) {
    oVFB.log('studioMainController.addNewFilterOperator');

    if (!goog.isDef(oDatasource['parameters']['filter'])) {
        oDatasource['parameters']['filter'] = {
            "relation": "AND",
            "operators": [{
                    "column": "",
                    "compare_operator": "=",
                    "value": ""
                }]
        };
    } else if (!goog.isDef(oDatasource['parameters']['filter']['operators'])) {
        oDatasource['parameters']['filter']['operators'] = [{
                "column": "",
                "compare_operator": "=",
                "value": ""
            }];
    } else if (oDatasource['parameters']['filter']['operators'].length > 0) {
        oDatasource['parameters']['filter']['operators'].push({
            "column": "",
            "compare_operator": "=",
            "value": ""
        });
    } else if (oDatasource['parameters']['filter']['operators'].length === 0) {
        delete oDatasource['parameters']['filter'].operators;
        oDatasource['parameters']['filter']['operators'] = [{
                "column": "",
                "compare_operator": "=",
                "value": ""
            }];
    }
};

/**
 * Remove the given operator from the filter
 * @param {object} oDatasource
 * @param {object} oOperator
 * @returns {Boolean}
 * @export
 */
oVFB.studioMainController.prototype.removeFilterOperator = function (oDatasource, oOperator) {
    oVFB.log('studioMainController.removeFilterOperator');

    if (!goog.isDefAndNotNull(oOperator)) {
        return false;
    }
    if (!goog.isDefAndNotNull(oDatasource)) {
        return false;
    }
    if (!goog.isDefAndNotNull(oDatasource['parameters'])) {
        return false;
    }
    if (!goog.isDefAndNotNull(oDatasource['parameters']['filter'])) {
        return false;
    }
    if (!goog.isArray(oDatasource['parameters']['filter']['operators'])) {
        return false;
    }

    var iOperatorIndex = oDatasource['parameters']['filter']['operators'].indexOf(oOperator);
    if (iOperatorIndex !== -1) {
        oDatasource['parameters']['filter']['operators'].splice(iOperatorIndex, 1);
    }
};

/**
 * Move a bootbox instance to the studio container element.
 * @param {object} oModal Instance bootbox.
 * @export
 */
oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer = function (oModal) {
    oVFB.log('studioMainController.moveBootboxModalToStudioContainer');
    // Uniquement si le studio est en mode plein écran.
    if (document['fullscreenElement'] || document['webkitFullscreenElement'] || document['mozFullScreenElement'] || document['msFullscreenElement']) {
        var aElement = oModal[0].parentNode.querySelectorAll(".modal-backdrop");
        for (var i = 0; i < aElement.length; i++) {
            document.getElementById("studio_container").appendChild(aElement[i]);
        }    
        document.getElementById("studio_container").appendChild(oModal[0]);
    }
};

/***********************************************************************************/
/* Instanciation des fonctions "Utils" */
oVFB.utils_ = nsUtils;

//Activation ou non des logs consoles
if (oProperties['mode'] === 'dev') {  // options pour le mode "dev"
    oVFB.utils_.bDebugMode = true;
}

/* Assignation des fonctions Utils*/
oVFB.log = oVFB.utils_.log;
oVFB.unselectAll = oVFB.utils_.unselectAll;

/**
 * @expose
 */
oVFB.reloadForm = oVFB.utils_.reloadForm;

/**
 * @expose
 */
oVFB.removeWebServiceFromFields = oVFB.utils_.removeWebServiceFromFields;
//oVFB['removeWebServiceFromFields'] = oVFB.utils_.removeWebServiceFromFields;


oVFB.JsonStringifier = oVFB.utils_.JsonStringifier;
oVFB.JsonOptimizer = oVFB.utils_.JsonOptimizer;
oVFB.clone = oVFB.utils_.clone;

/* Initialisation des variables pour chaque objet de l'application*/
oVFB.Update = false;
oVFB.oDevTools_ = {};
oVFB.oJsonLoader_ = {};
oVFB.oTreeView_ = {};
oVFB.oFormTools_ = {};
oVFB.oElementForm_ = {};
oVFB.oCompoList_ = {};
oVFB.oVisualizer_ = {};
oVFB.oJson_ = {'empty': true};
oVFB.oJsonOutput_ = {};
oVFB.sJs_ = '';
oVFB.sCSS_ = '';
oVFB.TimeNotify_ = oProperties['timeNotify'];

/**
 * oVFB.Collapse_[0] -> Formulaire
 * oVFB.Collapse_[1] -> list
 * oVFB.Collapse_[2] -> Paramètres publiés/Mise en forme
 * oVFB.Collapse_[3] -> form
 * oVFB.Collapse_[4] -> Definition
 */
oVFB.Collapse_ = [false, false, false, false, false];

//oVFB.Color_ = oVFB.utils_.changeColor();
oVFB.valid = true;
oVFB.aNotValid = [];
oVFB.token = '';
oVFB.AppName = '';
oVFB.id = 0;
oVFB.el = null;
oVFB.AppProperties = null;
/* Instanciation des objets de l'application */

oVFB.tree_ = 'no tree';

oVFB.oJsonLoader_ = new nsVFB.JsonLoader();
oVFB.oFormTools_ = new nsVFB.FormTools();
oVFB.oElementForm_ = new nsVFB.ElementForm();
oVFB.oVisualizer_ = new nsVFB.Visualizer();

//oVFB.module.config(function ($logProvider) {
//    $logProvider.debugEnabled(true);
//});

/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/