/* global goog, nsVFB, oVFB, angular, bootbox */

/**
 * @author: Anthony Borghi
 * @author: Armand Bahi
 * @Description: Fichier contenant la classe nsVFB.FormTools
 * cette classe permet l'initialisation des outils de mise en page et de la vue arborescente
 * Attention !!!!! cette classe ne fonctionne qu'avec une version de Bootstrap-Treeview modifié pour inclure de nouveaux events !!!!! Attention
 */

/*********************************************************************************************************
 *  TODO LIST  (95%)
 *      Verifier le Drag and Drop
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.FormTools');

goog.require('goog.object');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object TreeView visualizer
 * @constructor
 * @export
 */
nsVFB.FormTools = function () {
    oVFB.log("nsVFB.FormTools");

    oVFB.module.directive('appFormTools', this.formToolsDirective);
    oVFB.module.controller('AppFormToolsController', ["$scope", "$rootScope", "$timeout", this.formToolsController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.FormTools.prototype.formToolsDirective = function () {
    oVFB.log('nsVFB.FormTools.FormToolsDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppFormToolsController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/FormTools.html'
    };
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {Object} $scope AngularJS's service who return the current scope
 * @param {Object} $rootScope AngularJS's service who return the root scope, parent of all others scopes.
 * @param {Object} $timeout AngularJS's service who wrap window.timeout who delay execution of a function
 * @export
 */
nsVFB.FormTools.prototype.formToolsController = function ($scope, $rootScope, $timeout) {
    oVFB.log('nsVFB.FormTools.FormToolsController');

    var FormToolsController = this;
    this.$rootScope_ = $rootScope;
    this.$scope_ = $scope;
    this.elemAdded_ = 0;

    this['applicationName'] = oVFB.getApplication();

    /**
     * True when with lines mode
     * @expose
     */
    this.bTreeWithLines_ = false;
    
    $scope["copyPasteContainer"] = {};

    $scope.$watch("text", function () {
        oVFB.log("formtools text");
        if (goog.isDef($scope["text"]["FormTools"]))
            FormToolsController["text"] = $scope["text"]["FormTools"];
    });

    $scope["colapse_tools"] = oVFB.Collapse_[2];

    /**
     * Convert the object Json to a specific object needed by bootstrap-treeview and add usefull informations
     * @param {boolean} displayLines true if you want to display the lines, false otherwise 
     * @return {object} aTree : an array who contain Json Objects to set the TreeView 
     */
    FormToolsController.convertJson = function (displayLines) {
        oVFB.log("nsVFB.FormTools.convertJson");

        var oJson = oVFB.getJsonOutput();   //input
        var aTree = [];                     //output

        if (!goog.isDefAndNotNull(oJson)) {
            console.error('No JSON founded');
            return aTree;
        }

        displayLines = goog.isDef(displayLines) ? displayLines : true;

        if (!goog.object.isEmpty(oJson[$rootScope["selected_form_type"]])) {
            //on ne travaille que sur un seul mode pour l'instant $rootScope["selected_form_type"]
            for (var i = 0; i < oJson[$rootScope["selected_form_type"]]["rows"].length; i++) {
                if (displayLines === true) {
                    if (goog.isDefAndNotNull(this["text"])) {
                        //Pour chaque itération on ajoute un noeud parent qui correspond à une ligne (row)
                        aTree.push({//ajout d'un élément ligne
                            "text": this["text"]["Row"] + " " + i, //nom : "row_" concaténé avec l'itérateur
                            "state": {"expanded": true}, //un objet contenant les états du noeud ici on veut juste qu'il soit décontracté au démarrage
                            "tags": [0], //badge lié ici c'est juste le nombre de noeud enfants 
                            "nodes": [], //tableau de noeud enfant pour l'instant vide
                            "row": i, //itérateur de la ligne (non obligatoire)
                            "draggable": true
                        });
                    }
                }

                for (var j = 0; j < oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"].length; j++) {
                    // pour chaque row parcoure les champs
                    var glyphicon;
                    switch (oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"][j]['type']) {
                        case "codemirror" :
                            glyphicon = "icon-code";
                            break;
                        case "select" :
                        case "list" :
                        case "double_select" :
                            glyphicon = "icon-format_list_bulleted";
                            break;
                        case "text" :
                        case "tinymce" :
                            glyphicon = "icon-font";
                            break;
                        case "upload" :
                            glyphicon = "icon-file";
                            break;
                        case "checkbox" :
                            glyphicon = "icon-check-square";
                            break;
                        case "radio" :
                            glyphicon = "icon-dot-circle-o";
                            break;
                        case "date" :
                        case "datetime" :
                            glyphicon = "icon-calendar-check-o";
                            break;
                        case "password" :
                            glyphicon = "icon-key";
                            break;
                        case "email" :
                            glyphicon = "icon-at";
                            break;
                        case "url" :
                            glyphicon = "icon-chrome";
                            break;
                        case "integer" :
                        case "float" :
                        case "number":
                            glyphicon = "icon-calculator";
                            break;
                        case "color_picker" :
                            glyphicon = "icon-paint";
                            break;
                        case "slider" :
                            glyphicon = "icon-sliders";
                            break;
                        case "textarea" :
                            glyphicon = "icon-paragraph";
                            break;
                        case "hr":
                            glyphicon = "icon-minus";
                            break;
                        case "label":
                            glyphicon = "icon-eye";
                            break;
                        case "email":
                            glyphicon = "icon-at";
                            break;
                        case "hidden":
                            glyphicon = "icon-user-secret";
                            break;
                        case "link":
                            glyphicon = "glyphicon glyphicon-link";
                            break;
                        case "image":
                            glyphicon = "glyphicon glyphicon-picture";
                            break;
                        case "map_bing":
                        case "map_osm":
                        case "map_vmap":
                            glyphicon = "icon-map";
                            break;
                        default :
                            glyphicon = "icon-point";
                    }

                    if (displayLines === true) {
                        if (goog.isDefAndNotNull(aTree[i])) {
                            aTree[i]["tags"][0] += 1;   //incrémentation du nombre d'enfants
                            aTree[i]["nodes"].push({//ajout dans le tableau de noeuds enfants
                                "text": "  " + oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"][j]['name'], //nom de l'objet métier
                                "type": oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"][j]['type'], //Type de l'objet (non obligatoire)
                                "icon": glyphicon,
                                "row": i, //itérateur de la ligne (non obligatoire)
                                "field": j, //itérateur du champs non obligatoire
                                "draggable": true
                            });
                        }
                    } else {
                        aTree.push({
                            "text": "  " + oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"][j]['name'],
                            "type": oJson[$rootScope["selected_form_type"]]["rows"][i]["fields"][j]['type'],
                            "icon": glyphicon,
                            "row": i,
                            "field": j,
                            "draggable": true
                        });
                    }
                }
            }
        }
        return aTree;   // retourne l'objet pour la visualisation arborescente
    };

//connection à un signal 
    $scope.$on('updateEvent', function () {

        var dataWithLines = FormToolsController.convertJson(true);
        var collapsedNodes = $('#treeWithLines')['treeview']('getCollapsed');

        if (!goog.isDef(dataWithLines)) {
            console.error('No JSON converted founded');
            return 0;
        }
        if (!goog.isDef(collapsedNodes)) {
            console.error('collapsedNodes undefined');
            return 0;
        }

        // Met toutes les lignes à collapsed = false
        for (var i = 0; i < dataWithLines.length; i++) {
            dataWithLines[i]['collapsed'] = false;
        }

        // Met les lignes collapsées à collapsed = true
        for (var i = 0; i < collapsedNodes.length; i++) {
            if (goog.isDef(collapsedNodes[i]['nodes'])) {
                for (var ii = 0; ii < dataWithLines.length; ii++) {
                    if (collapsedNodes[i]['row'] === dataWithLines[ii]['row']) {
                        dataWithLines[ii]['collapsed'] = true;
                    }
                }
            }
        }

        $('#treeWithLines')["treeview"]({//instanciation d'une nouvelle arborescence
            "data": dataWithLines, //donnée
            "showTags": true, //présence des badges 
            "showBorder": false, // cache les bordures
            "expandIcon": "glyphicon glyphicon-menu-right", // change les icones d'origines
            "collapseIcon": "glyphicon glyphicon-menu-down",
            "onNodeSelected": function (event, data) {        //fonction appelé sur un noeud sélectionné
                if (goog.isDef(data['field'])) {
                    //si le noeud est un noeud enfant

                    $timeout(function () {
                        // selectionne le même élèment dans l'autre arbre
                        var node = $("#treeView")["treeview"]("search", [data["text"], {
                                "ignoreCase": true, // case insensitive
                                "exactMatch": true, // exact equals
                                "revealResults": false // don't reveal matching nodes
                            }]);
                        $("#treeView")["treeview"]('selectNode', [node[0]["nodeId"], {silent: true}]);
                        $('#treeView')["treeview"]('clearSearch');
                    });

                    // Sélectionne l'élément dans le formReader
                    FormToolsController.setSelectedElemInFormReader({
                        'type': 'element',
                        'element_name': data["text"].replace(/\s/g, "")
                    });

                    // emet un signal de mise à jour spécifique au composant de visualisation des attributs d'élément
                    $rootScope.$broadcast("update element", oVFB.getJsonOutput()[$rootScope["selected_form_type"]]["rows"][data['row']]["fields"][data['field']]);
                } else {
                    // Sélectionne l'élément dans le formReader
                    FormToolsController.setSelectedElemInFormReader({
                        'type': 'row',
                        'row_id': parseInt(data['row'])
                    });
                }
            },
            "onNodeUnselected": function (event, data) {      //fonction appelé sur un noeud désélectionné
                oVFB.unselectAll();
            },
            "onNodeHoverIn": function (event) {               //fonction appelé sur un noeud survolé par le curseur

                var elem = event["currentTarget"];

                // la coloration de l'élément
                if ($(elem)[0]['childNodes'][2]['data']) {// ligne
                    var tmp = $(elem)[0]['childNodes'][2]['data'].split(" ");
                    var hoveredInTree_ = {
                        'type': 'row',
                        'row_id': parseInt(tmp[1])
                    };
                } else { // elem
                    var hoveredInTree_ = {
                        'type': 'element',
                        'element_name': $(elem)[0]['textContent'].replace(/\s/g, "")
                    };
                }
                FormToolsController.setHoveredElemInFormReader(hoveredInTree_);
            },
            "onNodeHoverOut": function (event) {
                FormToolsController.setHoveredElemInFormReader({});
            },
            "highlightSelected": true, //surbrillance de l'élément sélectionné
            "multiSelect": false //désactivation de la multiselection
        });
        $('#treeView')["treeview"]({
            "data": FormToolsController.convertJson(false),
            "showTags": false,
            "showBorder": false,
            "levels": 1,
            "showIcon": true,
            "onNodeSelected": function (event, data) {
                if (typeof (data['field']) !== "undefined") {

//                    //colore le champ dans le visualizer pour améliorer la compréhension de l'utilisateur
//                    FormToolsController.setSelectedElemInFormReader({
//                        'type': 'element',
//                        'element_name': data["text"].replace(/\s/g, "")
//                    });

                    //on selectionne le même dans l'autre arbre
                    var node = $("#treeWithLines")["treeview"]("search", [data["text"], {
                            "ignoreCase": true, // case insensitive
                            "exactMatch": true, // exact equals
                            "revealResults": false // don't reveal matching nodes
                        }]);
                    var row = $("#treeWithLines")["treeview"]("search", [$scope.$parent["text"]["FormTools"]["Row"] + " " + node[0]["row"], {
                            "ignoreCase": true, // case insensitive
                            "exactMatch": true, // exact equals
                            "revealResults": false // don't reveal matching nodes
                        }]);
                    $('#treeWithLines')["treeview"]('expandNode', [row[0]["nodeId"], {silent: true}]);
                    $("#treeWithLines")["treeview"]('selectNode', [node[0]["nodeId"], {silent: false}]);
                    $('#treeWithLines')["treeview"]('clearSearch');
                }
            },
            "onNodeUnselected": function (event, data) {
                oVFB.unselectAll();
            },
            "onNodeHoverIn": function (event) {

                var elem = event["currentTarget"];

                FormToolsController.setHoveredElemInFormReader({
                    'type': 'element',
                    'element_name': $(elem)[0]['textContent'].replace(/\s/g, "")
                });
            },
            "onNodeHoverOut": function (event) {
                FormToolsController.setHoveredElemInFormReader({});
            },
            "highlightSelected": true, //surbrillance de l'élément sélectionné
            "multiSelect": false                            //désactivation de la multiselection
        });

        var elements = $('#treeWithLines')["treeview"]('getEnabled');

        // Collapse les éléments précédaments collapsés
        for (var i = 0; i < elements.length; i++) {
            if (elements[i]['collapsed'] === true) {
                $('#treeWithLines')["treeview"]('collapseNode', elements[i]);
            }
        }
    });

    /***********************************************************************************
     *                              Drag-and-Drop                                      *
     **********************************************************************************/
    var src = {};
    var dst = {};
    var ascend = true;

    document.getElementById("treeWithLines").addEventListener("dragstart", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            event["dataTransfer"]["setData"]("Text", event["target"]["id"]);

            // Change l'oppacité de l'élément déplacé et l'icone lors du glissement
            event["target"]["style"]["opacity"] = "0.5";
            event["dataTransfer"]["effectAllowed"] = "move";

            //Memorisation de l'état.
            src = event["target"];
            //Verouillage de l'arbre
            oVFB.setTreeDnD("FormTools");
        }
    });

    document.getElementById("treeWithLines").addEventListener("dragover", function (event) {
        event["preventDefault"](); //ATTENTION : ne pas effacer sinon drop ne marche plus
    });

    document.getElementById("treeWithLines").addEventListener("dragenter", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            var tmp = event["target"];
            if (oVFB.getTreeDnD() === "FormTools") {
                $(tmp).trigger("mouseover"); //coloration sur visualizer pour aider l'utilisateur
                if ((tmp !== src) && ($(tmp)[0].tagName === "LI")) {
                    $(src).remove(); //Suppréssion de la source
                    if (parseInt($(dst).attr("data-nodeid")) < parseInt($(tmp).attr("data-nodeid"))) {
                        //si on descend dans la liste
                        $(src).insertAfter(tmp);//mouvement de l'élément glissé
                    } else {
                        //si on remonte dans la liste
                        $(src).insertBefore(tmp);//mouvement de l'élément glissé
                    }
                    $(dst).trigger("mouseout"); //effacement de l'aide
                    dst = tmp; //mémorisation pour déplacement lors du déposé
                }
            }
        }
    });

    document.getElementById("treeWithLines").addEventListener("drop", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            //initialisation des variables necessaires
            var dst_index = 0;
            var src_index = 0;
            var oJson = oVFB.getJsonOutput();
            var tmp = 0;
            //si on est dans le même arbre qu'au départ;
            if (oVFB.getTreeDnD() === "FormTools") {
                src["style"]["opacity"] = "1"; //l'élément redevient pleinement visible
                if (src["childNodes"][0]["className"] === "indent") {
                    //noeud enfant
                    var src_id = 0;
                    var src_row = 0;
                    if (dst["childNodes"][0]["className"] === "indent") {
                        //sur noeud enfant
                        src_id = parseInt($(src).attr("data-nodeid"));  //récupération du nodeID 
                        //récupération de l'index de ligne et de champs
                        src_row = ($("#treeWithLines")["treeview"]('getNode', src_id))["row"];
                        src_index = ($("#treeWithLines")["treeview"]('getNode', src_id))["field"];

                        var dst_id = parseInt($(dst).attr("data-nodeid")); //récupération du nodeID 
                        //récupération de l'index de ligne et de champs
                        var dst_row = ($("#treeWithLines")["treeview"]('getNode', dst_id))["row"];
                        dst_index = ($("#treeWithLines")["treeview"]('getNode', dst_id))["field"];

                        //Mémorisation du champ à déplacer
                        tmp = oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"][src_index];

                        //Suppréssion du champs
                        oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].splice(src_index, 1);

                        //insertion du champs à son nouveau emplacement
                        oJson[$rootScope["selected_form_type"]]["rows"][dst_row]["fields"].splice(dst_index, 0, tmp);

                        if (src_row !== dst_row) {
                            //ajuste la taille des éléments de la ligne
                            FormToolsController.resizeElementsOnRow(oJson[$rootScope["selected_form_type"]]["rows"][src_row]);
                            FormToolsController.resizeElementsOnRow(oJson[$rootScope["selected_form_type"]]["rows"][dst_row]);
                        }

                        //si la ligne est vide on la supprime
                        if (oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].length === 0) {
                            oJson[$rootScope["selected_form_type"]]["rows"].splice(src_row, 1);
                        }
                    } else {
                        //sur noeud Parent
                        //récupération des infos lié à la source
                        src_id = parseInt($(src).attr("data-nodeid"));
                        src_row = ($("#treeWithLines")["treeview"]('getNode', src_id))["row"];
                        src_index = ($("#treeWithLines")["treeview"]('getNode', src_id))["field"];
                        //récupération de la ligne de destination
                        dst_index = parseInt(dst["childNodes"][2]["data"].split(" ")[1]);
                        //Stockage, puis supression, puis insertion en tête
                        tmp = oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"][src_index];
                        oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].splice(src_index, 1);
                        oJson[$rootScope["selected_form_type"]]["rows"][dst_index]["fields"].unshift(tmp);

                        //ajuste la taille des éléments de la ligne
                        FormToolsController.resizeElementsOnRow(oJson[$rootScope["selected_form_type"]]["rows"][src_row]);
                        FormToolsController.resizeElementsOnRow(oJson[$rootScope["selected_form_type"]]["rows"][dst_index]);

                        //si la row est vide on la supprime
                        if (oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].length === 0) {
                            oJson[$rootScope["selected_form_type"]]["rows"].splice(src_row, 1);
                        }
                    }
                } else {
                    //noeud Parent
                    if (dst["childNodes"][0]["className"] === "indent") {
                        //sur noeud enfant provoque une erreur
                        $["notify"](FormToolsController["text"]["Notify"]["Error_ElOnRow"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                    } else {
                        //Récupération des numéros de lignes source et destination
                        src_index = parseInt(src["childNodes"][2]["data"].split(" ")[1]);
                        dst_index = parseInt(dst["childNodes"][2]["data"].split(" ")[1]);
                        //Stockage, suppression et insertion de l'élément source
                        tmp = oJson[$rootScope["selected_form_type"]]["rows"][src_index];
                        oJson[$rootScope["selected_form_type"]]["rows"].splice(src_index, 1);
                        oJson[$rootScope["selected_form_type"]]["rows"].splice(dst_index, 0, tmp);
                    }
                }
            }
            oVFB.setJsonOutput(oJson); // on Memorise
            $(".hover-in-tree").each(function (index, element) {   // on s'assure de supprimer toute trace graphique qui resterais
                $(element).removeClass("hover-in-tree");
            });
            $(".selected-in-tree").removeClass("selected-in-tree");
            $rootScope.$broadcast("updateEvent", oVFB.getJsonOutput()); // on met à jour tout le monde pour appliquer l'update
            oVFB.setTreeDnD("no tree"); // et on reset l'arbre selectionné
            $scope.$apply();
        }
    });

    document.getElementById("treeView").addEventListener("dragstart", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            // The dataTransfer.setData() method sets the data type and the value of the dragged data
            event["dataTransfer"]["setData"]("Text", event["target"]["id"]);
            // Change the opacity of the draggable element
            event["target"]["style"]["opacity"] = "0.5";
            event["dataTransfer"]["effectAllowed"] = "move";
            //Memorisation de l'état.
            src = event["target"];
            oVFB.setTreeDnD("treeView");
        }
    });

    document.getElementById("treeView").addEventListener("dragover", function (event) {
        event["preventDefault"](); //ATTENTION : a ne pas effacer sinon drop ne marche plus
    });

    document.getElementById("treeView").addEventListener("dragenter", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            var tmp = event["target"];
            if (oVFB.getTreeDnD() === "treeView") {
                $(tmp).trigger("mouseover");
                if ((tmp !== src) && ($(tmp)[0].tagName === "LI")) {
                    if (parseInt($(dst).attr("data-nodeid")) < parseInt($(tmp).attr("data-nodeid"))) {
                        //si on descend dans la liste
                        $(src).remove();
                        $(src).insertAfter(tmp);
                        $(dst).trigger("mouseout");
                        dst = tmp;
                        ascend = false;
                    } else {
                        //si on remonte dans la liste
                        $(src).remove();
                        $(src).insertBefore(tmp);
                        $(dst).trigger("mouseout");
                        dst = tmp;
                        ascend = true;
                    }
                }
            }
        }
    });

    document.getElementById("treeView").addEventListener("drop", function (event) {
        if ($("#load_Perso_button").hasClass("active")) {
            var dst_index = 0;
            var src_index = 0;
            var oJson = oVFB.getJsonOutput();
            var tmp = 0;
            if (oVFB.getTreeDnD() === "treeView") {
                src["style"]["opacity"] = "1";
                var src_id = parseInt($(src).attr("data-nodeid"));
                var src_row = ($("#treeView")["treeview"]('getNode', src_id))["row"];
                var src_index = ($("#treeView")["treeview"]('getNode', src_id))["field"];
                var dst_id = parseInt($(dst).attr("data-nodeid"));
                var dst_row = ($("#treeView")["treeview"]('getNode', dst_id))["row"];
                dst_index = ($("#treeView")["treeview"]('getNode', dst_id))["field"];
                //switch fields
                tmp = oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"][src_index];
                oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].splice(src_index, 1);
                if (!ascend) {
                    dst_index += 1;
                }
                oJson[$rootScope["selected_form_type"]]["rows"][dst_row]["fields"].splice(dst_index, 0, tmp);
                //si la row est vide on la supprime
                if (oJson[$rootScope["selected_form_type"]]["rows"][src_row]["fields"].length === 0) {
                    oJson[$rootScope["selected_form_type"]]["rows"].splice(src_row, 1);
                }
            }
            oVFB.setJsonOutput(oJson);
            $(".hover-in-tree").each(function (index, element) {
                $(element).removeClass("hover-in-tree");
            });
            $(".selected-in-tree").removeClass("selected-in-tree");
            $rootScope.$broadcast("updateEvent", oVFB.getJsonOutput());
            $scope.$apply();
            oVFB.setTreeDnD("no tree");
        }
    });


    /***********************************************************************************
     *                                  End DnD                                        *
     **********************************************************************************/

//fonction de redimensionnement du composant
    FormToolsController["resize"] = function () {
        $scope["colapse_tools"] = !$scope["colapse_tools"];
        oVFB.Collapse_[2] = $scope["colapse_tools"];
        oVFB.resize();
    };
};

/**
 * Add a line after the selected node or at the end if none selected
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.addLine = function () {
    oVFB.log('nsVFB.FormTools.prototype.formToolsController.prototype.addLine');

    var this_ = this;
    var aSelectedNode = $('#treeWithLines')["treeview"]('getSelected'); // récupére le noeud sélectionné
    var data = oVFB.getJsonOutput();   // récupére l'objet JSON de sortie

    // si aucune ligne n'a été sélectionnée
    if (aSelectedNode.length !== 1) {
        aSelectedNode = [this.getLastLine()];
    }
    // si la ligne sélectionnée est un élément
    if (goog.isDef(aSelectedNode[0]["field"])) {
        aSelectedNode = [$('#treeWithLines')['treeview']('getNode', aSelectedNode[0]['parentId'])];
    }

    if (aSelectedNode.length === 1) {
        // si un seul noeud est séléctionné
        if (!goog.isDef(aSelectedNode[0]["field"])) {
            //si c'est une ligne on ajoute juste après une ligne vide
            data[this.$rootScope_["selected_form_type"]]["rows"].splice((aSelectedNode[0]["row"] + 1), 0, {"fields": []});
        }
    } else {
        //sinon aucun noeud n'est sélectionné rappel à l'ordre de l'utilisateur
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
    // enleve la coloration sur le visualizer
    $(".selected-in-tree").each(function (index, element) {
        $(element).removeClass("selected-in-tree");
    });
    // recharge
    oVFB.setJsonOutput(data);
    this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());
};

/**
 * Add an element after the selected node or at the end if none selected
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.addElement = function () {
    // Modification du studio 
    oVFB.Update = true;
    oVFB.log('nsVFB.FormTools.prototype.formToolsController.prototype.addElement');

    var this_ = this;
    var aSelectedNode = $('#treeWithLines')["treeview"]('getSelected'); // récupére le noeud sélectionné
    var data = oVFB.getJsonOutput(); // récupére l'objet JSON de sortie
    var lineAdded = false;

    // si aucun élément n'a été sélectionnée
    if (aSelectedNode.length !== 1) {
        // si on est en mode avec lignes on en ajoute une (en mode sans lignes il sera ajouté dans tous les cas)
        var lastLine = this.getLastLine();
        if (this.bTreeWithLines_ || !goog.isDef(lastLine['nodes'])) {
            this.addLine();
            lastLine = this.getLastLine();
            lineAdded = true;
        }
        aSelectedNode = [lastLine];
    }

    if (aSelectedNode.length === 1) {

        // vérifie que elemAdded_ ne soit pas déjà utilisé
        var checkElementAdded = function (rows) {
            for (var i = 0; i < rows.length; i++) {
                if (!goog.isDef(rows[i]['fields']))
                    continue;
                for (var ii = 0; ii < rows[i]['fields'].length; ii++) {
                    if (rows[i]['fields'][ii]['name'] === "Element_" + this_.elemAdded_) {
                        this_.elemAdded_++;
                        checkElementAdded(rows);
                        return 0;
                    }
                }
            }
        };
        var rows = oVFB.getJsonOutput()[this.$rootScope_["selected_form_type"]]["rows"];
        checkElementAdded(rows);

        var elemName = "Element_" + this.elemAdded_;

        var newElem = {
            "type": "text",
            "name": elemName,
            "label": "",
            "required": false,
            "pattern": "",
            "nb_cols": 12
        };

        var selectedNodeId = aSelectedNode[0]['nodeId'];

        // si on est en mode avec lignes
        if (this.bTreeWithLines_) {
            // ajoute l'elem à la ligne
            data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].splice(aSelectedNode[0]["field"] + 1, 0, newElem);
            // sélectionne l'elem 
            selectedNodeId = selectedNodeId + 1;
        } else {// si on est en mode sans lignes 
            if (!lineAdded) {
                // création d'une nouvelle ligne si besoin
                this.addLine();
                // ajoute de l'elem dans la ligne
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]["fields"].push(newElem);
                // sélectionne l'elem 
                var lastLine = this.getLastLine()['nodeId'] + 1;
                if (aSelectedNode[0]["row"] + 1 === data[this.$rootScope_["selected_form_type"]]["rows"].length - 1) {
                    selectedNodeId = selectedNodeId + 2 + data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length;
                } else {
                    selectedNodeId = selectedNodeId + 1 + data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length;
                }
            } else {
                // ajoute de l'elem dans la ligne ajoutée précédemment
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].push(newElem);
                // sélectionne l'elem 
                selectedNodeId = selectedNodeId + 2;
            }

        }

        // resize les éléments de la ligne
        var row = data[this.$rootScope_['selected_form_type']]['rows'][aSelectedNode[0]['row']];
        this.resizeElementsOnRow(row);

        if (goog.isDefAndNotNull(data[this.$rootScope_['selected_form_type']]['tabs'])) {
            if (goog.isDefAndNotNull(data[this.$rootScope_['selected_form_type']]['tabs']['list'])) {
                if (goog.isDefAndNotNull(data[this.$rootScope_['selected_form_type']]['tabs']['list'][0])) {
                    if (goog.isArray(data[this.$rootScope_['selected_form_type']]['tabs']['list'][0]['elements'])) {
                        data[this.$rootScope_['selected_form_type']]['tabs']['list'][0]['elements'].push(elemName);
                    }
                }
            }
        }


        // recharge tout
        oVFB.setJsonOutput(data);
        this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());

        $("#TreeView_Button_Group")["confirmation"]("destroy");

        $('#treeWithLines')['treeview']('selectNode', [selectedNodeId, {silent: false}]);


        //$('#treeWithLines')['treeview']('clearSearch');
    } else {
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
};

/**
 * Remove the selected node
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.removeElement = function () {
    // Modification du studio 
    oVFB.Update = true;
    oVFB.log('nsVFB.FormTools.prototype.formToolsController.prototype.removeElement');

    var aSelectedNode = $('#treeWithLines')["treeview"]('getSelected'); //on récupére le noeud sélectionné
    var data = oVFB.getJsonOutput(); //on récupére l'objet JSON de sortie
    var this_ = this;

    if (aSelectedNode.length === 0) {
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
        return 0;
    }

    // Suppression d'une ligne
    if (goog.isDef(aSelectedNode[0]['nodes'])) {
        if (aSelectedNode[0]['nodes'].length > 1) {
            $["notify"](this["text"]["Notify"]["Multiple_elements"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
            return 0;
        }
        else
            aSelectedNode = aSelectedNode[0]['nodes'];
    }

    if (aSelectedNode.length === 1) {
        var oModal = bootbox.confirm('<h4>' + this["text"]["Confirmation"]["Remove"] + '</h4>', function (result) {
            if (result === true) {
                var row = data[this_.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]];
                var oElem = row["fields"][aSelectedNode[0]["field"]];
                var sElemName = oElem["name"];

                // Supprime l'élément des onglets
                if (goog.isDefAndNotNull(sElemName)) {
                    if (goog.isDefAndNotNull(data[this_.$rootScope_["selected_form_type"]]["tabs"])) {
                        var aList = data[this_.$rootScope_["selected_form_type"]]["tabs"]["list"];
                        if (goog.isArray(aList)) {
                            for (var i = 0; i < aList.length; i++) {
                                if (goog.isArray(aList[i]["elements"])) {
                                    if (aList[i]["elements"].indexOf(sElemName) !== -1) {
                                        aList[i]["elements"].splice(aList[i]["elements"].indexOf(sElemName), 1);
                                    }
                                }
                            }
                        }
                    }
                }
                // Supprime l'élément des états wab
                if (goog.isDefAndNotNull(sElemName)) {
                    var oWab = data[this_.$rootScope_["selected_form_type"]]["wab"];
                    if (goog.isDefAndNotNull(oWab)) {
                        for (var sState in oWab) {
                            for (var sGroup in oWab[sState]) {
                                if (goog.isDefAndNotNull(oWab[sState][sGroup][sElemName])) {
                                    delete oWab[sState][sGroup][sElemName];
                                }
                            }
                        }
                    }
                }

                // supprime l'élément sélectionné
                row["fields"].splice(aSelectedNode[0]["field"], 1);
                if (data[this_.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length === 0) {
                    data[this_.$rootScope_["selected_form_type"]]["rows"].splice(aSelectedNode[0]["row"], 1);
                }
                // resize les élem de la ligne
                this_.resizeElementsOnRow(row);
                // dé-select les élem
                $(".selected-in-tree").each(function (index, element) {
                    $(element).removeClass("selected-in-tree");
                });
                // Désélectionne l'élem
                oVFB.unselectAll();
                // recharge tout
                oVFB.setJsonOutput(data);
                this_.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());
                this_.$scope_.$apply();
                $("#Formtools_buttons")["confirmation"]("destroy");
                $["notify"](this_["text"]["Notify"]["Remove"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
            }
        });
        // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
        oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
    } else {
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
};

/**
 * Drag a node up
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.up = function () {
    // Modification du studio 
    oVFB.Update = true;
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.up");

    var this_ = this;
    var aSelectedNode = $('#treeWithLines')["treeview"]('getSelected'); // récupére le noeud sélectionné
    var selectedNodeId = aSelectedNode[0]['nodeId'];
    var data = oVFB.getJsonOutput();   // récupére l'objet JSON de sortie    

    // si un seul noeud est séléctionné
    if (aSelectedNode.length === 1) {
        if (!goog.isDef(aSelectedNode[0]["field"])) { // ligne
            if (aSelectedNode[0]["row"] - 1 >= 0) {
                //si se n'est pas le premier élément de la liste
                // fait une simple permutation
                var row = aSelectedNode[0]["row"];

                // inverse le "collapsage" des lignes
                var treeLine = aSelectedNode[0];
                var treePreviousLine = this.getPreviousLineBeforeIndex(selectedNodeId);
                var aCollapsedElements = $('#treeWithLines')["treeview"]('getCollapsed');

                treeLine['collapsed'] = goog.object.contains(aCollapsedElements, treeLine);
                treePreviousLine['collapsed'] = goog.object.contains(aCollapsedElements, treePreviousLine);

                if (treePreviousLine['collapsed'] === true) {
                    $('#treeWithLines')["treeview"]('collapseNode', treeLine['nodeId']);
                } else {
                    $('#treeWithLines')["treeview"]('expandNode', treeLine['nodeId']);
                }

                if (treeLine['collapsed'] === true) {
                    $('#treeWithLines')["treeview"]('collapseNode', treePreviousLine['nodeId']);
                } else {
                    $('#treeWithLines')["treeview"]('expandNode', treePreviousLine['nodeId']);
                }

                var tmp = treeLine['collapsed'];
                treeLine['collapsed'] = treePreviousLine['collapsed'];
                treePreviousLine['collapsed'] = treeLine['collapsed'];

                // inverse les contenus des lignes
                var tmp = data[this.$rootScope_["selected_form_type"]]["rows"][row - 1];
                data[this.$rootScope_["selected_form_type"]]["rows"][row - 1] = data[this.$rootScope_["selected_form_type"]]["rows"][row];
                data[this.$rootScope_["selected_form_type"]]["rows"][row] = tmp;
            }

            var previousLine = this.getPreviousLineBeforeIndex(selectedNodeId);
            selectedNodeId = previousLine['nodeId'];

            // si on est en mode sans lignes alors on sélectionne le premier élément de la ligne
            if (!this.bTreeWithLines_) {
                selectedNodeId = previousLine['nodes'][0]['nodeId'];
            }

        } else { // élément
            if (aSelectedNode[0]["field"] - 1 >= 0) {
                //si il n'est pas le premier de sa row on permute simplement
                var tmp = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"] - 1];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"] - 1] = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]] = tmp;
                selectedNodeId--;
            } else {
                //sinon il faut le changer de row
                // mémorise le noeud
                var courant = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]];

                // si il est contenu dans la première ligne
                if (aSelectedNode[0]['row'] === 0) {

                    // ajoute une ligne
                    this.addLine();

                    // déplace l'élément dans la ligne                        
                    data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]["fields"].push(courant);
                    data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].splice(aSelectedNode[0]["field"], 1);

                    // déplace la ligne en haut
                    var tmpLine = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]];
                    data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]] = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1];
                    data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1] = tmpLine;

                    //ajuste la taille des éléments de la ligne
                    this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]);
                    this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]);
                    // l'élément se situe alors à la position 1
                    selectedNodeId = 1;
                    // décollapse la ligne juste après
                    $('#treeWithLines')["treeview"]('expandNode', this.getNextLineAfterIndex(selectedNodeId));
                } else {

                    // si on est en mode sans lignes
                    if (!this.bTreeWithLines_) {

                        var currentLine = this.getPreviousLineBeforeIndex(selectedNodeId);
                        if (currentLine['nodes'].length === 1) {// si il n'y a qu'un seul elem dans la ligne, inverse simplement les lignes
                            // sélectionne la ligne dans laquelle est contenue l'élément
                            $('#treeWithLines')['treeview']('selectNode', [currentLine['nodeId'], {silent: true}]);
                            // monte la ligne
                            this.up();
                            return 0;
                        } else {// si il y a plusieurs élem, crée une nouvelle ligne pour la placer au dessus
                            // ajoute une ligne
                            this.addLine();

                            // déplace l'élément dans la ligne                        
                            data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]["fields"].push(courant);
                            data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].splice(aSelectedNode[0]["field"], 1);

                            // déplace la ligne en haut
                            var tmpLine = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]];
                            data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]] = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1];
                            data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1] = tmpLine;

                            //ajuste la taille des éléments de la ligne
                            this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]);
                            this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]);
                        }
                    } else {

                        // l'ajoute dans sa nouvelle ligne
                        data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] - 1]["fields"].push(courant);

                        // le supprime de l'ancienne
                        data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].splice(aSelectedNode[0]["field"], 1);

                        //ajuste la taille des éléments de la ligne
                        this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] - 1]);
                        this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]);

                        //si la ligne est vide on la supprime
                        if (data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length === 0) {
                            data[this.$rootScope_["selected_form_type"]]["rows"].splice(aSelectedNode[0]["row"], 1);
                        }

                        selectedNodeId--;

                        // expand la nouvelle ligne
                        var newLineId = this.getPreviousLineBeforeIndex(selectedNodeId);
                        $('#treeWithLines')["treeview"]('expandNode', newLineId);
                    }
                }

            }
        }
    } else {
        //sinon aucun noeud n'est sélectionné rappel à l'ordre de l'utilisateur
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
    // vide les lignes vides
    for (var i = 0; i < data[this.$rootScope_["selected_form_type"]]["rows"].length; i++) {
        if (data[this.$rootScope_["selected_form_type"]]["rows"][i]["fields"].length === 0) {
            data[this.$rootScope_["selected_form_type"]]["rows"].splice(i, 1);
        }
    }

    // recharge tout
    oVFB.setJsonOutput(data);
    this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());

    // re-sélectionne l'élément
    $('#treeWithLines')['treeview']('selectNode', [selectedNodeId, {silent: false}]);

};

/**
 * Drag a node down
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.down = function () {
    // Modification du studio 
    oVFB.Update = true;
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.down");

    var this_ = this;

    var aSelectedNode = $('#treeWithLines')["treeview"]('getSelected'); // récupére le noeud sélectionné
    var selectedNodeId = aSelectedNode[0]['nodeId'];
    var data = oVFB.getJsonOutput(); // récupére l'objet JSON de sortie

    // si un seul noeud est séléctionné
    if (aSelectedNode.length === 1) {
        // si c'est une ligne
        if (!goog.isDef(aSelectedNode[0]["field"])) {
            // si se n'est pas le dernier élément de la liste     
            if (aSelectedNode[0]["row"] + 1 < data[this.$rootScope_["selected_form_type"]]["rows"].length) {
                // inverse le "collapsage" des lignes
                var treeLine = aSelectedNode[0];
                var treeNextLine = this.getNextLineAfterIndex(selectedNodeId);
                var aCollapsedElements = $('#treeWithLines')["treeview"]('getCollapsed');

                treeLine['collapsed'] = goog.object.contains(aCollapsedElements, treeLine);
                treeNextLine['collapsed'] = goog.object.contains(aCollapsedElements, treeNextLine);

                if (treeNextLine['collapsed'] === true) {
                    $('#treeWithLines')["treeview"]('collapseNode', treeLine['nodeId']);
                } else {
                    $('#treeWithLines')["treeview"]('expandNode', treeLine['nodeId']);
                }

                if (treeLine['collapsed'] === true) {
                    $('#treeWithLines')["treeview"]('collapseNode', treeNextLine['nodeId']);
                } else {
                    $('#treeWithLines')["treeview"]('expandNode', treeNextLine['nodeId']);
                }

                var tmp = treeLine['collapsed'];
                treeLine['collapsed'] = treeNextLine['collapsed'];
                treeNextLine['collapsed'] = treeLine['collapsed'];

                // inverse les contenus des lignes
                var tmp = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1] = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]] = tmp;

            } else {
                // si on est en mode sans lignes on sélectionne l'élément
                if (!this.bTreeWithLines_) {
                    $('#treeWithLines')['treeview']('selectNode', [selectedNodeId + 1, {silent: false}]);
                }
                return 0;
            }

            // recharge l'arbre pour que getNextLineAfterIndex s'applique à la nouvelle configuration
            oVFB.setJsonOutput(data);
            this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());


            var nextLine = this.getNextLineAfterIndex(selectedNodeId);
            selectedNodeId = nextLine['nodeId'];

            // si on est en mode sans lignes
            if (!this.bTreeWithLines_) {
                selectedNodeId++;
            }
        } else { // si c'est un élément

            // si il n'est pas le dernier de sa row                
            if (aSelectedNode[0]["field"] + 1 < data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length) {

                // permute simplement
                var tmp = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"] + 1];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"] + 1] = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]];
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]] = tmp;
                selectedNodeId++;
            }
            //sinon il faut le changer de row
            else {

                // mémorise le noeud
                var courant = data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"][aSelectedNode[0]["field"]];

                // si on est en mode sans lignes
                if (!this.bTreeWithLines_) {

                    // si le courant est le seul de sa row
                    if ($('#treeWithLines')['treeview']('getNode', aSelectedNode[0]['parentId'])['nodes'].length === 1) {
                        // Sélectionne la ligne et fait un down() pour la descendre
                        $('#treeWithLines')['treeview']('selectNode', [aSelectedNode[0]['parentId'], {silent: false}]);
                        this.down();
                        return 0; // arrete tout
                    } else if (goog.isDef($('#treeWithLines')['treeview']('getNode', aSelectedNode[0]['nodeId'] + 1)['nodes'])) {// si ils sont plusieurs et qu'il est le dernier de sa row
                        this.addLine();
                    }
                }

                // si la row suivante n'existe pas, alors on la crée
                if (!goog.isDef(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]))
                    this.addLine();

                // l'ajoute dans sa nouvelle ligne
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]["fields"].unshift(courant);

                // le supprime de l'ancienne
                data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].splice(aSelectedNode[0]["field"], 1);

                //ajuste la taille des éléments de la ligne
                this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"] + 1]);
                this.resizeElementsOnRow(data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]);

                // décollapase la ligne sur laquelle on vient d'inserrer l'objet
                $('#treeWithLines')["treeview"]('expandNode', this.getNextLineAfterIndex(selectedNodeId));

                //si la ligne est vide la supprime
                if (data[this.$rootScope_["selected_form_type"]]["rows"][aSelectedNode[0]["row"]]["fields"].length === 0) {
                    data[this.$rootScope_["selected_form_type"]]["rows"].splice(aSelectedNode[0]["row"], 1);
                } else {
                    selectedNodeId++;
                }
            }
        }
    } else {
        //sinon aucun noeud n'est sélectionné rappel à l'ordre de l'utilisateur
        $["notify"](this["text"]["Notify"]["Forgotten"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
    // recharge tout
    oVFB.setJsonOutput(data);
    this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());

    // re-sélectionne l'élément
    $('#treeWithLines')['treeview']('selectNode', [selectedNodeId, {silent: false}]);
};

/**
 * Get the last line node
 * @returns {object} last line
 */
nsVFB.FormTools.prototype.formToolsController.prototype.getLastLine = function () {
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.getLastLine");

    var lastNodeIndex = this.getLastNodeIndex();
    var tmpNode;

    for (var i = lastNodeIndex; i >= 0; i--) {
        tmpNode = $('#treeWithLines')['treeview']('getNode', i);
        if (!goog.isDef(tmpNode["field"]))
            return tmpNode;
    }
    return $('#treeWithLines')['treeview']('getNode', 0);
};

/**
 * Get the last element node
 * @returns {object} last line
 */
nsVFB.FormTools.prototype.formToolsController.prototype.getLastElement = function () {
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.getLastElement");

    var lastNodeIndex = this.getLastNodeIndex();
    var tmpNode;

    for (var i = lastNodeIndex; i >= 0; i--) {
        tmpNode = $('#treeWithLines')['treeview']('getNode', i);
        if (goog.isDef(tmpNode["field"]))
            return tmpNode;
    }
    return $('#treeWithLines')['treeview']('getNode', 0);
};

/**
 * Get the next line
 * @param {integer} index
 * @returns {object} line node
 */
nsVFB.FormTools.prototype.formToolsController.prototype.getNextLineAfterIndex = function (index) {
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.getNextLineAfterIndex");

    var lastNodeIndex = this.getLastNodeIndex();
    var tmpNode;

    // si l'élément est une ligne, prend l'élément suivant
    if (!goog.isDef($('#treeWithLines')['treeview']('getNode', index)['field']))
        index++;

    for (var i = index; i < lastNodeIndex; i++) {
        tmpNode = $('#treeWithLines')['treeview']('getNode', i);
        if (!goog.isDef(tmpNode["field"]))
            return tmpNode;
    }

    return $('#treeWithLines')['treeview']('getNode', 0);
};

/**
 * Get the previous line line
 * @param {integer} index
 * @returns {object} line node
 */
nsVFB.FormTools.prototype.formToolsController.prototype.getPreviousLineBeforeIndex = function (index) {
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.getPreviousLineBeforeIndex");

    var tmpNode;

    // si l'élément est une ligne, prend l'élément précédent
    if (!goog.isDef($('#treeWithLines')['treeview']('getNode', index)['field']))
        index--;

    for (var i = index - 1; i >= 0; i--) {
        tmpNode = $('#treeWithLines')['treeview']('getNode', i);
        if (!goog.isDef(tmpNode["field"]))
            return tmpNode;
    }

    return $('#treeWithLines')['treeview']('getNode', 0);
};

/**
 * Get the index of the last node
 * @returns {integer} last node index
 */
nsVFB.FormTools.prototype.formToolsController.prototype.getLastNodeIndex = function () {
    oVFB.log("nsVFB.FormTools.prototype.formToolsController.prototype.getLastNodeIndex");

    var data = oVFB.getJsonOutput();
    var counter = 0;

    for (var i = 0; i < data[this.$rootScope_["selected_form_type"]]["rows"].length; i++) {
        counter++;
        for (var ii = 0; ii < data[this.$rootScope_["selected_form_type"]]["rows"][i]["fields"].length; ii++) {
            counter++;
        }
    }

    return counter - 1;
};

/**
 * resize the elements of the row
 * @param {object} row
 */
nsVFB.FormTools.prototype.formToolsController.prototype.resizeElementsOnRow = function (row) {
    oVFB.log('nsVFB.FormTools.prototype.formToolsController.prototype.resizeElementsOnRow');

    var numberOfElements = row['fields'].length;
    var newLength = parseInt(12 / numberOfElements);

    for (var i = 0; i < row['fields'].length; i++) {
        row['fields'][i]['nb_cols'] = newLength;
    }
};

/**
 * Set the selected element on the FormReader
 * @param {object} element
 * @param {string} element.type row/element
 * @param {string} element.row_id (for type = row)
 * @param {string} element.element_name (for type = element)
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.setSelectedElemInFormReader = function (selectedInTree) {
    angular.element($('#FormModal')).scope()['ctrl'].setSelectedElem(selectedInTree, this.$scope_['selected_form_type']);
};

/**
 * Set the hovered element on the FormReader
 * @param {object} element
 * @param {string} element.type row/element
 * @param {string} element.row_id (for type = row)
 * @param {string} element.element_name (for type = element)
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.setHoveredElemInFormReader = function (hoverInTree) {
    angular.element($('#FormModal')).scope()['ctrl'].setHoveredElem(hoverInTree, this.$scope_['selected_form_type']);
};

/**
 * Copy json in clipboard
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.copyToClipboard = function () {
    var oJson = oVFB.getJsonOutput();   //input
    var textArea = document.createElement("textarea");

    // Place in top-left corner of screen regardless of scroll position.
    textArea.style.position = 'fixed';
    textArea.style.top = 0;
    textArea.style.left = 0;

    // Ensure it has a small width and height. Setting to 1px / 1em
    // doesn't work as this gives a negative w/h on some browsers.
    textArea.style.width = '2em';
    textArea.style.height = '2em';

    // We don't need padding, reducing the size if it does flash render.
    textArea.style.padding = 0;

    // Clean up any borders.
    textArea.style.border = 'none';
    textArea.style.outline = 'none';
    textArea.style.boxShadow = 'none';

    // Avoid flash of white box if rendered for any reason.
    textArea.style.background = 'transparent';


    textArea.value = JSON.stringify(oJson);

    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();

    try {
        var successful = document.execCommand('copy');
        var msg = successful ? 'successful' : 'unsuccessful';
        console.log('Copying text command was ' + msg);
    } catch (err) {
        console.log('error during copy' + err);
    }

    document.body.removeChild(textArea);
};


/**
 * Copy json in clipboard nécessite une permission du navigateur
 * @export
 */
/*nsVFB.FormTools.prototype.formToolsController.prototype.pasteFromClipboard = function () {
    var oJson = oVFB.getJsonOutput();   //en cas d'erreur
    var textArea = document.createElement("textarea");

    // Place in top-left corner of screen regardless of scroll position.
    textArea.style.position = 'fixed';
    textArea.style.top = 0;
    textArea.style.left = 0;

    // Ensure it has a small width and height. Setting to 1px / 1em
    // doesn't work as this gives a negative w/h on some browsers.
    textArea.style.width = '2em';
    textArea.style.height = '2em';

    // We don't need padding, reducing the size if it does flash render.
    textArea.style.padding = 0;

    // Clean up any borders.
    textArea.style.border = 'none';
    textArea.style.outline = 'none';
    textArea.style.boxShadow = 'none';

    // Avoid flash of white box if rendered for any reason.
    textArea.style.background = 'transparent';


    //textArea.value = JSON.stringify(oJson);

    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();

    try {
        var successful = document.execCommand('paste');
        var msg = successful ? 'successful' : 'unsuccessful';
        console.log('Pasting text command was ' + msg);
        oJson = JSON.parse(textArea.value);

    } catch (err) {
        console.log('error during copy' + err);
    }
    oVFB.setJsonOutput(oJson);
    document.body.removeChild(textArea);
};*/


/**
 * Copy Attribute from a mode
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.copy = function () {
    var oJson = oVFB.getJsonOutput();   //input
    
    // Modification du studio 
    oVFB.Update = true;

    this.$scope_["copyPasteContainer"] = angular.copy(oJson[this.$rootScope_["selected_form_type"]]);
};

/**
 * Paste Attribute in a mode
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.paste = function () {
    var oJson = oVFB.getJsonOutput();   //input
    // Modification du studio 
    oVFB.Update = true;
    oJson[this.$rootScope_["selected_form_type"]] = angular.copy(this.$scope_["copyPasteContainer"]);

    oVFB.setJsonOutput(oJson); // on Memorise
    this.$rootScope_.$broadcast("updateEvent", oVFB.getJsonOutput());
};

/**
 * Paste Attribute in a mode
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.labelizeForm = function () {
    // Modification du studio 
    oVFB.Update = true;
    this.$rootScope_.$broadcast("labelizeForm", null);
};


/**
 * Open the modal to generate method JSON Code
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.openModalMethodcreator = function(){
    var $scope = this.$scope_;
    var $this = this;
    var sModuleName = $scope["module"];
    var sObjectName = $scope["object"];

    ajaxRequest({
        'method': 'POST',
        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/wab/methods",
        'headers': {
            'Accept': 'application/x-vm-json',
            'X-HTTP-Method-Override': 'GET'
        },
        'scope': $scope,
        'data': {
            "sort_order" : 'ASC',
            // "attributs": "name",
            "distinct": true,
            'filter': {
                "relation": "AND",
                "operators": [{
                        'column': 'module_id',
                        'compare_operator': '=',
                        'value': sModuleName
                    }, {'column': 'bo_name',
                        'compare_operator': '=',
                        'value': sObjectName
                    }]
            }
        },
        'success': function (response) {
            console.log(response);
            $this.$rootScope_["aBoMethods"] = response["data"]["data"];
            //génération du champ groupe (1btn = 1grp) et du champ label (utilisation du camelCase) 
            for (var i = 0; i < $this.$rootScope_["aBoMethods"].length; i++){
                $this.$rootScope_["aBoMethods"][i]['group'] = $this.$rootScope_["aBoMethods"][i]['name'] + '_' + i;
                var sFinalLabel = '';
                var iLastIndex = 0;
                var iStartIndex = 1;
                if($this.$rootScope_["aBoMethods"][i]['name'].indexOf('tr') === 0){
                    iLastIndex = 2;
                    iStartIndex = 3;
                }
                //créer un label à partir du nom de la méthode en utilisant le CamelCase
                for(var j = iStartIndex; j < $this.$rootScope_["aBoMethods"][i]['name'].length; j++){
                    if($this.$rootScope_["aBoMethods"][i]['name'][j] === $this.$rootScope_["aBoMethods"][i]['name'][j].toUpperCase() && 
                        $this.$rootScope_["aBoMethods"][i]['name'][j-1] === $this.$rootScope_["aBoMethods"][i]['name'][j-1].toLowerCase()){
                        sFinalLabel += $this.$rootScope_["aBoMethods"][i]['name'].substring(iLastIndex, j) + ' ';
                        iLastIndex = j;
                    }
                }
                // copie le dernier mot du nom
                sFinalLabel += $this.$rootScope_["aBoMethods"][i]['name'].substring(iLastIndex);
                $this.$rootScope_["aBoMethods"][i]['label'] = sFinalLabel;
            }
            
            $('#studio-wabmanager-method-modal').modal('show');
        }
    });
}

/**
 * Paste Attribute in a mode
 * @export
 */
nsVFB.FormTools.prototype.formToolsController.prototype.idName = function () {
    // Modification du studio 
    oVFB.Update = true;

    var oJson = oVFB.getJsonOutput()
    var oForm;

    for (var sFormName in oJson) {
        oForm = oJson[sFormName];
        if (goog.isDefAndNotNull(oForm['rows'])) {
            for (var i = 0; i < oForm['rows'].length; i++) {
                if (goog.isDefAndNotNull(oForm['rows'][i]['fields'])) {
                    for (var ii = 0; ii < oForm['rows'][i]['fields'].length; ii++) {
                        oForm['rows'][i]['fields'][ii]['id'] = oForm['rows'][i]['fields'][ii]['name'];
                    }
                }
            }
        }
    }

    oVFB.setJsonOutput(oJson); // on Memorise
    this.$rootScope_.$broadcast("updateEvent", oVFB.getJsonOutput());

};


/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/
