/* global goog, nsVFB, oVFB, angular, bootbox */

/**
 * @author: Anthony Borghi, Armand Bahi
 * @Description: Fichier contenant la classe nsVFB.JsonLoader
 * cette classe permet de recevoir un fichier Json et de le sauvegarder
 */

/*********************************************************************************************************
 *  TODO LIST  (100%)
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.JsonLoader');

goog.require('goog.array');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object JsonLoader
 * @constructor
 * @export
 */
nsVFB.JsonLoader = function () {
    oVFB.log('nsVFB.JsonLoader');

    this.slider = null;

    oVFB.module.directive('appJsonLoader', this.jsonLoaderDirective);
    oVFB.module.controller('AppJsonLoaderController', ["$scope", "$rootScope", "$timeout", this.jsonLoaderController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderDirective = function () {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderDirective');
    return {
        restrict: 'A',
        replace: true,
        controller: 'AppJsonLoaderController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/JsonLoader.html'
    };
};

/**
 * Charge le controlleur lié au composant
 * @param {object} $rootScope AngularJS's service who return the root scope, parent of all others scopes.
 * @param {object} $timeout AngularJS's service who wrap window.timeout who delay execution of a function
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController = function ($scope, $rootScope, $timeout) {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController');

    var this_ = this;

    this.$scope_ = $scope;
    this.$rootScope_ = $rootScope;
    this.tmpForm_ = {};
    this["buttonHide"] = false;
    //this['applicationName'] = sessionStorage['application'];
    this['aSuggestedTableFields'] = [];

    this['applicationName'] = oVFB.getApplication();

    $scope['collapsed'] = oVFB.Collapse_[0];
    $scope["iWorkspaceId"] = oVFB.getId();
    $scope["iWorkSpace"] = oVFB.getId();
    $scope["default"] = "Default";
    $scope["FormSelected"] = "Perso";
    $scope["token"] = oVFB.getToken();
    $rootScope["selected_form_type"] = oVFB['config']['default_form_type'];

    $rootScope.$watch("selected_form_type", function (value) {
        oVFB.log("jsonLoaderController selected_form_type");

        var oJSONform = oVFB.getJsonOutput();

        if (!goog.isDefAndNotNull(oJSONform[value])) {
            oJSONform[value] = {"name": "custom-form", "title": "", "input_size": "xxs", "nb_cols": 12, "javascript": false, "rows": []};
            oVFB.setJsonOutput(oJSONform);
        }

        $rootScope.$broadcast("updateEvent", oVFB.getJsonOutput());
        $rootScope.$broadcast('update element', {type: "undefined"});
    });

    oVFB.getJsonLoader().slider = new Slider('#slider_Form', {
        "formatter": function (value) {
            return Math.round(value * 100 / 12) + "%";  //retourne la valeur sous un forme de pourcentage plus simple pour l'utilisateur
        }
    });

    //sur changement de la valeur du slider le formulaire change aussi
    oVFB.getJsonLoader().slider.on("change", function () {
        var tmp = oVFB.getJsonOutput();
        tmp[$rootScope["selected_form_type"]]['nb_cols'] = oVFB.getJsonLoader().slider["getValue"]();
        oVFB.setJsonOutput(tmp);
        $timeout(function () {
            $rootScope.$broadcast('updateJsonModel', oVFB.getJsonOutput());
            $rootScope.$broadcast('updateForm', oVFB.getJsonOutput());
            $scope.$apply();
        }, 1);
    });

    //Sur un changement de titre on set l'objet
    $scope.$watch("title", function (value) {
        oVFB.log("jsonLoaderController title");
        var tmp = oVFB.getJsonOutput();
        if (tmp[$rootScope["selected_form_type"]]) {
            tmp[$rootScope["selected_form_type"]]['title'] = value;
        }
        oVFB.setJsonOutput(tmp);
        $rootScope.$broadcast('updateJsonModel', oVFB.getJsonOutput());
        $rootScope.$broadcast('updateForm', oVFB.getJsonOutput());
    });

    //Sur un changement de titre on set l'objet
    $scope.$watch("event", function (value) {
        oVFB.log("jsonLoaderController event");
        var tmp = oVFB.getJsonOutput();
        if (tmp[$rootScope["selected_form_type"]]) {
            tmp[$rootScope["selected_form_type"]]['event'] = value;
        }
        oVFB.setJsonOutput(tmp);
        $rootScope.$broadcast('updateJsonModel', oVFB.getJsonOutput());
        $rootScope.$broadcast('updateForm', oVFB.getJsonOutput());
    });

    $scope.$watch("token", function (value) {
        oVFB.log("jsonLoaderController token");
        oVFB["setToken"](value);
    });

    $scope.$watch("iWorkspaceId", function (value) {
        oVFB.log("jsonLoaderController id");
        oVFB["setId"](value);
    });

    $scope.$watch("text", function () {
        oVFB.log("jsonLoaderController text");
        if (typeof $scope["text"]["Loader"] !== "undefined") {
            this_["text"] = $scope["text"]["Loader"];

            // Appelle récursivement toutes les secondes tant que la directive Angular n'est pas chargée
            var loadApp = function () {
                if (goog.isDefAndNotNull(angular.element($("#FormModal")).scope())) {
                    angular.element($("#load_Perso_button")).click();
                    if (oVFB.getApplication() == 'wab') {
                        this_["buttonHide"] = true;
                    }
                }else{
                    setTimeout(function () {
                        loadApp();
                    }, 1000);
                }
            };
            $timeout(function () {
                loadApp();
            });
        }
    });



    $scope.state = false;
};

/**
 * Request on Json and save it in app
 * @param {function} successCallback
 * @param {function} errorCallback
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.requestToJson = function (successCallback, errorCallback) {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.requestToJson');

    var this_ = this;
    var headers = {};
    var params = {};

    // Vide les valeurs présentes dans aFormValues
    angular.element($('#FormModal')).scope()['ctrl'].emptyFormValues();
    //on charge les données du composants
    this.$scope_['iWorkSpace'] = this.$scope_['iWorkspaceId'];
    //Selection du formulaire personnalisé ou non
    this.$scope_['default'] = this.$scope_['FormSelected'];

    this.$scope_['collapsed'] = oVFB.Collapse_[0];

    if (this['applicationName'] === 'gtf') {
        var url = oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/gtf/workspaces/" + oVFB.getId();
        headers = {
            "Accept": "application/json"
        };
        params = {
            'form': this.$scope_["FormSelected"]
        };
    } else if (this['applicationName'] === 'vmap') {
        var form = this.$scope_['FormSelected'] === 'Perso' ? 'custom' : angular.lowercase(this.$scope_['FormSelected']);
        var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/' + oVFB['config']['get']['api'] + '/' + oVFB['config']['get']['ressource'] + '/' + oVFB.getId() + '/forms/' + form + '/';
    } else if (this['applicationName'] === 'wab') {
        url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/' + oVFB['config']['get']['api'] + '/' + oVFB['config']['get']['ressource'] + '/' + oVFB.getId() + '/form';
    }


    //requete sur le formulaire Json
    showAjaxLoader();
    ajaxRequest({
        'method': 'GET',
        'url': url,
        'headers': headers,
        'params': params,
        'scope': this.$scope_,
        'success': function (data) {
            hideAjaxLoader();

            if (!goog.isDefAndNotNull(data[0])) {
                if (goog.isDefAndNotNull(data['data'])) {
                    data = data['data'];
                }
            }

            // Cas où il n'y a pas de résultat
            if (this_['applicationName'] === 'gtf') {
                if (!goog.isDefAndNotNull(data["workspaces"]) && !goog.isDefAndNotNull(data["data"])) {
                    var cmd;
                    switch (this_.$scope_['FormSelected']) {
                        case 'Default':
                            cmd = "Default_Reset";
                            break;
                        case 'Published':
                            cmd = "Default_Published";
                            break;
                        case 'Perso':
                            cmd = "Perso_Reset";
                            break;
                    }
                    this_.putRequest(cmd, undefined, function (data) {

                        // Cas d'erreur du put
                        if (goog.isDefAndNotNull(data['errorMessage'])) {
                            bootbox.alert('<h4>' + data['errorMessage'] + '</h4>', function () {
                            });
                            return 0;
                        }
                        // relance le chargement
                        this_.requestToJson();

                    }, function (data, status) {
                        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["GetJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                    });
                }
            } else {
                if (!goog.isDefAndNotNull(data[0])) {
                    if (goog.isDefAndNotNull(oVFB['config']['get']['no_result_function'])) {
                        this_[oVFB['config']['get']['no_result_function']](data, successCallback);
                    }
                    return 0;
                }
            }

            this_.useJson(data, successCallback);
        },
        'error': function (response) {
            hideAjaxLoader();
            if (goog.isFunction(errorCallback))
                this_.$scope_.$eval(errorCallback);
            $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["GetJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
        }
    });
};

/**
 *
 * @param {object} data
 * @param {function} successCallback
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.useJson = function (data, successCallback) {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.useJson');

    if (this['applicationName'] === 'gtf') {
        if (goog.isDefAndNotNull(data["workspaces"]))
            data = data["workspaces"][0]["json_form"];
        else
            data = data["data"][0]["json_form"];
    }

    //sauvegarde de l'objet Json
    if (!goog.isDefAndNotNull(data[0])) {
        console.error('data[0] not defined, data: ', data);
        return 0;
    }

    oVFB.setJson(angular.copy(data[0]));
    oVFB.setJsonOutput(angular.copy(data[0]));
    this.tmpForm_ = angular.copy(data[0]);

    // Formulaires disponibles
    if (goog.isDefAndNotNull(oVFB['config']['avaliable_form_types'])) {
        this.$scope_['json_forms'] = oVFB['config']['avaliable_form_types'];
    } else {
        this.$scope_['json_forms'] = Object.keys(data[0]);
    }

    // supprime "datasources" de la liste des formulaires
    if (this.$scope_['json_forms'].indexOf('datasources') !== -1)
        this.$scope_['json_forms'].splice(this.$scope_['json_forms'].indexOf('datasources'), 1);

    if (goog.isDef(data[1]) && data[1] !== false) {
        if (this['applicationName'] === 'gtf') {

            ajaxRequest({
                'method': 'GET',
                'url': data[1],
                'scope': this.$scope_,
                'timeout': 5000,
                "responseType": "text",
                'success': function (response) {
                    if (goog.isDefAndNotNull(response.data)) {
                        oVFB.setJs(response.data.replace(/(?:\r\n|\r|\n)/g, "\r\n"));
                    }
                },
                'error': function (response) {
                    console.error("Problem on Loading javascript");
                }
            });
        } else {
            oVFB.setJs(oVFB.clone(data[1]));
        }
        this.$rootScope_.$broadcast('updateJS', oVFB.getJs());
    } else {
        oVFB.setJs('');
        this.$rootScope_.$broadcast('updateJS', oVFB.getJs());
    }
    //si CSS on le charge
    if (goog.isDef(data[2]) && data[2] !== false) {
        oVFB.setCss(oVFB.clone(data[2]));
        this.$rootScope_.$broadcast('updateCSS', data[2]);
    }

    // Cas ou le formulaire selectionné n'existe pas
    if (!goog.isDefAndNotNull(data[0][this.$rootScope_["selected_form_type"]])) {
        console.error('Result[0][' + this.$rootScope_["selected_form_type"] + '] does not exist');
        return 0;
    }

    var nbCols = data[0][this.$rootScope_["selected_form_type"]]['nb_cols'];
    var title = oVFB.getJsonOutput()[this.$rootScope_["selected_form_type"]]['title'];
    var event = oVFB.getJsonOutput()[this.$rootScope_["selected_form_type"]]['event'];
    var inputSize = oVFB.getJsonOutput()[this.$rootScope_["selected_form_type"]]['input_size'];

    oVFB.getJsonLoader().slider["setValue"](nbCols);
    this.$scope_["title"] = title;
    this.$scope_["event"] = event;
    this.$scope_["input_size"] = inputSize;

    //On emet le signal de mise à jour dans toute l'application
    this.$rootScope_.$broadcast('updateEvent', oVFB.getJsonOutput());
    this.$rootScope_.$broadcast('updateInfos', oVFB.getJsonOutput());
    this.$rootScope_.$broadcast('update element', {type: "undefined"});

    // Lance successCallback si il a été défini
    if (goog.isFunction(successCallback))
        this.$scope_.$eval(successCallback);

    // Recharge le formulaire
    setTimeout(function () {
        oVFB.reloadForm();
        angular.element($('#studio_form_reader').children()).scope()['ctrl'].refreshForm()
    }, 1);
};

/**
 * Load a form with or without edit
 * @param {type} mode type (ex: Published)
 * @param {type} el button of the mode
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.load = function (mode, el) {

    oVFB.log('load');
    if (mode === "Perso") {
        this.loadWithEdit(true, mode, el);
    } else {
        this.loadWithoutEdit(mode, el);
    }
};

/**
 * update slider Value
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.updateSlider = function () {
    var nbCols = oVFB.getJsonOutput()[this.$rootScope_["selected_form_type"]]['nb_cols'];
    oVFB.getJsonLoader().slider["setValue"](nbCols);
};

/**
 * Load an object Json from the server and save him
 * @param {boolean} target choice element for confirmation's instance
 * @param {string} mode type (ex: Published)
 * @param {string} element button of the mode
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.loadWithEdit = function (target, mode, element) {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController.loadWithEdit');

    var this_ = this;

    var el = "";
    if (target) {
        el = "#json_loader_Mode_groupButton";
    } else {
        el = "#json_loader_Actions_groupButton";
    }

    var unlock = function () {
        $("#up_element_button").prop("disabled", false);
        $("#down_element_button").prop("disabled", false);
        $("#add_line_button").prop("disabled", false);
        $("#add_row_button").prop("disabled", false);
        $("#rem_element_button").prop("disabled", false);
        $("#formTools_datasoure_button").prop("disabled", false);

        $("#Title_Form_input").prop("disabled", false);
        $("#select_size_input").prop("disabled", false);
        oVFB.getJsonLoader().slider["enable"]();
        $("#boolean-JS-include").prop("disabled", false);
        $("#boolean-CSS-include").prop("disabled", false);

        $("#Lock_Icon").removeClass("fa-lock");
        $(".selected-in-tree").removeClass("selected-in-tree");
    };
    //chargement de l'objet Json
    if (!oVFB.getJson()["empty"] && this_.$scope_["default"] === "Perso") {
        //si il y a déjà un objet chargé
        //on demande confirmation avant d'en recharger un autre
        var oModal = bootbox.confirm('<h4>' + this["text"]["Confirmation"]["Lose"] + '</h4>', function (result) {
            if (result === true) {
                // Vide oFormValues du FormReader
                angular.element($('#FormModal')).scope()['ctrl'].emptyFormValues();
                // Charge le formulaire
                this_.$scope_["FormSelected"] = mode;
                this_.requestToJson();
                unlock();
            }
        });
        // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
        oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);

    } else if (this_.$scope_["default"] !== "Perso") {
        //si on a rien chargé alors pas de confirmation
        this_.$scope_["FormSelected"] = mode;
        this_.requestToJson();
        unlock();
    } else {
        this_.requestToJson();
        this_.$scope_["FormSelected"] = mode;
    }
};

/**
 * Load an object Json from the server and save him
 * @param {string} mode type (ex: Published)
 * @param {string} el button of the mode
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.loadWithoutEdit = function (mode, el) {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController.loadWithoutEdit');

    var this_ = this;

    // Rend les éléments disabled
    var lock = function () {
        $("#up_element_button").prop("disabled", true);
        $("#down_element_button").prop("disabled", true);
        $("#add_line_button").prop("disabled", true);
        $("#add_row_button").prop("disabled", true);
        $("#rem_element_button").prop("disabled", true);
        $("#formTools_datasoure_button").prop("disabled", true);

        $("#Title_Form_input").prop("disabled", true);
        $("#select_size_input").prop("disabled", true);
        oVFB.getJsonLoader().slider["disable"]();
        $("#boolean-JS-include").prop("disabled", true);
        $("#boolean-CSS-include").prop("disabled", true);

        this_.$rootScope_.$broadcast("update element", {});

        $("#Lock_Icon").addClass("fa-lock");
        $(".selected-in-tree").removeClass("selected-in-tree");
    };

    //chargement de l'objet Json
    if (!oVFB.getJson()["empty"] && this_.$scope_["default"] === "Perso") {

        // Si il n'y a pas eut de modifications
        if (angular.equals(oVFB.getJson(), this_.tmpForm_)) {
            // Vide oFormValues du FormReader
            angular.element($('#FormModal')).scope()['ctrl'].emptyFormValues();
            // Charge le formulaire
            this_.$scope_["FormSelected"] = mode;
            this_.requestToJson();
            lock();
        } else {
            bootbox.dialog({
                message: '<h4>' + this_["text"]["Confirmation"]["Lose"] + '<br><br>' + this_["text"]["Confirmation"]["SaveAndChange"] + ' ?</h4>',
                buttons: {
                    success: {
                        label: this_["text"]["Confirmation"]["Yes"],
                        className: "btn-primary",
                        callback: function () {
                            this_.save(function () {
                                this_.$scope_["FormSelected"] = mode;
                                this_.requestToJson();
                                lock();
                            });
                        }
                    },
                    danger: {
                        label: this_["text"]["Confirmation"]["No"],
                        className: "btn-danger",
                        callback: function () {
                            this_.$scope_["FormSelected"] = mode;
                            this_.requestToJson();
                            lock();
                        }
                    },
                    main: {
                        label: this_["text"]["Confirmation"]["Cancel"],
                        className: "btn-default",
                        callback: function () {

                        }
                    }
                }
            });
        }
    } else if (this_.$scope_["default"] !== "Perso") {
        //si on a rien chargé alors pas de confirmation
        this_.$scope_["FormSelected"] = mode;
        this_.requestToJson();
        lock();
    }
};

/**
 * Resize jsonLoader element
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.resize = function () {
    this.$scope_["collapsed"] = !this.$scope_["collapsed"];
    oVFB.Collapse_[0] = this.$scope_["collapsed"];
    oVFB.resize();
};

/**
 * save the data in json and upload it on server
 * @param {function} successCallback
 * @param {function} errorCallback
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.save = function (successCallback, errorCallback) {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController.save');

    var this_ = this;
    var data = new FormData();
    var tmp = oVFB.getJsonOutput();

    // Supprime les elements selectionnés
    oVFB.unselectAll();
    tmp = oVFB.cleanFormToSave(tmp);

    /*if ($("#boolean-JS-include").prop("checked")) {
     tmp[this_.$rootScope_["selected_form_type"]]["javascript"] = true;
     } else {
     tmp[this_.$rootScope_["selected_form_type"]]["javascript"] = false;
     }

     if ($("#boolean-CSS-include").prop("checked")) {
     tmp[this_.$rootScope_["selected_form_type"]]["style"] = true;
     } else {
     tmp[this_.$rootScope_["selected_form_type"]]["style"] = false;
     }*/

    if (this['applicationName'] === 'gtf') {
        tmp[this_.$rootScope_["selected_form_type"]]["name"] = "WSubform";
        tmp["display"] = tmp[this_.$rootScope_["selected_form_type"]];
        tmp["update"] = tmp[this_.$rootScope_["selected_form_type"]];
    }

    if (!goog.isDef(tmp["search"])) {
        tmp["search"] = {};
    }

    data.append("Json", JSON.stringify(tmp));
    data.append("Js", oVFB.getJs());
    data.append("Css", oVFB.getCss());

    var success = function () {
        this_.requestToJson(successCallback);
        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["SaveData"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
    };
    var error = function (data, status) {
        if (goog.isFunction(errorCallback))
            this_.$scope_.$eval(errorCallback);
        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["SaveData_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    };

    oVFB.valid = this.isValid(tmp);

    if (oVFB.valid && tmp !== null) {
        this_.putRequest("Perso_Save", data, success, error);
    } else {
        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["Validation_Error"] + ': ' + oVFB.aNotValid, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
    // Sauvegarde du studio Modifications Sauvegardées
    oVFB.Update = false;
};

/**
 * Publish custom form
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.publish = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.publish');

    oVFB.Update = false;
    var this_ = this;
    var data = new FormData();
    var tmp = oVFB.getJsonOutput();

    // Supprime les elements selectionnés
    oVFB.unselectAll();

    /*if ($("#boolean-JS-include").prop("checked")) {
     tmp[this_.$rootScope_["selected_form_type"]]["javascript"] = true;
     } else {
     tmp[this_.$rootScope_["selected_form_type"]]["javascript"] = false;
     }

     if ($("#boolean-CSS-include").prop("checked")) {
     tmp[this_.$rootScope_["selected_form_type"]]["style"] = true;
     } else {
     tmp[this_.$rootScope_["selected_form_type"]]["style"] = false;
     }*/

    if (this['applicationName'] === 'gtf') {
        tmp[this_.$rootScope_["selected_form_type"]]["name"] = "WSubform";
        tmp["display"] = tmp[this_.$rootScope_["selected_form_type"]];
        tmp["update"] = tmp[this_.$rootScope_["selected_form_type"]];
    }

    data.append("Json", JSON.stringify(tmp));
    data.append("Js", oVFB.getJs());
    data.append("Css", oVFB.getCss());

    var success = function () {
//        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["SaveData"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
        var data = "";
        var success = function () {
            this_.requestToJson();
            $["notify"](this_.$scope_["FormSelected"] + this_.$scope_["text"]["Loader"]["Notify"]["PublishAndSave"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
        };
        var error = function (data, status) {
            $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["Publish_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
        };

        this_.putRequest(this_.$scope_["FormSelected"] + "_Published", data, success, error);
    };
    var error = function (data, status) {
        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["SaveData_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    };
    if (oVFB.valid) {
        if (this_.$scope_["FormSelected"] != "Default") {
            this_.putRequest("Perso_Save", data, success, error);
        } else {
            this_.putRequest("Default_Published", data, success, error);

        }
    } else {
        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["Validation_Error"], {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
    }
};

/**
 * Check the whitespaces on the form and fill oVFB.aNotValid
 * @param {object} oForm
 * @returns {Boolean} true if any whitespace was detected
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.isValid = function (oForm) {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController.save');

    goog.array.clear(oVFB.aNotValid);

    for (var formName in oForm) {
        if (formName !== 'datasources') {
            if (goog.isDefAndNotNull(oForm[formName]['rows'])) {
                for (var i = 0; i < oForm[formName]['rows'].length; i++) {
                    for (var ii = 0; ii < oForm[formName]['rows'][i]['fields'].length; ii++) {
                        // Si il y a un espace dans le nom
                        if (oForm[formName]['rows'][i]['fields'][ii]['name'].match(/\s/g) !== null) {
                            // Pour gtf, pas besoin de spécifier le formName
                            if (this['applicationName'] === 'gtf')
                                oVFB.aNotValid.push(oForm[formName]['rows'][i]['fields'][ii]['name']);
                            else {
                                if (oVFB['config']['avaliable_form_types'].length < 1)
                                    oVFB.aNotValid.push(oForm[formName]['rows'][i]['fields'][ii]['name']);
                                else
                                    oVFB.aNotValid.push(formName + '.' + oForm[formName]['rows'][i]['fields'][ii]['name']);
                            }
                        }
                    }
                }
            }
        }
    }

    if (oVFB.aNotValid.length > 0)
        return false;
    else
        return true;
};

/**
 * Reset Json data with origin Json Data
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.reset = function () {
    oVFB.log('nsVFB.JsonLoader.jsonLoaderController.reset');

    var this_ = this;

    var oModal = bootbox.confirm('<h4>' + this["text"]["InfoBulle"]["Perso"]["Reset"] + ' ?</h4>' +
                    '<h4>' + this["text"]["Confirmation"]["Lose"] + '</h4>', function (result) {
        if (result === true) {

            if (this_.$scope_["FormSelected"] === "Default" && this_['applicationName'] !== 'gtf') {
                if (goog.isDefAndNotNull(oVFB['config']['reset_default_function'])) {
                    this_[oVFB['config']['reset_default_function']]();
                }
            } else {
                var data = "";
                var success = function () {
                    $["notify"](this_.$scope_["FormSelected"] + this_.$scope_["text"]["Loader"]["Notify"]["Reset"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
                    if (this_.$scope_["FormSelected"] === "Perso") {
                        this_.requestToJson();
                    }
                };
                var error = function (data, status) {
                    $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["Reset_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
                };
                this_.putRequest(this_.$scope_["FormSelected"] + "_Reset", data, success, error);
            }
        }
    });
    // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
    oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
};

/**
 * Make a put request on the server
 * @param {string} cmd command to load (Perso_Save, Perso_Published, Default_Published, Perso_Reset etc...)
 * @param {object} data FormData to send
 * @param {function} functSuccess function to load in case of success
 * @param {function} functError function to load in case of error
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.putRequest = function (cmd, data, functSuccess, functError) {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.putRequest');

    var url = '';
    var params = {};
    if (this['applicationName'] === 'gtf') {
        url = oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["services_alias"] + "/gtf/workspaces/" + oVFB.getId();
        params = {
            'cmd': cmd
        };
    } else if (this['applicationName'] === 'vmap') {
        var form = this.$scope_['FormSelected'] === 'Perso' ? 'custom' : angular.lowercase(this.$scope_['FormSelected']);
        url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/' + oVFB['config']['get']['api'] + '/' + oVFB['config']['get']['ressource'] + '/' + oVFB.getId() + '/forms/' + form;
        params = {
            'cmd': cmd
        };
    } else if (this['applicationName'] === 'wab') {
        url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/' + oVFB['config']['get']['api'] + '/' + oVFB['config']['get']['ressource'] + '/' + oVFB.getId() + '/form';
    }

    ajaxRequest({
        'method': 'PUT',
        'url': url,
        'headers': {
            "Content-Type": "undefined"
        },
        'params': params,
        'data': data,
        'scope': this.$scope_,
        'success': functSuccess,
        'error': functError
    });

//    this.$http_({
//        url: url,
//        method: 'PUT',
//        data: data,
//        headers: {
//            "Content-Type": "undefined"
//        }
//    }).success(functSuccess).error(functError);
};

/**
 * Suggest to the user if he want to generate a json form by the business object table
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestGenerateForm = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestGenerateForm');

    var this_ = this;
    var oModal = bootbox.confirm('<h4>' + this.$scope_['text']['Loader']['Notify']['generate_form'] + '</h4>', function (result) {
        if (result === true) {
            this_.suggestColumnsToGenerateForm();
        } else {
            this_['aSuggestedTableFields'] = [];
            this_.generateFormByBusinessObject();
        }
    });
    // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
    oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
};

/**
 * Use an empty form
 * @param {type} data
 * @param {type} successCallback
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.useEmptyForm = function (data, successCallback) {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.useEmptyForm');

    $.notify(this.$scope_["text"]["Loader"]["Notify"]["no_form"], 'warning');

    var aTypes = goog.isDef(oVFB['config']['avaliable_form_types']) ? oVFB['config']['avaliable_form_types'] : ['search', 'insert', 'update', 'display'];

    // Formulaire vide
    var emptyForm = {
        'input_size': 'xxs',
        'javascript': false,
        'name': 'custom-form',
        'nb_cols': 12,
        'rows': [],
        'title': ''
    };

    data[0] = {
        'datasources': {}
    };

    // Pour chaque type de formulaire, donne le formulaire par défaut
    for (var i = 0; i < aTypes.length; i++) {
        data[0][aTypes[i]] = emptyForm;
    }

    // Utilise le formulaire
    this.useJson(data, successCallback);
};

/**
 *  Ask for witch field to use
 *  @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsToGenerateForm = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsToGenerateForm');

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vmap/businessobjects/' + oVFB.getId() + '/fields/';
    if (oVFB.getApplication() === 'wab') {
        url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/wab/sections/' + oVFB.getId() + '/fields';
    }
    var this_ = this;

    // Vide le précédent tableau si il existe
    if (goog.isDef(this_['aSuggestedTableFields']))
        goog.array.clear(this_['aSuggestedTableFields']);

    ajaxRequest({
        'method': 'GET',
        'url': url,
        'headers': {'Accept': 'application/x-vm-json'},
        'scope': this.$scope_,
        'success': function (response) {
            if (!goog.isArray(response["data"]) || response["data"].length === 0) {
                var $oMainScope = angular.element(vitisApp.appMainDrtv).scope();
                $oMainScope.$root['modalWindow']('confirm', this_.$scope_["text"]["Loader"]["Notify"]["generate_form_error"], {
                    'className': 'modal-danger',
                    'message': this_.$scope_["text"]["Loader"]["Notify"]["generate_form_error_description"],
                    'buttons': {
                        'cancel': {
                            'label': '<i class="glyphicon glyphicon-remove"></i> Annuler',
                            'className': 'btn-default'
                        },
                        'confirm': {
                            'label': '<i class="glyphicon glyphicon-ok"></i> Poursuivre quand même',
                            'className': 'btn-danger'
                        }
                    },
                    'callback': function (result) {
                        if (result === true) {
                            this_['aSuggestedTableFields'] = [];
                            this_.generateFormByBusinessObject();
                        } else {
                            $oMainScope["setMode"]('search');
                        }
                    }
                });
            } else {
                this_['aSuggestedTableFields'] = response["data"];
                $('#select-fields-modal').modal('show');
            }
        },
        'error': function (response) {
            $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["CreateJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
        }
    });

//    this.$http_({
//        url: url,
//        method: 'GET'
//    }).success(function (data) {
//        if (!goog.isArray(data) || data.length === 0) {
//            var $oMainScope = angular.element(vitisApp.appMainDrtv).scope();
//            $oMainScope.$root['modalWindow']('confirm', this_.$scope_["text"]["Loader"]["Notify"]["generate_form_error"], {
//                'className': 'modal-danger',
//                'message': this_.$scope_["text"]["Loader"]["Notify"]["generate_form_error_description"],
//                'buttons': {
//                    'cancel': {
//                        'label': '<i class="glyphicon glyphicon-remove"></i> Annuler',
//                        'className': 'btn-default'
//                    },
//                    'confirm': {
//                        'label': '<i class="glyphicon glyphicon-ok"></i> Poursuivre quand même',
//                        'className': 'btn-danger'
//                    }
//                },
//                'callback': function (result) {
//                    if (result === true) {
//                        this_['aSuggestedTableFields'] = [];
//                        this_.generateFormByBusinessObject();
//                    } else {
//                        $oMainScope["setMode"]('search');
//                    }
//                }
//            });
//        } else {
//            this_['aSuggestedTableFields'] = data;
//            $('#select-fields-modal').modal('show');
//        }
//    }).error(function () {
//        $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["CreateJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
//    });
};

/**
 * Generates the json form by the business object table
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.generateFormByBusinessObject = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.generateFormByBusinessObject');

    var this_ = this;

    var form = "";
    if (this_.$scope_["FormSelected"] === "Perso") {
        form = "custom";
    } else if (this_.$scope_["FormSelected"] === "Default") {
        form = "default";
    } else {
        form = "published";
    }

    var url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/vmap/businessobjects/' + oVFB.getId() + '/forms/' + form + '/';
    if (oVFB.getApplication() === 'wab') {
        url = oVFB.AppProperties['web_server_name'] + '/' + oVFB.AppProperties['services_alias'] + '/wab/sections/' + oVFB.getId() + '/form';
    }

    var aFieldsToUse = [];
    var afieldsLabel = {};

    for (var i = 0; i < this_['aSuggestedTableFields'].length; i++) {
        if (this_['aSuggestedTableFields'][i]['fields'][0]['bUseForGenerate'] === true)
            aFieldsToUse.push(this_['aSuggestedTableFields'][i]['fields'][0]['name']);
        afieldsLabel[this_['aSuggestedTableFields'][i]['fields'][0]['name']] = this_['aSuggestedTableFields'][i]['fields'][0]['label'];
    }

    var sFieldsToUse = aFieldsToUse.toString().replace(/,/gi, '|');

    $('#select-fields-modal').modal('hide');

    if (this_.$scope_["FormSelected"] === "Default") {
        var success = function () {
            $["notify"](this_.$scope_["FormSelected"] + this_.$scope_["text"]["Loader"]["Notify"]["Reset"], {"className": "success", "autoHideDelay": oVFB.TimeNotify_});
            if (this_.$scope_["FormSelected"] === "Default") {
                this_.requestToJson();
            }
        };
        var error = function (data, status) {
            $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["Reset_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
        };
        this_.putRequest(this_.$scope_["FormSelected"] + "_Reset", {"field": sFieldsToUse, "label": afieldsLabel}, success, error);
    } else {

        ajaxRequest({
            'method': 'POST',
            'url': url,
            'data': {
                'fields': sFieldsToUse,
                'label': afieldsLabel
            },
            'scope': this.$scope_,
            'success': function (response) {
                this_.requestToJson();
            },
            'error': function (response) {
                $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["CreateJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
            }
        });

//        this.$http_({
//            url: url,
//            method: 'POST',
//            data: {
//                'fields': sFieldsToUse,
//                'label': afieldsLabel
//            }
//        }).success(function () {
//            this_.requestToJson();
//        }).error(function () {
//            $["notify"](this_.$scope_["text"]["Loader"]["Notify"]["CreateJson_Error"] + status, {"className": "error", "autoHideDelay": oVFB.TimeNotify_});
//        });
    }
};

/**
 * Sélectionne tous les champs lors de la génération du formulaire
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsSelectAllFields = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsSelectAllFields');

    for (var i = 0; i < this['aSuggestedTableFields'].length; i++) {
        this['aSuggestedTableFields'][i]['fields'][0]['bUseForGenerate'] = true;
    }
};

/**
 * Dé-sélectionne tous les champs lors de la génération du formulaire
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsUnselectAllFields = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsSelectAllFields');

    for (var i = 0; i < this['aSuggestedTableFields'].length; i++) {
        this['aSuggestedTableFields'][i]['fields'][0]['bUseForGenerate'] = false;
    }
};

/**
 * Retoure true si tous les champs suggérés lors de la génération du formulaire sont sélectionnés
 * @returns {Boolean}
 * @export
 */
nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsAreAllFieldsSelected = function () {
    oVFB.log('nsVFB.JsonLoader.prototype.jsonLoaderController.prototype.suggestColumnsAreAllFieldsSelected');

    var bAllSelected = true;
    for (var i = 0; i < this['aSuggestedTableFields'].length; i++) {
        if (this['aSuggestedTableFields'][i]['fields'][0]['bUseForGenerate'] !== true) {
            bAllSelected = false;
        }
    }
    return bAllSelected;
};
