/* global oVFB, less, goog, oProperties, angular, NaN */

/*Minifiable*/

'use strict';

goog.provide('nsUtils');

/**
 * nsUtils Object
 * @type {object}
 * @export
 */
nsUtils = {};

nsUtils.bDebugMode_ = false;

/**
 * Function to log messages if you are in mode dev else this function is empty
 * @param {string} message message to log
 * @export
 */
nsUtils.log = function (message) {
    if (goog.isDefAndNotNull(oVFB.AppProperties)) {
        if (oVFB.AppProperties['debug_mode']) {
            if (nsUtils.bDebugMode_) {
                console.log(message);
            }
        }
    }
};

/**
 * Unselect elements from ElementForm, Visualiser and FormTools
 * @export
 */
nsUtils.unselectAll = function () {
    nsUtils.log("util.unselectAll");
    $('#treeView')['treeview']('unselectNode', [$('#treeView')['treeview']('getSelected'), {silent: true}]);
    $('#treeWithLines')['treeview']('unselectNode', [$('#treeWithLines')['treeview']('getSelected'), {silent: true}]);
    angular.element($('#studio_container')).scope().$broadcast("update element", {});
    angular.element($('#FormModal')).scope()['ctrl'].removeSelectedAndHoveredElem();
};

/**
 * Reload the form
 * @param {string|undefined} target form to reload, defaut is #studio_form_reader
 * @export
 */
nsUtils.reloadForm = function (target) {
    nsUtils.log("util.reloadForm");

    if (!goog.isDefAndNotNull(target)) {
        target = '#studio_form_reader';
    }

    var oFormReaderScope = angular.element($(target).children()).scope();
    oFormReaderScope['oFormValues'][oFormReaderScope['sFormDefinitionName']] = {};

    setTimeout(function () {
        oFormReaderScope['compileTemplate']();
        setTimeout(function () {
            oFormReaderScope['ctrl'].useDefaultValues(true);
            setTimeout(function () {
                oFormReaderScope['ctrl'].extractFormDefinitionInfos();
            }, 100);
        }, 100);
    }, 100);
};

/**
 * Function to clone an object
 * @param {Object} obj Oject will be clone
 * @return {Object} a copy of object give in parameter
 * @export
 */
nsUtils.clone = function (obj) {
    nsUtils.log("util.clone");
    return obj; // on retourne la copie
};

/**
 * Function to condition a string form a JSON object for codeMirror
 * @param {Object} oJson Json Object to stringifier
 * @return {string} a string conditioned for codeMirror
 * @export
 */
nsUtils.JsonStringifier = function (oJson) {
    nsUtils.log("util.JsonStringifier");
    var strJson = JSON.stringify(oJson, null, 2);
    return strJson;
};

/**
 * Function to optimize output Json object
 * @param {Object} oJson Json object to optimize
 * @return {Object} color Json object optimized
 * @export
 */
nsUtils.JsonOptimizer = function (oJson) {
    //On va travailler sur insert
    var tmp = oJson["insert"];
    //Controle de la partie globale
    if (tmp["javascript"] == false) {
        delete tmp["javascript"];
    }
    if (tmp["style"] == false) {
        delete tmp["style"];
    }
    //Controle intégrité de rows
    var i = 0;
    while (i < tmp["rows"].length) {
        if (typeof tmp["rows"] !== "object") {
            console.error("error on rows integrity, this row who have been deleted :", tmp["rows"]);
            delete tmp["rows"];
        } else {
            //controle intégrité de fields
            if (!Array.isArray(tmp["rows"][i]["fields"])) {
                console.error("error on fields integrity, this fields who have been deleted in row " + i + " :", tmp["rows"][i]["fields"]);
                delete tmp["rows"][i]["fields"];
            } else {
                var j = 0;
                while (j < tmp["rows"][i]["fields"].length) {
                    //Controle d'intégrité de chaque field
                    if (typeof tmp["rows"][i]["fields"][j] !== "object") {
                        console.error("error on fields integrity, this field who have been deleted in row " + i + ", field " + j + " :", tmp["rows"][i]["fields"][j]);
                        delete tmp["rows"][i]["fields"][j];
                    } else {
                        //Traitement du field d'après son type
                        var field = tmp["rows"][i]["fields"][j];
                        var arrFields = [];
                        if (typeof field["type"] == "undefined" || field["name"] == "undefined" || field["id"] == "undefined") {
                            console.error("error on minimal containt of a field :", field);
                            return null;
                        }
                        switch (field["type"]) {
                            case "title":
                            case "label":
                                if (typeof field["label"] == "undefined") {
                                    console.error(field.type + " without a label isn't a " + field.type + " :", field);
                                    return null;
                                }
                                arrFields = ["type", "id", "label", "name"];
                                break;
                            case "hr":
                                arrFields = ["type", "id", "name"];
                                break;
                            case "subtitle" :
                                if (typeof field["label"] == "undefined") {
                                    console.error("subtitle without a text isn't a subtitle :", field);
                                    return null;
                                }
                                if (typeof field["class"] == "undefined") {
                                    delete field["class"];
                                }
                                arrFields = ["type", "id", "label", "name", "class"];
                                break;
                            case "checkbox":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["checked"] == "undefined" || field["checked"] == false) {
                                    delete field["checked"];
                                }
                                arrFields = ["type", "id", "label", "name", "checked"];
                                break;
                            case "radio":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["checked"] == "undefined" || field["checked"] == false) {
                                    delete field["checked"];
                                }
                                arrFields = ["type", "id", "label", "name", "checked", "options"];
                                break;
                            case "textarea":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["required"] == "undefined" || field["required"] == false) {
                                    delete field["required"];
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "required", "nb_cols"];
                                break;
                            case "select":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["required"] == "undefined" || field["required"] == false) {
                                    delete field["required"];
                                }
                                if (typeof field["multiple"] == "undefined" || field["multiple"] == false) {
                                    delete field["multiple"];
                                }
                                if (!goog.isArray(field["options"]) && !goog.isString(field["options"])) {
                                    console.error(field.type + "'s options are always an array :", field);
                                    return null;
                                }
                                if (typeof field["web_service"] != "object") {
                                    //console.error(field.type + "'s WS are always an object :", field);
                                    delete field["web_service"];
                                } else {
                                    if (typeof field["web_service"]["parameter"] != "undefined") {
                                        delete field["web_service"]["parameter"];
                                    }
                                    if (typeof field["web_service"]["ressource_id"] != "string" ||
                                            typeof field["web_service"]["id_key"] != "string" ||
                                            typeof field["web_service"]["label_key"] != "string") {
                                        return null;
                                        console.error(field.type + "'s WS parameter are always strings :", field);
                                    }
                                }
                                if (typeof field["child_select"] != "string") {
                                    delete field["child_select"];
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "required", "nb_cols", "multiple", "options", "web_service", "child_select"];
                                break;
                            case "double_select":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["required"] == "undefined" || field["required"] == false) {
                                    delete field["required"];
                                }
                                if (!Array.isArray[field["options"]]) {
                                    console.error(field.type + "'s options are always an array :", field);
                                    return null;
                                }
                                if (typeof field["web_service"] != "object") {
                                    delete field["web_service"];
                                    console.error(field.type + "'s WS are always an object :", field);
                                } else {
                                    if (typeof field["web_service"]["parameter"] != "undefined") {
                                        delete field["web_service"]["parameter"];
                                    }
                                    if (typeof field["web_service"]["ressource_id"] != "string" ||
                                            typeof field["web_service"]["id_key"] != "string" ||
                                            typeof field["web_service"]["label_key"] != "string") {
                                        console.error(field.type + "'s WS parameter are always strings :", field);
                                        return null;
                                    }
                                }
                                if (typeof field["size"] == "undefined") {
                                    field["size"] = 5;
                                }
                                if (typeof field["label_from"] != "string") {
                                    delete field["label_from"];
                                }
                                if (typeof field["label_to"] != "string") {
                                    delete field["label_to"];
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "required", "nb_cols", "options", "web_service", "size", "label_from", "label_to", "name_from", "name_to"];
                                break;
                            case "date":
                            case "datetime":
                            case "upload":
                            case "display_label":
                            case "color_picker":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "nb_cols"];
                                break;
                            case "tinymce":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["nb_rows"] == "undefined") {
                                    delete field["nb_rows"];
                                }
                                if (typeof field["options"] != "object") {
                                    delete field["options"];
                                }
                                arrFields = ["type", "id", "label", "name", "nb_rows", "options"];
                                break;
                            case "CodeMirror":
                            case "slider":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["options"] != "object") {
                                    delete field["options"];
                                }
                                arrFields = ["type", "id", "label", "name", "options"];
                                break;
                            case "text" :
                            case "password":
                            case "url":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["required"] == "undefined" || field["required"] == false) {
                                    delete field["required"];
                                }
                                if (typeof field["pattern"] == "undefined" || field["pattern"] == "") {
                                    delete field["pattern"];
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "pattern", "required", "nb_cols"];
                                break;
                            case "number":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["min"] == "undefined") {
                                    delete field["min"];
                                }
                                if (typeof field["max"] == "undefined") {
                                    delete field["max"];
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "min", "max", "nb_cols"];
                                break;
                            case "map_osm":
                            case "map_bing":
                            case "map_vmap":
                                if (typeof field["label"] == "undefined") {
                                    console.warn(field.type + " without a label :", field);
                                }
                                if (typeof field["required"] == "undefined" || field["required"] == false) {
                                    delete field["required"];
                                }
                                if (typeof field["map_options"] != "object") {
                                    delete field["map_options"];
                                } else {
                                    var options = field["map_options"];
                                    if (field["type"] == "map_osm") {
                                        if (options["type"] != "OSM") {
                                            console.warn(field.name + " problem with data type :", options);
                                        }
                                        if (typeof options["center"] != "object") {
                                            console.error(field["name"] + "have no center's parameter :", options);
                                            return null;
                                        } else {
                                            var center = options["center"];
                                            if (!Array.isArray(center["coord"]) && !Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " have no correct coordinate :", options);
                                                return null;
                                            } else if (center["coord"].length != 2 && Array.isArray(center["coord"])) {
                                                console.error(field["name"] + " bad parameters for center :", options);
                                                return null;
                                            } else if (center["extent"].length != 4 && Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " bad parameters for extent :", options);
                                                return null;
                                            }
                                            if (Array.isArray(center["coord"]) && (typeof center["zoom"] == "undefined" && typeof center["scale"] == "undefined")) {
                                                console.error(field["name"] + " center parameter need a scale value :", options);
                                                return null;
                                            }
                                            if (typeof center["zoom"] == "undefined" && typeof center["scale"] != "undefined") {
                                                delete center["zoom"];
                                            } else if (typeof center["zoom"] != "undefined" && typeof center["scale"] == "undefined") {
                                                delete center["scale"];
                                            }
                                        }
                                        if (typeof options["controls"] != "object") {
                                            console.error(field["name"] + " have no control's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["controls"]).length != 4) {
                                            console.error(field["name"] + " bad control's parameter :", options);
                                            return null;
                                        }
                                        if (!Array.isArray(options["layers"])) {
                                            console.warn(field["name"] + " layers problem :", options);
                                            //return null;
                                        } else if (options["layers"].length == 0) {
                                            delete options["layers"];
                                        }
                                        if (typeof options["interactions"] != "object") {
                                            console.error(field["name"] + " have no interactions's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["interactions"]).length != 7) {
                                            console.error(field["name"] + " bad interactions's parameter :", options);
                                            return null;
                                        }
                                        if (typeof options["draw_color"] == "undefined") {
                                            delete options["draw_color"];
                                        }
                                        if (!Array.isArray(options["features"])) {
                                            console.warn(field["name"] + " bad type for features :", options);
                                            //return null;
                                        } else if (options["features"].length == 0) {
                                            delete options["features"];
                                        }
                                        if (typeof options["coord_accuracy"] == "undefined") {
                                            options["coord_accuracy"] = 8;
                                        }
                                        //////////////////////////////////////////////////////////
                                    } else if (field["type"] == "map_bing") {
                                        if (options["type"] != "bing") {
                                            console.warn(field.name + " preoblem with data type :", options);
                                        }
                                        if (typeof options["center"] != "object") {
                                            console.error(field["name"] + "have no center's parameter :", options);
                                            return null;
                                        } else {
                                            var center = options["center"];
                                            if (!Array.isArray(center["coord"]) && !Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " have no correct coordinate :", options);
                                                return null;
                                            } else if (center["coord"].length != 2 && Array.isArray(center["coord"])) {
                                                console.error(field["name"] + " bad parameters for center :", options);
                                                return null;
                                            } else if (center["extent"].length != 4 && Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " bad parameters for extent :", options);
                                                return null;
                                            }
                                            if (Array.isArray(center["coord"]) && (typeof center["zoom"] == "undefined" && typeof center["scale"] == "undefined")) {
                                                console.error(field["name"] + " center parameter need a scale value :", options);
                                                return null;
                                            }
                                            if (typeof center["zoom"] == "undefined" && typeof center["scale"] != "undefined") {
                                                delete center["zoom"];
                                            } else if (typeof center["zoom"] != "undefined" && typeof center["scale"] == "undefined") {
                                                delete center["scale"];
                                            }
                                        }
                                        if (typeof options["controls"] != "object") {
                                            console.error(field["name"] + " have no control's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["controls"]).length != 4) {
                                            console.error(field["name"] + " bad control's parameter :", options);
                                            return null;
                                        }
                                        if (!Array.isArray(options["layers"])) {
                                            console.warn(field["name"] + " layers undefined :", options);
                                            //return null;
                                        } else if (options["layers"].length == 0) {
                                            delete options["layers"];
                                        }
                                        if (typeof options["interactions"] != "object") {
                                            console.error(field["name"] + " have no interactions's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["interactions"]).length != 7) {
                                            console.error(field["name"] + " bad interactions's parameter :", options);
                                            return null;
                                        }
                                        if (typeof options["draw_color"] == "undefined") {
                                            delete options["draw_color"];
                                        }
                                        if (!Array.isArray(options["features"])) {
                                            console.warn(field["name"] + " bad type for features :", options);
                                            //return null;
                                        } else if (options["features"].length == 0) {
                                            delete options["features"];
                                        }
                                        if (typeof options["coord_accuracy"] == "undefined") {
                                            options["coord_accuracy"] = 8;
                                        }
                                        if (typeof options["source"] != "object") {
                                            console.error(field["name"] + " have no source's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["source"]).length != 3) {
                                            console.error(field["name"] + " bad source's parameter :", options);
                                            return null;
                                        }
                                    } else if (field["type"] == "map_vmap") {
                                        if (options["type"] != "vmap") {
                                            console.warn(field.name + " preoblem with data type :", options);
                                        }
                                        if (typeof options["center"] != "object") {
                                            console.error(field["name"] + "have no center's parameter :", options);
                                            return null;
                                        } else {
                                            var center = options["center"];
                                            if (!Array.isArray(center["coord"]) && !Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " have no correct coordinate :", options);
                                                return null;
                                            } else if (center["coord"].length != 2 && Array.isArray(center["coord"])) {
                                                console.error(field["name"] + " bad parameters for center :", options);
                                                return null;
                                            } else if (center["extent"].length != 4 && Array.isArray(center["extent"])) {
                                                console.error(field["name"] + " bad parameters for extent :", options);
                                                return null;
                                            }
                                            if (Array.isArray(center["coord"]) && (typeof center["zoom"] == "undefined" && typeof center["scale"] == "undefined")) {
                                                console.error(field["name"] + " center parameter need a scale value :", options);
                                                return null;
                                            }
                                            if (typeof center["zoom"] == "undefined" && typeof center["scale"] != "undefined") {
                                                delete center["zoom"];
                                            } else if (typeof center["zoom"] != "undefined" && typeof center["scale"] == "undefined") {
                                                delete center["scale"];
                                            }
                                        }
                                        if (typeof options["controls"] != "object") {
                                            console.error(field["name"] + " have no control's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["controls"]).length != 4) {
                                            console.error(field["name"] + " bad control's parameter :", options);
                                            return null;
                                        }
                                        if (!Array.isArray(options["layers"])) {
                                            console.warn(field["name"] + " bad type for layers :", options);
                                            //return null;
                                        } else if (options["layers"].length == 0) {
                                            delete options["layers"];
                                        }
                                        if (typeof options["interactions"] != "object") {
                                            console.error(field["name"] + " have no interactions's parameter :", options);
                                            return null;
                                        } else if (Object.keys(options["interactions"]).length != 7) {
                                            console.error(field["name"] + " bad interactions's parameter :", options);
                                            return null;
                                        }
                                        if (typeof options["draw_color"] == "undefined") {
                                            delete options["draw_color"];
                                        }
                                        if (!Array.isArray(options["features"])) {
                                            console.warn(field["name"] + " bad type for features :", options);
                                            //return null;
                                        } else if (options["features"].length == 0) {
                                            delete options["features"];
                                        }

                                        if (typeof options["coord_accuracy"] == "undefined") {
                                            options["coord_accuracy"] = 8;
                                        }
                                        if (typeof options["tree"] != "object") {
                                            console.error(field["name"] + " have no tree object :", options);
                                            return null;
                                        } else if (Object.keys(options["tree"]).length == 0) {
                                            console.error(field["name"] + " empty tree :", options);
                                            return null;
                                        }
                                    }
                                }
                                if (typeof field["nb_cols"] == "undefined") {
                                    field["nb_cols"] = 12;
                                }
                                arrFields = ["type", "id", "label", "name", "required", "map_options", "nb_cols"];
                                break;
                        }
                        for (var srckey in field) {
                            if (arrFields.indexOf(srckey) === -1) {
                                delete field[srckey];
                            }
                        }
                        j++;
                    }
                }
            }
            i++;
        }
    }
    return oJson;
};

/**
 * Function to parse a number
 * @param {String} str string to parse in number
 * @param {boolean} bInt Parse in Integer or in Float
 * @export
 */
nsUtils.numberParser = function (str, bInt) {
    str = goog.isDef(str) ? str : "";
    bInt = goog.isDef(bInt) ? bInt : false;

    if (bInt) {
        return this.numberParser(str);
    } else {
        str = str.replace(",", ".");
        var parts = str.split(".");
        if (parts.length === 0)
            return NaN;
        else if (parts.length === 1)
            return this.numberParser(str);
        else if (parts.length >= 2) {
            var left = this.numberParser(parts[0]);
            var right = 0;
            if (parts.length === 2)
                right = this.numberParser(parts[1]);
            else {
                var tmp = "";
                for (var i = 1; i < parts.length; i++) {
                    tmp += parts[i];
                }
                right = this.numberParser(tmp);
            }
            return parseFloat(left + "." + right);
        } else
            return NaN;
    }

};

/**
 * Function to parse an integer with correction on char error
 * @param {String} str string to parse in intger
 * @return {integer} value intger of the string
 * @export
 */
nsUtils.numberParser = function (str) {
    var ret = "";
    for (var i = 0; i < str.length; i++) {
        var currentChar = str.charAt(i);
        if (!isNan(parseInt(currentChar)))
            ret += currentChar;
    }
    return parseInt(ret);
};

/**
 * Get all the elems with a name = elementName
 * @param {object} oJson
 * @param {string} formName
 * @param {string} elementName
 * @returns {Array}
 */
nsUtils.getElementsByName = function (oJson, formName, elementName) {

    var aElems = [];

    if (!goog.isDefAndNotNull(elementName)) {
        return aElems;
    }
    if (!goog.isDefAndNotNull(oJson[formName])) {
        return aElems;
    }
    if (!goog.isDefAndNotNull(oJson[formName]['rows'])) {
        return aElems;
    }

    for (var i = 0; i < oJson[formName]['rows'].length; i++) {
        if (goog.isDefAndNotNull(oJson[formName]['rows'][i]['fields'])) {
            for (var ii = 0; ii < oJson[formName]['rows'][i]['fields'].length; ii++) {
                if (oJson[formName]['rows'][i]['fields'][ii]['name'] === elementName) {
                    aElems.push(oJson[formName]['rows'][i]['fields'][ii]);
                }
            }
        }
    }

    return aElems;
};