/* global goog, nsVFB, oVFB, angular, vitisApp */

/**
 * @author: Anthony Borghi
 * @Description: Fichier contenant la classe nsVFB.Visualiszer
 * cette classe permet de visualiser notre sortie de différente manière et d'y concevoir du code à attacher
 */

/*********************************************************************************************************
 *  TODO LIST  (95%)
 * + ajouter des types d'éléments
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.Visualizer');
goog.require('nsVFB.nsVisualizerMode.FormMode');
goog.require('nsVFB.nsVisualizerMode.JsonMode');
goog.require('nsVFB.nsVisualizerMode.JsMode');
goog.require('nsVFB.nsVisualizerMode.CssMode');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object JsonLoader
 * @constructor
 * @export
 */
nsVFB.Visualizer = function () {
    oVFB.log('nsVFB.Visualizer');

    this.oFormMode_ = new nsVFB.nsVisualizerMode.FormMode();
    this.oJsonMode_ = new nsVFB.nsVisualizerMode.JsonMode();
    this.oJsMode_ = new nsVFB.nsVisualizerMode.JsMode();
    this.oCssMode_ = new nsVFB.nsVisualizerMode.CssMode();

    oVFB.module.directive('appVisualizer', this.visualizerDirective);
    oVFB.module.controller('AppVisualizerController', ["$scope", "$timeout", this.visualizerController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.Visualizer.prototype.visualizerDirective = function () {
    oVFB.log('nsVFB.Visualizer.visualizerDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppVisualizerController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/Visualizer.html'
    };
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {object} $scope AngularJS's service who return the current scope
 * @param {object} $timeout AngularJS's service who wrap window.timeout who delay execution of a function
 * @export
 * @ngInject
 */
nsVFB.Visualizer.prototype.visualizerController = function ($scope, $timeout) {
    oVFB.log('nsVFB.Visualizer.visualizerController');

    var visualizerController = this; //glitch pour utiliser this
    /**
     * @private
     */
    this.$scope_ = $scope;

    //initialisation en mode formulaire
    visualizerController["form_"] = true;
    visualizerController["css_"] = visualizerController["js_"] = visualizerController["json_"] = false;

    visualizerController["JSPresent"] = true;
    visualizerController["CSSPresent"] = true;

    $scope.$watch("text", function () {
        oVFB.log("visualizer text");
        if (typeof $scope["text"]["Visualizer"] !== "undefined") {
            visualizerController["text"] = $scope["text"]["Visualizer"];
            visualizerController["ModeSelected"] = visualizerController["text"]["FormMode"];
        }
    });

    //Dissimule les mode CSS et JS si pas d'attache spécifié 

    visualizerController["verifyMode"] = function () {
        if (goog.isDef(angular.element($("#boolean-JS-include"))[0]))
            visualizerController["JSPresent"] = !angular.element($("#boolean-JS-include"))[0]['checked'];
        if (goog.isDef(angular.element($("#boolean-CSS-include"))[0]))
            visualizerController["CSSPresent"] = !angular.element($("#boolean-CSS-include"))[0]['checked'];
    };

    visualizerController["form"] = function () {
        visualizerController["ModeSelected"] = visualizerController["text"]["FormMode"];
        $scope.$broadcast('updateEvent', {}); //maj mode formulaire
        visualizerController["form_"] = true;
        visualizerController["css_"] = visualizerController["js_"] = visualizerController["json_"] = false;
    };

    visualizerController["json"] = function () {
        visualizerController["ModeSelected"] = visualizerController["text"]["JsonMode"];
        $scope.$broadcast('updateEvent', {}); //maj mode Json
        visualizerController["json_"] = true;
        visualizerController["css_"] = visualizerController["js_"] = visualizerController["form_"] = false;
    };

    visualizerController["js"] = function () {
        visualizerController["ModeSelected"] = visualizerController["text"]["JsMode"];
        //visualizerController["CSSPresent"] = !angular.element($("#boolean-CSS-include"))[0]['checked'];
        visualizerController["js_"] = true;
        visualizerController["css_"] = visualizerController["json_"] = visualizerController["form_"] = false;
        $scope.$broadcast('updateJS', oVFB.getJs()); //maj mode JavaScript
    };

    visualizerController["css"] = function () {
        visualizerController["ModeSelected"] = visualizerController["text"]["CssMode"];
        //visualizerController["JSPresent"] = !angular.element($("#boolean-JS-include"))[0]['checked'];
        $scope.$broadcast('updateCSS', oVFB.getCss()); //maj mode CSS
        visualizerController["css_"] = true;
        visualizerController["json_"] = visualizerController["js_"] = visualizerController["form_"] = false;
    };
};

/**
 * Toggle full screen mode
 * @export
 */
nsVFB.Visualizer.prototype.visualizerController.prototype.toggleFullScreen = function () {
    oVFB.log('nsVFB.Visualizer.visualizerController.toggleFullScreen');

    // Si il est possible d'afficher en fullScreen
    if (
            document['fullscreenEnabled'] ||
            document['webkitFullscreenEnabled'] ||
            document['mozFullScreenEnabled'] ||
            document['msFullscreenEnabled']
            ) {

        var button_full_screen = $('#studio-full-screen-btn').get(0);
        var elem = $('#studio_container').get(0);

        // Si on est déjà en mode plein écran
        if (
                document['fullscreenElement'] ||
                document['webkitFullscreenElement'] ||
                document['mozFullScreenElement'] ||
                document['msFullscreenElement']
                ) {

            $(button_full_screen).removeClass('icon-shrink');

            if (document['exitFullscreen']) {
                document['exitFullscreen']();
            } else if (document['webkitExitFullscreen']) {
                document['webkitExitFullscreen']();
            } else if (document['mozCancelFullScreen']) {
                document['mozCancelFullScreen']();
            } else if (document['msExitFullscreen']) {
                document['msExitFullscreen']();
            }

            setTimeout(function () {
                oVFB.resize();
            }, 100);

        } else {

            $(button_full_screen).addClass('icon-shrink');

            if (elem['requestFullscreen']) {
                elem['requestFullscreen']();
            } else if (elem['mozRequestFullScreen']) {
                elem['mozRequestFullScreen']();
            } else if (elem['webkitRequestFullscreen']) {
                elem['webkitRequestFullscreen']();
            } else if (elem['msRequestFullscreen']) {
                elem['msRequestFullscreen']();
            }
            setTimeout(function () {
                oVFB.resize(true);
            }, 500);
        }
    } else {
        $.notify('Fonction non disponible pour votre navigateur', 'error');
    }
};

/**
 * Show the datasource modal and set the default options
 * @export
 */
nsVFB.Visualizer.prototype.visualizerController.prototype.loadDefaultJavascript = function () {
    oVFB.log('nsVFB.visualizerController.loadDefaultJavascript');

    var $scope = this.$scope_;
    var sJs = oVFB.getJs();

    if (goog.isDef(sJs)) {
        if (sJs !== '') {
            var oModal = bootbox.confirm('<h4>' + this["text"]["Confirmation"]["LoseJs"] + '</h4>', function (result) {
                if (result === true) {
                    ajaxRequest({
                        'method': 'GET',
                        'url': oVFB.AppProperties["web_server_name"] + "/" + oVFB.AppProperties["public_alias"] + "/studio/default.js",
                        'scope': this.$scope_,
                        'timeout': 5000,
                        'success': function (response) {
                            if (goog.isDefAndNotNull(response.data)) {
                                oVFB.setJs(response.data.replace(/(?:\r\n|\r|\n)/g, "\r\n"));
                                $scope.$broadcast('updateJS', oVFB.getJs()); //maj mode JavaScript
                            }
                        },
                        'error': function (response) {
                            console.error("Problem on Loading default javascript");
                        }
                    });
                } else {
                    return;
                }
            });
            // Déplace la popup dans l'élément principal du studio (sinon elle est masquée en mode plein écran).
            oVFB.studioMainController.prototype.moveBootboxModalToStudioContainer(oModal);
        }
    }

};

/***********************************************************************************
 *                               Data_Access                                       *
 **********************************************************************************/

/**
 * getter
 * @return {object} Componant FormMode
 * @export
 */
nsVFB.Visualizer.prototype.getFormMode = function () {
    return nsVFB.Visualizer.oFormMode_;
};

/**
 * getter
 * @return {object} Componant JsonMode
 * @export
 */
nsVFB.Visualizer.prototype.getJsonMode = function () {
    return nsVFB.Visualizer.oJsonMode_;
};

/**
 * getter
 * @return {object} Componant JsMode
 * @export
 */
nsVFB.Visualizer.prototype.getJsMode = function () {
    return nsVFB.Visualizer.oJsMode_;
};

/**
 * getter
 * @return {object} Componant CssMode
 * @export
 */
nsVFB.Visualizer.prototype.getCssMode = function () {
    return nsVFB.Visualizer.oCssMode_;
};
/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/