/* global goog, nsVFB, oVFB, oProperties */

/**
 * @author: Anthony Borghi
 * @Description: Fichier contenant la classe nsVFB.nsVisualizerMode.CssMode
 * cette classe permet d'écrire du code CSS qui sera associé à notre formulaire
 */

/*********************************************************************************************************
 *  TODO LIST  (100%)
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.nsVisualizerMode.CssMode');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object CssMode
 * @constructor
 * @export
 */
nsVFB.nsVisualizerMode.CssMode = function () {
    oVFB.log('nsVFB.nsVisualizerMode.CssMode');

    oVFB.module.directive('appEditorCss', this.editorCssModeDirective);
    oVFB.module.controller('AppEditorCssController', ["$scope",this.editorCssModeController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.nsVisualizerMode.CssMode.prototype.editorCssModeDirective = function () {
    oVFB.log('nsVFB.VisualizerMode.CssMode.editorCssModeDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppEditorCssController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/VisualizerMode/CssMode.html'
    };
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {Object} $scope AngularJS's service who return the current scope
 * @export
 */
nsVFB.nsVisualizerMode.CssMode.prototype.editorCssModeController = function ($scope) {
    oVFB.log('nsVFB.VisualizerMode.CssMode.editorCssModeController');
    
    //les donnée se mettent automatiquement à jour qaund le composant devient visible ou invisible
    $scope["CssModel"] = oVFB.getCss();    //donnée à mettre dans l'objet CodeMirror
    $scope["editorOptions"] = {            //Options de code Mirror
        "mode": "css",
        "readOnly": false,
        "styleActiveLine": true,
        "lineNumbers": true,
        "lineSeparator": '\r\n',
        "indentWithTabs": true,
        "tabSize": 2,
        "viewportMargin": 50,
        "theme" : "Veremes"
    };

    oVFB.resize();
    
    $scope.$watch("CssModel", function(value, old){
        oVFB.log("cssmode model");
        oVFB.setCss(value);
    });

    //Connection du signal
    $scope.$on('updateCSS', function (event, data) {
        oVFB.log(oVFB.getCss());
        $scope["CssModel"] = oVFB.getCss(); // reload data
    });
};

/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/

