/* global goog, nsVFB, oVFB, angular, ol, propertiesSrvc */

/**
 * @author: Anthony Borghi
 * @author: Armand Bahi
 * @Description: Fichier contenant la classe nsVFB.nsVisualizerMode.FormMode
 * cette classe permet de visualiser notre sortie Formulaire
 */

/*Minifiable*/

'use strict';

goog.provide('nsVFB.nsVisualizerMode.FormMode');

goog.require('goog.object');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object JsonLoader
 * @constructor
 * @export
 */
nsVFB.nsVisualizerMode.FormMode = function () {
    oVFB.log('nsVFB.nsVisualizerMode.FormMode');

    oVFB.module.directive('appVisualizermodeForm', this.visualizerFormModeDirective);
    oVFB.module.directive('appSpecificParam', ["$timeout", "$rootScope", "$q", this.specificParameterDirective]);
    oVFB.module.controller('AppVisualizermodeFormController', ["$scope", this.visualizerFormModeController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeDirective = function () {
    oVFB.log('nsVFB.VisualizerMode.FormMode.visualizerFormModeDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppVisualizermodeFormController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/VisualizerMode/FormMode.html'
    };
};

/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {object} $scope AngularJS's service who return the current scope
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController = function ($scope) {
    oVFB.log('nsVFB.VisualizerMode.FormMode.visualizerFormModeController');

    var this_ = this;

    /**
     * @private
     */
    this.$scope_ = $scope;

    /**
     * name of the form (display, update, insert)
     * @type string
     */
    $scope['sFormDefinitionName'] = '';

    /**
     * Values of the form
     * @type object
     */
    $scope['oFormValues'] = {};

    /**
     * Form
     * @type object
     */
    $scope['oFormDefinition'] = {};

    /**
     * Scope to use for the form events
     * @type object
     */
    $scope['oFormScope'] = {};

    /**
     * Properties
     * @type object
     */
    $scope['oProperties'] = oVFB.AppProperties;

    /**
     * Token
     * @type string
     */
    $scope['sToken'] = sessionStorage['session_token'];

    // Event Broadcasted by all the studio elements exept ElementForm
    $scope.$on('updateEvent', function (event, data) {
        oVFB.log('visualizerFormModeController updateEvent');
        $scope.$broadcast("updateForm", data);
    });

    // Event Broadcasted by ElementForm
    $scope.$on('updateForm', function (event, data) {
        oVFB.log('visualizerFormModeController updateForm');
        //si donnée valide
        if (!goog.object.isEmpty(data[$scope['selected_form_type']])) {
            var oJson = data[$scope['selected_form_type']];
            //si pas d'id on en fabrique un
            if (!goog.object.isEmpty(oJson['rows'])) {
	            for (var i = 0; i < oJson['rows'].length; i++) {
	                for (var j = 0; j < oJson['rows'][i]['fields'].length; j++) {
	                    if (!oJson['rows'][i]['fields'][j]['id']) {
	                        oJson['rows'][i]['fields'][j]['id'] = oJson['rows'][i]['fields'][j]['name'] + '_' + (i + 1) + '_' + (j + 1);
	                    }
	                }
	            }
	        }


            /**
             * !Important! utilisation d'un pointeur permet que les changements 
             * de oFormDefinition affecteront getJsonOutput
             */
            $scope['oFormDefinition'] = data;

            // reinit variables
            $scope['sFormDefinitionName'] = $scope['selected_form_type'];
            $scope['title'] = oJson['title'];

            // Valeurs par défaut)
            if (!goog.isDef($scope['oFormValues']))
                $scope['oFormValues'] = {};
            if (!goog.isDef($scope['oFormValues'][$scope['sFormDefinitionName']]))
                $scope['oFormValues'][$scope['sFormDefinitionName']] = {};

            // Refresh le formReader
            angular.element($('#studio_form_reader').children()).scope()['ctrl'].refreshForm();

        } else {
            oVFB.log('visualizerFormModeController. Load JSON form fail: ' + $scope['selected_form_type'] + ' undefined in ', data);
        }
    });

    $scope.$on('updateDefautValue', function (event, data) {
        if (typeof(data["default_value"]) != "undefined" && data["default_value"] != "") {
            switch (data["type"]) {
                case "select":
                    // Si la valeur est un nombre : force le type.
                    if (!isNaN(data["default_value"]))
                        data["default_value"] = Number(data["default_value"]);
                    break;
                case "list":
                    var $timeout = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['$timeout']);
                    $timeout(function () {
                        // Sélectionne les options qui sont dans les valeurs par défaut.
                        var aValues = [];
                        var oListElement = document.getElementById(data["id"]);
                        if (oListElement !== null) {
                            if (String(data["default_value"]).indexOf("|") == -1)
                                aValues.push(data["default_value"]);
                            else
                                aValues = String(data["default_value"]).split("|");
                            for (var i = 0; i < oListElement.options.length; i++) {
                                if (aValues.indexOf(oListElement.options[i].value) != -1)
                                    oListElement.options[i].selected = true;
                                else
                                    oListElement.options[i].selected = false;
                            }
                        }
                    });
                    break;
            }
        }
        // Set les valeurs par défaut
        angular.element($('#studio_form_reader').children()).scope()['ctrl'].useDefaultValues(true, data['name']);
    });
};

/**
 * Set the selected element on the FormReader
 * @param {object} element
 * @param {string} element.type row/element
 * @param {string} element.row_id (for type = row)
 * @param {string} element.element_name (for type = element)
 * @param {string} sFormDefinitionName
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.setSelectedElem = function (element, sFormDefinitionName) {
    oVFB.log('nsVFB.nsVisualizerMode.FormMode.visualizerFormModeController.setSelectedElem');

    var this_ = this;
    var $scope = this.$scope_;

    // Le timeout permet de passer après le updateElement/updateForm (qui est lancé car elementForm a changé d'élément)
    setTimeout(function () {
        $scope.$evalAsync(function () {

            var aRows = $scope['oFormDefinition'][sFormDefinitionName]['rows'];

            // vide les anciens selected
            this_.removeSelectedElem(sFormDefinitionName);

            // Ajoute la nouvelle classe
            if (element['type'] === 'row') {
                aRows[element['row_id']]['selected'] = true;
            }
            if (element['type'] === 'element') {
                for (var i = 0; i < aRows.length; i++) {
                    for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {
                        if (aRows[i]['fields'][ii]['name'] === element['element_name'])
                            aRows[i]['fields'][ii]['selected'] = true;
                    }
                }
            }
            angular.element($('#studio_form_reader').children()).scope()['ctrl'].refreshForm();
        });
    });
};

/**
 * Set the hovered element on the FormReader
 * @param {object} element
 * @param {string} element.type row/element
 * @param {string} element.row_id (for type = row)
 * @param {string} element.element_name (for type = element)
 * @param {string} sFormDefinitionName
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.setHoveredElem = function (element, sFormDefinitionName) {

    var this_ = this;
    var $scope = this.$scope_;

    $scope.$evalAsync(function () {

        var aRows = $scope['oFormDefinition'][sFormDefinitionName]['rows'];

        // vide les anciennes classes
        this_.removeHoveredElem(sFormDefinitionName);

        // Ajoute la nouvelle classe
        if (element['type'] === 'row') {
            aRows[element['row_id']]['hovered'] = true;
        }
        if (element['type'] === 'element') {
            for (var i = 0; i < aRows.length; i++) {
                for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {
                    if (aRows[i]['fields'][ii]['name'] === element['element_name'])
                        aRows[i]['fields'][ii]['hovered'] = true;
                }
            }
        }
        angular.element($('#studio_form_reader').children()).scope()['ctrl'].refreshForm();
    });
};

/**
 * Recusive function that remove the selected elements: 
 * if sFormDefinitionName is not defined the function will remove from all the names 
 * if aRows is not defined the function will remove from $scope['oFormDefinition'] and oVFB.getJsonOutput()
 * @param {string|undefined} sFormDefinitionName
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.removeSelectedElem = function (sFormDefinitionName) {
    oVFB.log('nsVFB.nsVisualizerMode.FormMode.visualizerFormModeController.removeSelectedElem');

    var $scope = this.$scope_;

    // Si sFromDefinitionName n'est pas défini, alors la fonction est relancée avec chaque nom possible
    if (!goog.isDefAndNotNull(sFormDefinitionName)) {
        for (var sName in $scope['oFormDefinition']) {
            this.removeSelectedElem(sName);
        }
        return 0;
    }

    var aRows = $scope['oFormDefinition'][sFormDefinitionName]['rows'];

    if (!goog.isDefAndNotNull(aRows))
        return 0;

    // vide les anciens selected
    for (var i = 0; i < aRows.length; i++) {
        if (aRows[i]['selected'] === true) {
            delete aRows[i]['selected'];
        }
        for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {
            if (aRows[i]['fields'][ii]['selected'] === true)
                delete aRows[i]['fields'][ii]['selected'];
        }
    }
};

/**
 * Remove the selected and hovered elements from sFormDefinitionName, 
 * if sFormDefinitionName is not defined the function will remove from all the names in $scope['oFormDefinition']
 * @param {string|undefined} sFormDefinitionName
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.removeHoveredElem = function (sFormDefinitionName) {

    var $scope = this.$scope_;

    if (!goog.isDef(sFormDefinitionName)) {
        // Run the function for all the names in $scope['oFormDefinition']
        for (var sName in $scope['oFormDefinition']) {
            this.removeHoveredElem(sName);
        }
        return 0;
    }

    var aRows = $scope['oFormDefinition'][sFormDefinitionName]['rows'];
    if (!goog.object.isEmpty(aRows)) {

    	    for (var i = 0; i < aRows.length; i++) {
    	        if (aRows[i]['hovered'] === true) {
    	            delete aRows[i]['hovered'];
    	        }
    	        for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {
    	            if (aRows[i]['fields'][ii]['hovered'] === true)
    	                delete aRows[i]['fields'][ii]['hovered'];
    	        }
    	    }
    	}
};

/**
 * Recusive function that remove the selected and hovered elements: 
 * if sFormDefinitionName is not defined the function will remove from all the names 
 * if aRows is not defined the function will remove from $scope['oFormDefinition'] and oVFB.getJsonOutput()
 * @param {string|undefined} sFormDefinitionName
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.removeSelectedAndHoveredElem = function (sFormDefinitionName) {

    var $scope = this.$scope_;

    // Si sFromDefinitionName n'est pas défini, alors la fonction est relancée avec chaque nom possible
    if (!goog.isDefAndNotNull(sFormDefinitionName)) {
        for (var sName in $scope['oFormDefinition']) {
            this.removeSelectedAndHoveredElem(sName);
        }
        return 0;
    }

    var aRows = $scope['oFormDefinition'][sFormDefinitionName]['rows'];

    if (!goog.isDefAndNotNull(aRows))
        return 0;

    // vide les anciens selected
    for (var i = 0; i < aRows.length; i++) {
        if (aRows[i]['selected'] === true) {
            delete aRows[i]['selected'];
        }
        if (aRows[i]['hovered'] === true) {
            delete aRows[i]['hovered'];
        }
        for (var ii = 0; ii < aRows[i]['fields'].length; ii++) {
            if (aRows[i]['fields'][ii]['selected'] === true)
                delete aRows[i]['fields'][ii]['selected'];
            if (aRows[i]['fields'][ii]['hovered'] === true)
                delete aRows[i]['fields'][ii]['hovered'];
        }
    }
};

/**
 * emptyFormValues
 * @export
 */
nsVFB.nsVisualizerMode.FormMode.prototype.visualizerFormModeController.prototype.emptyFormValues = function () {
    oVFB.log('nsVFB.nsVisualizerMode.FormMode.visualizerFormModeController.emptyFormValues');

    var $scope = this.$scope_;

    if (goog.isDef($scope['oFormValues'])) {
        $scope['oFormValues'] = {};
    }
};
