/* global goog, nsVFB, oVFB, oProperties */

/**
 * @author: Anthony Borghi
 * @Description: Fichier contenant la classe nsVFB.nsVisualizerMode.JsMode
 * cette classe permet d'écrire du code javascript qui sera ssocié à notre formulaire
 */

/*********************************************************************************************************
 *  TODO LIST  (100%)
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.nsVisualizerMode.JsMode');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object JsMode
 * @constructor
 * @export
 */
nsVFB.nsVisualizerMode.JsMode = function () {
    oVFB.log('nsVFB.nsVisualizerMode.JsMode');

    oVFB.module.directive('appEditorJs', this.editorJsModeDirective);
    oVFB.module.controller('AppEditorJsController', ["$scope", this.editorJsModeController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.nsVisualizerMode.JsMode.prototype.editorJsModeDirective = function () {
    oVFB.log('nsVFB.VisualizerMode.JsMode.editorJsModeDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppEditorJsController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/VisualizerMode/JsMode.html'
    };
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {Object} $scope AngularJS's service who return the current scope
 * @export
 */
nsVFB.nsVisualizerMode.JsMode.prototype.editorJsModeController = function ($scope) {
    oVFB.log('nsVFB.VisualizerMode.JsMode.editorJsModeController');

    $scope["JsModel"] = oVFB.getJs();
    $scope["editorOptions"] = {
        "mode": {"name": "javascript", "json": false},
        "readOnly": false,
        "styleActiveLine": true,
        "lineNumbers": true,
        "lineSeparator": null,
        "indentWithTabs": true,
        "tabSize": 2,
        "viewportMargin": 50,
        "theme": "Veremes",
        "foldGutter": true,
        "gutters": ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
        "autoCloseBrackets": true,
        "extraKeys": {
            "Ctrl-Space": "autocomplete",
            "Cmd-Space": "autocomplete", 
            "Cmd-/": "toggleComment",
            "Ctrl-/": "toggleComment"
        },
        "onLoad": function (cm_) {

            $scope.$watch("JsModel", function (value, old) {
                oVFB.log("jsmode model");
                oVFB.setJs(value);
            });

            //Connection du signal
            $scope.$on('updateJS', function () {
                oVFB.log("Js");
                $scope["JsModel"] = oVFB.getJs();
            });
        }
    };


};

/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/

