/* global goog, nsVFB, oVFB, oProperties */

/**
 * @author: Anthony Borghi
 * @Description: Fichier contenant la classe nsVFB.nsVisualizerMode.JsonMode
 * cette classe permet de visualiser notre sortie Json
 */

/*********************************************************************************************************
 *  TODO LIST  (100%)
 *********************************************************************************************************/

/*Minifiable*/

'use strict';

goog.provide('nsVFB.nsVisualizerMode.JsonMode');

/***********************************************************************************
 *                                  Start                                          *
 **********************************************************************************/

/**
 * Create an object JsonMode
 * @constructor
 * @export
 */
nsVFB.nsVisualizerMode.JsonMode = function () {
    oVFB.log('nsVFB.nsVisualizerMode.JsonMode');

    oVFB.module.directive('appVisualizermodeJson', this.visualizerJsonModeDirective);
    oVFB.module.controller('AppVisualizermodeJsonController', ["$scope", "$timeout", "$rootScope", this.visualizerJsonModeController]);
};

/***********************************************************************************
 *                                 Angular                                         *
 **********************************************************************************/
/*********************************Directive****************************************/
/**
 * Charge la vue liée au composant
 * @export
 */
nsVFB.nsVisualizerMode.JsonMode.prototype.visualizerJsonModeDirective = function () {
    oVFB.log('nsVFB.VisualizerMode.JsonMode.visualizerJsonModeDirective');

    return {
        restrict: 'A',
        replace: true,
        controller: 'AppVisualizermodeJsonController',
        controllerAs: 'ctrl',
        scope: true,
        bindToController: true,
        templateUrl: 'javascript/externs/studio/templates/VisualizerMode/JsonMode.html'
    };
};
/*********************************Controller***************************************/
/**
 * Charge le controlleur lié au composant
 * @param {object} $scope AngularJS's service who return the current scope
 * @export
 */
nsVFB.nsVisualizerMode.JsonMode.prototype.visualizerJsonModeController = function ($scope, $timeout, $rootScope) {
    oVFB.log('nsVFB.VisualizerMode.JsonMode.visualizerJsonModeController');

    this.scope_ = $scope;
    this.rootScope_ = $rootScope;
    this.timeout_ = $timeout;

    $scope.moment_ = Date.now();
    $scope.labs_ = 1000;

    $scope["JsonModel"] = oVFB.JsonStringifier(oVFB.getJsonOutput());
    $scope["error_Json"] = false;
    //var locker = $("#Lock_Icon").hasClass("fa-lock");

    $scope["editorOptions"] = {
        "mode": {name: "javascript", json: true},
        "readOnly": true,
        "styleActiveLine": true,
        "lineNumbers": true,
        "lineSeparator": null,
        "indentWithTabs": true,
        "tabSize": 2,
        "viewportMargin": 50,
        "theme": "Veremes",
        //"keymap": "sublime",
        "foldGutter": true,
        "gutters": ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
        "autoCloseBrackets" : true,
        "onLoad": function (cm_) {
            //Connection du signal
            $scope.$on('updateEvent', function (event, data) {
                cm_['setOption']("readOnly", $("#Lock_Icon").hasClass("fa-lock"));
                $scope["JsonModel"] = oVFB.JsonStringifier(oVFB.getJsonOutput());
            });

            $scope.$watch("JsonModel", function (value, old) {
                oVFB.log("jsonmode model");
                var error = false;
                try {
                    JSON.parse(value);
                } catch (e) {
                    //console.error(e);
                    error = true;

                } finally {
                    $scope.$parent["error_Json"] = error;
                }

            });

            $scope.$on('updateJsonModel', function (event, data) {
                if ($scope["$parent"]["ctrl"]["json_"]) {
                    $scope.moment_ = Date.now();
                    $timeout(function () {
                        if (Date.now() - $scope.moment_ >= $scope.labs_) {
                            $scope["JsonModel"] = oVFB.JsonStringifier(oVFB.getJsonOutput());
                        }
                    }, $scope.labs_);
                }
            });
        }
    };

};

/**
 * Save the json data
 * @export
 */
nsVFB.nsVisualizerMode.JsonMode.prototype.visualizerJsonModeController.prototype.saveData = function () {
    oVFB.setJsonOutput(JSON.parse(this.scope_["JsonModel"]));

    var selectedElement = $('#treeWithLines')["treeview"]('getSelected');
    var selectedElementInTreeview = $('#treeView')["treeview"]('getSelected');

    this.rootScope_.$broadcast("updateEvent", oVFB.getJsonOutput());
    if (selectedElement.length !== 0 && selectedElementInTreeview.length !== 0) {
        this.timeout_(function () {
            $('#treeWithLines')['treeview']('selectNode', [selectedElement[0]['nodeId'], {silent: false}]);
            $('#treeView')['treeview']('selectNode', [selectedElementInTreeview[0]['nodeId'], {silent: false}]);
        }, 1);
    }
};

/***********************************************************************************
 *                                   End                                           *
 **********************************************************************************/

