/* global browser, __dirname, module */

'use strict';
/**
 * @author: Anthony Borghi
 * @Description: The class VeremesTest define all function use by E2E test
 */

module.exports = {
//**********************************************************************/ 
//                                                                      /
//          fonctions de Mise en forme fichier de sortie                /
//                                                                      / 
//**********************************************************************/    

    /**
     * Wrap console.log for output file
     * @param {string} text : for the output 
     */
    log: function (text) {
        console.log("\n");
        console.log(text);
    },
//**********************************************************************/ 
//                                                                      /
//                     fonctions de Temporisation                       /
//                                                                      /
//**********************************************************************/  

    /**
     * Wait between to test for function afterEach() (default 300ms)
     */
    waitBetweenTwoTests: function () {
        browser.sleep(300);
    },
    /**
     * Wait to load a page of app (default 2000ms)
     */
    waitToLoadPage: function () {
        browser.sleep(5000);
    },
    /**
     * Wait after a function click() (default 200ms)
     */
    waitAfterClick: function () {
        browser.sleep(200);
    },
    /**
     * Wait after a function sendKeys() (default 200ms)
     */
    waitAfterSendKeys: function () {
        browser.sleep(300);
    },
    /**
     * Wait after a suite of actions (default 200ms)
     */
    waitAfterActions: function () {
        browser.sleep(400);
    },
    /**
     * Wait to pop of alert's windows (default 1000ms)
     */
    waitBeforeAlert: function () {
        browser.sleep(1000);
    },
    /**
     * Wait to finish your test and see the last state of the app (default 10000ms)
     */
    waitToSeeTheEnd: function () {
        browser.sleep(10000);
    },
    /**
     * wiat ti load page during dev
     */
    waitToLoadPageDev: function () {
        browser.sleep(8000);
    },
//**********************************************************************/ 
//                                                                      /
//    fonctions de Simplification pour l'utilisation de Protractor      /
//                                                                      /
//**********************************************************************/  

    /**
     * resolve the absolute path of a file with it relative path
     * @param {string} URL : path to resolve 
     */
    pathResolver: function (URL) {
        var path = require('path');
        return path.resolve(__dirname, URL);
    },
    /**
     * enable or disable synchronization with angular application
     * @param {boolean} flag : true : this app is Angular Application false : this app is not Angular Application
     */
    isAngularApp: function (flag) {
        return browser.ignoreSynchronization = !flag;
    },
    getBrowserName: function () {
        return browser.driver.session_.value_.caps_.caps_.browserName;
    },
    /**
     * clone an javascript object
     * @param {object} obj : object to clone
     */
    clone: function (obj) {
        if (null === obj || "object" !== typeof obj)  // si ce n'est pas un objet on retourne l'objet (parti à modifier)
            console.log(typeof obj);
        return obj;
        var copy = obj["constructor"](); // sinon on instancie un nouvel objet
        for (var attr in obj) {                     // on set tous ses attribut avec ceux de l'objet d'origine
            if (obj.hasOwnProperty(attr))
                copy[attr] = obj[attr];
        }
        return copy; // on retourne la copie
    },
//**********************************************************************/ 
//                                                                      /
//          fonctions de Mise en forme fichier de sortie                /
//                                                                      / 
//**********************************************************************/    
    /**
     * return date of current day yyyy-mm-dd 
     */

    currentDay: function () {
        var newDate = new Date();
        var DateYear = (newDate.getFullYear()).toString();
        var DateMonth = (newDate.getMonth() + 1).toString();
        var DateDay = (newDate.getDate()).toString();
        if (DateMonth.length === 1) {
            DateMonth = '0' + DateMonth;
        }
        if (DateDay.length === 1) {
            DateDay = '0' + DateDay;
        }

        var dateMyFormat = DateYear + '-' + DateMonth + '-' + DateDay;
        return dateMyFormat;
    },
    /**
     * return date of current day yyyy-mm-dd hh:mm:ss
     */
    currentDayTime: function () {
        var newDate = new Date();
        var DateYear = (newDate.getFullYear()).toString();
        var DateMonth = (newDate.getMonth() + 1).toString();
        var DateDay = (newDate.getDate()).toString();
        var DateHours = (newDate.getHours()).toString();
        var DateMinutes = (newDate.getMinutes()).toString();
        var DateSeconds = (newDate.getSeconds()).toString();
        if (DateMonth.length === 1) {
            DateMonth = '0' + DateMonth;
        }
        if (DateDay.length === 1) {
            DateDay = '0' + DateDay;
        }
        if (DateHours.length === 1) {
            DateHours = '0' + DateHours;
        }
        if (DateMinutes.length === 1) {
            DateMinutes = '0' + DateMinutes;
        }
        if (DateSeconds.length === 1) {
            DateSeconds = '0' + DateSeconds;
        }

        var dateMyFormat = DateYear + '-' + DateMonth + '-' + DateDay + " " + DateHours + ":" + DateMinutes + ":" + DateSeconds;
        return dateMyFormat;
    },
    getGrid: function (gridId) {
        return element(by.id(gridId));
        
    },
    getRow: function (gridId, rowNum) {
        return this.getGrid(gridId).element(by.repeater('(rowRenderIndex, row) in rowContainer.renderedRows track by $index').row(rowNum));
    },
    dataCell: function (gridId, fetchRow, fetchCol) {
        var row = this.getGrid(gridId).element(by.css('.ui-grid-render-container-body')).element(by.repeater('(rowRenderIndex, row) in rowContainer.renderedRows track by $index').row(fetchRow));
        return row.element(by.repeater('(colRenderIndex, col) in colContainer.renderedColumns track by col.uid').row(fetchCol));
    },

    // touche Entrée 
    // var enter = browser.actions().sendKeys(protractor.Key.ENTER);
    //enter.perform();
    
    // Récupère la valeur d'un element de type select
    getSelectedText: function (select) {
        return select.getAttribute('value').then(function (i) {
            return select.element(by.css('option[value="' + i + '"]')).getText();
        });
    },

    //Confirmer une Alerte
       // confirmAlert: function(label){
   // element(by.className("bootbox")).element(by.className("modal-dialog")).element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"' + label + '\"]')).click();
     //    },
         
           confirmAlert: function(){
    element(by.className("bootbox")).element(by.className("modal-dialog")). element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
           }

};
