/* global by, browser, element, expect, jasmine */

'use strict';
/**
 * @author: M ESPADA
 * @Description: test E2E on GTF application
 * Controle des abonnnements
 */

describe("vitis GTF  Gestion des abonnements - ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;

    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 1900000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });

    it("Connexion à GTF", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;

    });

    describe("Connexion de l'admin - ", function () {

        it("connexion de l'admin", function () {
            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();

            expect(element(by.id("user_column")).getText()).toContain("margot");
        });
    });
    describe("1 - Activation abonnement - ", function () {


        it(" Rendre non dispo un traitement pour abonnement ", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterActions();

            //Filtre 
            element(by.id("publication_gtf_workspace_search_filter_button")).click();

            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_abonnement");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(400);

            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);

            element(by.id("radio_subscription_1")).click();
            element(by.id("publication_gtf_workspace_general_update_form_form_submit")).click();
            browser.sleep(1000);

            element(by.id("mode_my_work")).click();
            browser.sleep(400);

            //onglet Abonnements
            element(by.id("object_column_my_work_gtf_user_subscription")).click;

            browser.sleep(400);
            element(by.id("my_work_gtf_user_subscription_add_smallFlexigrid_ui_grid_add")).click();

            var arbreProjets = element(by.id("my_work_gtf_user_subscription_insert_form_workspace_id"));
            expect(arbreProjets.element(by.cssContainingText('option', 't_abonnement')).isPresent()).toBe(false);
            browser.sleep(1000);
        });

        it(" Rendre dispo un traitement pour abonnement ", function () {

            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterActions();
            element(by.id("publication_gtf_workspace_search_filter_button")).click();

            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_abonnement");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(1000);


            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);

            element(by.id("radio_subscription_0")).click();
            browser.sleep(1000);

            element(by.id("publication_gtf_workspace_general_update_form_form_submit")).click();

            browser.sleep(1000);

            element(by.id("mode_my_work")).click();
            browser.sleep(400);

            //onglet Abonnements
            element(by.id("object_column_my_work_gtf_user_subscription")).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_subscription_add_smallFlexigrid_ui_grid_add")).click();

            var arbreProjets = element(by.id("my_work_gtf_user_subscription_insert_form_workspace_id"));

            expect(arbreProjets.element(by.cssContainingText('option', 't_abonnement')).isPresent()).toBe(true);
            browser.sleep(1000);
        });
    });


    describe("2 Abonnement à un traitement - ", function () {

        it("Abonnement à un traitement toutes les 2 minutes", function () {
            var arbreProjets = element(by.id("my_work_gtf_user_subscription_insert_form_workspace_id"));
            arbreProjets.element(by.cssContainingText('option', 't_abonnement')).click();

            browser.sleep(500);

            var periode = element(by.id("my_work_gtf_user_subscription_insert_form_period_id"));
            periode.element(by.cssContainingText('option', 'ma période de 2 minutes')).click();
            browser.sleep(400);



            element(by.id("my_work_gtf_user_subscription_insert_subform_form_submit")).click();

            browser.sleep(1000);

            // tri décroissant sur la colonne id des abonnements
            element(by.className("my_work_gtf_user_subscription_order_id")).click();
            element(by.className("my_work_gtf_user_subscription_order_id")).click();
            element(by.className("my_work_gtf_user_subscription_order_id")).click();
            var cellule = FonctVeremes.dataCell("my_work_gtf_user_subscription_grid_data", 0, 2);

            expect(cellule.getText()).toEqual("t_abonnement");
            browser.sleep(160000);
        });

        it("Check execution abonnement", function () {

            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_supervision")).click();
            FonctVeremes.waitAfterActions();

            // tri décroissant sur la colonne id des Demandes  
            element(by.className("supervision_gtf_order_order_id")).click();
            element(by.className("supervision_gtf_order_order_id")).click();
            element(by.className("supervision_gtf_order_order_id")).click();


            var cellule = FonctVeremes.dataCell("supervision_gtf_order_grid_data", 0, 2);

            expect(cellule.getText()).toEqual("t_abonnement");
        });

    });

    describe("3 Suppression Abonnement - ", function () {

        it(" Suppression abonnement", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_my_work")).click();
            browser.sleep(400);
            element(by.id("object_column_my_work_gtf_user_subscription")).click();
            browser.sleep(400);
            //Filtre 
            element(by.id("my_work_gtf_user_subscription_search_filter_button")).click();
            browser.sleep(400);
            var FiltreListeProjets = element(by.id("my_work_gtf_user_subscription_search_form_workspace_id"));
            FiltreListeProjets.element(by.cssContainingText('option', 't_abonnement')).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_subscription_search_form_search")).click();
            browser.sleep(400);


            var listeProjets = element(by.id("my_work_gtf_user_subscription_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeProjets.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            FonctVeremes.waitToLoadPage();
            element(by.id("my_work_gtf_user_subscription_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitToLoadPage();

            FonctVeremes.confirmAlert("confirm");
          
            FonctVeremes.waitToLoadPage();

        });

    });
});
