/* global by, browser, element, expect, jasmine, protractor */

'use strict';
/**
 * @author: ME
 * @Description: test E2E on vitis 
 * Création, import et suppression de catégories de projet
 */


describe("Vitis categorie-", function () {
//create, remove an user (with differents privileges) 
//var id;
    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;
    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 280000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });
    it("should have a title in tab", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;
        //vérif du nom de l'onglet = Administration
        //expect(browser.getTitle()).toEqual('GTF');
    });


    describe("1 -Connexion admin-", function () {

        it("Connexion de l'admin", function () {
            //saisie des identifiants
            element(by.id("login_form_user_login")).sendKeys(login);
            // browser.sleep(100);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            // browser.sleep(100);
            //FonctVeremes.waitToLoadPagoe();
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();

        });
    });

    describe("2 -Gestion des catégories-", function () {

        it("- Création d'une catégorie ", function () {
            //FonctVeremes.waitToLoadPage();
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitToLoadPage();

            element(by.id("object_column_publication_gtf_category")).click();
            FonctVeremes.waitToLoadPage();
            element(by.id("publication_gtf_category_add_smallFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitToLoadPage();
            element(by.id("publication_gtf_category_insert_form_name")).sendKeys('catégorie 1');
            element(by.id("publication_gtf_category_insert_form_form_submit")).click();
            browser.sleep(1000);
            element(by.id("publication_gtf_category_update_form_return_list")).click();

            // tri décroissant sur la colonne id de la liste des catégories
            element(by.className("publication_gtf_category_category_id")).element(by.className("ng-binding")).click();
            element(by.className("publication_gtf_category_category_id")).element(by.className("ng-binding")).click();
            element(by.className("publication_gtf_category_category_id")).element(by.className("ng-binding")).click();

            var cellule = FonctVeremes.dataCell("publication_gtf_category_grid_data", 0, 2);
            expect(cellule.getText()).toEqual("catégorie 1");

            browser.sleep(10000);
        });


        it("- Création d'une catégorie existante ", function () {

            element(by.id("publication_gtf_category_add_smallFlexigrid_ui_grid_add")).click();

            FonctVeremes.waitToLoadPage();
            element(by.id("publication_gtf_category_insert_form_name")).sendKeys('catégorie 1');
            element(by.id("publication_gtf_category_insert_form_form_submit")).click();
            browser.sleep(1000);

            //var alerte = element(by.className("bootbox")).element(by.className("modal-dialog"));
           // expect(alerte.isPresent()).toBe(true);

            element(by.className("bootbox")).element(by.className("modal-dialog")).element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"close\"]')).click();

            //browser.switchTo().alert().accept;
           

            browser.sleep(10000);
        });

        it("- Suppression catégorie ", function () {
            element(by.id("publication_gtf_category_insert_form_return_list")).click();
            browser.sleep(400);

            //filtre 
            element(by.id("publication_gtf_category_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_reset")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_name")).sendKeys("catégorie 1");
            element(by.id("publication_gtf_category_search_form_search")).click();
            FonctVeremes.waitAfterClick();

            var listeCategories = element(by.id("publication_gtf_category_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeCategories.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();


            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_category_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();
            FonctVeremes.confirmAlert();

            // element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();

            FonctVeremes.waitToLoadPage();

            browser.sleep(10000);
        });

    });


    describe("3 - Création d'une nouvelle catégorie par import -", function () {

        it("Ajout d'un projet FME avec une nouvelle catégorie", function () {
            console.log("\nit del'Ajout projet metadata\n");
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_add_smallFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_workspace_general_insert_form_name")).sendKeys('test_metadata');

            var FileToUpload = FonctVeremes.pathResolver("./resource/metadata.fmw");
            element(by.id("publication_gtf_workspace_general_insert_form_fmw_file")).sendKeys(FileToUpload);

            FonctVeremes.waitAfterSendKeys();
            element(by.id("publication_gtf_workspace_general_insert_form_form_submit")).click();
            browser.sleep(3000);
            element(by.id("publication_gtf_workspace_general_update_form_return_list")).click();
            FonctVeremes.waitToLoadPage();

            //recherche par filtre du projet : 
            element(by.id("publication_gtf_workspace_search_filter_button")).click();

            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);

            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(1000);

            var cellCompte = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 2);
            expect(cellCompte.getText()).toEqual("test_metadata");
            browser.sleep(1000);
        });


        it("Check import de la nouvelle catégorie", function () {
            console.log("\nit de Check import Nouvelle catégorie");

            //recherche par filtre de la nouvelle catégorie dans l'onglet catégories
            element(by.id("object_column_publication_gtf_category")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_reset")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_name")).sendKeys("Nouvelle catégorie");

            console.log("saisie ok");
            element(by.id("publication_gtf_category_search_form_search")).click();
            browser.sleep(3000);
            var cellCompte = FonctVeremes.dataCell("publication_gtf_category_grid_data", 0, 2);
            expect(cellCompte.getText()).toEqual("Nouvelle catégorie");
            browser.sleep(1000);
        });


        it("- Suppression de la catégorie importée", function () {

            var listeCategories = element(by.id("publication_gtf_category_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeCategories.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();

            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_category_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();

            // element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
            //expect((fenetre).isPresent()).toBe(true);
            //browser.switchTo().alert().accept;

            FonctVeremes.confirmAlert();

            FonctVeremes.waitToLoadPage();

            browser.sleep(10000);
        });

        it("suppression du projet metadata", function () {

            element(by.id("object_column_publication_gtf_workspace")).click();

            browser.sleep(600);
            //recherche projet par le filtre : 

            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            FonctVeremes.waitAfterClick();

            //var ListeProjet = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            // ListeProjet.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by ").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name").row(0)).element(by.css('[ng-click="selectButtonClick(row, $event)"]')).click();

            var listeProjets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeProjets.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();



            FonctVeremes.waitToLoadPage();
            element(by.id("publication_gtf_workspace_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitToLoadPage();

            //element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
            // expect((fenetre).isPresent()).toBe(true);
            // browser.switchTo().alert().accept;
            FonctVeremes.confirmAlert();

            FonctVeremes.waitToLoadPage();

        });


    });
});
   