/* global by, browser, element, expect, jasmine */

'use strict';
/**
 * @author: M ESPADA
 * @Description: test E2E on GTF application
 * Contrôle des surveillances de répertoire
 * Dépôt du fichier dpt2.zip dans le dépôt de test avant exécution du script
 */



describe("WINDOWS vitis GTF  Gestion des dépôts - ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;

    beforeEach(function () {
        browser.driver.manage().window().maximize();
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 4000000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });

    it("Connexion à GTF", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;

    });

    describe("Connexion de l'admin - ", function () {

        it("connexion de l'admin", function () {
            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();

            expect(element(by.id("user_column")).getText()).toContain("margot");
        });
    });


    describe("1 - Ajout de surveillance - ", function () {

        it(" Rendre dispo un traitement pour surveillance ", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterActions();

            //filtre 
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_surveillance");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(400);

            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);

            element(by.id("radio_survey_0")).click();
            browser.sleep(1000);
            element(by.id("publication_gtf_workspace_general_update_form_form_submit")).click();
            browser.sleep(2000);

        });



        it(" Ajout d'une surveillance toutes les 2 min du dépôt de test ", function () {

            element(by.id("mode_my_work")).click();
            browser.sleep(400);
            element(by.id("object_column_my_work_gtf_user_survey")).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_survey_add_smallFlexigrid_ui_grid_add")).click();

            var arbreProjets = element(by.id("my_work_gtf_user_survey_insert_form_workspace_id"));
            arbreProjets.element(by.cssContainingText('option', 't_surveillance')).click();
            browser.sleep(1000);

            element(by.id("my_work_gtf_user_survey_insert_form_period_id")).element(by.cssContainingText('option', 'ma période de 2 minutes')).click();
            browser.sleep(1000);

            element(by.id("my_work_gtf_user_survey_insert_form_inbox_id")).element(by.cssContainingText('option', 'depot de test')).click();

            browser.sleep(1000);
            element(by.id("my_work_gtf_user_survey_insert_subform_form_submit")).click();

        });


        it(" Exécution du traitement ", function () {

            browser.sleep(150000);
            element(by.id("mode_supervision")).click();
            browser.sleep(400);

            // tri décroissant sur la colonne Date de la demande
            element(by.className("supervision_gtf_order_order_date")).click();
            element(by.className("supervision_gtf_order_order_date")).click();
            element(by.className("supervision_gtf_order_order_date")).click();

            var cellule = FonctVeremes.dataCell("supervision_gtf_order_grid_data", 0, 2);
            expect(cellule.getText()).toEqual("t_surveillance");

            var celluleEtat = FonctVeremes.dataCell("supervision_gtf_order_grid_data", 0, 3);
            expect(celluleEtat.element(by.className('status3-icon')).isPresent()).toBe(true);

            browser.sleep(1000);
        });

    });

    describe("2  - Activation et désactivation de la surveillance - Contrôle des icônes - ", function () {

        it(" Rendre inactive la surveillance ", function () {
            element(by.id("mode_my_work")).click();
            browser.sleep(400);
            element(by.id("object_column_my_work_gtf_user_survey")).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_survey_search_filter_button")).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_survey_search_form_workspace_id")).element(by.cssContainingText('option', 't_surveillance')).click();
            browser.sleep(400);
            element(by.id("my_work_gtf_user_survey_search_form_search")).click();

            browser.sleep(400);
            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);
            element(by.id("radio_enabled_yes_1")).click();
            browser.sleep(400);
            element(by.id('my_work_gtf_user_survey_update_subform_form_submit')).click();
            browser.sleep(1000);

            var celluleActif = FonctVeremes.dataCell("my_work_gtf_user_survey_grid_data", 0, 10);
            expect(celluleActif.element(by.className('false-icon')).isPresent()).toBe(true);
            browser.sleep(1000);
        });

        it(" Rendre active la surveillance ", function () {

            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);
            element(by.id("radio_enabled_yes_0")).click();
            browser.sleep(400);
            element(by.id('my_work_gtf_user_survey_update_subform_form_submit')).click();
            browser.sleep(1000);

            var celluleActif = FonctVeremes.dataCell("my_work_gtf_user_survey_grid_data", 0, 10);
            expect(celluleActif.element(by.className('true-icon')).isPresent()).toBe(true);
        });
    });

    describe("3  - Supprimer la surveillance - ", function () {

        it(" Supprimer la surveillance du dépot de test ", function () {

            var listeSurveillances = element(by.id("my_work_gtf_user_survey_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeSurveillances.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            browser.sleep(1000);

            element(by.id("my_work_gtf_user_survey_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitToLoadPage();
            FonctVeremes.confirmAlert("confirm");

        });
    });

});