/* global by, browser, element, expect, jasmine, protractor */

'use strict';
/**
 * @author: ME
 * @Description: COntrole des formulaires par défaut, publié et perso
 */

describe("formulaire par défaut, publié, personnalisé - ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;
    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 160000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });
    it("Connexion à GTF - ", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        //browser.driver.manage().window().maximize();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;
        console.log("Connexion à gtf ");
        //vérif du nom de l'onglet = Administration
        //expect(browser.getTitle()).toEqual('Gtf');
    });
    describe("Connexion de l'admin à GTF - ", function () {

        it("Connexion de l'admin à GTF", function () {

            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();

            console.log("\nConnexion de l'admin à gtf\n");
        });
    });

    describe("1- Création du projet t_formulaire.fmw - ", function () {
        
         it("- Ajout du projet FME - ", function () {
         var mode = element(by.id("mode_column"));
         mode.element(by.id("mode_publication")).click();
         FonctVeremes.waitAfterClick();
         
         element(by.id("publication_gtf_workspace_add_smallFlexigrid_ui_grid_add")).click();
         FonctVeremes.waitAfterClick();
         
         element(by.id("publication_gtf_workspace_general_insert_form_name")).sendKeys('t_formulaire');
         var FileToUpload = FonctVeremes.pathResolver("./resource/t_formulaire.fmw");
         element(by.id("publication_gtf_workspace_general_insert_form_fmw_file")).sendKeys(FileToUpload);
         FonctVeremes.waitAfterClick();
         element(by.id("publication_gtf_workspace_general_insert_form_form_submit")).click();
         browser.sleep(2000);
         
         //section Droits
         element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(2)).click();
         
         browser.sleep(1000);
         
         element(by.id("publication_gtf_workspace_updateRight_update_form_groups_from")).element(by.cssContainingText('option', 'groupeTest')).click();
         element(by.id("publication_gtf_workspace_updateRight_update_form_from_group_to_groups")).click();
         element(by.id("publication_gtf_workspace_updateRight_update_form_form_submit")).click();
         browser.sleep(3000);
         
         });
         
         
         it("_ it de controle du formulaire par defaut dans le mode mon travail", function () {
         var mode = element(by.id("mode_column"));
         mode.element(by.id("mode_my_work")).click();
         FonctVeremes.waitAfterActions();
         element(by.id("my_work_gtf_user_order_add_smallFlexigrid_ui_grid_add")).click();
         FonctVeremes.waitAfterClick();
         element(by.id("my_work_gtf_user_order_insert_form_workspace_id")).click();
         browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
         browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
         browser.sleep(2000);
         expect(element(by.id("my_work_gtf_user_order_insert_subform_DestDataset_MAPINFO_label")).getText()).toEqual("Nom du Dossier destination MapInfo :");
         browser.sleep(2000);
         });
         
        it("_ it de controle du picto de formulaire par défaut dans la liste des projets", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            browser.sleep(2000);
            //FIltre 
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(2000);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(1000);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_formulaire");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(2000);

            var celluleFormulaire = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 12);

            expect(celluleFormulaire.element(by.className('true-icon')).isPresent()).toBe(true);
            browser.sleep(1000);
        });

    

        describe("2- Personnalisation du formulaire - ", function () {
            it("- clic formulaire perso", function () {

                element(by.css('[ng-if="grid.appScope.edit_column"]')).click();
                //Section formulaire 
                browser.sleep(400);
                element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(3)).click();
                browser.sleep(6000);
                //personnalisation du formulaire 
                var studio1 = element(by.id("container_section_publication_gtf_workspace_SubForm")).element(by.id("FormBuilder")).element(by.id("studio_container"));

              studio1.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.id("json_loader_Mode_groupButton")).element(by.id("load_Default_button")).click();
              browser.sleep(1000);
                studio1.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.id("json_loader_Mode_groupButton")).element(by.id("load_Perso_button")).click();


                browser.sleep(4000);

              
            });

            it("- Fenetre des paramètres publiés ", function () {
                //fenetre de sélection des paramètres publiés

                var studio1 = element(by.id("container_section_publication_gtf_workspace_SubForm")).element(by.id("FormBuilder")).element(by.id("studio_container"));
                studio1.element(by.id("second-Layout")).element(by.id("FormToolsElement")).element(by.className("panel-body")).element(by.className("form-tools-tree-container")).element(by.id("treeView")).element(by.className("list-group")).element(by.className("list-group-item")).element(by.className("node-icon")).click();
             
                browser.sleep(2000);
            });


            //fenetre de définition des paramètres 
            it("- Publication du formulaire perso", function () {
                element(by.id("Element_Form_label_input")).clear();

                browser.sleep(400);

                element(by.id("Element_Form_label_input")).sendKeys("formulaire perso");
                browser.sleep(400);
                //publication de formulaire perso : 
                var studio = element(by.id("container_section_publication_gtf_workspace_SubForm")).element(by.id("FormBuilder")).element(by.id("studio_container"));
            
                studio.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.className("panel-body")).element(by.className("element-margin")).element(by.className("btn-group ")).element(by.css('[ng-show=\"FormSelected === \'Perso\' && !ctrl.buttonHide\"]')).click();   
               
                                
                // studio2.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.className("panel-heading")).element(by.className("element-margin")).element(by.className("btn-group")).element(by.css('[ng-click=\"ctrl.publish()\"]')).element(by.className("glyphicon")).click();
                browser.sleep(3000);

            });


            it("_ Controle de publication du formulaire personnalisé ", function () {
                var mode = element(by.id("mode_column"));
                mode.element(by.id("mode_my_work")).click();
                FonctVeremes.waitAfterActions();
                element(by.id("my_work_gtf_user_order_add_smallFlexigrid_ui_grid_add")).click();
                FonctVeremes.waitAfterClick();
                element(by.id("my_work_gtf_user_order_insert_form_workspace_id")).click();
                browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
                browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
                browser.sleep(3000);
                expect(element(by.id("DestDataset_MAPINFO_1_1_label")).getText()).toEqual("formulaire perso");
                browser.sleep(2000);

            });

            it("_ it de controle du picto de formulaire personnalisé ", function () {
                var mode = element(by.id("mode_column"));
                mode.element(by.id("mode_publication")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_filter_button")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_form_reset")).click();
                browser.sleep(1000);
                element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_formulaire");
                element(by.id("publication_gtf_workspace_search_form_search")).click();
                browser.sleep(2000);

                var celluleFormulaire = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 12);

                expect(celluleFormulaire.element(by.className('custom-icon')).isPresent()).toBe(true);
                browser.sleep(1000);
            });

        });

        describe("3-  Retour  au formulaire par defaut  - ", function () {

            it("Republication du formulaire par defaut ", function () {

                element(by.css('[ng-if="grid.appScope.edit_column"]')).click();
                //Section formulaire 
                browser.sleep(400);
                element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(3)).click();
                browser.sleep(4000);
               
                var studio = element(by.id("container_section_publication_gtf_workspace_SubForm")).element(by.id("FormBuilder")).element(by.id("studio_container"));
                //studio1.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.className("panel-body")).element(by.className("element-margin")).element(by.className("btn-group")).element(by.css('[ng-click=\"ctrl.reset()\"]')).element(by.className("icon-recycle")).click();
           
                 studio.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.className("panel-body")).element(by.id("json_loader_Mode_groupButton")).element(by.id("load_Default_button")).click();
                    browser.sleep(2000);
                 studio.element(by.id("first-Layout")).element(by.id("FilesURL")).element(by.className("panel-body")).element(by.className("element-margin")).element(by.className("btn-group")).element(by.css('[title=\"Publier le formulaire par défaut\"]')).click();
               
               
                browser.sleep(3000);


            });

            it("_ it de controle de publication du formulaire par defaut ", function () {
                var mode = element(by.id("mode_column"));
                mode.element(by.id("mode_my_work")).click();
                FonctVeremes.waitAfterActions();
                element(by.id("my_work_gtf_user_order_add_smallFlexigrid_ui_grid_add")).click();
                FonctVeremes.waitAfterClick();
                element(by.id("my_work_gtf_user_order_insert_form_workspace_id")).click();
                browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
                browser.actions().mouseMove(element(by.cssContainingText('option', 't_formulaire'))).click().perform();
                browser.sleep(3000);
                expect(element(by.id("my_work_gtf_user_order_insert_subform_DestDataset_MAPINFO_label")).getText()).toEqual("Nom du Dossier destination MapInfo :");
                browser.sleep(2000);

            });

            it("_ it de controle du picto de formulaire par defaut  ", function () {
                var mode = element(by.id("mode_column"));
                mode.element(by.id("mode_publication")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_filter_button")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_form_reset")).click();
                browser.sleep(1000);
                element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_formulaire");
                element(by.id("publication_gtf_workspace_search_form_search")).click();
                browser.sleep(2000);

                var celluleFormulaire = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 12);
                expect(celluleFormulaire.element(by.className('true-icon')).isPresent()).toBe(true);

            });
        });

        describe("4 - Suppression projet", function () {
            it("Suppression du projet", function () {
                var mode = element(by.id("mode_column"));
                mode.element(by.id("mode_publication")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_filter_button")).click();
                browser.sleep(2000);
                element(by.id("publication_gtf_workspace_search_form_reset")).click();
                browser.sleep(1000);
                element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_formulaire");
                element(by.id("publication_gtf_workspace_search_form_search")).click();
                browser.sleep(2000);


                var listeProjets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
                listeProjets.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();


                FonctVeremes.waitToLoadPage();

                element(by.id("publication_gtf_workspace_deleteFlexigrid_ui_grid_add")).click();
                FonctVeremes.waitToLoadPage();
           
                FonctVeremes.confirmAlert();
            
                FonctVeremes.waitToLoadPage();


            });

        });
        
    });
});
