/* global by, browser, element, expect, jasmine, protractor */

'use strict';
/**
 * @author: ME
 * @Description: test import de fichiers par lot
 */

describe("Export Import  - ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;
    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 300000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });
    it("Obtenir le titre gtf dans l'onglet", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        //browser.driver.manage().window().maximize();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;
        //vérif du nom de l'onglet = Administration
        //expect(browser.getTitle()).toEqual('Gtf');
    });
    describe("- Connexion de l'admin - ", function () {

        it("- Connexion de l'admin", function () {

            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();
        });
    });

    describe("1- Suppression des fichiers fmw importés par lot", function () {

        it("- it de filtre pour supprimer", function () {

          var mode = element(by.id("mode_column"));
          mode.element(by.id("mode_publication")).click();
            browser.sleep(2000);
           }); 
           it("filtre", function(){
                 browser.sleep(200);
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(2000);
               element(by.id("publication_gtf_workspace_search_form_reset")).click();
                    browser.sleep(200);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_importparlot");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(2000);
            
 });
 
 it(" it de sélection des projets d'import par lot", function (){
     browser.driver.manage().window().setSize(1800, 1200);
          var listeprojets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-top-panel")).element(by.className("ui-grid-header-viewport")).element(by.className("ui-grid-header-canvas"));
          listeprojets.element(by.repeater("col in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"headerButtonClick($event)"]')).click();
     
       }); 
        // });  
         
       /*
      it("selection2", function(){
          //element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-header")).element(by.className("ui-grid-col0")).click();
            
                      
            var listprojets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-render-container-body")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listprojets.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).each(function (el, i) {
                var celluleProjet = el.element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name").row(2));
         celluleProjet.getText().then(function (text) {
        console.log(text)});
                text.match(/[A-E]/gi)
                if (text.indexOf("t_importparlot1") > -1)
                //celluleProjet.getText().then(function (text) {
                  //  if ((text == "t_importparlot") || (text == "t_importparlot1") || (text == "t_importparlot2")) {
                    //    celluleCompte.element(by.className("ui-grid-cell-contents")).click();
                  //  }
                });
            });   
            
            
      });
         */
            it(" it de supression des projets par lot", function (){
             
            browser.sleep(2000);
            element(by.id("publication_gtf_workspace_deleteFlexigrid_ui_grid_add")).click();

            FonctVeremes.waitToLoadPage();

            var fenetre = element(by.className("modal-content"));
            console.log("\nFenêtre de validation de la suppression :\n");
           // expect((fenetre).isPresent()).toBe(true);

            //element(by.className("modal-dialog")).element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
           // element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
            FonctVeremes.confirmAlert();
        
            FonctVeremes.waitToLoadPage();

        });
  
  }); 

 
    describe("2- Import par lot - ", function () {

        it("- import de fmw par lot", function () {

            console.log("\nit d'import par lot");
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterActions();
            element(by.id("publication_gtf_workspace_adImport_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();

            var fmw1 = FonctVeremes.pathResolver("./resource/t_importparlot1.fmw");
            var fmw2 = FonctVeremes.pathResolver("./resource/t_importparlot2.fmw");

            element(by.id("publication_workspace_import_workspace_fmw_file")).sendKeys(fmw1);
            FonctVeremes.waitAfterClick();
            element(by.id("publication_workspace_import_workspace_fmw_file")).sendKeys(fmw2);
            FonctVeremes.waitAfterClick();

            element(by.className("fileinput-upload-button")).click();
            FonctVeremes.waitToLoadPage();

            //onglet Projets FME 
            element(by.id("object_column_publication_gtf_workspace")).click();
            
            //Filtre 
            element(by.id("data_column")).element(by.id("publication_gtf_workspace_grid")).element(by.id("publication_gtf_workspace_grid_header")).element(by.id("publication_gtf_workspace_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_importparlot");
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            var listProjects = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            expect(listProjects.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).count()).toEqual(2);
            browser.sleep(300);

        });

        it("- contrôle des formulaires importés", function () {
            console.log("\nit de contrôle de l'import des formulaires");
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_importparlot1");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            FonctVeremes.waitAfterClick();

            var celluleFormulaire = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 12);

            expect(celluleFormulaire.element(by.className('true-icon')).isPresent()).toBe(true);
            browser.sleep(2000);


        });
        it("-Renommage de projets fmw déjà existants", function () {
            element(by.id("publication_gtf_workspace_adImport_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();
            var fmw1 = FonctVeremes.pathResolver("./resource/t_importparlot1.fmw");
            element(by.id("publication_workspace_import_workspace_fmw_file")).sendKeys(fmw1);
            FonctVeremes.waitAfterClick();
            element(by.className("fileinput-upload-button")).click();
            FonctVeremes.waitToLoadPage();
            //onglet Projets FME 
            element(by.id("object_column_publication_gtf_workspace")).click();
            //filtre
            element(by.id("data_column")).element(by.id("publication_gtf_workspace_grid")).element(by.id("publication_gtf_workspace_grid_header")).element(by.id("publication_gtf_workspace_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_importparlot1");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            var listProjects = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            expect(listProjects.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).count()).toEqual(2);
            browser.sleep(300);
        });
    });

    describe("3- Import par lot de fichier autre que fmw ", function () {

        it("- It d'import d'un fichier jpg par lot", function () {

            element(by.id("publication_gtf_workspace_adImport_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();
            var jpg = FonctVeremes.pathResolver("./resource/vse.jpg");
            element(by.id("publication_workspace_import_workspace_fmw_file")).sendKeys(jpg);
            browser.sleep(400);

            element(by.id("object_column_publication_gtf_workspace")).click();
            //Filtre
            element(by.id("data_column")).element(by.id("publication_gtf_workspace_grid")).element(by.id("publication_gtf_workspace_grid_header")).element(by.id("publication_gtf_workspace_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("vse");
            element(by.id("publication_gtf_workspace_search_form_search")).click();


            var listProjects = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            expect(listProjects.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).count()).toEqual(0);
            browser.sleep(5000);

        });
    });
   });




