/* global by, browser, element, expect, jasmine, protractor */

'use strict';
/**
 * @author: ME
 * @Description: test publication a FME project on vitis then add an order
 */

describe("Vitis gestion des métadonnées - ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;
    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 150000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });

    it("COnnexion à GTF", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        //browser.driver.manage().window().maximize();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;
        //vérif du nom de l'onglet = Administration
        //expect(browser.getTitle()).toEqual('Gtf');
    });

    describe("Connexion de l'administrateur - ", function () {
        //test de connexion de l'admin

        it("connexion à gtf", function () {
            console.log("\nit de connexion de l'admin");
            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();
        });
    });

    describe("Check de l'import initial des métadonnées- ", function () {

        it("Ajout d'un nouveau projet FME", function () {
            console.log("\nit del'Ajout projet metadata\n");
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_add_smallFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_workspace_general_insert_form_name")).sendKeys('test_metadata');

            var FileToUpload = FonctVeremes.pathResolver("./resource/metadata.fmw");
            element(by.id("publication_gtf_workspace_general_insert_form_fmw_file")).sendKeys(FileToUpload);

            FonctVeremes.waitAfterSendKeys();
            element(by.id("publication_gtf_workspace_general_insert_form_form_submit")).click();
            browser.sleep(3000);
            element(by.id("publication_gtf_workspace_general_update_form_return_list")).click();
            FonctVeremes.waitToLoadPage();


            //recherche par filtre du projet : 
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);


            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(1000);

            var cellCompte = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 2);
            expect(cellCompte.getText()).toEqual("test_metadata");

        });


        it("Check import de la nouvelle catégorie", function () {
            console.log("\nit de Check import Nouvelle catégorie");
            //recherche par filtre de la nouvelle catégorie dans l'onglet catégories
            element(by.id("object_column_publication_gtf_category")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_reset")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_name")).sendKeys("Nouvelle catégorie");
            element(by.id("publication_gtf_category_search_form_search")).click();
            browser.sleep(1000);

            var cellCompte = FonctVeremes.dataCell("publication_gtf_category_grid_data", 0, 2);
            expect(cellCompte.getText()).toEqual("Nouvelle catégorie");
            browser.sleep(1000);
        });

        it("Check import métadata", function () {
            //retour onglet Projets FME 
            console.log("\nit Check import des métadonnées\n");
            element(by.id("object_column_publication_gtf_workspace")).click();

            browser.sleep(500);
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);

            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();

            element(by.css('[ng-if="grid.appScope.edit_column"]')).click();

            browser.sleep(1000);

            //Section metadonnées :
            element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(1)).click();
            browser.sleep(1000);

            console.log("\ncheck description");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_description")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Description</p>');
            console.log("\ncheck utilisation");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_usage")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;"><br></p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Utilisation</p>');
            console.log("\ncheck prerequis");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_requirements")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Pré requis</p>');

            //console.log("\ncheck conditions utilisation");
            //expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_legal_terms_conditions")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Conditions d\'utilisation</p>');
            FonctVeremes.waitAfterClick();

        });
    });

    describe("Gestion des métadonnées lors du rechargement de projet - ", function () {

        it("rechargement du projet fmw", function () {
            console.log("\nit de Rechargement du projet fme dans la section Répertoire projet");
            element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(5)).click();
            browser.sleep(600);

            var FileToUpload2 = FonctVeremes.pathResolver("./resource/metadata2.fmw");
            element(by.id("publication_gtf_workspace_loadProjectDirectory_update_form_fmw_file")).sendKeys(FileToUpload2);

            FonctVeremes.waitAfterSendKeys();
            element(by.id("publication_gtf_workspace_loadProjectDirectory_update_form_btn_upload_fmw_file")).click();

            browser.sleep(1000);
            //retour liste projets
            element(by.id("object_column_publication_gtf_workspace")).click();

            browser.sleep(400);
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(300);

            var cell_fichierFMW = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 3);
            expect(cell_fichierFMW.getText()).toEqual("metadata2.fmw");

            element(by.css('[ng-click="grid.appScope.executeActionButtonEvent(row, grid.appScope.edit_column)"]')).click();
            browser.sleep(600);

            //Section Métadonnées. Check des métadonnées non modifiées
            element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(1)).click();
            FonctVeremes.waitAfterClick();

            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_description")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Description</p>');
            console.log("\ncheck utlisation");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_usage")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;"><br></p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Utilisation</p>');
            console.log("\ncheck prerequis");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_requirements")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Pré requis</p>');
            console.log("\ncheck conditions utilisation");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_legal_terms_conditions")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Projet pour tester l\'import de métadonnées dans GTF</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">éàçù!</p><p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Conditions d\'utilisation</p>');
            FonctVeremes.waitAfterClick();
        });

        it("rechargement des métadonnées", function () {
            //test du rechargement des métadonnées - Bouton Relire le projet 
            console.log("\nit de rechargement des métadonnées");
            element(by.id("publication_gtf_workspace_updateMetadata_update_form_regenerate_metadata")).click();

            browser.sleep(1000);
            // element(by.id("publication_gtf_workspace_updateMetadata_update_form_form_submit")).click();
            browser.sleep(600);
            console.log("\ncheck description2");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_description")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Description modifiée</p><p style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-paragraph-type: empty; -qt-block-indent: 0; text-indent: 0px; margin: 0px;"><br></p>');
            FonctVeremes.waitAfterClick();
            console.log("\ncheck utlisation2");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_usage")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Utilisation modifiée</p>');
            FonctVeremes.waitAfterClick();
            console.log("\ncheck prerequis2");
            expect(element(by.id("publication_gtf_workspace_updateMetadata_update_form_requirements")).getAttribute("value")).toEqual('<p style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;" data-mce-style="-qt-block-indent: 0; text-indent: 0px; margin: 0px;">Pre requis modifiés</p>');

            browser.sleep(1000);

        });
    });


    describe("Suppression projet et catégories - ", function () {
        //test de connexion de l'admin

        it("suppression du projet", function () {
            console.log("\nit de Suppression du projet metadata\n");

            element(by.id("publication_gtf_workspace_updateMetadata_update_form_return_list")).click();

            browser.sleep(600);
            //recherche projet par le filtre 

            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(300);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("test_metadata");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            FonctVeremes.waitAfterClick();

            //var ListeProjet = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            // ListeProjet.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by ").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.colDef.name").row(0)).element(by.css('[ng-click="selectButtonClick(row, $event)"]')).click();

            var listeProjets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeProjets.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            FonctVeremes.waitToLoadPage();
            element(by.id("publication_gtf_workspace_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitToLoadPage();

            FonctVeremes.confirmAlert();
            //element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
            FonctVeremes.waitToLoadPage();

        });

        it("suppression des 2 nouvelles catégories", function () {
            //Onglet catégorie 
            console.log("\nit de Suppression de la Nouvelle catégorie\n");
            element(by.id("object_column_publication_gtf_category")).click();
            FonctVeremes.waitAfterClick();

            //recherche projet par le filtre 
            element(by.id("publication_gtf_category_search_filter_button")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("publication_gtf_category_search_form_reset")).click();
            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_category_search_form_name")).sendKeys("Nouvelle catégorie");
            element(by.id("publication_gtf_category_search_form_search")).click();
            FonctVeremes.waitAfterClick();

            var listeCategories = element(by.id("publication_gtf_category_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeCategories.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            FonctVeremes.waitAfterClick();
            listeCategories.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(1)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            FonctVeremes.waitToLoadPage();

            element(by.id("publication_gtf_category_deleteFlexigrid_ui_grid_add")).click();
            FonctVeremes.waitAfterClick();

            FonctVeremes.confirmAlert();
       
            FonctVeremes.waitToLoadPage();

        });

    });

});
