/* global by, browser, element, expect, jasmine */

'use strict';
/**
 * @author: M ESPADA
 * @Description: test E2E on GTF application
 * Contrôle Attribution et changement de moteurs
 */

describe("vitis GTF - Affiliation de moteur à un projet- ", function () {

    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;

    beforeEach(function () {
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 2800000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });

    it("Connexion à GTF", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm03.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
        browser.driver.manage().window().setSize(1800, 1200);
        browser.ignoreSynchronization = false;

    });

    describe("Connexion de l'admin - ", function () {

        it("connexion de l'admin", function () {
            element(by.id("login_form_user_login")).sendKeys(login);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();

            expect(element(by.id("user_column")).getText()).toContain("margot");
        });
    });

    describe("Nouveau projet et affiliation moteur 2016 - ", function () {

        it("Ajout d'un projet FME ", function () {

            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();
            FonctVeremes.waitAfterClick;

            //filtre
            // element(by.id("publication_gtf_workspace_search_filter_button")).click();

            // browser.sleep(1000);

            // element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_moteur");

            //  element(by.id("publication_gtf_workspace_search_form_search")).click();

            // browser.sleep(1000);


            element(by.id("publication_gtf_workspace_add_smallFlexigrid_ui_grid_add")).click();

            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_workspace_general_insert_form_name")).sendKeys('t_moteur');
            var FileToUpload = FonctVeremes.pathResolver("./resource/shp2mif.fmw");
            element(by.id("publication_gtf_workspace_general_insert_form_fmw_file")).sendKeys(FileToUpload);

            var ResourceToUpload = FonctVeremes.pathResolver("./resource/dpt2.zip");

            element(by.id("publication_gtf_workspace_general_insert_form_comp_file")).sendKeys(ResourceToUpload);
            FonctVeremes.waitAfterClick();

            //moteur 2016
            element(by.id("publication_gtf_workspace_general_insert_form_tag_label")).click();

            browser.actions().mouseMove(element(by.cssContainingText('option', 'fme2016'))).click().perform();
            browser.actions().mouseMove(element(by.cssContainingText('option', 'fme2016'))).click().perform();

            FonctVeremes.waitAfterClick();

            element(by.id("publication_gtf_workspace_general_insert_form_form_submit")).click();

            browser.sleep(6000);

            //section Droits
            element(by.repeater("section in ::oSectionForm[sSelectedObjectName].sections track by $index").row(2)).click();

            browser.sleep(1000);

            element(by.id("publication_gtf_workspace_updateRight_update_form_groups_from")).element(by.cssContainingText('option', 'groupeTest')).click();
            element(by.id("publication_gtf_workspace_updateRight_update_form_from_group_to_groups")).click();
            element(by.id("publication_gtf_workspace_updateRight_update_form_form_submit")).click();
            browser.sleep(3000);

            //liste projets
            element(by.id("publication_gtf_workspace_updateRight_update_form_return_list")).click();
            browser.sleep(2000);

            var celluleFormulaire = FonctVeremes.dataCell("publication_gtf_workspace_grid_data", 0, 10);

            expect(celluleFormulaire.getText()).toEqual("fme2016");

            browser.sleep(1000);


        });

        it("Mode Mon travail et sélection du projet t_moteur ", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_my_work")).click();
            element(by.id("my_work_gtf_user_order_add_smallFlexigrid_ui_grid_add")).click();

            browser.sleep(2000);

            element(by.id("my_work_gtf_user_order_insert_form_workspace_id")).click();
            browser.actions().mouseMove(element(by.cssContainingText('option', 'GEOFLA'))).click().perform();
            browser.actions().mouseMove(element(by.cssContainingText('option', 'GEOFLA'))).click().perform();
            browser.sleep(2000);
            browser.actions().mouseMove(element(by.cssContainingText('option', 't_moteur'))).click().perform();
            browser.actions().mouseMove(element(by.cssContainingText('option', 't_moteur'))).click().perform();

            browser.sleep(2000);
        });

        it("clic sur Demander  ", function () {

            expect(element(by.id("my_work_gtf_user_order_insert_subform_DestDataset_MIF_label")).isPresent()).toBe(true);


            element(by.id("my_work_gtf_user_order_insert_subform_form_submit")).click();

            browser.sleep(120000);
            console.log("demande de traitement");
        });
          });
            });
        
/*
        it("vérification du traitement de la demande ", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_supervision")).click();

            //Filtre
            browser.sleep(2000);
            element(by.id("supervision_gtf_order_search_filter_button")).click();
            browser.sleep(1000);
            element(by.id("supervision_gtf_order_search_form_workspace_id")).element(by.cssContainingText('option', 't_moteur')).click();
            element(by.id("supervision_gtf_order_search_form_search")).click();
            browser.sleep(1000);

            var tableauDemandes = element(by.id("supervision_gtf_order_grid_data", 0, 3));
            expect(tableauDemandes.element(by.className('status3-icon')).isPresent()).toBe(true);

            browser.sleep(1000);
        });
    });


    describe("Modification moteur - ", function () {

        it("Sélection du projet t_moteur ", function () {

            var listeDemandes = element(by.id("supervision_gtf_order_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeDemandes.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();

            browser.sleep(1000);
        });


        it("affectation du moteur fme 2015 ", function () {
            element(by.id("supervision_gtf_order_changeEngineFlexigrid_ui_grid_add")).click();
            browser.sleep(1000);



            element(by.id("supervision_gtf_order_change_gtf_engine_form_gtf_engine_id")).sendKeys("Moteur #2");
            browser.sleep(2000);
        });

        it("Clic OK sur l'alerte de changement de moteur ", function () {
            element(by.id("supervision_gtf_order_change_gtf_engine_form_form_submit")).click();

            browser.sleep(3000);
            var tableauDemandes = FonctVeremes.dataCell("supervision_gtf_order_grid_data", 0, 13);
            expect(tableauDemandes.getText()).toEqual("2 - Moteur #2");


            browser.sleep(1000);
        });


        it("Réinitialisation du traitement t_moteur avec moteur fme 2015 ", function () {

            element(by.id("supervision_gtf_order_waitStatusFlaxigrid_ui_grid_add")).click();
            browser.sleep(120000);
            var tableauDemandes = element(by.id("supervision_gtf_order_grid_data", 0, 3));
            expect(tableauDemandes.element(by.className('status2-icon')).isPresent()).toBe(true);
            browser.sleep(2000);
        });

    });

    describe("Suppression du projet- ", function () {

        it("Suppression du projet t_moteur ", function () {
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_publication")).click();

            //recherche par filtre de la demande de t_moteur
            browser.sleep(2000);
            element(by.id("publication_gtf_workspace_search_filter_button")).click();
            browser.sleep(1000);
            element(by.id("publication_gtf_workspace_search_form_reset")).click();
            browser.sleep(2000);
            element(by.id("publication_gtf_workspace_search_form_name")).sendKeys("t_moteur");
            element(by.id("publication_gtf_workspace_search_form_search")).click();
            browser.sleep(1000);
            var listeProjets = element(by.id("publication_gtf_workspace_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
            listeProjets.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index").row(0)).element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(0)).element(by.css('[ng-click=\"selectButtonClick(row, $event)\"]')).click();
            element(by.id("publication_gtf_workspace_deleteFlexigrid_ui_grid_add")).click();

            browser.sleep(1000);

            FonctVeremes.confirmAlert();

            FonctVeremes.waitToLoadPage();

        });
    });

});
*/