/* global by, browser, element, expect, jasmine, protractor */

'use strict';
/**
 * @author: ME
 * @Description: test E2E on vitis 
 * Create and remove users
 */


describe("Vitis Users-", function () {
//create, remove an user (with differents privileges) 
//var id;
    var FonctVeremes = require("../VeremesTest");
    var login = browser.params.login;
    var pwd = browser.params.password;
    beforeEach(function () {
          browser.driver.manage().window().maximize();
        jasmine.DEFAULT_TIMEOUT_INTERVAL = 280000; // maximum time between two IT
        //browser.ignoreSynchronization = true; //non angular application
        FonctVeremes.isAngularApp(true);
    });
    afterEach(function () {
        FonctVeremes.waitBetweenTwoTests();
    });
    
    it("Connexion à GTF", function () {
        browser.ignoreSynchronization = true;
        browser.get('https://vm06.veremes.net/gtf/');
        FonctVeremes.waitToLoadPage();
         
        browser.ignoreSynchronization = false;
   
    });
    
    

    describe("1 -Connexion admin-", function () {

        it("Connexion de margot", function () {
            //saisie des identifiants
            element(by.id("login_form_user_login")).sendKeys(login);
            // browser.sleep(100);
            element(by.id("login_form_user_password")).sendKeys(pwd);
            // browser.sleep(100);
            //FonctVeremes.waitToLoadPage();
            element(by.id("login_form_name")).click();
            FonctVeremes.waitToLoadPage();

        });
    });
 
 
    describe("2 -Création d'un utilisateur avec des privilèges admin-", function () {

           it("Création de t_admin", function () {
            //FonctVeremes.waitToLoadPage();
            var mode = element(by.id("mode_column"));
            mode.element(by.id("mode_users")).click();
            //FonctVeremes.waitToLoadPage();
            //Ajout utilisateur
            var grid = element(by.id("users_vitis_users_grid"));
            grid.element(by.id("users_vitis_users_add_smallFlexigrid_ui_grid_add")).click();
         
            element(by.id("users_vitis_users_insert_form_login")).sendKeys('t_admin');
            element(by.id("users_vitis_users_insert_form_name")).sendKeys('t_admin');
            element(by.id("users_vitis_users_insert_form_email")).sendKeys('admin@veremes.com');
            element(by.id("users_vitis_users_insert_form_company")).sendKeys('Veremes');
            element(by.id("users_vitis_users_insert_form_department")).sendKeys('dev');
            //attribution du groupe test
            var groupe = element(by.id("users_vitis_users_insert_form_groups_from"));
            groupe.element(by.css('[label="groupeTest"]')).click();
            element(by.id("users_vitis_users_insert_form_from_group_to_groups")).click();
            //attibution privileges gtf_admin, vitis_admin et vitis_user

            var privilege = element(by.id("users_vitis_users_insert_form_privileges_from"));
            privilege.element(by.css('[label="gtf_admin"]')).click();
            element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
            privilege.element(by.css('[label="vitis_admin"]')).click();
            element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
            privilege.element(by.css('[label="vitis_user"]')).click();
            element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();

            //attribution mot de passe 
            element(by.id("users_vitis_users_insert_form_password")).sendKeys('t_admin');
            element(by.id("users_vitis_users_insert_form_password_confirm")).sendKeys('t_admin');
             
                browser.actions()
                .mouseMove(element(by.id('users_vitis_users_insert_form_form_submit'))).click()
                .perform();
      
               browser.sleep(10000);
       

            element(by.id("users_vitis_users_update_form_return_list")).click();
        
               
               browser.sleep(2000);

            // tri décroissant sur la colonne id de la liste des utilisateurs 
            element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
            element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
            element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();

            var cellule = FonctVeremes.dataCell("users_vitis_users_grid_data", 0, 2);
            expect(cellule.getText()).toEqual("t_admin");
            element(by.id("user_column")).click();
            FonctVeremes.waitAfterClick();
            element(by.id("btn_disconnect")).click();

            browser.sleep(10000);
        });
       
  
 
 it("Reconnexion de t_admin", function () {
 element(by.id("login_form_user_login")).sendKeys('t_admin');
 element(by.id("login_form_user_password")).sendKeys('t_admin');
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();

 expect(element(by.id("user_column")).getText()).toContain("t_admin");
 });
 
 it("Changement de pwd par t_admin", function () {
 var mode = element(by.id("mode_column"));
 mode.element(by.id("mode_users")).click();
 FonctVeremes.waitAfterClick();
 //recherche par filtre 
 element(by.id("users_vitis_users_search_filter_button")).click();
 browser.sleep(300);
 element(by.id("users_vitis_users_search_form_login")).sendKeys("t_admin");
 element(by.id("users_vitis_users_search_form_search")).click();
 var cellCompte = FonctVeremes.dataCell("users_vitis_users_grid_data", 0, 2);
 expect(cellCompte.getText()).toEqual("t_admin");
 //Edition du compte t_admin et modification du pwd : 
 element(by.css('[ng-if="grid.appScope.edit_column"]')).click();
 FonctVeremes.waitAfterClick();
 element(by.id("users_vitis_users_update_form_password")).sendKeys('testeur');
 FonctVeremes.waitAfterClick();
 element(by.id("users_vitis_users_update_form_password_confirm")).sendKeys('testeur');
 FonctVeremes.waitAfterClick();
  browser.sleep(2000);
 element(by.id("users_vitis_users_update_form_form_submit")).click();
 
 browser.sleep(10000);
 

 FonctVeremes.confirmAlert();
     console.log("\nchangement de mot de passe en testeur");
 FonctVeremes.waitToLoadPage();
 
 });
 
 it("Reconnexion de t_admin  avec le nouveau pwd", function () {
 
 element(by.id("login_form_user_login")).sendKeys('t_admin');
 element(by.id("login_form_user_password")).sendKeys('testeur');
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();
 
 console.log("\n reconnexion de t_admin ");
 expect(element(by.id("user_column")).getText()).toContain("t_admin");
 FonctVeremes.waitBetweenTwoTests();
 });
 
 
 it("Creation d'un nouveau groupe par t_admin", function () {
 
 element(by.id("mode_users")).click();
 //onglet Groupes : 
 element(by.id("object_column_users_vitis_group")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("users_vitis_group_add_smallFlexigrid_ui_grid_add")).click();
 FonctVeremes.waitAfterClick();
 FonctVeremes.waitAfterClick();
 
 
 element(by.id("framework_group_insert_form")).element(by.id("users_vitis_group_general_insert_form_name")).sendKeys('groupe_test2');
 
 FonctVeremes.waitAfterClick();
 
 var user = element(by.id("framework_group_insert_form")).element(by.id("users_vitis_group_general_insert_form_users_from"));
 
 user.element(by.css('[label="t_admin"]')).click();
 element(by.id("users_vitis_group_general_insert_form_from_user_to_users")).click();
 element(by.id("users_vitis_group_general_insert_form_form_submit")).click();
 FonctVeremes.waitToLoadPage();
 element(by.id("object_column_users_vitis_users")).click();
 FonctVeremes.waitToLoadPage();
 element(by.id("user_column")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("btn_disconnect")).click();
 FonctVeremes.waitToLoadPage();
 
 });
 });

 describe("4 - Création d'utilisateur de privilège user - ", function () {
 
 it("Creation de l'utilisateur user", function () {
 element(by.id("login_form_user_login")).sendKeys(login);
 element(by.id("login_form_user_password")).sendKeys(pwd);
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();
 
 
 var mode = element(by.id("mode_column"));
 mode.element(by.id("mode_users")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("users_vitis_users_add_smallFlexigrid_ui_grid_add")).click();
 element(by.id("users_vitis_users_insert_form_login")).sendKeys('user');
 element(by.id("users_vitis_users_insert_form_name")).sendKeys('user');
 element(by.id("users_vitis_users_insert_form_email")).sendKeys('user@veremes.com');
 element(by.id("users_vitis_users_insert_form_company")).sendKeys('Veremes');
 element(by.id("users_vitis_users_insert_form_department")).sendKeys('dev');
 //attribution du groupe test
 var groupe = element(by.id("users_vitis_users_insert_form_groups_from"));
 groupe.element(by.css('[label="groupeTest"]')).click();
 element(by.id("users_vitis_users_insert_form_from_group_to_groups")).click();
 //attribution privilege vitis_user, vitis_admin et gtf_user: 
 var privilege = element(by.id("users_vitis_users_insert_form_privileges_from"));
 privilege.element(by.css('[label="gtf_user"]')).click();
 
 element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
 privilege.element(by.css('[label="vitis_user"]')).click();
 element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
 //attribution d'un mot de passe avec espace
 element(by.id("users_vitis_users_insert_form_password")).sendKeys('user user');
 element(by.id("users_vitis_users_insert_form_password_confirm")).sendKeys('user user');
     browser.actions()
                .mouseMove(element(by.id('users_vitis_users_insert_form_form_submit'))).click()
                
                .perform();
        FonctVeremes.waitAfterActions();
  browser.sleep(5000);


 browser.sleep(5000);
 
 element(by.id("users_vitis_users_update_form_return_list")).click();
 browser.sleep(500);
 // tri décroissant sur la colonne id de la liste des utilisateurs : 
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 var cellule = FonctVeremes.dataCell("users_vitis_users_grid_data", 0, 2);
 
 expect(cellule.getText()).toEqual("user");
 
 element(by.id("user_column")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("btn_disconnect")).click();
 FonctVeremes.waitToLoadPage();
 });
 
 it("Connexion de user ", function () {
 element(by.id("login_form_user_login")).sendKeys('user');
 element(by.id("login_form_user_password")).sendKeys('user user');
 element(by.id("login_form_name")).click();
 //FonctVeremes.waitToLoadPage();
 
 expect(element(by.id("mode_column")).all(by.tagName("a")).count()).toEqual(2);
 expect(element(by.id("user_column")).getText()).toContain("user");
 FonctVeremes.waitBetweenTwoTests();
 });
 });
 
 
 describe("5 - Création d'utilisateur de privilège Auteur -", function () {
 it("Création de l'utilisateur author ", function () {
 
 element(by.id("user_column")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("btn_disconnect")).click();
 FonctVeremes.waitToLoadPage();
 element(by.id("login_form_user_login")).sendKeys(login);
 element(by.id("login_form_user_password")).sendKeys(pwd);
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();
 FonctVeremes.waitToLoadPage();
 console.log('\nReconnexion de margot');
 
 
 element(by.id("mode_users")).click();
 element(by.id("users_vitis_users_add_smallFlexigrid_ui_grid_add")).click();
 element(by.id("users_vitis_users_insert_form_login")).sendKeys('author');
 element(by.id("users_vitis_users_insert_form_name")).sendKeys('author');
 element(by.id("users_vitis_users_insert_form_email")).sendKeys('author@veremes.com');
 element(by.id("users_vitis_users_insert_form_company")).sendKeys('Veremes');
 element(by.id("users_vitis_users_insert_form_department")).sendKeys('dev');
 //attribution du groupe test
 var groupe = element(by.id("users_vitis_users_insert_form_groups_from"));
 groupe.element(by.css('[label="groupeTest"]')).click();
 element(by.id("users_vitis_users_insert_form_from_group_to_groups")).click();
 //attribution privilege vitis_user, vitis_admin et gtf_author: 
 var privilege = element(by.id("users_vitis_users_insert_form_privileges_from"));
 privilege.element(by.css('[label="gtf_author"]')).click();
 element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
 
 element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
 privilege.element(by.css('[label="vitis_user"]')).click();
 element(by.id("users_vitis_users_insert_form_from_privilege_to_privileges")).click();
 //attribution d'un mot de passe
 element(by.id("users_vitis_users_insert_form_password")).sendKeys('author');
 element(by.id("users_vitis_users_insert_form_password_confirm")).sendKeys('author');
 
 
     browser.actions()
                .mouseMove(element(by.id('users_vitis_users_insert_form_form_submit'))).click()
                .perform();
        FonctVeremes.waitAfterActions();
 
 
 browser.sleep(3000);
 element(by.id("users_vitis_users_update_form_form_submit")).click();
 browser.sleep(3000);
 element(by.id("users_vitis_users_update_form_return_list")).click();
 // tri décroissant sur la colonne id de la liste des utilisateurs 
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 element(by.className("users_vitis_users_user_id")).element(by.className("ng-binding")).click();
 var cellule = FonctVeremes.dataCell("users_vitis_users_grid_data", 0, 2);
 
 expect(cellule.getText()).toEqual("author");
 
 element(by.id("user_column")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("btn_disconnect")).click();
 FonctVeremes.waitToLoadPage();
 });
 
 it("Connexion de author", function () {
 element(by.id("login_form_user_login")).sendKeys('author');
 element(by.id("login_form_user_password")).sendKeys('author');
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();
 
 expect(element(by.id("mode_column")).all(by.tagName("a")).count()).toEqual(6);
 expect(element(by.id("user_column")).getText()).toContain("author");
 
 
 FonctVeremes.waitBetweenTwoTests();
 element(by.id("user_column")).click();
 FonctVeremes.waitAfterClick();
 element(by.id("btn_disconnect")).click();
 browser.sleep(8000);
 
 });
 });
 
 describe("7 - Suppression utilisateurs et groupe-", function () {
 
 it("Suppression des utilisateurs ", function () {
 element(by.id("login_form_user_login")).sendKeys(login);
 
 element(by.id("login_form_user_password")).sendKeys(pwd);
 
 element(by.id("login_form_name")).click();
 FonctVeremes.waitToLoadPage();
 element(by.id("mode_users")).click();
 browser.sleep(500);
 
 
 
 
 var listusers = element(by.id("users_vitis_users_grid_data")).element(by.className("ui-grid-render-container-body")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
 listusers.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).each(function (el, i) {
 var celluleCompte = el.element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(2));
 //var celluleCompte = el.element(by.className("ui-grid-coluiGrid-0NU"));
 celluleCompte.getText().then(function (text) {
 if ((text == "t_admin") || (text == "user") || (text == "eeeec") || (text == "صباح الخير") || (text == "你好") || (text == "author")) {
 celluleCompte.element(by.className("ui-grid-cell-contents")).click();
 }
 })
 });
 
 element(by.id("users_vitis_users_deleteFlexigrid_ui_grid_add")).click();
 FonctVeremes.waitAfterActions();
 
 element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
 FonctVeremes.waitToLoadPage();
 
 
 var listusers = element(by.id("users_vitis_users_grid_data")).element(by.className("ui-grid-render-container-body")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
 listusers.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).each(function (el, i) {
 var celluleCompte = el.element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(2));
 celluleCompte.getText().then(function (text) {
 expect(text).not.toEqual("t_admin");
 expect(text).not.toEqual("user");
 expect(text).not.toEqual("صباح الخير");
 expect(text).not.toEqual("你好");
 expect(text).not.toEqual("éèêëç");
 expect(text).not.toEqual("author");
 FonctVeremes.waitToLoadPage();
 });
 });
 });
 
 it("Suppression groupe ", function () {
 
 var mode = element(by.id("mode_column"));
 mode.element(by.id("mode_users")).click();
 browser.sleep(1000);
 
 
 
 element(by.id("object_column_users_vitis_group")).click();
 browser.sleep(1000);
 //Filtre
 element(by.id("users_vitis_group_search_filter_button")).click();
 browser.sleep(1000);
 element(by.id("users_vitis_group_search_form_name")).sendKeys("groupe_test2");
 browser.sleep(400);
 element(by.id("users_vitis_group_search_form_search")).click();
 browser.sleep(1000);
 
 var liste_groupe = element(by.id("users_vitis_group_grid_data")).element(by.className("ui-grid-pinned-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
 liste_groupe.element(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).element(by.css('[ng-click=\"selectButtonClick(row, $event)"]')).click();
 browser.sleep(400);
 
 element(by.id("users_vitis_group_deleteFlexigrid_ui_grid_add")).click();
 console.log("clic sur le bouton supprimer");
 browser.sleep(5000);
 
 //element(by.className("bootbox")).element(by.className("modal-dialog")).element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
 FonctVeremes.confirmAlert();
 //element(by.className("modal-content")).element(by.className("modal-footer")).element(by.css('[data-bb-handler=\"confirm\"]')).click();
 // element(by.className("bootbox-confirm in")).
 // element(by.className("modal-content")).element(by.className("modal-footer")).element(by.className("btn btn-primary")).click();
 FonctVeremes.waitToLoadPage();
 
 
 var liste_groupe2 = element(by.id("users_vitis_group_grid_data")).element(by.className("ui-grid-render-container")).element(by.className("ui-grid-viewport")).element(by.className("ui-grid-canvas"));
 liste_groupe2.all(by.repeater("(rowRenderIndex, row) in rowContainer.renderedRows track by $index")).each(function (el, i) {
 
 
 console.log("\nLe groupe groupe_test2 n'est pas présent :");
 var celluleGroupe = el.element(by.repeater("(colRenderIndex, col) in colContainer.renderedColumns track by col.uid").row(2));
 celluleGroupe.getText().then(function (text) {
 
 expect(text).not.toEqual("groupe_test2");
 });
 });
 });
 
 });
 
 });
 
 

          