<?php

//Par défaut il faudra inclure la lib de log pour pouvoir logger
//D’autres lib pourront être chargées ici en fonction des besoins

require_once("vmlib/logUtil.inc");
require_once("vmlib/Email.class.inc");
require_once("vmlib/phpUtil.inc");
require_once("gtf_lib/gtf_object/User.class.inc");

class WabBusinessObject {

    protected $bo_id;
    protected $className;
    private $status;
    protected $history;
    protected $oBd;
    public $aValues = array();
    protected $aTableInfo = array();
    protected $aProperties = array();
    protected $aSql = array();
    protected $bNoError = true;
    protected $sErrorMessage;
    protected $aLastCurlRequestInfo = "";

    /*     * ****************************************************
      Class constructor
      \oBd : Connection object.
      \aProperties : Array of properties.

     * **************************************************** */

    public function __construct($oBd, $aTableInfo, $aValues, $aProperties, $className, $iId = null) {
        require 'BusinessObject.class.sql.inc';
        $this->aTableInfo = $aTableInfo;
        $this->oBd = $oBd;
        $this->aValues = $aValues;
        $this->aProperties = $aProperties;
        $this->className = $className;
        $this->bo_id = $iId;
        $this->history = "";
    }


     /* *****************************************************
      Change le statut
      \sStatus : statut
     * **************************************************** */

    public function wabSetStatus($sSchema, $sTable, $sBoNameField, $mBoIdValue, $sStatusName, $sView = '') {
        require 'BusinessObject.class.sql.inc';

        if($sView === ''){
          $sView = $sTable;
        }

        // get status Id avec le StatusName
        $aParams = array(
          "SCHEMA"=> array("value"=> $sSchema, "type"=>'column_name'),
          "TABLE"=> array("value"=> $sTable, "type"=>'column_name'),
          "STATUS_NAME"=> array("value"=> $sStatusName, "type"=>'string')
          );
        $oResultat = $this->oBd->executeWithParams($aSQL["getStatusId"], $aParams);

        //$this->status = $this->oBd->objetSuivant($oResultat)->status_id;
		$oStatus = $this->oBd->objetSuivant($oResultat);
        // ajout historique
        //$this->addHistoryEvent($this->status);
        //$this->addHistoryEvent($oStatus->name);
		// UPDATE dans la table avec le boName
        $sSql = $aSQL["updateStatus"];
        $aParams = array(
          "SCHEMA" => array("value"=> $sSchema, "type"=> 'column_name'),
          "TABLE" => array("value"=> $sView, "type"=> 'column_name'),
          "STATUS_ID" => array("value"=> $oStatus->status_id, "type"=> 'number'),
          "BOIDFIELD" => array("value"=> $sBoNameField, "type"=> 'column_name'),
          "BOID" => array("value"=> $mBoIdValue, "type"=> 'number')
          );

        $this->oBd->executeWithParams($sSql, $aParams);
		
		$this->aValues["status_id"] = $oStatus->status_id;
    }

    public function wabGetStatus($sSchema, $sTable, $sBoNameField, $mBoIdValue) {
        require 'BusinessObject.class.sql.inc';
        // GET Status name
        $sSql = $aSQL["getStatusName"];
        $aParams = array(
          "SCHEMA" => array("value"=> $sSchema, "type"=> 'column_name'),
          "TABLE" => array("value"=> $sTable, "type"=> 'column_name'),
          "BOIDFIELD" => array("value"=> $sBoNameField, "type"=> 'column_name'),
          "BOID" => array("value"=> $mBoIdValue, "type"=> 'number')
          );

        $oResultat = $this->oBd->executeWithParams($sSql, $aParams);
        return $this->oBd->objetSuivant($oResultat)->name;
    }
	
	public function wabGetObject($sSchema, $sTable, $sBoNameField, $mBoIdValue){
		require 'BusinessObject.class.sql.inc';
		$aParams = array(
          "SCHEMA" => array("value"=> $sSchema, "type"=> 'column_name'),
          "TABLE" => array("value"=> $sTable, "type"=> 'column_name'),
          "BOIDFIELD" => array("value"=> $sBoNameField, "type"=> 'column_name'),
          "BOID" => array("value"=> $mBoIdValue, "type"=> 'number')
          );

        $oResultat = $this->oBd->executeWithParams($aSQL["getBoValues"], $aParams);
		$oFields = (array) $this->oBd->objetSuivant($oResultat);
		
		return $oFields;
	}
    /*     * ********************************************************************
      Ajoute une note
      \sLineAttribute : Champ de form. contenant la note à ajouter
      \sNoteAttribute : Champ de form. contenant l'historique des notes
     * ******************************************************************** */

    public function addNote($sLineAttribute, $sNoteAttribute) {
        if (!empty($this->aValues[$sLineAttribute])) {
            // Mode insertion ?
            if (!empty($this->iId))
                $this->bo_id = $this->iId;
            //	
            $note = preg_replace('/^<br>/', '', $this->aValues[$sNoteAttribute]);
            $note .= date('d/m/Y H:i') . ' | ' . $_SESSION['ses_Login'] . ' | ' . $this->aValues[$sLineAttribute] . PHP_EOL;
            $this->aValues[$sNoteAttribute] = $note;
            $this->save();
        }
    }

    /*     * *********************************************
      Retourne toutes les infos d'une méthode pour
      la transition
      \sMethodName : Nom de la méthode
     * ********************************************* */
    /* function getMethodParameters($sMethodName) {
      $sSql = $this->aSql[$this->oBd->sgbd]['getMethodParameters'];
      $sSql = str_replace('[methodName]', $sMethodName , $sSql);
      $sSql = str_replace('[schema_gpm]', $this->aProperties['schema_gpm'] , $sSql);
      $sSql = str_replace('[className]', $this->className , $sSql);
      $result = $this->oBd->execute($sSql);
      if(!$oBd->erreurRencontree) {
      $oMethodParameters = $this->oBd->objetSuivant($result);
      }
      return $oMethodParameters;
      } */

    /*     * **********************************************
      Exécute le processus de transition par défaut.
      \sMethodName : Nom de la méthode
     * ********************************************** */
    /* function setTransition($sMethodName) {
      $oMethodParameters = $this->getMethodParameters($sMethodName . '()');
      // Before script
      if (!empty($oMethodParameters->before_transition_code))
      eval($oMethodParameters->before_transition_code);
      // Mise à jour du status
      if ($this->bNoError) {
      $this->setStatus($oMethodParameters->transition_to_status);
      // After script
      if (!empty($oMethodParameters->after_transition_code))
      eval($oMethodParameters->after_transition_code);
      }

      } */

    /*     * ************************************************************
      Vérifie si la méthode appelée inexistante est une méthode de
      transition.
      \$sMethodName : Nom de la méthode inexistante
      \$aMethodArguments : Arguments de la méthode
      /Retour : Tableau avec un message si erreur.
     * ************************************************************ */
    /* public function __call($sMethodName, $aMethodArguments) {
      $sSql = $this->aSql[$this->oBd->sgbd]['isTransitionMethod'];
      $sSql = str_replace('[methodName]', $sMethodName . '()' , $sSql);
      $sSql = str_replace('[schema_gpm]', $this->aProperties['schema_gpm'] , $sSql);
      $sSql = str_replace('[className]', $this->className , $sSql);
      $oResult = $this->oBd->execute($sSql);
      if(!$oBd->erreurRencontree) {
      if ($this->oBd->nombreLigne ($oResult) > 0) {
      $this->setTransition($sMethodName);
      }
      }
      if ($this->bNoError) {
      $aReturn = array('sStatus' => 0);
      $bFinishCreateWorkspace = true;
      } else {
      $aReturn = array('sStatus' => 1, 'sMessage' => $this->sErrorMessage);
      $bFinishCreateWorkspace = false;
      }
      return array('bFinishCreateWorkspace' => $bFinishCreateWorkspace, 'aReturn' => $aReturn);
      } */

    /*     * ********************************************************************
      Modifie un paramètre de la classe
      \sParameterName : nom du paramètre à modifier
      \sValue : Nouvelle valeur
     * ******************************************************************** */

    function set($sParameterName, $sValue) {
        if (property_exists($this, $sParameterName))
            $this->$sParameterName = $sValue;
        else
            $this->aValues[$sParameterName] = $sValue;
    }

    /*     * ********************************************************************
      Retourne un paramètre de la classe
      \sParameterName : nom du paramètre à retourner
      /Retour : Valeur du paramètre (si il existe)
     * ******************************************************************** */

    function get($sParameterName) {
        if (property_exists($this, $sParameterName))
            return $this->$sParameterName;
    }

    /*     * ********************************************************************
      Sauve tous les paramètres de la classe
     * ******************************************************************** */

    function save() {
        //$aValues = $this->getClassParameters();
        //$this->oBd->update($this->aTableInfo['schema_name'], str_replace($this->aTableInfo["module"] . "_", "", $this->aTableInfo['name']), $aValues, $this->aTableInfo['id_field'], $this->bo_id, $this->aTableInfo['id_field_type']);
		$aValues = $this->getClassParameters();
        $this->oBd->update($this->aTableInfo['schema_name'], $this->aTableInfo['name'], $aValues, $this->aTableInfo['id_field'], $this->bo_id, $this->aTableInfo['id_field_type']);
    }

    /*     * ********************************************************************
      Fusionne les propriétés de l'objet et le tableau aValues
      /Return : tableau
     * ******************************************************************** */

    function getClassParameters() {
        foreach (get_object_vars($this) as $sIndex => $value) {
            if (!is_array($value) && !is_object($value))
                $aClassParameters[$sIndex] = $value;
        }
        return array_merge($this->aValues, $aClassParameters);
    }

    /*     * ********************************************************************
      Insère une demande pour un projet FME
      \$sWorkspaceKey : Clé du projet FME
      \$sWkParams : Paramètres de la demande
      \$iPriorityId : Priority level
      \$iEmailOptionId : Identifier for email option
      \$sEmailNotifications : Notificiation email address
      \$sXslStyleSheet : Stylesheet path
      /Retour : booléen (T:ok, F:erreur)
     * ******************************************************************** */

    function insertOrder($sWorkspaceKey, $sWkParams, $iPriorityId = 1, $iEmailOptionId = 3, $sEmailNotifications = null, $sXslStyleSheet = '') {
        
      $bNoError = true;

      //get workspace id
      $sSQL = "SELECT workspace_id FROM [SCHEMA_GTF].workspace WHERE key = [WK_KEY];";
      $aParams = array(
        "SCHEMA_GTF" => array('value'=> $this->aProperties["schema_gtf"], 'type' => 'column_name'),
        "WK_KEY" => array('value'=> $sWorkspaceKey, 'type' => 'string'),
      );
      $oWK = $this->oBd->executeWithParams($sSQL, $aParams);
      // oBd en erreur
      $iWKid = $this->oBd->objetSuivant ($oWK)->workspace_id;
      // Insertion de la demande
      $sUrl = $this->aProperties['web_server_name'] . '/' . $this->aProperties['services_alias'] . '/gtf/userorders';
      $postfields = array(
      //'token'=>$sToken, 
        'order_date' => date('Y-m-d'),
        'workspace_id'=>$iWKid, 
        'priority_id'=>$iPriorityId,
        'email_option_id'=>$iEmailOptionId,
        'wk_params'=>$sWkParams,
        'xslstylesheet'=>$sXslStyleSheet
      );
        
      if ( $sEmailNotifications != null){
        $postfields['email_notifications'] = $sEmailNotifications;
      }
      
      $oReturn = $this->contactCurrentApi("POST", 'gtf/userorders', $postfields , $sMode="json");
	  
	  error_log(print_r($oReturn, true));

      if($oReturn === false){
        $sErrorMsg = 'Error while performing a cURL session (' . __METHOD__ . ' (get token))';
      }

      if ($sErrorMsg != '') {
        writeToErrorLog($sErrorMsg);
        $bNoError = false;
        $this->sErrorMessage = $sErrorMsg;
      }
      $this->bNoError = $bNoError;
      return $bNoError;
    }

    /*     * ********************************************************************
      Envoi un email
      \$iEmailTemplateId : Id du modèle d'email.
      /Retour : Message
     * ******************************************************************** */

    function sendMail($iEmailTemplateId = null) {
        $sMessage = '';
        $aObjects = array('oBusinessObject' => $this);
        if (empty($iEmailTemplateId))
            $iEmailTemplateId = $this->aProperties['default_mail_model'];
        $oEmail = new Email($this->oBd, $iEmailTemplateId, $this->aProperties, $aObjects);
        //if(!empty($sValuesKey)){
        //$oEmail->aValues = $this->aValues;
        //}
        if (!empty($oEmail->oEmailTemplate->name))
            $sMessage = $oEmail->send();
        return $sMessage;
    }

    /*     * ********************************************************************
      Retourne un objet de la classe "User".
      \$sUserLogin : Login d'un utilisateur
      /Retour : Objet de la classe User
     * ******************************************************************** */

    function getUser($sUserLogin) {
        $sSql = $this->aSql[$this->oBd->sgbd]['getUserId'];
        //$sSql = str_replace('[login]', $this->aValues[$sUserLogin], $sSql);
        //$sSql = str_replace('[schema_framework]', $this->aProperties['schema_framework'], $sSql);
        $aParams = array(
          "login"=>array("value"=>$this->aValues[$sUserLogin], "type"=>"string"),
          "schema_framework"=>array("value"=>$this->aProperties['schema_framework'], "type"=>"column_name"),
        );
        $oResult = $this->oBd->executeWithParams($sSql, $aParams);
        if (!$this->oBd->erreurRencontree) {
            if ($this->oBd->nombreLigne($oResult) > 0) {
                $oUser = new User($this->oBd, $this->oBd->objetSuivant($oResult)->user_id, $this->aProperties);
                return $oUser;
            }
        }
    }

    /*     * ********************************************************************
      Récupére un token de session utilisateur.
      /Retour : string token
     * ******************************************************************** */

    function getToken ($sServerRestUrl = '', $aAuthParams = null) {

        if($this->aProperties['web_server_name'] === "[HTTP_HOST]"){
          $this->aProperties['web_server_name'] = "https://localhost";
        }

        if(empty($sServerRestUrl)){
          $sServerRestUrl = $this->aProperties['web_server_name'] . '/' . $this->aProperties['services_alias'];
        }

        $sUrl = $sServerRestUrl . '/vitis/privatetoken';
		
        if(!empty($aAuthParams)){
          $postfields = $aAuthParams;
        } else if(!empty($_SESSION["ses_Login"])){
          $sUserPassword = trim(des(rtrim(utf8_decode($_SESSION['ses_Login'])), hexToString(rtrim($_SESSION['ses_Password'])), 0, 0, null));
          $postfields = array('user'=>$_SESSION["ses_Login"], 'password'=>$sUserPassword);
        } else {
          $postfields = array('user'=>$this->aProperties["login_bot"], 'password'=>$this->aProperties["pass_bot"]);
        }

        //$oToken = json_decode($this->postCurlRequest ($sUrl, $postfields));
        $oToken = json_decode($this->sendCurlRequest ("POST", $sUrl, json_encode($postfields), array("Accept: applicaton/json", "Content-Type: application/json")));
		
        return $oToken->token;
    }

    /*     * ********************************************************************
      envoi une requete curl en POST (DEPRECATED)
      \$sUrl : Url pour envoyer la requete
      \$postfields : array contenant les paramètres à envoyer
      /Retour : string token
     * ******************************************************************** */
    function postCurlRequest ($sUrl, $postfields) {
		/*$ch = curl_init($sUrl);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Accept: application/json"));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        return curl_exec($ch);*/
		$this->sendCurlRequest("POST", $sUrl, $postfield, array("Accept: application/json"));
    }

    function sendCurlRequest($sMethod, $sUrl, $aParams=array(), $aHeaders=array()){

        $this->aLastCurlRequestInfo = '';
        //
        $ch = curl_init();
        $sType = strtoupper($sMethod);
        // Force la méthode de requête utilisée (GET, POST...).
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $sType);
        // Url à utiliser.
        if (($sType == 'GET' || $sType == 'DELETE') && !empty($aParams))
            $sUrl .= '?' . http_build_query($aParams);
        curl_setopt($ch, CURLOPT_URL, $sUrl);
        // ajout des en-tête
        curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeaders);
        // Retour sous forme de texte. 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // Requête POST PUT parameters.

        if ($sType == 'POST' || $sType == 'PUT') {
			if($sType == 'POST'){
				curl_setopt($ch, CURLOPT_POST, true);
			}
            // Chaîne de requête en encodage URL.
            //if (is_array($aParamsaParams) && !$bMultipartFormData)
            //    $aParams = http_build_query($aParams);
            // Données de la requête.
            curl_setopt($ch, CURLOPT_POSTFIELDS, $aParams);
            //
            //curl_setopt($ch, CURLOPT_SAFE_UPLOAD, true);
            // Entête pour la requête en POST.
            //$aHeaders[] = 'Content-Type: application/x-www-form-urlencoded';
        }

        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        // Curl error: SSL certificate problem: unable to get local issuer certificate
        // Curl error n°60
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        //
        $output = curl_exec($ch);
        // Erreur de la requête CURL.
        if(curl_errno($ch)) {
            writeToErrorLog('Curl error: ' . curl_error($ch));
            writeToErrorLog('Curl error n°' . curl_errno($ch));
        }
        // Informations de la requête.
        $aCurlInfo = curl_getinfo($ch);
        $this->aLastCurlRequestInfo = $aCurlInfo;
        
        // Ferme la session CURL.
        curl_close($ch);
        return $output;
    }

    function contactCurrentApi($sMethod, $sUrlPath, $aParams=array(), $sMode="json", $aAuthParams = null){

      if($this->aProperties['web_server_name'] === "[HTTP_HOST]"){
          $this->aProperties['web_server_name'] = "https://localhost";
        }

      $sRestUrl = $this->aProperties['web_server_name'] . '/' . $this->aProperties['services_alias'];

      $this->contactAnotherApi($sMethod, $sRestUrl, $sUrlPath, $aParams, $sMode, $aAuthParams);
    }

    function contactAnotherApi($sMethod, $sRestUrl, $sUrlPath, $aParams=array(), $sMode="json", $aAuthParams = null){
        $mToken = $this->getToken($sRestUrl, $aAuthParams);
		
        $sUrl = $sRestUrl . "/" . $sUrlPath;

        if($mToken !== false){

            // modification des paramètres si besoin
            $aSendParams = array();
            $aHeaders = array("token: " . $mToken);

            switch ($sMode) {
                case 'json':
                    $aSendParams = json_encode($aParams);
                    $aHeaders[] = "Content-Type: application/json";
                    $aHeaders[] = "Accept: application/json";
                    break;
                case 'query':
                    $sUrl .= '?' . http_build_query($aParams);
                    $aHeaders[] = "Accept: application/x-vm-json";
                    break;
                case 'urlencode':
                    $aSendParams = http_build_query($aParams);
                    $aHeaders[] = "Accept: application/x-www-form-urlencoded";
                    break;
                case 'formdata' :
                    $aSendParams = $aParams;
                    break;
            }

            $sOutput = $this->sendCurlRequest($sMethod, $sUrl, $aSendParams, $aHeaders);
			error_log(print_r($this->aLastCurlRequestInfo, true));
            return $sOutput;
        } else {
            writeToErrorLog("This user can't have a token on Calimap at URL : " . $sRestUrl);
            return false;
        }
    }
	
	/**********************************************************************
      Sauve l'historique deprecated
    **********************************************************************/
    function saveHistory() {
        $aHistoryValues = array('bo_id' => $this->aValues["my_vitis_id"], 'login' => $_SESSION['ses_Login'], 'comment' => $this->status, 'date' => date('Y-m-d H:i:s'));
        $this->oBd->insert($this->aTableInfo['schema_name'], 'history', $aHistoryValues, $this->aTableInfo['schema_name'] . '.history_history_id_seq', 'history_id');
    }
	/**********************************************************************
      Sauve une note ou commentaire (history sert d'historique)
    **********************************************************************/
	function addHistoryLine($sComment, $sHistoryTable, $iBoId){
		$sUser = 'u_scheduler';
		if(isset($_SESSION['ses_Login']) && !empty($_SESSION['ses_Login'])){
			$sUser = $_SESSION['ses_Login'];
		}
		
		$aHistoryValues = array('bo_id' => $iBoId, 'login' => $sUser, 'comment' => $sComment, 'date' => date('Y-m-d H:i:s'));
        $this->oBd->insert($this->aTableInfo['schema_name'], $sHistoryTable, $aHistoryValues, $this->aTableInfo['schema_name'] . '.seq_' . $sHistoryTable . "_id" , 'history_id');
	}
	
	function commitNoteLine($sNoteLineField, $sNoteTable, $sBoTable, $sFieldId, $iBoId){
		// get note line
		$aFields = $this->wabGetObject($this->aTableInfo['schema_name'], $sBoTable, $sFieldId, $iBoId);
		
		if(!empty($aFields[$sNoteLineField])){
			$sUser = 'u_scheduler';
			if(isset($_SESSION['ses_Login']) && !empty($_SESSION['ses_Login'])){
				$sUser = $_SESSION['ses_Login'];
			}
			$aNoteValues = array('bo_id' => $iBoId, 'login' => $sUser, 'comment' => $aFields[$sNoteLineField], 'date' => date('Y-m-d H:i:s'));
			$this->oBd->insert($this->aTableInfo['schema_name'], $sNoteTable, $aNoteValues, $this->aTableInfo['schema_name'] . '.seq_' . $sNoteTable . "_id", 'history_id');
		}
		
		// reset note line
		$this->aValues[$sNoteLineField] = "";
		$this->save();
	}
	
}

?>
