<?php
require "constants.inc";
require "properties_server.inc";
require "properties_domain.inc";
require "selected_properties.inc";
$properties['language'] = 'fr';
$properties['cookie_lifetime'] = 525600;
$properties['max_upload_file_size'] = 100 * 1024 * 1024;
$properties['max_execution_time'] = 3600;
$properties['max_request_time'] = 10;
$properties['minimum_refresh_period'] = 100;
$properties['forbidden_extension'] = '*.bat|*.com|*.exe|*.php|*.phtml|*.vhtml|*.js|*.vbe|*.wsf|*.dll';
$properties['rows_per_page'] = 20;
$properties['extract_dir'] = "{$properties['vas_home']}/tmp";
$properties['date_format'] = 'd/m/Y';
$properties['log_mode'] = true;
$properties['debug_mode'] = false;
$properties['log_period'] = 'Y-m';
$properties['log_size'] = 2048;
$properties['shared_dir'] = "{$properties['vas_home']}/shared";
$properties['public_alias'] = 'public[ENV]';
$properties['services_alias'] = 'rest[ENV]';
$properties['doc_alias'] = 'doc[ENV]';
$properties['ws_data_alias'] = 'ws_data[ENV]';
$properties['proxy_check_ssl'] = true;
$properties['mixed_rights_management'] = true;
$properties['allow_public_connection'] = false;
$properties['public_login'] = '';
$properties['public_password'] = '';
$properties['public_token'] = '';
$properties["sign_up"] = "disabled";
$properties["password_forgotten"] = "disabled";
$properties["unsubscribe"] = false;
$properties['geolocation_enabled'] = false;
$properties['login_remember_me'] = 'enabled';
$properties['login_remember_me_default'] = true;
$properties['server_timezone'] = 'Europe/Paris';

//inscription automatique
$properties['advanced_login_page'] = false;
$properties['automated_sign_up'] = false;
$properties['enable_error_notification'] = false;
$properties['mail_tag_subject'] = '[VITIS] ';
//propriétés existentes dans GTF
$properties['mail_sender'] = 'vitis@domaine.com';
$properties['nickname_sender'] = 'Vitis';
$properties['smtp_host'] = 'smtp.domaine.com';
$properties['smtp_port'] = 26;
$properties['smtp_authentification'] = true;
$properties['smtp_login'] = 'login@domaine.com';
$properties['smtp_password'] = 'password';
//si automated_sign_up === false or error_notification === true
$properties["admin_sign_up"] = "login@domaine.com";
//pour l'inscription
$properties["google_private_captcha"] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
// pour identifier la machine
$properties["instanceIdentifier"] = "";
// Notifications par SMS
$properties['sms_notifications'] = false;

// Require tous les fichiers de tous les dossiers contenus sans properties
$aDir = scandir(__DIR__);
foreach ($aDir as $dir) {
	if($dir != '.' && $dir != '..'){
		if(is_dir(__DIR__.'/'.$dir)){
			$aFiles = scandir(__DIR__.'/'.$dir);
			foreach ($aFiles as $file) {
				if((filetype(__DIR__.'/'.$dir.'/'.$file) == 'file') && (pathinfo(__DIR__.'/'.$dir.'/'.$file)['extension']) == 'inc' && $file != "version.inc"){
					require_once __DIR__.'/'.$dir.'/'.$file;
				}
			}
		}
	}
}

require "properties_post.inc";
include "php_conf.inc";
?>
