<?php

require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';

/**
 * \file BillingBillingGroup.class.inc
 * \class BillingGroup
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the BillingGroup php class
 *
 * This class defines operation for one BillingGroup
 * 
 */
class BillingGroup extends Vitis {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("billinggroup_id", "billinggroup", "description");
    }

    /**
     * @SWG\Get(path="/billinggroups/{billinggroup_id}", 
     *   tags={"BillingGroups"},
     *   summary="Get BillingGroup",
     *   description="Request to get BillingGroup by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="billinggroup_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_framework'], "v_billinggroup", "billinggroup_id");
        //$this->getUsers();
    }

    /**
     *  get users of billinggroup
     */
    /*
    function getUsers() {
        require $this->sRessourcesFile;
        if (in_array("users", $this->aSelectedFields)) {
            $aParams['sSchemaFramework'] = array('value' => $this->aProperties['schema_framework'], 'type' => 'schema_name');
            $aParams['billinggroup_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getGroupUsers'], $aParams);
            $sListUserId = "";
            $aListUserLogin = array();
            while ($aLigne = $this->oConnection->oBd->ligneSuivante($oPDOresult)) {
                if ($sListUserId == "") {
                    $sListUserId = $aLigne["user_id"];
                } else {
                    $sListUserId .= "|" . $aLigne["user_id"];
                }
                $aListUserLogin[] = $aLigne["login"];
            }
            $oPDOresult = $this->oConnection->oBd->fermeResultat();
            $this->aFields['users'] = $sListUserId;
            $this->aFields['users_label'] = implode(',', $aListUserLogin);
        }
    }
    */
    /**
     * delete an user
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_framework'], 'v_billinggroup', 'billinggroup_id', $this->aValues['my_vitis_id'], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['billinggroup_id'] = $this->aValues['my_vitis_id'];
        }
    }

}

?>