<?php

/**
 * \file BillingGroups.class.inc
 * \class BillingGroups
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis BillingGroups
 * 
 */
require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';
require_once 'BillingGroup.class.inc';
require_once(__DIR__ . '/../../class/vmlib/BdDataAccess.inc');

class BillingGroups extends Vitis {
    /**
     * @SWG\Definition(
     *   definition="/billinggroups",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/billinggroups")
     *   }
     * )
     * * @SWG\Tag(
     *   name="BillingGroups",
     *   description="Operations about BillingGroups"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("billinggroup_id", "billinggroup", "description");
    }

    /**
     * @SWG\Get(path="/billinggroups",
     *   tags={"BillingGroups"},
     *   summary="Get BillingGroups",
     *   description="Request to get BillingGroups",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */

    /**
     * get BillingGroups
     * @return  BillingGroups
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_framework'], "v_billinggroup", "billinggroup_id");
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Post(path="/billinggroups",
     *   tags={"BillingGroups"},
     *   summary="Add BillingGroup",
     *   description="Request to add billinggroup",
     *   operationId="POST",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="name",
     *     in="formData",
     *     description="Name of the billinggroup",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="users",
     *     in="formData",
     *     description="Users of the billinggroup",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */

    /**
     * insert billinggroup
     * @return id of the billinggroup created
     */
    function POST() {
        $aReturn = $this->genericPost($this->aProperties['schema_framework'], 'v_billinggroup', $this->aProperties['schema_framework'] . '.seq_common', 'billinggroup_id');
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Put(path="/billinggroups/{billinggroup_id}",
     *   tags={"BillingGroups"},
     *   summary="Update BillingGroup",
     *   description="Request to update BillingGroup",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="billinggroup_id",
     *     in="path",
     *     description="id of the billinggroup",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * * @SWG\Parameter(
     *     name="name",
     *     in="query",
     *     description="Name of the billinggroup",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="users",
     *     in="query",
     *     description="Users of the billinggroup",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */

    /**
     * update billinggroup
     * @return id of the billinggroup if ok error object if ko
     */
    function PUT() {
        $aReturn = $this->genericPut($this->aProperties['schema_framework'], 'v_billinggroup', 'billinggroup_id');
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Delete(path="/billinggroups/",
     *   tags={"BillingGroups"},
     *   summary="delete BillingGroup",
     *   description="Request to delete BillingGroup",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the billinggroups",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/billinggroups/{billinggroup_id}",
     *   tags={"BillingGroups"},
     *   summary="delete BillingGroup",
     *   description="Request to delete BillingGroup",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="billinggroup_id",
     *     in="path",
     *     description="id of the billinggroup",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/billinggroups")
     *     )
     *  )
     */

    /**
     * delete billinggroup
     * @return id of billinggroup deleted or error object if a billinggroup is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_framework'], 'v_billinggroup', 'billinggroup_id');
        return $aReturn['sMessage'];
    }
}
?>