<?php

/**
 * \file FormatDates.class.inc
 * \class FormatDates
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis FormatDates
 * 
 */
require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';
require_once 'FormatDate.class.inc';
require_once(__DIR__ . '/../../class/vmlib/BdDataAccess.inc');

class FormatDates extends Vitis {
    /**
     * @SWG\Definition(
     *   definition="/formatdates",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/formatdates")
     *   }
     * )
     * * @SWG\Tag(
     *   name="FormatDates",
     *   description="Operations about FormatDates"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("formatdate_id", "formatdate", "CONCAT(formatdate, to_char(NOW(), ' (' || formatdate_id || ' HH24:MI:SS'), ')') as label");
    }

    /**
     * @SWG\Get(path="/formatdates",
     *   tags={"FormatDates"},
     *   summary="Get FormatDates",
     *   description="Request to get FormatDates",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/formatdates")
     *     )
     *  )
     */

    /**
     * get FormatDates
     * @return  FormatDates
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_framework'], "rt_formatdate", "formatdate_id");
        return $aReturn['sMessage'];
    }
}
?>