<?php

/**
 * \file SmtpServer.class.inc
 * \class SmtpServer
 *
 * \author Armand Bahi <armand.bahi@veremes.com>.
 *
 * \brief This file contains the SmtpServer php class
 *
 * This class defines Rest Api to SmtpServer
 * 
 */
require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';
require_once __DIR__ . '/../../class/vmlib/BdDataAccess.inc';
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require_once 'PHPMailer/src/Exception.php';
require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

class SmtpServer extends Vitis {
    /**
     * @SWG\Definition(
     *   definition="/smtpserver",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/smtpserver")
     *   }
     * )
     * * @SWG\Tag(
     *   name="SmtpServer",
     *   description="SMTP test Class"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
    }

    /**
     * @SWG\Get(path="/smtpserver/Check",
     *   tags={"SmtpServer"},
 *   summary="Check smtp server connection",
     *   description="Request to check the connection to the Smtp Server",
     *   operationId="GET",
     *   produces={"application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/smtpserver")
     *     )
     *  )
     */

    /**
     * get SmtpServer
     * @return  SmtpServer
     */
    function GET() {
        if (!empty($this->aPath[2])) {
            if ($this->aPath[2] == "Check")
                $sMessage = $this->checkSmtpServerConnection();
            return $sMessage;
        }
    }

    /**
     * Retourne les symboles du fichier "symbols.sym".
     */
    function checkSmtpServerConnection() {
        $mail = new PHPMailer;
        $mail->isSMTP();                                                // Set mailer to use SMTP
        //$mail->SMTPDebug = 3;                                         // debugger level (3 all with connection)
        $mail->Debugoutput = function($str, $level) {error_log("debug level $level; message: $str");};
        $mail->Host = $this->aProperties["smtp_host"];                  // Specify main and backup SMTP servers
        $mail->Port = $this->aProperties["smtp_port"];                  // TCP port to connect to
        $mail->SMTPAuth = $this->aProperties["smtp_authentification"];  // Enable SMTP authentication
        // if authentication add parameter to connect SMTP
        if ($this->aProperties["smtp_authentification"] === true){
            $mail->AuthType = 'LOGIN';
            $mail->Username = $this->aProperties["smtp_login"];             // SMTP username
            $mail->Password = $this->aProperties["smtp_password"];          // SMTP password
            $mail->SMTPSecure = 'tls';                                      // Enable TLS encryption, `ssl` also accepted (deprecated)
        }
        // Depuis PHP 5.6 -> vérification du certificat SSL.
        if (!$this->aProperties['proxy_check_ssl']) {
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );
        }
        if ($mail->smtpConnect()) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        }
        else {
            $oError = new VitisError(1, 'MODAL_CONTENT_ERROR_CHECK_SMTP_CONNECTION_CONFIGURATION');
            $aXmlRacineAttribute['status'] = 0;
            $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        }
        return $sMessage;
    }
}
?>