<?php

/**
 * \file TimeZones.class.inc
 * \class TimeZones
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis TimeZones
 * 
 */
require_once 'Vitis.class.inc';
require_once __DIR__ . '/../../class/vitis_lib/Connection.class.inc';
require_once 'TimeZone.class.inc';
require_once(__DIR__ . '/../../class/vmlib/BdDataAccess.inc');

class TimeZones extends Vitis {
    /**
     * @SWG\Definition(
     *   definition="/timezones",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/timezones")
     *   }
     * )
     * * @SWG\Tag(
     *   name="TimeZones",
     *   description="Operations about TimeZones"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("name", "abbrev", "utc_offset", 'is_dst', "CONCAT(name, ' ', 'GMT',' ',substr(CASE WHEN (substr(utc_offset::text, 1, 1) = '-') THEN utc_offset::text ELSE CONCAT('+', utc_offset) END::text, 1, 6)) as label");
    }

    /**
     * @SWG\Get(path="/timezones",
     *   tags={"TimeZones"},
     *   summary="Get TimeZones",
     *   description="Request to get TimeZones",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/timezones")
     *     )
     *  )
     */

    /**
     * get TimeZones
     * @return  TimeZones
     */
    function GET() {
        $aReturn = $this->genericGet('pg_catalog', 'pg_timezone_names', 'name');
        return $aReturn['sMessage'];
    }
}
?>