<?php

require_once __DIR__ . '/AWS_notification.class.inc';
require_once("vmlib/logUtil.inc");

/**
 * \file AWS_SMS.php
 * \brief Class to send SMS by the Veremes's service
 *
 * \author Anthony Borghi <anthony.borghi@veremes.com>
 */

Class AWS_SMS extends AWS_notification{

    const AWS_API_SMS_TYPE = "SMS";

    //$slogFileName = $properties['log_dir'] . "/notifications/sms.log";

	/**
     * construct
     * @param {string} $sAwsAccessKeyId Access key ID.
     * @param {string} $sAwsSecretAccessKey Secret access key.
     * @param {string} $sDeploymentName Name of the deployment for this API.
     */
    function __construct ($sAwsAccessKeyId, $sAwsSecretAccessKey, $sDeploymentName, $sAppIdentifier) {
    	parent::__construct($sAwsAccessKeyId, $sAwsSecretAccessKey, $sDeploymentName, $sAppIdentifier);
    	// stockage du noeud principal de déploiement 
    	$this->sType = self::AWS_API_SMS_TYPE;
        // définition de la structure de donnée pour ce type de notification
        $this->aRequiredFields = array("message", "destination");
        $this->aOptionalFields = array("sender");
    }	


    function sendSMS ($aValues){
        $bError = $this->defineNotification ($aValues);

    	if (!$bError){
            //error_log("send SMS to " . $this->aRequestParams["notificationParams"]["destination"]);
            $mReturn = $this->sendRequestToSendNotification();

            if($this->aLastCurlRequestInfo["http_code"] != 200){
                $this->bError = true;
                writeToErrorLog("can't send SMS to " . $this->aRequestParams["notificationParams"]["destination"] . ". The service return this message : " . $mReturn);
            } else {
                writeToLog("send SMS to " . $this->aRequestParams["notificationParams"]["destination"], $this->slogFileName);
            }

            //error_log(print_r($this->aLastCurlRequestInfo, true));
        } else {
            writeToErrorLog("can't send SMS (missing parameters)");
        }
    }
}

?>